/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageBuilder {
    private static final String ENGAGE_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private final String mToken;

    public MessageBuilder(String token) {
        this.mToken = token;
    }

    public JSONObject event(String distinctId, String eventName, JSONObject properties) {
        long time = System.currentTimeMillis();
        try {
            JSONObject dataObj = new JSONObject();
            dataObj.put("event", (Object)eventName);
            JSONObject propertiesObj = null;
            propertiesObj = properties == null ? new JSONObject() : new JSONObject(properties.toString());
            if (!propertiesObj.has("token")) {
                propertiesObj.put("token", (Object)this.mToken);
            }
            if (!propertiesObj.has("time")) {
                propertiesObj.put("time", time);
            }
            if (!propertiesObj.has("mp_lib")) {
                propertiesObj.put("mp_lib", (Object)"jdk");
            }
            if (distinctId != null) {
                propertiesObj.put("distinct_id", (Object)distinctId);
            }
            dataObj.put("properties", (Object)propertiesObj);
            JSONObject envelope = new JSONObject();
            envelope.put("envelope_version", 1);
            envelope.put("message_type", (Object)"event");
            envelope.put("message", (Object)dataObj);
            return envelope;
        }
        catch (JSONException e) {
            throw new RuntimeException("Can't construct a Mixpanel message", e);
        }
    }

    public JSONObject set(String distinctId, JSONObject properties) {
        return this.set(distinctId, properties, null);
    }

    public JSONObject set(String distinctId, JSONObject properties, JSONObject modifiers) {
        return this.peopleMessage(distinctId, "$set", properties, modifiers);
    }

    public JSONObject setOnce(String distinctId, JSONObject properties) {
        return this.setOnce(distinctId, properties, null);
    }

    public JSONObject setOnce(String distinctId, JSONObject properties, JSONObject modifiers) {
        return this.peopleMessage(distinctId, "$set_once", properties, modifiers);
    }

    public JSONObject delete(String distinctId) {
        return this.delete(distinctId, null);
    }

    public JSONObject delete(String distinctId, JSONObject modifiers) {
        return this.peopleMessage(distinctId, "$delete", new JSONObject(), modifiers);
    }

    public JSONObject increment(String distinctId, Map<String, Long> properties) {
        return this.increment(distinctId, properties, null);
    }

    public JSONObject increment(String distinctId, Map<String, Long> properties, JSONObject modifiers) {
        JSONObject jsonProperties = new JSONObject(properties);
        return this.peopleMessage(distinctId, "$add", jsonProperties, modifiers);
    }

    public JSONObject append(String distinctId, JSONObject properties) {
        return this.append(distinctId, properties, null);
    }

    public JSONObject append(String distinctId, JSONObject properties, JSONObject modifiers) {
        return this.peopleMessage(distinctId, "$append", properties, modifiers);
    }

    public JSONObject remove(String distinctId, JSONObject properties) {
        return this.remove(distinctId, properties, null);
    }

    public JSONObject remove(String distinctId, JSONObject properties, JSONObject modifiers) {
        return this.peopleMessage(distinctId, "$remove", properties, modifiers);
    }

    public JSONObject union(String distinctId, Map<String, JSONArray> properties) {
        return this.union(distinctId, properties, null);
    }

    public JSONObject union(String distinctId, Map<String, JSONArray> properties, JSONObject modifiers) {
        JSONObject jsonProperties = new JSONObject(properties);
        return this.peopleMessage(distinctId, "$union", jsonProperties, modifiers);
    }

    public JSONObject unset(String distinctId, Collection<String> propertyNames) {
        return this.unset(distinctId, propertyNames, null);
    }

    public JSONObject unset(String distinctId, Collection<String> propertyNames, JSONObject modifiers) {
        JSONArray propNamesArray = new JSONArray(propertyNames);
        return this.peopleMessage(distinctId, "$unset", propNamesArray, modifiers);
    }

    public JSONObject trackCharge(String distinctId, double amount, JSONObject properties) {
        return this.trackCharge(distinctId, amount, properties, null);
    }

    public JSONObject trackCharge(String distinctId, double amount, JSONObject properties, JSONObject modifiers) {
        JSONObject transactionValue = new JSONObject();
        JSONObject appendProperties = new JSONObject();
        try {
            transactionValue.put("$amount", amount);
            SimpleDateFormat dateFormat = new SimpleDateFormat(ENGAGE_DATE_FORMAT);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            transactionValue.put("$time", (Object)dateFormat.format(new Date()));
            if (null != properties) {
                Iterator iter = properties.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    transactionValue.put(key, properties.get(key));
                }
            }
            appendProperties.put("$transactions", (Object)transactionValue);
            return this.append(distinctId, appendProperties, modifiers);
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot create trackCharge message", e);
        }
    }

    public JSONObject peopleMessage(String distinctId, String actionType, Object properties, JSONObject modifiers) {
        JSONObject dataObj = new JSONObject();
        if (null == properties) {
            throw new IllegalArgumentException("Cannot send null properties, use JSONObject.NULL instead");
        }
        try {
            dataObj.put(actionType, properties);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Cannot interpret properties as a JSON payload", e);
        }
        try {
            String[] keys;
            dataObj.put("$token", (Object)this.mToken);
            dataObj.put("$distinct_id", (Object)distinctId);
            dataObj.put("$time", System.currentTimeMillis());
            if (null != modifiers && (keys = JSONObject.getNames((JSONObject)modifiers)) != null) {
                for (String key : keys) {
                    dataObj.put(key, modifiers.get(key));
                }
            }
            JSONObject envelope = new JSONObject();
            envelope.put("envelope_version", 1);
            envelope.put("message_type", (Object)"people");
            envelope.put("message", (Object)dataObj);
            return envelope;
        }
        catch (JSONException e) {
            throw new RuntimeException("Can't construct a Mixpanel message", e);
        }
    }

    public JSONObject groupSet(String groupKey, String groupId, JSONObject properties) {
        return this.groupSet(groupKey, groupId, properties, null);
    }

    public JSONObject groupSet(String groupKey, String groupId, JSONObject properties, JSONObject modifiers) {
        return this.groupMessage(groupKey, groupId, "$set", properties, modifiers);
    }

    public JSONObject groupSetOnce(String groupKey, String groupId, JSONObject properties) {
        return this.groupSetOnce(groupKey, groupId, properties, null);
    }

    public JSONObject groupSetOnce(String groupKey, String groupId, JSONObject properties, JSONObject modifiers) {
        return this.groupMessage(groupKey, groupId, "$set_once", properties, modifiers);
    }

    public JSONObject groupDelete(String groupKey, String groupId) {
        return this.groupDelete(groupKey, groupId, null);
    }

    public JSONObject groupDelete(String groupKey, String groupId, JSONObject modifiers) {
        return this.groupMessage(groupKey, groupId, "$delete", new JSONObject(), modifiers);
    }

    public JSONObject groupRemove(String groupKey, String groupId, JSONObject properties) {
        return this.groupRemove(groupKey, groupId, properties, null);
    }

    public JSONObject groupRemove(String groupKey, String groupId, JSONObject properties, JSONObject modifiers) {
        return this.groupMessage(groupKey, groupId, "$remove", properties, modifiers);
    }

    public JSONObject groupUnion(String groupKey, String groupId, Map<String, JSONArray> properties) {
        return this.groupUnion(groupKey, groupId, properties, null);
    }

    public JSONObject groupUnion(String groupKey, String groupId, Map<String, JSONArray> properties, JSONObject modifiers) {
        JSONObject jsonProperties = new JSONObject(properties);
        return this.groupMessage(groupKey, groupId, "$union", jsonProperties, modifiers);
    }

    public JSONObject groupUnset(String groupKey, String groupId, Collection<String> propertyNames) {
        return this.groupUnset(groupKey, groupId, propertyNames, null);
    }

    public JSONObject groupUnset(String groupKey, String groupId, Collection<String> propertyNames, JSONObject modifiers) {
        JSONArray propNamesArray = new JSONArray(propertyNames);
        return this.groupMessage(groupKey, groupId, "$unset", propNamesArray, modifiers);
    }

    public JSONObject groupMessage(String groupKey, String groupId, String actionType, Object properties, JSONObject modifiers) {
        JSONObject dataObj = new JSONObject();
        if (null == properties) {
            throw new IllegalArgumentException("Cannot send null properties, use JSONObject.NULL instead");
        }
        try {
            dataObj.put(actionType, properties);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Cannot interpret properties as a JSON payload", e);
        }
        try {
            String[] keys;
            dataObj.put("$token", (Object)this.mToken);
            dataObj.put("$group_key", (Object)groupKey);
            dataObj.put("$group_id", (Object)groupId);
            dataObj.put("$time", System.currentTimeMillis());
            if (null != modifiers && (keys = JSONObject.getNames((JSONObject)modifiers)) != null) {
                for (String key : keys) {
                    dataObj.put(key, modifiers.get(key));
                }
            }
            JSONObject envelope = new JSONObject();
            envelope.put("envelope_version", 1);
            envelope.put("message_type", (Object)"group");
            envelope.put("message", (Object)dataObj);
            return envelope;
        }
        catch (JSONException e) {
            throw new RuntimeException("Can't construct a Mixpanel message", e);
        }
    }
}

