/*
 * Decompiled with CFR 0.152.
 */
package zmodem.zm.io;

import java.io.IOException;
import java.io.OutputStream;
import zmodem.xfer.io.ObjectOutputStream;
import zmodem.xfer.util.ASCII;
import zmodem.xfer.util.Buffer;
import zmodem.xfer.zm.packet.DataPacket;
import zmodem.xfer.zm.packet.Format;
import zmodem.xfer.zm.packet.Header;
import zmodem.xfer.zm.util.ZMPacket;
import zmodem.xfer.zm.util.ZModemCharacter;

public class ZMPacketOutputStream
extends ObjectOutputStream<ZMPacket> {
    private final OutputStream os;

    public ZMPacketOutputStream(OutputStream netOs) {
        this.os = netOs;
    }

    public void implWrite(byte b) throws IOException {
        this.os.write(b);
    }

    @Override
    public void write(ZMPacket o) throws IOException {
        Buffer buff = o.marshall();
        Format fmt = null;
        if (o instanceof Header) {
            fmt = ((Header)o).format();
        }
        if (fmt != null) {
            for (int i = 0; i < fmt.width(); ++i) {
                this.implWrite(ZModemCharacter.ZPAD.value());
            }
            this.implWrite(ZModemCharacter.ZDLE.value());
            this.implWrite(fmt.character());
        }
        if (buff.hasRemaining()) {
            byte[] buf = new byte[buff.remaining()];
            buff.get(buf);
            this.os.write(buf);
        }
        if (fmt != null && fmt.hex()) {
            this.implWrite(ASCII.CR.value());
            this.implWrite(ASCII.LF.value());
            this.implWrite(ASCII.XON.value());
        }
        if (o instanceof DataPacket && ((DataPacket)o).type() == ZModemCharacter.ZCRCW) {
            this.implWrite(ASCII.XON.value());
        }
        this.os.flush();
    }
}

