/*
 * Decompiled with CFR 0.152.
 */
package zmodem.xfer.zm.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.net.io.CopyStreamAdapter;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zmodem.FileCopyStreamEvent;
import zmodem.util.FileAdapter;
import zmodem.xfer.util.InvalidChecksumException;
import zmodem.xfer.zm.packet.Cancel;
import zmodem.xfer.zm.packet.DataPacket;
import zmodem.xfer.zm.packet.Finish;
import zmodem.xfer.zm.packet.Format;
import zmodem.xfer.zm.packet.Header;
import zmodem.xfer.zm.util.ZMOptions;
import zmodem.xfer.zm.util.ZMPacket;
import zmodem.xfer.zm.util.ZMPacketFactory;
import zmodem.xfer.zm.util.ZModemCharacter;
import zmodem.zm.io.ZMPacketInputStream;
import zmodem.zm.io.ZMPacketOutputStream;

public class ZModemSend {
    private static final int packLen = 8192;
    private static final Logger log = LoggerFactory.getLogger(ZModemSend.class);
    private final byte[] data = new byte[8192];
    private final CopyStreamAdapter adapter = new CopyStreamAdapter();
    private final Supplier<List<FileAdapter>> destinationSupplier;
    private final InputStream netIs;
    private final OutputStream netOs;
    private List<FileAdapter> files;
    private Iterator<FileAdapter> iter;
    private FileAdapter file;
    private int fOffset = 0;
    private int index = 0;
    private int filesize = 0;
    private boolean atEof = false;
    private InputStream fileIs;

    public ZModemSend(Supplier<List<FileAdapter>> destinationSupplier, InputStream netin, OutputStream netout) throws IOException {
        this.destinationSupplier = destinationSupplier;
        this.netIs = netin;
        this.netOs = netout;
    }

    public boolean nextFile() throws IOException {
        IOUtils.closeQuietly((InputStream)this.fileIs);
        if (this.files == null) {
            this.files = this.destinationSupplier.get();
            this.iter = this.files.iterator();
        }
        if (!this.iter.hasNext()) {
            return false;
        }
        this.file = this.iter.next();
        this.fileIs = this.file.getInputStream();
        this.filesize = this.fileIs.available();
        this.fOffset = 0;
        this.atEof = false;
        ++this.index;
        return true;
    }

    public void addCopyStreamListener(CopyStreamListener listener2) {
        this.adapter.addCopyStreamListener(listener2);
    }

    public void removeCopyStreamListener(CopyStreamListener listener2) {
        this.adapter.removeCopyStreamListener(listener2);
    }

    private void position(int offset) throws IOException {
        if (offset != this.fOffset) {
            this.fileIs.skipNBytes(offset);
            this.fOffset = offset;
        }
    }

    private byte[] getNextBlock() throws IOException {
        int len = this.fileIs.read(this.data);
        if (len < this.data.length) {
            this.atEof = true;
        } else if (this.fileIs.available() == 0) {
            this.atEof = true;
        }
        if (len == -1) {
            return null;
        }
        this.fOffset += len;
        if (len != this.data.length) {
            return ArrayUtils.subarray((byte[])this.data, (int)0, (int)len);
        }
        return this.data;
    }

    private DataPacket getNextDataPacket() throws IOException {
        byte[] data = this.getNextBlock();
        ZModemCharacter fe = ZModemCharacter.ZCRCW;
        if (this.atEof) {
            fe = ZModemCharacter.ZCRCE;
            this.fileIs.close();
        }
        if (data == null) {
            return new DataPacket(fe);
        }
        return new DataPacket(fe, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Supplier<Boolean> isCancelled) {
        ZMPacketFactory factory = new ZMPacketFactory();
        ZMPacketInputStream is = new ZMPacketInputStream(this.netIs);
        ZMPacketOutputStream os = new ZMPacketOutputStream(this.netOs);
        try {
            boolean end = false;
            int errorCount = 0;
            ZMPacket packet = null;
            block14: while (!end) {
                block22: {
                    try {
                        packet = is.read();
                    }
                    catch (InvalidChecksumException ice) {
                        if (++errorCount <= 20) break block22;
                        os.write(new Cancel());
                        end = true;
                    }
                }
                if (packet instanceof Cancel) {
                    end = true;
                } else if (isCancelled.get().booleanValue()) {
                    os.write(new Cancel());
                    continue;
                }
                if (!(packet instanceof Header)) continue;
                Header header = (Header)packet;
                switch (header.type()) {
                    case ZSKIP: {
                        this.fireBytesTransferred(true);
                    }
                    case ZRINIT: {
                        if (!this.nextFile()) {
                            os.write(new Header(Format.BIN, ZModemCharacter.ZFIN));
                            continue block14;
                        }
                        os.write(new Header(Format.BIN, ZModemCharacter.ZFILE, new byte[]{0, 0, 0, ZMOptions.with(ZMOptions.ZCBIN)}));
                        os.write(factory.createZFilePacket(this.file.getName(), this.filesize));
                        this.fireBytesTransferred(false);
                        continue block14;
                    }
                    case ZRPOS: {
                        if (!this.atEof) {
                            this.position(header.getPos());
                        }
                    }
                    case ZACK: {
                        os.write(new Header(Format.BIN, ZModemCharacter.ZDATA, this.fOffset));
                        os.write(this.getNextDataPacket());
                        if (this.atEof) {
                            os.write(new Header(Format.HEX, ZModemCharacter.ZEOF, this.fOffset));
                        }
                        this.fireBytesTransferred(false);
                        continue block14;
                    }
                    case ZFIN: {
                        end = true;
                        os.write(new Finish());
                        continue block14;
                    }
                }
                end = true;
                os.write(new Cancel());
            }
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.fileIs);
        }
    }

    private void fireBytesTransferred(boolean skip) {
        if (this.filesize == this.fOffset) {
            System.out.println();
        }
        this.adapter.bytesTransferred((CopyStreamEvent)new FileCopyStreamEvent(this, this.file.getName(), this.files.size() - this.index + 1, this.index, this.filesize, this.fOffset, 0L, skip));
    }
}

