/*
 * Decompiled with CFR 0.152.
 */
package zmodem.xfer.zm.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.net.io.CopyStreamAdapter;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zmodem.FileCopyStreamEvent;
import zmodem.util.EmptyFileAdapter;
import zmodem.util.FileAdapter;
import zmodem.xfer.util.InvalidChecksumException;
import zmodem.xfer.zm.packet.Cancel;
import zmodem.xfer.zm.packet.DataPacket;
import zmodem.xfer.zm.packet.Finish;
import zmodem.xfer.zm.packet.Format;
import zmodem.xfer.zm.packet.Header;
import zmodem.xfer.zm.util.ZMOptions;
import zmodem.xfer.zm.util.ZMPacket;
import zmodem.xfer.zm.util.ZModemCharacter;
import zmodem.zm.io.ZMPacketInputStream;
import zmodem.zm.io.ZMPacketOutputStream;

public class ZModemReceive {
    private static final Logger log = LoggerFactory.getLogger(ZModemReceive.class);
    private final CopyStreamAdapter adapter = new CopyStreamAdapter();
    private final Supplier<FileAdapter> destinationSupplier;
    private FileAdapter destination;
    private FileAdapter file;
    private int fOffset = 0;
    private Long filesize;
    private int remaining = 0;
    private int index = 0;
    private OutputStream fileOs = null;
    private final InputStream netIs;
    private final OutputStream netOs;

    public ZModemReceive(Supplier<FileAdapter> destDir, InputStream netin, OutputStream netout) throws IOException {
        this.destinationSupplier = destDir;
        this.netIs = netin;
        this.netOs = netout;
    }

    private void open(int offset) throws IOException {
        boolean append = false;
        if (offset != 0) {
            if (this.file.exists() && this.file.length() == (long)offset) {
                append = true;
            } else {
                offset = 0;
            }
        }
        IOUtils.closeQuietly((OutputStream)this.fileOs);
        this.fileOs = this.file.getOutputStream(append);
        this.fOffset = offset;
    }

    private void decodeFileNameData(DataPacket p) {
        Object[] segments;
        ByteArrayOutputStream filename = new ByteArrayOutputStream();
        StringBuilder extract = new StringBuilder();
        byte[] data = p.data();
        for (int i = 0; i < data.length; ++i) {
            byte b = data[i];
            if (b == 0) {
                for (int j = i + 1; j < data.length && (b = data[j]) != 0; ++j) {
                    extract.append((char)b);
                }
                break;
            }
            filename.write(b);
        }
        if (ArrayUtils.isNotEmpty((Object[])(segments = extract.toString().split(" ")))) {
            if (segments.length >= 1) {
                this.filesize = NumberUtils.toLong((String)segments[0]);
            }
            if (segments.length >= 5) {
                this.remaining = NumberUtils.toInt((String)segments[4]);
            }
        }
        this.file = this.destination.getChild(filename.toString());
        this.fOffset = 0;
        ++this.index;
        this.adapter.bytesTransferred((CopyStreamEvent)new FileCopyStreamEvent(this, this.file.getName(), this.remaining - this.index, this.index, this.filesize, this.fOffset, 0L, false));
    }

    public void addCopyStreamListener(CopyStreamListener listener2) {
        this.adapter.addCopyStreamListener(listener2);
    }

    public void removeCopyStreamListener(CopyStreamListener listener2) {
        this.adapter.removeCopyStreamListener(listener2);
    }

    private void writeData(DataPacket p) throws IOException {
        byte[] data = p.data();
        this.fileOs.write(data);
        this.fOffset += data.length;
        this.adapter.bytesTransferred((CopyStreamEvent)new FileCopyStreamEvent(this, this.file.getName(), this.remaining, this.index, this.filesize, this.fOffset, 0L, false));
    }

    private boolean initDestination() {
        if (this.destination != null) {
            return true;
        }
        this.destination = this.destinationSupplier.get();
        return !(this.destination instanceof EmptyFileAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Supplier<Boolean> isCancelled) {
        ZMPacketInputStream is = new ZMPacketInputStream(this.netIs);
        ZMPacketOutputStream os = new ZMPacketOutputStream(this.netOs);
        Expect expect = Expect.NOTHING;
        byte[] recvOpt = new byte[]{0, 4, 0, ZMOptions.with(ZMOptions.ESCCTL, ZMOptions.ESC8)};
        try {
            boolean end = false;
            int errorCount = 0;
            ZMPacket packet = null;
            while (!end) {
                block36: {
                    try {
                        packet = is.read();
                    }
                    catch (InvalidChecksumException ice) {
                        if (log.isErrorEnabled()) {
                            log.error(ice.getMessage(), (Throwable)ice);
                        }
                        if (++errorCount < 3) break block36;
                        os.write(new Cancel());
                        end = true;
                    }
                }
                if (packet instanceof Cancel) {
                    end = true;
                } else if (packet instanceof Finish) {
                    end = true;
                }
                if (isCancelled.get().booleanValue()) {
                    break;
                }
                if (this.destination instanceof EmptyFileAdapter) {
                    os.write(new Cancel());
                    break;
                }
                if (packet instanceof Header) {
                    Header header = (Header)packet;
                    switch (header.type()) {
                        case ZRQINIT: {
                            os.write(new Header(Format.HEX, ZModemCharacter.ZRINIT, recvOpt));
                            break;
                        }
                        case ZFILE: {
                            expect = Expect.FILENAME;
                            break;
                        }
                        case ZEOF: {
                            os.write(new Header(Format.HEX, ZModemCharacter.ZRINIT, recvOpt));
                            expect = Expect.NOTHING;
                            this.file = null;
                            this.fileOs.flush();
                            IOUtils.closeQuietly((OutputStream)this.fileOs);
                            this.fileOs = null;
                            break;
                        }
                        case ZDATA: {
                            this.open(header.getPos());
                            expect = Expect.DATA;
                            break;
                        }
                        case ZFIN: {
                            os.write(new Header(Format.HEX, ZModemCharacter.ZFIN));
                            end = true;
                            break;
                        }
                        default: {
                            end = true;
                            os.write(new Cancel());
                        }
                    }
                }
                if (!(packet instanceof DataPacket)) continue;
                DataPacket data = (DataPacket)packet;
                block10 : switch (expect.ordinal()) {
                    case 2: {
                        os.write(new Header(Format.HEX, ZModemCharacter.ZRINIT, recvOpt));
                        break;
                    }
                    case 0: {
                        if (!this.initDestination()) {
                            end = true;
                            os.write(new Cancel());
                            break;
                        }
                        this.decodeFileNameData(data);
                        if (this.file.length() == this.filesize.longValue()) {
                            os.write(new Header(Format.HEX, ZModemCharacter.ZSKIP));
                            this.adapter.bytesTransferred((CopyStreamEvent)new FileCopyStreamEvent(this, this.file.getName(), this.remaining, this.index, this.filesize, this.fOffset, 0L, true));
                        } else {
                            os.write(new Header(Format.HEX, ZModemCharacter.ZRPOS, (int)this.file.length()));
                        }
                        expect = Expect.NOTHING;
                        break;
                    }
                    case 1: {
                        this.writeData(data);
                        switch (data.type()) {
                            case ZCRCW: {
                                expect = Expect.NOTHING;
                            }
                            case ZCRCQ: {
                                os.write(new Header(Format.HEX, ZModemCharacter.ZACK, this.fOffset));
                                break block10;
                            }
                            case ZCRCE: {
                                expect = Expect.NOTHING;
                            }
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this.fileOs);
        }
    }

    private static enum Expect {
        FILENAME,
        DATA,
        NOTHING;

    }
}

