/*
 * Decompiled with CFR 0.152.
 */
package zmodem.xfer.zm.util;

import zmodem.xfer.zm.packet.Format;
import zmodem.xfer.zm.proto.Escape;
import zmodem.xfer.zm.util.ZModemCharacter;

public class ZDLEEncoder {
    private byte[] raw;
    private byte[] zdle;
    private int zdleLen;
    private Format format;

    public ZDLEEncoder(byte[] data) {
        this(data, Format.BIN);
    }

    public ZDLEEncoder(byte[] data, Format fmt) {
        this.raw = data;
        this.format = fmt;
        this.zdle = new byte[this.raw.length * 2];
        this.encode();
    }

    private void putZdle(byte b) {
        this.zdle[this.zdleLen] = b;
        ++this.zdleLen;
    }

    private void encode() {
        byte previous = 0;
        for (byte b : this.raw) {
            if (!this.format.hex() && Escape.mustEscape(b, previous, false)) {
                this.putZdle(ZModemCharacter.ZDLE.value());
                b = Escape.escapeIt(b);
            }
            this.putZdle(b);
            previous = b;
        }
    }

    public byte[] raw() {
        return this.raw;
    }

    public int zdleLen() {
        return this.zdleLen;
    }

    public byte[] zdle() {
        return this.zdle;
    }
}

