/*
 * Decompiled with CFR 0.152.
 */
package zmodem.xfer.zm.proto;

import java.util.HashMap;
import java.util.Map;
import zmodem.xfer.zm.proto.Action;
import zmodem.xfer.zm.util.ZModemCharacter;

public class Escape {
    private int len = 0;
    private Action action = Action.ESCAPE;
    private static Map<Byte, Escape> _specials = new HashMap<Byte, Escape>();

    public Escape(Action a) {
        this(a, 0);
    }

    public Escape(Action a, int l) {
        this.len = l;
        this.action = a;
    }

    public Action action() {
        return this.action;
    }

    public int len() {
        return this.len;
    }

    public static Escape detect(byte b, boolean acceptsHeader) {
        Escape r = _specials.get(b);
        if (r == null || !acceptsHeader && r.action() == Action.HEADER) {
            return new Escape(Action.ESCAPE);
        }
        return r;
    }

    public static boolean mustEscape(byte b, byte previous, boolean escapeCtl) {
        switch (b) {
            case -115: 
            case 13: {
                if (!escapeCtl || previous != 64) break;
                return true;
            }
            case -112: 
            case -111: 
            case -109: 
            case -1: 
            case 16: 
            case 17: 
            case 19: 
            case 24: 
            case 127: {
                return true;
            }
            default: {
                if (!escapeCtl || (b & 0x60) != 0) break;
                return true;
            }
        }
        return false;
    }

    public static byte escapeIt(byte b) {
        if (b == 127) {
            return ZModemCharacter.ZRUB0.value();
        }
        if (b == -1) {
            return ZModemCharacter.ZRUB1.value();
        }
        if (b == ZModemCharacter.ZRUB0.value()) {
            return 127;
        }
        if (b == ZModemCharacter.ZRUB1.value()) {
            return -1;
        }
        return (byte)(b ^ 0x40);
    }

    public String toString() {
        return "Action=" + String.valueOf((Object)this.action) + ", len=" + this.len;
    }

    static {
        _specials.put(ZModemCharacter.ZBIN.value(), new Escape(Action.HEADER, 7));
        _specials.put(ZModemCharacter.ZHEX.value(), new Escape(Action.HEADER, 16));
        _specials.put(ZModemCharacter.ZBIN32.value(), new Escape(Action.HEADER, 9));
        _specials.put(ZModemCharacter.ZCRCE.value(), new Escape(Action.DATA, 2));
        _specials.put(ZModemCharacter.ZCRCG.value(), new Escape(Action.DATA, 2));
        _specials.put(ZModemCharacter.ZCRCQ.value(), new Escape(Action.DATA, 2));
        _specials.put(ZModemCharacter.ZCRCW.value(), new Escape(Action.DATA, 2));
    }
}

