/*
 * Decompiled with CFR 0.152.
 */
package zmodem.xfer.zm.packet;

import zmodem.xfer.util.Arrays;
import zmodem.xfer.util.Buffer;
import zmodem.xfer.util.ByteBuffer;
import zmodem.xfer.util.CRC;
import zmodem.xfer.util.HexBuffer;
import zmodem.xfer.util.InvalidChecksumException;
import zmodem.xfer.zm.packet.Format;
import zmodem.xfer.zm.util.ZDLEEncoder;
import zmodem.xfer.zm.util.ZMPacket;
import zmodem.xfer.zm.util.ZModemCharacter;

public class Header
extends ZMPacket {
    private Format format;
    private ZModemCharacter type;
    private byte[] data = new byte[]{0, 0, 0, 0};

    public static Header unmarshall(Buffer buff) {
        Format fmt = null;
        while (fmt == null) {
            fmt = Format.fromByte(buff.get());
        }
        if (fmt.hex()) {
            buff = buff.asHexBuffer();
        }
        CRC crc = new CRC(fmt.crc());
        byte b = buff.get();
        crc.update(b);
        ZModemCharacter type = ZModemCharacter.forbyte(b);
        byte[] data = new byte[4];
        for (int i = 0; i < data.length; ++i) {
            b = buff.get();
            crc.update(b);
            data[i] = b;
        }
        crc.finalized();
        byte[] netCrc = new byte[crc.size()];
        buff.get(netCrc);
        if (!Arrays.equals(netCrc, crc.getBytes())) {
            throw new InvalidChecksumException();
        }
        return new Header(fmt, type, data);
    }

    private Header(Format fFmt) {
        this.format = fFmt;
    }

    public Header(Format fFmt, ZModemCharacter fType) {
        this(fFmt);
        this.type = fType;
    }

    public Header(Format fFmt, ZModemCharacter fType, byte[] flags) {
        this(fFmt, fType);
        this.setFlags(flags);
    }

    public Header(Format fFmt, ZModemCharacter fType, int pos) {
        this(fFmt, fType);
        this.setPos(pos);
    }

    public ZModemCharacter type() {
        return this.type;
    }

    public Format format() {
        return this.format;
    }

    public void setFlags(byte[] flags) {
        this.data = Arrays.copyOf(flags, flags.length);
    }

    public byte[] getFlags() {
        return this.data;
    }

    public void setPos(int num) {
        this.data = Arrays.fromInt(num, Arrays.Endianness.Little);
    }

    public int getPos() {
        return Arrays.toInt(this.data, Arrays.Endianness.Little);
    }

    @Override
    public Buffer marshall() {
        Buffer buff = this.format.hex() ? HexBuffer.allocate(16) : ByteBuffer.allocate(32);
        CRC crc = new CRC(this.format.crc());
        crc.update(this.type.value());
        buff.put(this.type.value());
        crc.update(this.data);
        ZDLEEncoder encoder = new ZDLEEncoder(this.data, this.format);
        buff.put(encoder.zdle(), 0, encoder.zdleLen());
        crc.finalized();
        encoder = new ZDLEEncoder(crc.getBytes(), this.format);
        buff.put(encoder.zdle(), 0, encoder.zdleLen());
        buff.flip();
        return buff.asByteBuffer();
    }

    public String toString() {
        return String.valueOf((Object)this.type) + ", " + String.valueOf((Object)this.format) + ", {" + this.data[0] + "," + this.data[1] + "," + this.data[2] + "," + this.data[3] + "}";
    }
}

