/*
 * Decompiled with CFR 0.152.
 */
package zmodem.xfer.zm.packet;

import zmodem.xfer.util.Arrays;
import zmodem.xfer.util.Buffer;
import zmodem.xfer.util.ByteBuffer;
import zmodem.xfer.util.CRC;
import zmodem.xfer.util.InvalidChecksumException;
import zmodem.xfer.zm.util.ZDLEEncoder;
import zmodem.xfer.zm.util.ZMPacket;
import zmodem.xfer.zm.util.ZModemCharacter;

public class DataPacket
extends ZMPacket {
    private final ZModemCharacter type;
    private byte[] data = new byte[0];

    public static DataPacket unmarshall(Buffer buff, CRC crc) {
        byte[] data = new byte[buff.remaining() - crc.size() - 1];
        buff.get(data);
        ZModemCharacter type = ZModemCharacter.forbyte(buff.get());
        byte[] netCrc = new byte[crc.size()];
        buff.get(netCrc);
        if (!Arrays.equals(netCrc, crc.getBytes())) {
            throw new InvalidChecksumException();
        }
        return new DataPacket(type, data);
    }

    public DataPacket(ZModemCharacter fe) {
        this.type = fe;
    }

    public DataPacket(ZModemCharacter fr, byte[] d) {
        this(fr);
        this.data = d;
    }

    public ZModemCharacter type() {
        return this.type;
    }

    public byte[] data() {
        return this.data;
    }

    public void setData(byte[] d) {
        this.data = d;
    }

    public void copyData(byte[] d) {
        this.data = Arrays.copyOf(d, d.length);
    }

    @Override
    public Buffer marshall() {
        ByteBuffer buff = ByteBuffer.allocate(this.data.length * 2 + 64);
        CRC crc = new CRC(CRC.Type.CRC16);
        ZDLEEncoder encoder = new ZDLEEncoder(this.data);
        crc.update(this.data);
        buff.put(encoder.zdle(), 0, encoder.zdleLen());
        buff.put(ZModemCharacter.ZDLE.value());
        crc.update(this.type.value());
        buff.put(this.type.value());
        crc.finalized();
        encoder = new ZDLEEncoder(crc.getBytes());
        buff.put(encoder.zdle(), 0, encoder.zdleLen());
        buff.flip();
        return buff;
    }

    public String toString() {
        return String.valueOf((Object)this.type) + ":" + this.data.length + " bytes";
    }
}

