/*
 * Decompiled with CFR 0.152.
 */
package zmodem.xfer.util;

public class Arrays {
    public static byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static boolean equals(byte[] a, byte[] a2) {
        return java.util.Arrays.equals(a, a2);
    }

    public static long toInteger(byte[] array, int size, Endianness endian) {
        long n = 0L;
        int offset = 0;
        int increment = 1;
        switch (endian.ordinal()) {
            case 0: {
                increment = 1;
                offset = 0;
                break;
            }
            case 1: {
                increment = -1;
                offset = size - 1;
            }
        }
        for (int i = 0; i < size; ++i) {
            n += (long)((0xFF & array[offset]) * (1 << i * 8));
            offset += increment;
        }
        return n;
    }

    public static short toShort(byte[] array, Endianness endian) {
        return (short)Arrays.toInteger(array, 2, endian);
    }

    public static int toInt(byte[] array, Endianness endian) {
        return (int)Arrays.toInteger(array, 4, endian);
    }

    public static long toLong(byte[] array, Endianness endian) {
        return Arrays.toInteger(array, 8, endian);
    }

    public static byte[] fromInteger(long n, int size, Endianness endian) {
        byte[] ret = new byte[size];
        int offset = 0;
        int increment = 1;
        switch (endian.ordinal()) {
            case 1: {
                increment = -1;
                offset = size - 1;
                break;
            }
            case 0: {
                increment = 1;
                offset = 0;
            }
        }
        for (int i = 0; i < size; ++i) {
            ret[offset] = (byte)(n >> i * 8 & 0xFFL);
            offset += increment;
        }
        return ret;
    }

    public static byte[] fromShort(short s, Endianness endian) {
        return Arrays.fromInteger(s, 2, endian);
    }

    public static byte[] fromInt(int i, Endianness endian) {
        return Arrays.fromInteger(i, 4, endian);
    }

    public static byte[] fromLong(long i, Endianness endian) {
        return Arrays.fromInteger(i, 8, endian);
    }

    public static enum Endianness {
        Little,
        Big;

    }
}

