/*
 * Decompiled with CFR 0.152.
 */
package zmodem.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.commons.io.input.RandomAccessFileInputStream;
import zmodem.util.FileAdapter;

public class CustomFile
implements FileAdapter {
    File file = null;

    public CustomFile(File file) {
        this.file = file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return ((RandomAccessFileInputStream.Builder)RandomAccessFileInputStream.builder().setCloseOnClose(true).setRandomAccessFile(new RandomAccessFile(this.file, "r")).setBufferSize(8192)).get();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(false);
    }

    @Override
    public OutputStream getOutputStream(boolean append) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(this.file, append));
    }

    @Override
    public FileAdapter getChild(String name) {
        if (name.equals(this.file.getName())) {
            return this;
        }
        if (this.file.isDirectory()) {
            return new CustomFile(new File(this.file.getAbsolutePath(), name));
        }
        return null;
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }
}

