/*
 * Decompiled with CFR 0.152.
 */
package zmodem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.commons.net.io.CopyStreamListener;
import zmodem.util.FileAdapter;
import zmodem.xfer.zm.util.ZModemReceive;
import zmodem.xfer.zm.util.ZModemSend;

public class ZModem {
    private final InputStream netIs;
    private final OutputStream netOs;
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);

    public ZModem(InputStream netin, OutputStream netout) {
        this.netIs = netin;
        this.netOs = netout;
    }

    public void receive(Supplier<FileAdapter> destDir, CopyStreamListener listener2) throws IOException {
        ZModemReceive sender = new ZModemReceive(destDir, this.netIs, this.netOs);
        sender.addCopyStreamListener(listener2);
        sender.receive(this.isCancelled::get);
        this.netOs.flush();
    }

    public void send(Supplier<List<FileAdapter>> filesSupplier, CopyStreamListener listener2) throws IOException {
        ZModemSend sender = new ZModemSend(filesSupplier, this.netIs, this.netOs);
        sender.addCopyStreamListener(listener2);
        sender.send(this.isCancelled::get);
        this.netOs.flush();
    }

    public void cancel() {
        this.isCancelled.compareAndSet(false, true);
    }
}

