/*
 * Decompiled with CFR 0.152.
 */
package app.termora.vfs2.sftp;

import app.termora.vfs2.sftp.MySftpFileObject;
import app.termora.vfs2.sftp.MySftpFileProvider;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lapp/termora/vfs2/sftp/MySftpFileSystem;", "Lorg/apache/commons/vfs2/provider/AbstractFileSystem;", "sftpFileSystem", "Lorg/apache/sshd/sftp/client/fs/SftpFileSystem;", "rootName", "Lorg/apache/commons/vfs2/FileName;", "fileSystemOptions", "Lorg/apache/commons/vfs2/FileSystemOptions;", "<init>", "(Lorg/apache/sshd/sftp/client/fs/SftpFileSystem;Lorg/apache/commons/vfs2/FileName;Lorg/apache/commons/vfs2/FileSystemOptions;)V", "addCapabilities", "", "caps", "", "Lorg/apache/commons/vfs2/Capability;", "createFile", "Lorg/apache/commons/vfs2/FileObject;", "name", "Lorg/apache/commons/vfs2/provider/AbstractFileName;", "getDefaultDir", "", "getClientSession", "Lorg/apache/sshd/client/session/ClientSession;", "termora"})
public final class MySftpFileSystem
extends AbstractFileSystem {
    @NotNull
    private final SftpFileSystem sftpFileSystem;

    public MySftpFileSystem(@NotNull SftpFileSystem sftpFileSystem, @NotNull FileName rootName, @NotNull FileSystemOptions fileSystemOptions) {
        Intrinsics.checkNotNullParameter((Object)sftpFileSystem, (String)"sftpFileSystem");
        Intrinsics.checkNotNullParameter((Object)rootName, (String)"rootName");
        Intrinsics.checkNotNullParameter((Object)fileSystemOptions, (String)"fileSystemOptions");
        super(rootName, null, fileSystemOptions);
        this.sftpFileSystem = sftpFileSystem;
    }

    protected void addCapabilities(@NotNull Collection<Capability> caps) {
        Intrinsics.checkNotNullParameter(caps, (String)"caps");
        caps.addAll((Collection<Capability>)MySftpFileProvider.Companion.getCapabilities());
    }

    @NotNull
    protected FileObject createFile(@NotNull AbstractFileName name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (FileObject)new MySftpFileObject(this.sftpFileSystem, name, this);
    }

    @NotNull
    public final String getDefaultDir() {
        SftpPath sftpPath = this.sftpFileSystem.getDefaultDir();
        Intrinsics.checkNotNullExpressionValue((Object)sftpPath, (String)"getDefaultDir(...)");
        return ((Object)((Path)sftpPath).toAbsolutePath()).toString();
    }

    @NotNull
    public final ClientSession getClientSession() {
        ClientSession clientSession = this.sftpFileSystem.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)clientSession, (String)"getSession(...)");
        return clientSession;
    }
}

