/*
 * Decompiled with CFR 0.152.
 */
package app.termora.vfs2.sftp;

import app.termora.sftp.FileSystemViewTableModel;
import app.termora.vfs2.sftp.MySftpFileSystem;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.sshd.common.file.util.BasePath;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.apache.sshd.sftp.client.fs.WithFileAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 P2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001PB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u0015\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001eH\u0014\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010 \u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u001eH\u0014\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0014J\b\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020&H\u0014J\b\u0010.\u001a\u00020&H\u0014J\b\u0010/\u001a\u00020&H\u0014J\u0010\u00100\u001a\u00020,2\u0006\u00101\u001a\u00020!H\u0014J\u0010\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020!H\u0016J\b\u00104\u001a\u00020,H\u0014J\u0018\u00105\u001a\u00020,2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00106\u001a\u000207H\u0002J\u0018\u00108\u001a\u00020&2\u0006\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020&H\u0014J\u0018\u0010;\u001a\u00020&2\u0006\u0010<\u001a\u00020&2\u0006\u0010:\u001a\u00020&H\u0014J\u0018\u0010=\u001a\u00020&2\u0006\u0010>\u001a\u00020&2\u0006\u0010:\u001a\u00020&H\u0014J\u0010\u0010?\u001a\u00020&2\u0006\u0010@\u001a\u00020\u001aH\u0014J\b\u0010A\u001a\u00020,H\u0014J\b\u0010B\u001a\u00020&H\u0014J\u0014\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0014J\b\u0010D\u001a\u00020\u001aH\u0014J\u0018\u0010E\u001a\u00020,2\u0006\u0010F\u001a\u00020\u00172\u0006\u0010G\u001a\u00020\u0018H\u0014J\b\u0010H\u001a\u00020&H\u0014J\u0014\u0010I\u001a\u00020,2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020L0KJ\n\u0010M\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010N\u001a\u00020,2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000bH\u0002J\u000e\u0010O\u001a\b\u0012\u0004\u0012\u00020L0KH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lapp/termora/vfs2/sftp/MySftpFileObject;", "Lorg/apache/commons/vfs2/provider/AbstractFileObject;", "Lapp/termora/vfs2/sftp/MySftpFileSystem;", "sftpFileSystem", "Lorg/apache/sshd/sftp/client/fs/SftpFileSystem;", "fileName", "Lorg/apache/commons/vfs2/provider/AbstractFileName;", "fileSystem", "<init>", "(Lorg/apache/sshd/sftp/client/fs/SftpFileSystem;Lorg/apache/commons/vfs2/provider/AbstractFileName;Lapp/termora/vfs2/sftp/MySftpFileSystem;)V", "_attributes", "Lorg/apache/sshd/sftp/client/SftpClient$Attributes;", "isInitialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "path", "Lorg/apache/sshd/sftp/client/fs/SftpPath;", "kotlin.jvm.PlatformType", "getPath", "()Lorg/apache/sshd/sftp/client/fs/SftpPath;", "path$delegate", "Lkotlin/Lazy;", "attributes", "", "", "", "doGetContentSize", "", "doGetType", "Lorg/apache/commons/vfs2/FileType;", "doListChildren", "", "()[Ljava/lang/String;", "doListChildrenResolved", "Lorg/apache/commons/vfs2/FileObject;", "()[Lorg/apache/commons/vfs2/FileObject;", "doGetOutputStream", "Ljava/io/OutputStream;", "bAppend", "", "doGetInputStream", "Ljava/io/InputStream;", "bufferSize", "", "doCreateFolder", "", "doIsExecutable", "doIsReadable", "doIsWriteable", "doRename", "newFile", "moveTo", "destFile", "doDelete", "deleteRecursivelySFTP", "sftpClient", "Lorg/apache/sshd/sftp/client/SftpClient;", "doSetExecutable", "executable", "ownerOnly", "doSetReadable", "readable", "doSetWritable", "writable", "doSetLastModifiedTime", "modtime", "doDetach", "doIsHidden", "doGetAttributes", "doGetLastModifiedTime", "doSetAttribute", "attrName", "value", "doIsSymbolicLink", "setPosixFilePermissions", "permissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "getAttributes", "setAttributes", "getPermissions", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nMySftpFileObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MySftpFileObject.kt\napp/termora/vfs2/sftp/MySftpFileObject\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n37#2:274\n36#2,3:275\n1#3:278\n*S KotlinDebug\n*F\n+ 1 MySftpFileObject.kt\napp/termora/vfs2/sftp/MySftpFileObject\n*L\n92#1:274\n92#1:275,3\n*E\n"})
public final class MySftpFileObject
extends AbstractFileObject<MySftpFileSystem> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SftpFileSystem sftpFileSystem;
    @Nullable
    private SftpClient.Attributes _attributes;
    @NotNull
    private final AtomicBoolean isInitialized;
    @NotNull
    private final Lazy path$delegate;
    @NotNull
    private final Map<String, Object> attributes;
    private static final Logger log = LoggerFactory.getLogger(MySftpFileObject.class);
    @NotNull
    public static final String POSIX_FILE_PERMISSIONS = "PosixFilePermissions";

    public MySftpFileObject(@NotNull SftpFileSystem sftpFileSystem, @NotNull AbstractFileName fileName, @NotNull MySftpFileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)sftpFileSystem, (String)"sftpFileSystem");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)((Object)fileSystem), (String)"fileSystem");
        super(fileName, (AbstractFileSystem)fileSystem);
        this.sftpFileSystem = sftpFileSystem;
        this.isInitialized = new AtomicBoolean(false);
        this.path$delegate = LazyKt.lazy(() -> MySftpFileObject.path_delegate$lambda$0(this, fileName));
        this.attributes = new LinkedHashMap();
    }

    private final SftpPath getPath() {
        Lazy lazy = this.path$delegate;
        return (SftpPath)lazy.getValue();
    }

    protected long doGetContentSize() {
        SftpClient.Attributes attributes = this.getAttributes();
        if (attributes == null || !attributes.getFlags().contains(SftpClient.Attribute.Size)) {
            throw new FileSystemException("vfs.provider.sftp/unknown-size.error");
        }
        return attributes.getSize();
    }

    @NotNull
    protected FileType doGetType() {
        FileType fileType;
        SftpClient.Attributes attributes = this.getAttributes();
        if (attributes == null) {
            return FileType.IMAGINARY;
        }
        SftpClient.Attributes attributes2 = attributes;
        if (attributes2.isDirectory()) {
            fileType = FileType.FOLDER;
        } else if (attributes2.isRegularFile()) {
            fileType = FileType.FILE;
        } else if (attributes2.isSymbolicLink()) {
            SftpPath sftpPath = this.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)sftpPath, (String)"<get-path>(...)");
            Path path = Files.readSymbolicLink((Path)sftpPath);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"readSymbolicLink(...)");
            Path e = path;
            if (e instanceof SftpPath && ((SftpPath)e).getAttributes() != null) {
                fileType = ((SftpPath)e).getAttributes().isDirectory() ? FileType.FOLDER : FileType.FILE;
            } else {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                fileType = Files.isDirectory(e, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? FileType.FOLDER : FileType.FILE;
            }
        } else {
            fileType = FileType.IMAGINARY;
        }
        return fileType;
    }

    @Nullable
    protected String[] doListChildren() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected FileObject[] doListChildrenResolved() {
        if (this.isFile()) {
            return null;
        }
        List children = new ArrayList();
        AutoCloseable autoCloseable = Files.list((Path)this.getPath());
        Throwable throwable = null;
        try {
            Stream files = (Stream)autoCloseable;
            boolean bl = false;
            Iterator iterator2 = files.iterator();
            while (iterator2.hasNext()) {
                Path file = (Path)iterator2.next();
                Intrinsics.checkNotNull((Object)file);
                FileObject fo = this.resolveFile(PathsKt.getName((Path)file));
                if (file instanceof WithFileAttributes && fo instanceof MySftpFileObject && ((MySftpFileObject)fo).isInitialized.compareAndSet(false, true)) {
                    ((MySftpFileObject)fo).setAttributes(((WithFileAttributes)file).getAttributes());
                }
                Intrinsics.checkNotNull((Object)fo);
                children.add(fo);
            }
            files = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Collection $this$toTypedArray$iv = children;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FileObject[0]);
    }

    @NotNull
    protected OutputStream doGetOutputStream(boolean bAppend) {
        if (bAppend) {
            SftpPath sftpPath = this.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)sftpPath, (String)"<get-path>(...)");
            Path path = (Path)sftpPath;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.APPEND};
            OutputStream outputStream = Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            return outputStream;
        }
        SftpPath sftpPath = this.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)sftpPath, (String)"<get-path>(...)");
        Path path = (Path)sftpPath;
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        return outputStream;
    }

    @NotNull
    protected InputStream doGetInputStream(int bufferSize) {
        SftpPath sftpPath = this.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)sftpPath, (String)"<get-path>(...)");
        Path path = (Path)sftpPath;
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        return inputStream;
    }

    protected void doCreateFolder() {
        Files.createDirectories((Path)this.getPath(), new FileAttribute[0]);
    }

    protected boolean doIsExecutable() {
        Set<PosixFilePermission> permissions = this.getPermissions();
        return permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE) || permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE) || permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE);
    }

    protected boolean doIsReadable() {
        Set<PosixFilePermission> permissions = this.getPermissions();
        return permissions.contains((Object)PosixFilePermission.GROUP_READ) || permissions.contains((Object)PosixFilePermission.OWNER_READ) || permissions.contains((Object)PosixFilePermission.OTHERS_READ);
    }

    protected boolean doIsWriteable() {
        Set<PosixFilePermission> permissions = this.getPermissions();
        return permissions.contains((Object)PosixFilePermission.GROUP_WRITE) || permissions.contains((Object)PosixFilePermission.OWNER_WRITE) || permissions.contains((Object)PosixFilePermission.OTHERS_WRITE);
    }

    protected void doRename(@NotNull FileObject newFile) {
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        if (!(newFile instanceof MySftpFileObject)) {
            throw new FileSystemException("vfs.provider/rename-not-supported.error");
        }
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
        Files.move((Path)this.getPath(), (Path)((MySftpFileObject)newFile).getPath(), copyOptionArray);
    }

    public void moveTo(@NotNull FileObject destFile) {
        Intrinsics.checkNotNullParameter((Object)destFile, (String)"destFile");
        if (!this.canRenameTo(destFile)) {
            throw new FileSystemException("vfs.provider/rename-not-supported.error");
        }
        this.doRename(destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() {
        Closeable closeable = (Closeable)this.sftpFileSystem.getClient();
        Throwable throwable = null;
        try {
            SftpClient it = (SftpClient)closeable;
            boolean bl = false;
            SftpPath sftpPath = this.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)sftpPath, (String)"<get-path>(...)");
            Intrinsics.checkNotNull((Object)it);
            this.deleteRecursivelySFTP(sftpPath, it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void deleteRecursivelySFTP(SftpPath path, SftpClient sftpClient) {
        boolean isDirectory;
        if (path.getAttributes() != null) {
            v0 = path.getAttributes().isDirectory();
        } else {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            v0 = isDirectory = Files.isDirectory((Path)path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        }
        if (isDirectory) {
            for (SftpClient.DirEntry e : sftpClient.readDir(path.toString())) {
                if (Intrinsics.areEqual((Object)e.getFilename(), (Object)"..") || Intrinsics.areEqual((Object)e.getFilename(), (Object)".")) continue;
                if (e.getAttributes().isDirectory()) {
                    BasePath basePath = path.resolve(e.getFilename());
                    Intrinsics.checkNotNullExpressionValue((Object)basePath, (String)"resolve(...)");
                    this.deleteRecursivelySFTP((SftpPath)basePath, sftpClient);
                    continue;
                }
                sftpClient.remove(((SftpPath)path.resolve(e.getFilename())).toString());
            }
            sftpClient.rmdir(path.toString());
        } else {
            sftpClient.remove(path.toString());
        }
    }

    protected boolean doSetExecutable(boolean executable, boolean ownerOnly) {
        Set permissions = CollectionsKt.toMutableSet((Iterable)this.getPermissions());
        permissions.add(PosixFilePermission.OWNER_EXECUTE);
        if (ownerOnly) {
            permissions.remove((Object)PosixFilePermission.OTHERS_EXECUTE);
            permissions.remove((Object)PosixFilePermission.GROUP_EXECUTE);
        }
        Files.setPosixFilePermissions((Path)this.getPath(), permissions);
        return true;
    }

    protected boolean doSetReadable(boolean readable, boolean ownerOnly) {
        Set permissions = CollectionsKt.toMutableSet((Iterable)this.getPermissions());
        permissions.add(PosixFilePermission.OWNER_READ);
        if (ownerOnly) {
            permissions.remove((Object)PosixFilePermission.OTHERS_READ);
            permissions.remove((Object)PosixFilePermission.GROUP_EXECUTE);
        }
        Files.setPosixFilePermissions((Path)this.getPath(), permissions);
        return true;
    }

    protected boolean doSetWritable(boolean writable, boolean ownerOnly) {
        Set permissions = CollectionsKt.toMutableSet((Iterable)this.getPermissions());
        permissions.add(PosixFilePermission.OWNER_WRITE);
        if (ownerOnly) {
            permissions.remove((Object)PosixFilePermission.OTHERS_WRITE);
            permissions.remove((Object)PosixFilePermission.GROUP_WRITE);
        }
        Files.setPosixFilePermissions((Path)this.getPath(), permissions);
        return true;
    }

    protected boolean doSetLastModifiedTime(long modtime) {
        Files.setLastModifiedTime((Path)this.getPath(), FileTime.fromMillis(modtime));
        return true;
    }

    protected void doDetach() {
        this.setAttributes(null);
        this.isInitialized.compareAndSet(true, false);
    }

    protected boolean doIsHidden() {
        String string = this.getName().getBaseName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBaseName(...)");
        return StringsKt.startsWith$default((String)string, (String)".", (boolean)false, (int)2, null);
    }

    @NotNull
    protected Map<String, Object> doGetAttributes() {
        return this.attributes;
    }

    protected long doGetLastModifiedTime() {
        SftpClient.Attributes attributes = this.getAttributes();
        if (attributes == null || !attributes.getFlags().contains(SftpClient.Attribute.ModifyTime)) {
            throw new FileSystemException("vfs.provider.sftp/unknown-modtime.error");
        }
        return attributes.getModifyTime().toMillis();
    }

    protected void doSetAttribute(@NotNull String attrName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.attributes.put(attrName, value);
    }

    protected boolean doIsSymbolicLink() {
        SftpClient.Attributes attributes = this.getAttributes();
        return attributes != null ? attributes.isSymbolicLink() : false;
    }

    public final void setPosixFilePermissions(@NotNull Set<? extends PosixFilePermission> permissions) {
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        SftpPath sftpPath = this.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)sftpPath, (String)"<get-path>(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Files.setPosixFilePermissions((Path)sftpPath, permissions), (String)"setPosixFilePermissions(...)");
    }

    private final SftpClient.Attributes getAttributes() {
        block3: {
            if (this.isInitialized.compareAndSet(false, true)) {
                try {
                    SftpClient.Attributes attributes = this.sftpFileSystem.provider().readRemoteAttributes(this.sftpFileSystem.provider().toSftpPath((Path)this.getPath()), new LinkOption[0]);
                    this.setAttributes(attributes);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return this._attributes;
    }

    private final void setAttributes(SftpClient.Attributes attributes) {
        if (attributes == null) {
            this.doGetAttributes().remove(POSIX_FILE_PERMISSIONS);
        } else {
            this.doSetAttribute(POSIX_FILE_PERMISSIONS, attributes.getPermissions());
        }
        this._attributes = attributes;
    }

    private final Set<PosixFilePermission> getPermissions() {
        SftpClient.Attributes attributes = this.getAttributes();
        if (attributes == null) {
            return SetsKt.emptySet();
        }
        return FileSystemViewTableModel.Companion.fromSftpPermissions(attributes.getPermissions());
    }

    private static final SftpPath path_delegate$lambda$0(MySftpFileObject this$0, AbstractFileName $fileName) {
        return (SftpPath)this$0.sftpFileSystem.getPath($fileName.getPath(), new String[0]);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/vfs2/sftp/MySftpFileObject$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "POSIX_FILE_PERMISSIONS", "", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

