/*
 * Decompiled with CFR 0.152.
 */
package app.termora.vfs2;

import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a8\u0006\u000b"}, d2={"Lapp/termora/vfs2/VFSWalker;", "", "<init>", "()V", "walk", "Ljava/nio/file/FileVisitResult;", "dir", "Lorg/apache/commons/vfs2/FileObject;", "visitor", "Ljava/nio/file/FileVisitor;", "EmptyBasicFileAttributes", "termora"})
public final class VFSWalker {
    @NotNull
    public static final VFSWalker INSTANCE = new VFSWalker();

    private VFSWalker() {
    }

    @NotNull
    public final FileVisitResult walk(@NotNull FileObject dir, @NotNull FileVisitor<FileObject> visitor) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        if (visitor.preVisitDirectory(dir, EmptyBasicFileAttributes.Companion.getINSTANCE()) == FileVisitResult.TERMINATE) {
            return FileVisitResult.TERMINATE;
        }
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])dir.getChildren());
        while (iterator2.hasNext()) {
            FileObject e = (FileObject)iterator2.next();
            if (Intrinsics.areEqual((Object)e.getName().getBaseName(), (Object)"..") || Intrinsics.areEqual((Object)e.getName().getBaseName(), (Object)".")) continue;
            if (e.isFolder()) {
                FileObject fileObject = dir.resolveFile(e.getName().getBaseName());
                Intrinsics.checkNotNullExpressionValue((Object)fileObject, (String)"resolveFile(...)");
                if (this.walk(fileObject, visitor) != FileVisitResult.TERMINATE) continue;
                return FileVisitResult.TERMINATE;
            }
            FileVisitResult result = visitor.visitFile(dir.resolveFile(e.getName().getBaseName()), EmptyBasicFileAttributes.Companion.getINSTANCE());
            if (result == FileVisitResult.TERMINATE) {
                return FileVisitResult.TERMINATE;
            }
            if (result != FileVisitResult.SKIP_SUBTREE) continue;
        }
        if (visitor.postVisitDirectory(dir, null) == FileVisitResult.TERMINATE) {
            return FileVisitResult.TERMINATE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lapp/termora/vfs2/VFSWalker$EmptyBasicFileAttributes;", "Ljava/nio/file/attribute/BasicFileAttributes;", "<init>", "()V", "lastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "lastAccessTime", "creationTime", "isRegularFile", "", "isDirectory", "isSymbolicLink", "isOther", "size", "", "fileKey", "", "Companion", "termora"})
    private static final class EmptyBasicFileAttributes
    implements BasicFileAttributes {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final EmptyBasicFileAttributes INSTANCE = new EmptyBasicFileAttributes();

        @Override
        @NotNull
        public FileTime lastModifiedTime() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public FileTime lastAccessTime() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public FileTime creationTime() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public boolean isRegularFile() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public boolean isDirectory() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public boolean isSymbolicLink() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public boolean isOther() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public long size() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public Object fileKey() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lapp/termora/vfs2/VFSWalker$EmptyBasicFileAttributes$Companion;", "", "<init>", "()V", "INSTANCE", "Lapp/termora/vfs2/VFSWalker$EmptyBasicFileAttributes;", "getINSTANCE", "()Lapp/termora/vfs2/VFSWalker$EmptyBasicFileAttributes;", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final EmptyBasicFileAttributes getINSTANCE() {
                return INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

