/*
 * Decompiled with CFR 0.152.
 */
package app.termora.tlog;

import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.Database;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.TerminalTabbedManager;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.native.FileChooser;
import app.termora.tlog.LogViewerTerminalTab;
import com.formdev.flatlaf.extras.components.FlatPopupMenu;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019R\u001f\u0010\u0004\u001a\u00060\u0005R\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lapp/termora/tlog/TerminalLoggerAction;", "Lapp/termora/actions/AnAction;", "<init>", "()V", "properties", "Lapp/termora/Database$Properties;", "Lapp/termora/Database;", "getProperties", "()Lapp/termora/Database$Properties;", "properties$delegate", "Lkotlin/Lazy;", "value", "", "isRecording", "()Z", "setRecording", "(Z)V", "actionPerformed", "", "evt", "Lapp/termora/actions/AnActionEvent;", "openLogViewer", "owner", "Ljava/awt/Window;", "getLogDir", "Ljava/io/File;", "termora"})
public final class TerminalLoggerAction
extends AnAction {
    @NotNull
    private final Lazy properties$delegate = LazyKt.lazy(TerminalLoggerAction::properties_delegate$lambda$0);
    private boolean isRecording;

    public TerminalLoggerAction() {
        super(I18n.INSTANCE.getString("termora.terminal-logger"), (Icon)((Object)Icons.INSTANCE.getListFiles()));
        String string = this.getProperties().getString("terminal.logger.isRecording");
        this.isRecording = string != null ? Boolean.parseBoolean(string) : false;
        this.setSmallIcon(this.isRecording ? (Icon)((Object)Icons.INSTANCE.getDotListFiles()) : (Icon)((Object)Icons.INSTANCE.getListFiles()));
    }

    private final Database.Properties getProperties() {
        Lazy lazy = this.properties$delegate;
        return (Database.Properties)lazy.getValue();
    }

    public final boolean isRecording() {
        return this.isRecording;
    }

    private final void setRecording(boolean value) {
        this.isRecording = value;
        this.putValue("Recording", value);
        this.getProperties().putString("terminal.logger.isRecording", String.valueOf(value));
    }

    @Override
    protected void actionPerformed(@NotNull AnActionEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Object source = evt.getSource();
        if (!(source instanceof JComponent)) {
            return;
        }
        FlatPopupMenu popupMenu = new FlatPopupMenu();
        if (this.isRecording) {
            popupMenu.add(I18n.INSTANCE.getString("termora.terminal-logger.stop-recording")).addActionListener(arg_0 -> TerminalLoggerAction.actionPerformed$lambda$1(this, arg_0));
        } else {
            popupMenu.add(I18n.INSTANCE.getString("termora.terminal-logger.start-recording")).addActionListener(arg_0 -> TerminalLoggerAction.actionPerformed$lambda$2(this, arg_0));
        }
        popupMenu.addSeparator();
        popupMenu.add(I18n.INSTANCE.getString("termora.terminal-logger.open-log-viewer")).addActionListener(arg_0 -> TerminalLoggerAction.actionPerformed$lambda$3(this, source, arg_0));
        Object[] objectArray = new Object[]{SystemInfo.isMacOS ? I18n.INSTANCE.getString("termora.finder") : (SystemInfo.isWindows ? I18n.INSTANCE.getString("termora.explorer") : I18n.INSTANCE.getString("termora.folder"))};
        popupMenu.add(I18n.INSTANCE.getString("termora.terminal-logger.open-in-folder", objectArray)).addActionListener(arg_0 -> TerminalLoggerAction.actionPerformed$lambda$4(this, arg_0));
        int width = popupMenu.getPreferredSize().width;
        popupMenu.show((Component)source, -(width / 2) + ((JComponent)source).getWidth() / 2, ((JComponent)source).getHeight());
    }

    private final void openLogViewer(Window owner) {
        FileChooser fc = new FileChooser();
        fc.setAllowsMultiSelection(true);
        fc.setTitle(I18n.INSTANCE.getString("termora.terminal-logger.open-log-viewer"));
        fc.setFileSelectionMode(0);
        if (SystemInfo.isMacOS) {
            fc.setOsxAllowedFileTypes(CollectionsKt.listOf((Object)"log"));
        } else if (SystemInfo.isWindows) {
            fc.getWin32Filters().add((Pair<String, List<String>>)new Pair((Object)"Log files", (Object)CollectionsKt.listOf((Object)"log")));
        }
        String string = this.getLogDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        fc.setDefaultDirectory(string);
        fc.showOpenDialog(owner).thenAccept(arg_0 -> TerminalLoggerAction.openLogViewer$lambda$7(arg_0 -> TerminalLoggerAction.openLogViewer$lambda$6(owner, arg_0), arg_0));
    }

    @NotNull
    public final File getLogDir() {
        String[] stringArray = new String[]{"terminal", "logs", LocalDate.now().toString()};
        File dir = FileUtils.getFile((File)Application.INSTANCE.getBaseDataDir(), (String[])stringArray);
        FileUtils.forceMkdir((File)dir);
        Intrinsics.checkNotNull((Object)dir);
        return dir;
    }

    private static final Database.Properties properties_delegate$lambda$0() {
        return Database.Companion.getDatabase().getProperties();
    }

    private static final void actionPerformed$lambda$1(TerminalLoggerAction this$0, ActionEvent it) {
        this$0.setRecording(false);
        this$0.setSmallIcon((Icon)((Object)Icons.INSTANCE.getListFiles()));
    }

    private static final void actionPerformed$lambda$2(TerminalLoggerAction this$0, ActionEvent it) {
        this$0.setRecording(true);
        this$0.setSmallIcon((Icon)((Object)Icons.INSTANCE.getDotListFiles()));
    }

    private static final void actionPerformed$lambda$3(TerminalLoggerAction this$0, Object $source, ActionEvent it) {
        Window window = SwingUtilities.getWindowAncestor((Component)$source);
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindowAncestor(...)");
        this$0.openLogViewer(window);
    }

    private static final void actionPerformed$lambda$4(TerminalLoggerAction this$0, ActionEvent it) {
        File dir = this$0.getLogDir();
        URI uRI = dir.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
        Application.browse$default(Application.INSTANCE, uRI, false, 2, null);
    }

    private static final void openLogViewer$lambda$6$lambda$5(Window $owner, List $files) {
        TerminalTabbedManager manager = (TerminalTabbedManager)ApplicationScope.Companion.forWindowScope($owner).get(Reflection.getOrCreateKotlinClass(TerminalTabbedManager.class));
        for (File file : $files) {
            LogViewerTerminalTab tab = new LogViewerTerminalTab(ApplicationScope.Companion.forWindowScope($owner), file);
            tab.start();
            TerminalTabbedManager.DefaultImpls.addTerminalTab$default(manager, tab, false, 2, null);
        }
    }

    private static final Unit openLogViewer$lambda$6(Window $owner, List files) {
        Intrinsics.checkNotNull((Object)files);
        if (!((Collection)files).isEmpty()) {
            SwingUtilities.invokeLater(() -> TerminalLoggerAction.openLogViewer$lambda$6$lambda$5($owner, files));
        }
        return Unit.INSTANCE;
    }

    private static final void openLogViewer$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

