/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel.vw;

import app.termora.Disposer;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.SSHTerminalTab;
import app.termora.SshClients;
import app.termora.terminal.panel.vw.AutoRefreshPanel;
import app.termora.terminal.panel.vw.NvidiaSMIVisualWindow;
import app.termora.terminal.panel.vw.SSHVisualWindow;
import app.termora.terminal.panel.vw.SmartProgressBar;
import app.termora.terminal.panel.vw.VisualWindowManager;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.StringReader;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.swing.SwingDispatcherKt;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 (2\u00020\u0001:\u0005()*+,B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0#H\u0014J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0002J\b\u0010'\u001a\u00020%H\u0016R\u001f\u0010\b\u001a\u00060\tR\u00020\u00008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\r\u001a\u0004\b\u001f\u0010 \u00a8\u0006-"}, d2={"Lapp/termora/terminal/panel/vw/NvidiaSMIVisualWindow;", "Lapp/termora/terminal/panel/vw/SSHVisualWindow;", "tab", "Lapp/termora/SSHTerminalTab;", "visualWindowManager", "Lapp/termora/terminal/panel/vw/VisualWindowManager;", "<init>", "(Lapp/termora/SSHTerminalTab;Lapp/termora/terminal/panel/vw/VisualWindowManager;)V", "nvidiaSMIPanel", "Lapp/termora/terminal/panel/vw/NvidiaSMIVisualWindow$NvidiaSMIPanel;", "getNvidiaSMIPanel", "()Lapp/termora/terminal/panel/vw/NvidiaSMIVisualWindow$NvidiaSMIPanel;", "nvidiaSMIPanel$delegate", "Lkotlin/Lazy;", "busyLabel", "Lorg/jdesktop/swingx/JXBusyLabel;", "errorPanel", "Ljavax/swing/JPanel;", "kotlin.jvm.PlatformType", "loadingPanel", "cardLayout", "Ljava/awt/CardLayout;", "rootPanel", "value", "", "isPercentage", "()Z", "setPercentage", "(Z)V", "percentageBtn", "Ljavax/swing/JButton;", "getPercentageBtn", "()Ljavax/swing/JButton;", "percentageBtn$delegate", "toolbarButtons", "", "initViews", "", "initEvents", "dispose", "Companion", "GPU", "NvidiaSMI", "GPUPanel", "NvidiaSMIPanel", "termora"})
public final class NvidiaSMIVisualWindow
extends SSHVisualWindow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy nvidiaSMIPanel$delegate;
    @NotNull
    private final JXBusyLabel busyLabel;
    private final JPanel errorPanel;
    private final JPanel loadingPanel;
    @NotNull
    private final CardLayout cardLayout;
    @NotNull
    private final JPanel rootPanel;
    @NotNull
    private final Lazy percentageBtn$delegate;
    private static final Logger log = LoggerFactory.getLogger(NvidiaSMIVisualWindow.class);

    public NvidiaSMIVisualWindow(@NotNull SSHTerminalTab tab, @NotNull VisualWindowManager visualWindowManager) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        Intrinsics.checkNotNullParameter((Object)visualWindowManager, (String)"visualWindowManager");
        super(tab, "NVIDIA-SMI", visualWindowManager);
        this.nvidiaSMIPanel$delegate = LazyKt.lazy(() -> NvidiaSMIVisualWindow.nvidiaSMIPanel_delegate$lambda$0(this));
        this.busyLabel = new JXBusyLabel();
        this.errorPanel = FormBuilder.create().layout(new FormLayout("pref:grow", "20dlu, pref, 5dlu, pref")).add((Component)new JLabel((Icon)new FlatSVGIcon(Icons.INSTANCE.getWarningDialog().getName(), 60, 60))).xy(1, 2, "center, fill").add((Component)new JLabel("Not supported")).xy(1, 4, "center, fill").build();
        this.loadingPanel = FormBuilder.create().layout(new FormLayout("pref:grow", "20dlu, pref")).add((Component)this.busyLabel).xy(1, 2, "center, fill").build();
        this.cardLayout = new CardLayout();
        this.rootPanel = new JPanel(this.cardLayout);
        this.percentageBtn$delegate = LazyKt.lazy(() -> NvidiaSMIVisualWindow.percentageBtn_delegate$lambda$1(this));
        Disposer.register(tab, this);
        this.initViews();
        this.initEvents();
        this.initVisualWindowPanel();
    }

    private final NvidiaSMIPanel getNvidiaSMIPanel() {
        Lazy lazy = this.nvidiaSMIPanel$delegate;
        return (NvidiaSMIPanel)lazy.getValue();
    }

    private final boolean isPercentage() {
        return Boolean.parseBoolean(this.getProperties().getString("VisualWindow." + this.getId() + ".isPercentage", "false"));
    }

    private final void setPercentage(boolean value) {
        this.getProperties().putString("VisualWindow." + this.getId() + ".isPercentage", String.valueOf(value));
    }

    private final JButton getPercentageBtn() {
        Lazy lazy = this.percentageBtn$delegate;
        return (JButton)lazy.getValue();
    }

    @Override
    @NotNull
    protected List<JButton> toolbarButtons() {
        return CollectionsKt.listOf((Object)this.getPercentageBtn());
    }

    private final void initViews() {
        this.setTitle(I18n.INSTANCE.getString("termora.visual-window.nvidia-smi"));
        this.busyLabel.setBusy(true);
        this.rootPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.rootPanel.add((Component)this.errorPanel, "ErrorPanel");
        this.rootPanel.add((Component)this.loadingPanel, "LoadingPanel");
        this.rootPanel.add((Component)this.getNvidiaSMIPanel(), "NvidiaSMIPanel");
        this.add((Component)this.rootPanel, "Center");
        this.cardLayout.show(this.rootPanel, "LoadingPanel");
    }

    private final void initEvents() {
        this.getPercentageBtn().addActionListener(arg_0 -> NvidiaSMIVisualWindow.initEvents$lambda$2(this, arg_0));
        Disposer.register(this, this.getNvidiaSMIPanel());
    }

    @Override
    public void dispose() {
        this.busyLabel.setBusy(false);
        super.dispose();
    }

    private static final NvidiaSMIPanel nvidiaSMIPanel_delegate$lambda$0(NvidiaSMIVisualWindow this$0) {
        return this$0.new NvidiaSMIPanel();
    }

    private static final JButton percentageBtn_delegate$lambda$1(NvidiaSMIVisualWindow this$0) {
        return new JButton((Icon)((Object)(this$0.isPercentage() ? Icons.INSTANCE.getText() : Icons.INSTANCE.getPercentage())));
    }

    private static final void initEvents$lambda$2(NvidiaSMIVisualWindow this$0, ActionEvent it) {
        this$0.setPercentage(!this$0.isPercentage());
        this$0.getPercentageBtn().setIcon(this$0.isPercentage() ? (Icon)((Object)Icons.INSTANCE.getText()) : (Icon)((Object)Icons.INSTANCE.getPercentage()));
        this$0.getNvidiaSMIPanel().refreshPanel();
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ CardLayout access$getCardLayout$p(NvidiaSMIVisualWindow $this) {
        return $this.cardLayout;
    }

    public static final /* synthetic */ JPanel access$getRootPanel$p(NvidiaSMIVisualWindow $this) {
        return $this.rootPanel;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/terminal/panel/vw/NvidiaSMIVisualWindow$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b8\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0089\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\t\u00102\u001a\u00020\u0005H\u00c6\u0003J\t\u00103\u001a\u00020\u0007H\u00c6\u0003J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\u0007H\u00c6\u0003J\t\u00106\u001a\u00020\u0003H\u00c6\u0003J\t\u00107\u001a\u00020\u0007H\u00c6\u0003J\t\u00108\u001a\u00020\u0003H\u00c6\u0003J\t\u00109\u001a\u00020\u0007H\u00c6\u0003J\t\u0010:\u001a\u00020\u0003H\u00c6\u0003J\t\u0010;\u001a\u00020\u0007H\u00c6\u0003J\t\u0010<\u001a\u00020\u0003H\u00c6\u0003J\t\u0010=\u001a\u00020\u0007H\u00c6\u0003J\u008b\u0001\u0010>\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010B\u001a\u00020\u0005H\u00d6\u0001J\t\u0010C\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0019\"\u0004\b \u0010\u001bR\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0015\"\u0004\b\"\u0010\u001eR\u001a\u0010\u000b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0019\"\u0004\b$\u0010\u001bR\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0015\"\u0004\b&\u0010\u001eR\u001a\u0010\r\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0019\"\u0004\b(\u0010\u001bR\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0015\"\u0004\b*\u0010\u001eR\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0019\"\u0004\b,\u0010\u001bR\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0015\"\u0004\b.\u0010\u001eR\u001a\u0010\u0011\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0019\"\u0004\b0\u0010\u001b\u00a8\u0006D"}, d2={"Lapp/termora/terminal/panel/vw/NvidiaSMIVisualWindow$GPU;", "", "productName", "", "minorNumber", "", "temp", "", "tempText", "powerUsage", "powerUsageText", "powerCap", "powerCapText", "memoryUsage", "memoryUsageText", "memoryCap", "memoryCapText", "gpu", "<init>", "(Ljava/lang/String;IDLjava/lang/String;DLjava/lang/String;DLjava/lang/String;DLjava/lang/String;DLjava/lang/String;D)V", "getProductName", "()Ljava/lang/String;", "getMinorNumber", "()I", "getTemp", "()D", "setTemp", "(D)V", "getTempText", "setTempText", "(Ljava/lang/String;)V", "getPowerUsage", "setPowerUsage", "getPowerUsageText", "setPowerUsageText", "getPowerCap", "setPowerCap", "getPowerCapText", "setPowerCapText", "getMemoryUsage", "setMemoryUsage", "getMemoryUsageText", "setMemoryUsageText", "getMemoryCap", "setMemoryCap", "getMemoryCapText", "setMemoryCapText", "getGpu", "setGpu", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "copy", "equals", "", "other", "hashCode", "toString", "termora"})
    private static final class GPU {
        @NotNull
        private final String productName;
        private final int minorNumber;
        private double temp;
        @NotNull
        private String tempText;
        private double powerUsage;
        @NotNull
        private String powerUsageText;
        private double powerCap;
        @NotNull
        private String powerCapText;
        private double memoryUsage;
        @NotNull
        private String memoryUsageText;
        private double memoryCap;
        @NotNull
        private String memoryCapText;
        private double gpu;

        public GPU(@NotNull String productName, int minorNumber, double temp, @NotNull String tempText, double powerUsage, @NotNull String powerUsageText, double powerCap, @NotNull String powerCapText, double memoryUsage, @NotNull String memoryUsageText, double memoryCap, @NotNull String memoryCapText, double gpu) {
            Intrinsics.checkNotNullParameter((Object)productName, (String)"productName");
            Intrinsics.checkNotNullParameter((Object)tempText, (String)"tempText");
            Intrinsics.checkNotNullParameter((Object)powerUsageText, (String)"powerUsageText");
            Intrinsics.checkNotNullParameter((Object)powerCapText, (String)"powerCapText");
            Intrinsics.checkNotNullParameter((Object)memoryUsageText, (String)"memoryUsageText");
            Intrinsics.checkNotNullParameter((Object)memoryCapText, (String)"memoryCapText");
            this.productName = productName;
            this.minorNumber = minorNumber;
            this.temp = temp;
            this.tempText = tempText;
            this.powerUsage = powerUsage;
            this.powerUsageText = powerUsageText;
            this.powerCap = powerCap;
            this.powerCapText = powerCapText;
            this.memoryUsage = memoryUsage;
            this.memoryUsageText = memoryUsageText;
            this.memoryCap = memoryCap;
            this.memoryCapText = memoryCapText;
            this.gpu = gpu;
        }

        public /* synthetic */ GPU(String string, int n, double d, String string2, double d2, String string3, double d3, String string4, double d4, String string5, double d5, String string6, double d6, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = "";
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                d = 0.0;
            }
            if ((n2 & 8) != 0) {
                string2 = "";
            }
            if ((n2 & 0x10) != 0) {
                d2 = 0.0;
            }
            if ((n2 & 0x20) != 0) {
                string3 = "";
            }
            if ((n2 & 0x40) != 0) {
                d3 = 0.0;
            }
            if ((n2 & 0x80) != 0) {
                string4 = "";
            }
            if ((n2 & 0x100) != 0) {
                d4 = 0.0;
            }
            if ((n2 & 0x200) != 0) {
                string5 = "";
            }
            if ((n2 & 0x400) != 0) {
                d5 = 0.0;
            }
            if ((n2 & 0x800) != 0) {
                string6 = "";
            }
            if ((n2 & 0x1000) != 0) {
                d6 = 0.0;
            }
            this(string, n, d, string2, d2, string3, d3, string4, d4, string5, d5, string6, d6);
        }

        @NotNull
        public final String getProductName() {
            return this.productName;
        }

        public final int getMinorNumber() {
            return this.minorNumber;
        }

        public final double getTemp() {
            return this.temp;
        }

        public final void setTemp(double d) {
            this.temp = d;
        }

        @NotNull
        public final String getTempText() {
            return this.tempText;
        }

        public final void setTempText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.tempText = string;
        }

        public final double getPowerUsage() {
            return this.powerUsage;
        }

        public final void setPowerUsage(double d) {
            this.powerUsage = d;
        }

        @NotNull
        public final String getPowerUsageText() {
            return this.powerUsageText;
        }

        public final void setPowerUsageText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.powerUsageText = string;
        }

        public final double getPowerCap() {
            return this.powerCap;
        }

        public final void setPowerCap(double d) {
            this.powerCap = d;
        }

        @NotNull
        public final String getPowerCapText() {
            return this.powerCapText;
        }

        public final void setPowerCapText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.powerCapText = string;
        }

        public final double getMemoryUsage() {
            return this.memoryUsage;
        }

        public final void setMemoryUsage(double d) {
            this.memoryUsage = d;
        }

        @NotNull
        public final String getMemoryUsageText() {
            return this.memoryUsageText;
        }

        public final void setMemoryUsageText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.memoryUsageText = string;
        }

        public final double getMemoryCap() {
            return this.memoryCap;
        }

        public final void setMemoryCap(double d) {
            this.memoryCap = d;
        }

        @NotNull
        public final String getMemoryCapText() {
            return this.memoryCapText;
        }

        public final void setMemoryCapText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.memoryCapText = string;
        }

        public final double getGpu() {
            return this.gpu;
        }

        public final void setGpu(double d) {
            this.gpu = d;
        }

        @NotNull
        public final String component1() {
            return this.productName;
        }

        public final int component2() {
            return this.minorNumber;
        }

        public final double component3() {
            return this.temp;
        }

        @NotNull
        public final String component4() {
            return this.tempText;
        }

        public final double component5() {
            return this.powerUsage;
        }

        @NotNull
        public final String component6() {
            return this.powerUsageText;
        }

        public final double component7() {
            return this.powerCap;
        }

        @NotNull
        public final String component8() {
            return this.powerCapText;
        }

        public final double component9() {
            return this.memoryUsage;
        }

        @NotNull
        public final String component10() {
            return this.memoryUsageText;
        }

        public final double component11() {
            return this.memoryCap;
        }

        @NotNull
        public final String component12() {
            return this.memoryCapText;
        }

        public final double component13() {
            return this.gpu;
        }

        @NotNull
        public final GPU copy(@NotNull String productName, int minorNumber, double temp, @NotNull String tempText, double powerUsage, @NotNull String powerUsageText, double powerCap, @NotNull String powerCapText, double memoryUsage, @NotNull String memoryUsageText, double memoryCap, @NotNull String memoryCapText, double gpu) {
            Intrinsics.checkNotNullParameter((Object)productName, (String)"productName");
            Intrinsics.checkNotNullParameter((Object)tempText, (String)"tempText");
            Intrinsics.checkNotNullParameter((Object)powerUsageText, (String)"powerUsageText");
            Intrinsics.checkNotNullParameter((Object)powerCapText, (String)"powerCapText");
            Intrinsics.checkNotNullParameter((Object)memoryUsageText, (String)"memoryUsageText");
            Intrinsics.checkNotNullParameter((Object)memoryCapText, (String)"memoryCapText");
            return new GPU(productName, minorNumber, temp, tempText, powerUsage, powerUsageText, powerCap, powerCapText, memoryUsage, memoryUsageText, memoryCap, memoryCapText, gpu);
        }

        public static /* synthetic */ GPU copy$default(GPU gPU, String string, int n, double d, String string2, double d2, String string3, double d3, String string4, double d4, String string5, double d5, String string6, double d6, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = gPU.productName;
            }
            if ((n2 & 2) != 0) {
                n = gPU.minorNumber;
            }
            if ((n2 & 4) != 0) {
                d = gPU.temp;
            }
            if ((n2 & 8) != 0) {
                string2 = gPU.tempText;
            }
            if ((n2 & 0x10) != 0) {
                d2 = gPU.powerUsage;
            }
            if ((n2 & 0x20) != 0) {
                string3 = gPU.powerUsageText;
            }
            if ((n2 & 0x40) != 0) {
                d3 = gPU.powerCap;
            }
            if ((n2 & 0x80) != 0) {
                string4 = gPU.powerCapText;
            }
            if ((n2 & 0x100) != 0) {
                d4 = gPU.memoryUsage;
            }
            if ((n2 & 0x200) != 0) {
                string5 = gPU.memoryUsageText;
            }
            if ((n2 & 0x400) != 0) {
                d5 = gPU.memoryCap;
            }
            if ((n2 & 0x800) != 0) {
                string6 = gPU.memoryCapText;
            }
            if ((n2 & 0x1000) != 0) {
                d6 = gPU.gpu;
            }
            return gPU.copy(string, n, d, string2, d2, string3, d3, string4, d4, string5, d5, string6, d6);
        }

        @NotNull
        public String toString() {
            return "GPU(productName=" + this.productName + ", minorNumber=" + this.minorNumber + ", temp=" + this.temp + ", tempText=" + this.tempText + ", powerUsage=" + this.powerUsage + ", powerUsageText=" + this.powerUsageText + ", powerCap=" + this.powerCap + ", powerCapText=" + this.powerCapText + ", memoryUsage=" + this.memoryUsage + ", memoryUsageText=" + this.memoryUsageText + ", memoryCap=" + this.memoryCap + ", memoryCapText=" + this.memoryCapText + ", gpu=" + this.gpu + ")";
        }

        public int hashCode() {
            int result = this.productName.hashCode();
            result = result * 31 + Integer.hashCode(this.minorNumber);
            result = result * 31 + Double.hashCode(this.temp);
            result = result * 31 + this.tempText.hashCode();
            result = result * 31 + Double.hashCode(this.powerUsage);
            result = result * 31 + this.powerUsageText.hashCode();
            result = result * 31 + Double.hashCode(this.powerCap);
            result = result * 31 + this.powerCapText.hashCode();
            result = result * 31 + Double.hashCode(this.memoryUsage);
            result = result * 31 + this.memoryUsageText.hashCode();
            result = result * 31 + Double.hashCode(this.memoryCap);
            result = result * 31 + this.memoryCapText.hashCode();
            result = result * 31 + Double.hashCode(this.gpu);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GPU)) {
                return false;
            }
            GPU gPU = (GPU)other;
            if (!Intrinsics.areEqual((Object)this.productName, (Object)gPU.productName)) {
                return false;
            }
            if (this.minorNumber != gPU.minorNumber) {
                return false;
            }
            if (Double.compare(this.temp, gPU.temp) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tempText, (Object)gPU.tempText)) {
                return false;
            }
            if (Double.compare(this.powerUsage, gPU.powerUsage) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.powerUsageText, (Object)gPU.powerUsageText)) {
                return false;
            }
            if (Double.compare(this.powerCap, gPU.powerCap) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.powerCapText, (Object)gPU.powerCapText)) {
                return false;
            }
            if (Double.compare(this.memoryUsage, gPU.memoryUsage) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.memoryUsageText, (Object)gPU.memoryUsageText)) {
                return false;
            }
            if (Double.compare(this.memoryCap, gPU.memoryCap) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.memoryCapText, (Object)gPU.memoryCapText)) {
                return false;
            }
            return Double.compare(this.gpu, gPU.gpu) == 0;
        }

        public GPU() {
            this(null, 0, 0.0, null, 0.0, null, 0.0, null, 0.0, null, 0.0, null, 0.0, 8191, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\u0014"}, d2={"Lapp/termora/terminal/panel/vw/NvidiaSMIVisualWindow$GPUPanel;", "Ljavax/swing/JPanel;", "minorNumber", "", "title", "", "<init>", "(ILjava/lang/String;)V", "getMinorNumber", "()I", "gpuProgressBar", "Lapp/termora/terminal/panel/vw/SmartProgressBar;", "getGpuProgressBar", "()Lapp/termora/terminal/panel/vw/SmartProgressBar;", "tempProgressBar", "getTempProgressBar", "memProgressBar", "getMemProgressBar", "powerProgressBar", "getPowerProgressBar", "termora"})
    @SourceDebugExtension(value={"SMAP\nNvidiaSMIVisualWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NvidiaSMIVisualWindow.kt\napp/termora/terminal/panel/vw/NvidiaSMIVisualWindow$GPUPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,387:1\n1#2:388\n*E\n"})
    private static final class GPUPanel
    extends JPanel {
        private final int minorNumber;
        @NotNull
        private final SmartProgressBar gpuProgressBar;
        @NotNull
        private final SmartProgressBar tempProgressBar;
        @NotNull
        private final SmartProgressBar memProgressBar;
        @NotNull
        private final SmartProgressBar powerProgressBar;

        public GPUPanel(int minorNumber, @NotNull String title) {
            FormBuilder formBuilder;
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            super(new BorderLayout());
            this.minorNumber = minorNumber;
            this.gpuProgressBar = new SmartProgressBar();
            this.tempProgressBar = new SmartProgressBar();
            this.memProgressBar = new SmartProgressBar();
            this.powerProgressBar = new SmartProgressBar();
            String formMargin = "4dlu";
            int rows = 0;
            rows = 1;
            int step = 2;
            FormBuilder $this$_init__u24lambda_u240 = formBuilder = FormBuilder.create().debug(false).layout(new FormLayout("left:pref, " + formMargin + ", default:grow", "pref, " + formMargin + ", pref, " + formMargin + ", pref, " + formMargin + ", pref")).border((Border)BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(4, 4, 4, 4))).add("GPU: ", new Object[0]).xy(1, rows).add((Component)((Object)this.gpuProgressBar)).xy(3, rows);
            boolean bl = false;
            FormBuilder $this$_init__u24lambda_u241 = formBuilder = formBuilder.add("Temp: ", new Object[0]).xy(1, rows += step).add((Component)((Object)this.tempProgressBar)).xy(3, rows);
            boolean bl2 = false;
            FormBuilder $this$_init__u24lambda_u242 = formBuilder = formBuilder.add("Mem: ", new Object[0]).xy(1, rows += step).add((Component)((Object)this.memProgressBar)).xy(3, rows);
            boolean bl3 = false;
            FormBuilder $this$_init__u24lambda_u243 = formBuilder = formBuilder.add("Power: ", new Object[0]).xy(1, rows += step).add((Component)((Object)this.powerProgressBar)).xy(3, rows);
            boolean bl4 = false;
            rows += step;
            JPanel p = formBuilder.build();
            this.add((Component)p, "Center");
        }

        public final int getMinorNumber() {
            return this.minorNumber;
        }

        @NotNull
        public final SmartProgressBar getGpuProgressBar() {
            return this.gpuProgressBar;
        }

        @NotNull
        public final SmartProgressBar getTempProgressBar() {
            return this.tempProgressBar;
        }

        @NotNull
        public final SmartProgressBar getMemProgressBar() {
            return this.memProgressBar;
        }

        @NotNull
        public final SmartProgressBar getPowerProgressBar() {
            return this.powerProgressBar;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B+\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lapp/termora/terminal/panel/vw/NvidiaSMIVisualWindow$NvidiaSMI;", "", "driverVersion", "", "cudaVersion", "gpus", "", "Lapp/termora/terminal/panel/vw/NvidiaSMIVisualWindow$GPU;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getDriverVersion", "()Ljava/lang/String;", "getCudaVersion", "getGpus", "()Ljava/util/List;", "termora"})
    private static final class NvidiaSMI {
        @NotNull
        private final String driverVersion;
        @NotNull
        private final String cudaVersion;
        @NotNull
        private final List<GPU> gpus;

        public NvidiaSMI(@NotNull String driverVersion, @NotNull String cudaVersion, @NotNull List<GPU> gpus) {
            Intrinsics.checkNotNullParameter((Object)driverVersion, (String)"driverVersion");
            Intrinsics.checkNotNullParameter((Object)cudaVersion, (String)"cudaVersion");
            Intrinsics.checkNotNullParameter(gpus, (String)"gpus");
            this.driverVersion = driverVersion;
            this.cudaVersion = cudaVersion;
            this.gpus = gpus;
        }

        public /* synthetic */ NvidiaSMI(String string, String string2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            if ((n & 4) != 0) {
                list = new ArrayList();
            }
            this(string, string2, list);
        }

        @NotNull
        public final String getDriverVersion() {
            return this.driverVersion;
        }

        @NotNull
        public final String getCudaVersion() {
            return this.cudaVersion;
        }

        @NotNull
        public final List<GPU> getGpus() {
            return this.gpus;
        }

        public NvidiaSMI() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\u0016\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0094@\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0019H\u0002J\u0006\u0010 \u001a\u00020\u0019J\u0018\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR#\u0010\u000b\u001a\n \u0006*\u0004\u0018\u00010\f0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lapp/termora/terminal/panel/vw/NvidiaSMIVisualWindow$NvidiaSMIPanel;", "Lapp/termora/terminal/panel/vw/AutoRefreshPanel;", "<init>", "(Lapp/termora/terminal/panel/vw/NvidiaSMIVisualWindow;)V", "xPath", "Ljavax/xml/xpath/XPath;", "kotlin.jvm.PlatformType", "getXPath", "()Ljavax/xml/xpath/XPath;", "xPath$delegate", "Lkotlin/Lazy;", "db", "Ljavax/xml/parsers/DocumentBuilder;", "getDb", "()Ljavax/xml/parsers/DocumentBuilder;", "db$delegate", "nvidiaSMI", "Lapp/termora/terminal/panel/vw/NvidiaSMIVisualWindow$NvidiaSMI;", "gpuRootPanel", "Ljavax/swing/JPanel;", "driverVersionLabel", "Ljavax/swing/JLabel;", "cudaVersionLabel", "gpusLabel", "initViews", "", "initEvents", "refresh", "isFirst", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initPanel", "refreshPanel", "refreshGPUPanel", "gpu", "Lapp/termora/terminal/panel/vw/NvidiaSMIVisualWindow$GPU;", "g", "Lapp/termora/terminal/panel/vw/NvidiaSMIVisualWindow$GPUPanel;", "termora"})
    private final class NvidiaSMIPanel
    extends AutoRefreshPanel {
        @NotNull
        private final Lazy xPath$delegate = LazyKt.lazy(NvidiaSMIPanel::xPath_delegate$lambda$0);
        @NotNull
        private final Lazy db$delegate = LazyKt.lazy(NvidiaSMIPanel::db_delegate$lambda$1);
        @NotNull
        private NvidiaSMI nvidiaSMI = new NvidiaSMI(null, null, null, 7, null);
        @NotNull
        private final JPanel gpuRootPanel = new JPanel();
        @NotNull
        private final JLabel driverVersionLabel = new JLabel();
        @NotNull
        private final JLabel cudaVersionLabel = new JLabel();
        @NotNull
        private final JLabel gpusLabel = new JLabel();

        public NvidiaSMIPanel() {
            this.initViews();
            this.initEvents();
        }

        private final XPath getXPath() {
            Lazy lazy = this.xPath$delegate;
            return (XPath)lazy.getValue();
        }

        private final DocumentBuilder getDb() {
            Lazy lazy = this.db$delegate;
            return (DocumentBuilder)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        private final void initViews() {
            void $this$initViews_u24lambda_u242;
            JScrollPane jScrollPane;
            this.setLayout(new BorderLayout());
            this.add((Component)FormBuilder.create().debug(false).layout(new FormLayout("default:grow, pref, default:grow, 4dlu, pref, default:grow, 4dlu, pref, default:grow, default:grow", "pref, 4dlu")).add(Box.createHorizontalGlue()).xy(1, 1).add("Driver: ", new Object[0]).xy(2, 1).add((Component)this.driverVersionLabel).xy(3, 1).add("CUDA: ", new Object[0]).xy(5, 1).add((Component)this.cudaVersionLabel).xy(6, 1).add("GPUS: ", new Object[0]).xy(8, 1).add((Component)this.gpusLabel).xy(9, 1).add(Box.createHorizontalGlue()).xy(10, 1).build(), "North");
            JScrollPane jScrollPane2 = jScrollPane = new JScrollPane(this.gpuRootPanel);
            NvidiaSMIPanel nvidiaSMIPanel = this;
            boolean bl = false;
            $this$initViews_u24lambda_u242.getVerticalScrollBar().setMaximumSize(new Dimension(0, 0));
            $this$initViews_u24lambda_u242.getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
            $this$initViews_u24lambda_u242.getVerticalScrollBar().setMinimumSize(new Dimension(0, 0));
            $this$initViews_u24lambda_u242.setBorder(BorderFactory.createEmptyBorder());
            nvidiaSMIPanel.add((Component)jScrollPane, "Center");
        }

        private final void initEvents() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        @Nullable
        protected Object refresh(boolean var1_1, @NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof refresh.1)) ** GOTO lbl-1000
            var10_3 = $completion;
            if ((var10_3.label & -2147483648) != 0) {
                var10_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ NvidiaSMIPanel this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.refresh(false, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = NvidiaSMIVisualWindow.this.getTab().getData(SSHTerminalTab.Companion.getSSHSession());
                    if (v0 == null) {
                        return Unit.INSTANCE;
                    }
                    session = v0;
                    try {
                        var5_7 /* !! */  = SshClients.INSTANCE.execChannel(session, "nvidia-smi -x -q");
                        code = ((Number)var5_7 /* !! */ .component1()).intValue();
                        text = (String)var5_7 /* !! */ .component2();
                        if (!StringUtils.isNotBlank((CharSequence)text)) {
                            throw new IllegalStateException("exit code: " + code);
                        }
                        var5_7 /* !! */  = this.getDb().parse(new InputSource(new StringReader(text)));
                    }
                    catch (Exception e) {
                        if (NvidiaSMIVisualWindow.access$getLog$cp().isErrorEnabled()) {
                            NvidiaSMIVisualWindow.access$getLog$cp().error(e.getMessage(), (Throwable)e);
                        }
                        var5_7 /* !! */  = null;
                    }
                    doc = var5_7 /* !! */ ;
                    if (doc != null) break;
                    if (isFirst == false) ** GOTO lbl41
                    $continuation.label = 1;
                    v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(NvidiaSMIVisualWindow.this, null){
                        int label;
                        final /* synthetic */ NvidiaSMIVisualWindow this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    NvidiaSMIVisualWindow.access$getCardLayout$p(this.this$0).show(NvidiaSMIVisualWindow.access$getRootPanel$p(this.this$0), "ErrorPanel");
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v1 == var11_5) {
                        return var11_5;
                    }
                    ** GOTO lbl40
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl40:
                    // 2 sources

                    SwingUtilities.invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, refresh$lambda$3(app.termora.terminal.panel.vw.NvidiaSMIVisualWindow$NvidiaSMIPanel ), ()V)((NvidiaSMIPanel)this));
lbl41:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            v2 = this.getXPath().compile("/nvidia_smi_log/driver_version/text()").evaluate(doc);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"evaluate(...)");
            v3 = this.getXPath().compile("/nvidia_smi_log/cuda_version/text()").evaluate(doc);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"evaluate(...)");
            this.nvidiaSMI = new NvidiaSMI(v2, v3, null, 4, null);
            v4 = this.getXPath().compile("/nvidia_smi_log/attached_gpus/text()").evaluate(doc);
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"evaluate(...)");
            v5 = StringsKt.toIntOrNull((String)v4);
            attachedGPUs = v5 != null ? v5 : 0;
            i = 1;
            if (i <= attachedGPUs) {
                while (true) {
                    v6 = this.getXPath().compile("/nvidia_smi_log/gpu[" + i + "]/product_name/text()").evaluate(doc);
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"evaluate(...)");
                    v7 = this.getXPath().compile("/nvidia_smi_log/gpu[" + i + "]/minor_number/text()").evaluate(doc);
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"evaluate(...)");
                    v8 = StringsKt.toIntOrNull((String)v7);
                    v9 = v8 != null ? v8 : 0;
                    v10 = this.getXPath().compile("/nvidia_smi_log/gpu[" + i + "]/temperature/gpu_temp/text()").evaluate(doc);
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"evaluate(...)");
                    v11 = this.getXPath().compile("/nvidia_smi_log/gpu[" + i + "]/gpu_power_readings/power_draw/text()").evaluate(doc);
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"evaluate(...)");
                    v12 = this.getXPath().compile("/nvidia_smi_log/gpu[" + i + "]/gpu_power_readings/max_power_limit/text()").evaluate(doc);
                    Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"evaluate(...)");
                    v13 = this.getXPath().compile("/nvidia_smi_log/gpu[" + i + "]/fb_memory_usage/used/text()").evaluate(doc);
                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"evaluate(...)");
                    v14 = this.getXPath().compile("/nvidia_smi_log/gpu[" + i + "]/fb_memory_usage/total/text()").evaluate(doc);
                    Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"evaluate(...)");
                    v15 = this.getXPath().compile("/nvidia_smi_log/gpu[" + i + "]/utilization/gpu_util/text()").evaluate(doc);
                    Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"evaluate(...)");
                    var8_13 = new String[]{" "};
                    v16 = StringsKt.toDoubleOrNull((String)((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)v15, (String[])var8_13, (boolean)false, (int)0, (int)6, null))));
                    gpu = new GPU(v6, v9, 0.0, v10, 0.0, v11, 0.0, v12, 0.0, v13, 0.0, v14, v16 != null ? v16 : 0.0, 1364, null);
                    var8_13 = new String[]{" "};
                    v17 = StringsKt.toDoubleOrNull((String)((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)gpu.getTempText(), (String[])var8_13, (boolean)false, (int)0, (int)6, null))));
                    var8_13 = new String[]{" "};
                    v18 = StringsKt.toDoubleOrNull((String)((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)gpu.getPowerUsageText(), (String[])var8_13, (boolean)false, (int)0, (int)6, null))));
                    var8_13 = new String[]{" "};
                    v19 = StringsKt.toDoubleOrNull((String)((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)gpu.getPowerCapText(), (String[])var8_13, (boolean)false, (int)0, (int)6, null))));
                    var8_13 = new String[]{" "};
                    v20 = StringsKt.toDoubleOrNull((String)((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)gpu.getMemoryUsageText(), (String[])var8_13, (boolean)false, (int)0, (int)6, null))));
                    var8_13 = new String[]{" "};
                    v21 = StringsKt.toDoubleOrNull((String)((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)gpu.getMemoryCapText(), (String[])var8_13, (boolean)false, (int)0, (int)6, null))));
                    this.nvidiaSMI.getGpus().add(GPU.copy$default(gpu, null, 0, v17 != null ? v17 : 0.0, null, v18 != null ? v18 : 0.0, null, v19 != null ? v19 : 0.0, null, v20 != null ? v20 : 0.0, null, v21 != null ? v21 : 0.0, null, 0.0, 6827, null));
                    if (i == attachedGPUs) break;
                    ++i;
                }
            }
            $continuation.label = 2;
            v22 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(isFirst != false, this, NvidiaSMIVisualWindow.this, null){
                int label;
                final /* synthetic */ boolean $isFirst;
                final /* synthetic */ NvidiaSMIPanel this$0;
                final /* synthetic */ NvidiaSMIVisualWindow this$1;
                {
                    this.$isFirst = $isFirst;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            if (this.$isFirst) {
                                NvidiaSMIPanel.access$initPanel(this.this$0);
                                NvidiaSMIVisualWindow.access$getCardLayout$p(this.this$1).show(NvidiaSMIVisualWindow.access$getRootPanel$p(this.this$1), "NvidiaSMIPanel");
                            }
                            this.this$0.refreshPanel();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (Continuation)$continuation);
            if (v22 == var11_5) {
                return var11_5;
            }
            ** GOTO lbl98
            {
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v22 = $result;
lbl98:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final void initPanel() {
            this.gpuRootPanel.setLayout(new GridLayout(this.nvidiaSMI.getGpus().size() % 2 == 0 ? this.nvidiaSMI.getGpus().size() / 2 : this.nvidiaSMI.getGpus().size() / 2 + 1, 2, 4, 4));
            for (GPU e : this.nvidiaSMI.getGpus()) {
                this.gpuRootPanel.add(new GPUPanel(e.getMinorNumber(), e.getMinorNumber() + " " + e.getProductName()));
            }
        }

        public final void refreshPanel() {
            this.cudaVersionLabel.setText(this.nvidiaSMI.getCudaVersion());
            this.driverVersionLabel.setText(this.nvidiaSMI.getDriverVersion());
            this.gpusLabel.setText(String.valueOf(this.nvidiaSMI.getGpus().size()));
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this.gpuRootPanel.getComponents());
            block0: while (iterator2.hasNext()) {
                Component c2 = (Component)iterator2.next();
                if (!(c2 instanceof GPUPanel)) continue;
                for (GPU g : this.nvidiaSMI.getGpus()) {
                    if (((GPUPanel)c2).getMinorNumber() != g.getMinorNumber()) continue;
                    this.refreshGPUPanel(g, (GPUPanel)c2);
                    continue block0;
                }
            }
        }

        private final void refreshGPUPanel(GPU gpu, GPUPanel g) {
            g.getGpuProgressBar().setValue((int)gpu.getGpu());
            g.getTempProgressBar().setValue((int)gpu.getTemp());
            g.getTempProgressBar().setString((String)(NvidiaSMIVisualWindow.this.isPercentage() ? g.getTempProgressBar().getValue() + "%" : gpu.getTempText()));
            g.getPowerProgressBar().setValue((int)(gpu.getPowerUsage() / gpu.getPowerCap() * 100.0));
            g.getPowerProgressBar().setString(NvidiaSMIVisualWindow.this.isPercentage() ? g.getPowerProgressBar().getValue() + "%" : gpu.getPowerUsageText() + "/" + gpu.getPowerCapText());
            g.getMemProgressBar().setValue((int)(gpu.getMemoryUsage() / gpu.getMemoryCap() * 100.0));
            g.getMemProgressBar().setString(NvidiaSMIVisualWindow.this.isPercentage() ? g.getMemProgressBar().getValue() + "%" : gpu.getMemoryUsageText() + "/" + gpu.getMemoryCapText());
        }

        private static final XPath xPath_delegate$lambda$0() {
            return XPathFactory.newInstance().newXPath();
        }

        private static final DocumentBuilder db_delegate$lambda$1() {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setXIncludeAware(false);
            factory.setNamespaceAware(false);
            DocumentBuilder db2 = factory.newDocumentBuilder();
            db2.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) {
                    return StringUtils.contains((CharSequence)systemId, (CharSequence)".dtd") ? new InputSource(new StringReader("")) : null;
                }
            });
            return db2;
        }

        private static final void refresh$lambda$3(NvidiaSMIPanel this$0) {
            CoroutineScopeKt.cancel$default((CoroutineScope)this$0.getCoroutineScope(), null, (int)1, null);
        }

        public static final /* synthetic */ void access$initPanel(NvidiaSMIPanel $this) {
            $this.initPanel();
        }
    }
}

