/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel;

import app.termora.terminal.ColorPalette;
import app.termora.terminal.FindKind;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalColor;
import app.termora.terminal.panel.TerminalFindPanel;
import app.termora.terminal.panel.TerminalPanel;
import com.formdev.flatlaf.ui.FlatScrollBarUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ScrollBarUI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lapp/termora/terminal/panel/TerminalScrollBar;", "Ljavax/swing/JScrollBar;", "terminalPanel", "Lapp/termora/terminal/panel/TerminalPanel;", "terminalFindPanel", "Lapp/termora/terminal/panel/TerminalFindPanel;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/panel/TerminalPanel;Lapp/termora/terminal/panel/TerminalFindPanel;Lapp/termora/terminal/Terminal;)V", "colorPalette", "Lapp/termora/terminal/ColorPalette;", "getColorPalette", "()Lapp/termora/terminal/ColorPalette;", "myUI", "Lapp/termora/terminal/panel/TerminalScrollBar$MyScrollBarUI;", "setUI", "", "ui", "Ljavax/swing/plaf/ScrollBarUI;", "drawFindMap", "g", "Ljava/awt/Graphics;", "trackBounds", "Ljava/awt/Rectangle;", "MyScrollBarUI", "termora"})
public final class TerminalScrollBar
extends JScrollBar {
    @NotNull
    private final TerminalPanel terminalPanel;
    @NotNull
    private final TerminalFindPanel terminalFindPanel;
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final MyScrollBarUI myUI;

    public TerminalScrollBar(@NotNull TerminalPanel terminalPanel, @NotNull TerminalFindPanel terminalFindPanel, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
        Intrinsics.checkNotNullParameter((Object)terminalFindPanel, (String)"terminalFindPanel");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminalPanel = terminalPanel;
        this.terminalFindPanel = terminalFindPanel;
        this.terminal = terminal;
        this.myUI = new MyScrollBarUI();
        this.setUI((ScrollBarUI)((Object)this.myUI));
    }

    private final ColorPalette getColorPalette() {
        return this.terminal.getTerminalModel().getColorPalette();
    }

    @Override
    public void setUI(@NotNull ScrollBarUI ui) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        super.setUI((ScrollBarUI)((Object)this.myUI));
    }

    private final void drawFindMap(Graphics g, Rectangle trackBounds) {
        if (!this.terminalPanel.getFindMap()) {
            return;
        }
        List<FindKind> kinds = this.terminalFindPanel.getKinds();
        if (kinds.isEmpty()) {
            return;
        }
        int averageCharWidth = this.terminalPanel.getAverageCharWidth() * 2;
        int count = Math.max(this.terminal.getDocument().getLineCount(), this.terminal.getTerminalModel().getRows());
        int lineHeight = Math.max((int)Math.ceil(1.0 * (double)trackBounds.height / (double)count), 1);
        LinkedHashSet<Integer> rows = new LinkedHashSet<Integer>();
        for (FindKind kind : kinds) {
            rows.add(kind.getStartPosition().getY());
            rows.add(kind.getEndPosition().getY());
        }
        g.setColor(new Color(this.getColorPalette().getColor(TerminalColor.Find.INSTANCE.getBACKGROUND())));
        Iterator iterator2 = rows.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<FindKind> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            FindKind findKind = iterator3.next();
            Intrinsics.checkNotNullExpressionValue((Object)findKind, (String)"next(...)");
            int row = ((Number)((Object)findKind)).intValue();
            double n = (double)row * 1.0 / (double)count;
            int y = Math.max((int)Math.ceil((double)trackBounds.height * n) - lineHeight, 0);
            g.fillRect(trackBounds.width - averageCharWidth, y, averageCharWidth, lineHeight);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lapp/termora/terminal/panel/TerminalScrollBar$MyScrollBarUI;", "Lcom/formdev/flatlaf/ui/FlatScrollBarUI;", "<init>", "(Lapp/termora/terminal/panel/TerminalScrollBar;)V", "paintTrack", "", "g", "Ljava/awt/Graphics;", "c", "Ljavax/swing/JComponent;", "trackBounds", "Ljava/awt/Rectangle;", "termora"})
    private final class MyScrollBarUI
    extends FlatScrollBarUI {
        protected void paintTrack(@NotNull Graphics g, @NotNull JComponent c2, @NotNull Rectangle trackBounds) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            Intrinsics.checkNotNullParameter((Object)trackBounds, (String)"trackBounds");
            super.paintTrack(g, c2, trackBounds);
            TerminalScrollBar.this.drawFindMap(g, trackBounds);
        }
    }
}

