/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel;

import app.termora.terminal.DataKey;
import app.termora.terminal.MouseMode;
import app.termora.terminal.Position;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalKeyEvent;
import app.termora.terminal.TerminalModel;
import app.termora.terminal.TerminalModelKt;
import app.termora.terminal.TerminalMouseButton;
import app.termora.terminal.TerminalMouseEvent;
import app.termora.terminal.TerminalMouseEventType;
import app.termora.terminal.panel.AWTTerminalMouseEvent;
import app.termora.terminal.panel.TerminalPanel;
import app.termora.terminal.panel.TerminalWriter;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0001.B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020!H\u0016J \u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J \u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0018\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0014\u00a8\u0006/"}, d2={"Lapp/termora/terminal/panel/TerminalPanelMouseTrackingAdapter;", "Ljava/awt/event/MouseAdapter;", "terminalPanel", "Lapp/termora/terminal/panel/TerminalPanel;", "terminal", "Lapp/termora/terminal/Terminal;", "writer", "Lapp/termora/terminal/panel/TerminalWriter;", "<init>", "(Lapp/termora/terminal/panel/TerminalPanel;Lapp/termora/terminal/Terminal;Lapp/termora/terminal/panel/TerminalWriter;)V", "terminalModel", "Lapp/termora/terminal/TerminalModel;", "getTerminalModel", "()Lapp/termora/terminal/TerminalModel;", "mouseMode", "Lapp/termora/terminal/MouseMode;", "getMouseMode", "()Lapp/termora/terminal/MouseMode;", "isNotMouseTracking", "", "()Z", "isUrxvtMouseMode", "isUTF8MouseMode", "isSGRMouseMode", "shouldSendMouseData", "getShouldSendMouseData", "mousePressed", "", "e", "Ljava/awt/event/MouseEvent;", "mouseReleased", "mouseMoved", "mouseWheelMoved", "Ljava/awt/event/MouseWheelEvent;", "sendMouseEvent", "position", "Lapp/termora/terminal/Position;", "event", "Lapp/termora/terminal/TerminalMouseEvent;", "eventType", "Lapp/termora/terminal/TerminalMouseEventType;", "mouseReport", "cb", "", "x", "y", "Companion", "termora"})
public final class TerminalPanelMouseTrackingAdapter
extends MouseAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalPanel terminalPanel;
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final TerminalWriter writer;
    private static final Logger log = LoggerFactory.getLogger(TerminalPanelMouseTrackingAdapter.class);

    public TerminalPanelMouseTrackingAdapter(@NotNull TerminalPanel terminalPanel, @NotNull Terminal terminal, @NotNull TerminalWriter writer) {
        Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.terminalPanel = terminalPanel;
        this.terminal = terminal;
        this.writer = writer;
    }

    private final TerminalModel getTerminalModel() {
        return this.terminal.getTerminalModel();
    }

    private final MouseMode getMouseMode() {
        return this.getTerminalModel().getData(DataKey.Companion.getMouseMode(), MouseMode.MOUSE_REPORTING_NONE);
    }

    private final boolean isNotMouseTracking() {
        return this.getMouseMode() == MouseMode.MOUSE_REPORTING_NONE;
    }

    private final boolean isUrxvtMouseMode() {
        return this.getTerminalModel().getData(DataKey.Companion.getUrxvtMouseMode(), false);
    }

    private final boolean isUTF8MouseMode() {
        return this.getTerminalModel().getData(DataKey.Companion.getUTF8MouseMode(), false);
    }

    private final boolean isSGRMouseMode() {
        return this.getTerminalModel().getData(DataKey.Companion.getSGRMouseMode(), false);
    }

    private final boolean getShouldSendMouseData() {
        return this.getMouseMode() == MouseMode.MOUSE_REPORTING_NORMAL || this.getMouseMode() == MouseMode.MOUSE_REPORTING_BUTTON_MOTION || this.getMouseMode() == MouseMode.MOUSE_REPORTING_ALL_MOTION;
    }

    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.isNotMouseTracking()) {
            return;
        }
        if (this.getShouldSendMouseData()) {
            Point point = e.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            this.sendMouseEvent(this.terminalPanel.pointToPosition(point), new AWTTerminalMouseEvent(e), TerminalMouseEventType.Pressed);
        }
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.isNotMouseTracking()) {
            return;
        }
        if (this.getShouldSendMouseData()) {
            Point point = e.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            this.sendMouseEvent(this.terminalPanel.pointToPosition(point), new AWTTerminalMouseEvent(e), TerminalMouseEventType.Released);
        }
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.getMouseMode() == MouseMode.MOUSE_REPORTING_ALL_MOTION) {
            Point point = e.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            Position p = this.terminalPanel.pointToPosition(point);
            this.mouseReport(3, p.getX(), p.getY());
        }
    }

    @Override
    public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.getShouldSendMouseData() || TerminalModelKt.isAlternateScreenBuffer(this.getTerminalModel())) {
            int unitsToScroll = e.getUnitsToScroll();
            String encode = this.terminal.getKeyEncoder().encode(new TerminalKeyEvent(e.getWheelRotation() < 0 ? 38 : 40, 0, 2, null));
            if (StringsKt.isBlank((CharSequence)encode)) {
                return;
            }
            byte[] byArray = encode.getBytes(this.writer.getCharset());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] bytes = byArray;
            int n = Math.abs(unitsToScroll);
            for (int i = 0; i < n; ++i) {
                this.writer.write(TerminalWriter.WriteRequest.Companion.fromBytes(bytes));
            }
        }
    }

    private final void sendMouseEvent(Position position, TerminalMouseEvent event, TerminalMouseEventType eventType) {
        if (event.getButton() == TerminalMouseButton.None) {
            return;
        }
        if (this.isNotMouseTracking()) {
            return;
        }
        int cb = event.getButton().getCode();
        if (eventType == TerminalMouseEventType.Pressed) {
            if (event.getButton() == TerminalMouseButton.ScrollDown || event.getButton() == TerminalMouseButton.ScrollUp) {
                int offset = TerminalMouseButton.ScrollDown.getCode();
                cb -= offset;
                cb |= 0x40;
            }
            cb |= event.getModifiers();
        } else if (eventType == TerminalMouseEventType.Released) {
            cb = this.isSGRMouseMode() ? cb | 0x80 : cb | 3;
            cb |= event.getModifiers();
        }
        this.mouseReport(cb, position.getX(), position.getY());
    }

    private final void mouseReport(int cb, int x, int y) {
        StringBuilder sb = new StringBuilder();
        Charset charset = Charsets.UTF_8;
        if (this.isUTF8MouseMode()) {
            v0 = sb.append('\u001b').append("[M").append((char)(32 + cb)).append((char)(32 + x)).append((char)(32 + y));
        } else if (this.isSGRMouseMode()) {
            v0 = (cb & 0x80) != 0 ? sb.append('\u001b').append("[<").append(cb ^ 0x80).append(';').append(x).append(';').append(y).append('m') : sb.append('\u001b').append("[<").append(cb).append(';').append(x).append(';').append(y).append('M');
        } else if (this.isUrxvtMouseMode()) {
            v0 = sb.append('\u001b').append("[").append(32 + cb).append(x).append(y).append('M');
        } else {
            charset = Charsets.ISO_8859_1;
            v0 = sb.append('\u001b').append("[M").append((char)(32 + cb)).append((char)(32 + x)).append(x).append((char)(32 + y));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.writer.write(TerminalWriter.WriteRequest.Companion.fromBytes(byArray));
        if (log.isTraceEnabled()) {
            log.trace("Send ESC{}", (Object)sb.substring(1));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/terminal/panel/TerminalPanelMouseTrackingAdapter$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

