/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel;

import app.termora.terminal.ClickableHighlighter;
import app.termora.terminal.Highlighter;
import app.termora.terminal.Position;
import app.termora.terminal.Terminal;
import app.termora.terminal.panel.TerminalPanel;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/termora/terminal/panel/TerminalPanelMouseHyperlinkAdapter;", "Ljava/awt/event/MouseAdapter;", "terminalPanel", "Lapp/termora/terminal/panel/TerminalPanel;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/panel/TerminalPanel;Lapp/termora/terminal/Terminal;)V", "mouseClicked", "", "e", "Ljava/awt/event/MouseEvent;", "termora"})
public final class TerminalPanelMouseHyperlinkAdapter
extends MouseAdapter {
    @NotNull
    private final TerminalPanel terminalPanel;
    @NotNull
    private final Terminal terminal;

    public TerminalPanelMouseHyperlinkAdapter(@NotNull TerminalPanel terminalPanel, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminalPanel = terminalPanel;
        this.terminal = terminal;
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (SwingUtilities.isLeftMouseButton(e)) {
            Point point = e.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            Position position = this.terminalPanel.pointToPosition(point);
            for (Highlighter highlighter : this.terminal.getMarkupModel().getHighlighters(position)) {
                if (!(highlighter instanceof ClickableHighlighter)) continue;
                ((ClickableHighlighter)highlighter).onClicked(position);
            }
        }
    }
}

