/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel;

import app.termora.Database;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.SSHTerminalTab;
import app.termora.TerminalTab;
import app.termora.actions.DataProvider;
import app.termora.actions.DataProviderSupport;
import app.termora.actions.DataProviders;
import app.termora.terminal.CharBuffer;
import app.termora.terminal.CursorModel;
import app.termora.terminal.DataKey;
import app.termora.terminal.DataListener;
import app.termora.terminal.KTermKt;
import app.termora.terminal.Position;
import app.termora.terminal.ScrollingModel;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalColor;
import app.termora.terminal.TerminalSize;
import app.termora.terminal.TextStyle;
import app.termora.terminal.panel.FloatingToolbarPanel;
import app.termora.terminal.panel.TerminalBlink;
import app.termora.terminal.panel.TerminalDisplay;
import app.termora.terminal.panel.TerminalFindPanel;
import app.termora.terminal.panel.TerminalInputMethodData;
import app.termora.terminal.panel.TerminalPaintListener;
import app.termora.terminal.panel.TerminalPanelComponentAdapter;
import app.termora.terminal.panel.TerminalPanelKeyAdapter;
import app.termora.terminal.panel.TerminalPanelMouseFloatingToolBarAdapter;
import app.termora.terminal.panel.TerminalPanelMouseHyperlinkAdapter;
import app.termora.terminal.panel.TerminalPanelMouseSelectionAdapter;
import app.termora.terminal.panel.TerminalPanelMouseTrackingAdapter;
import app.termora.terminal.panel.TerminalPanelRepaintListener;
import app.termora.terminal.panel.TerminalPredicateAction;
import app.termora.terminal.panel.TerminalScrollBar;
import app.termora.terminal.panel.TerminalWindowsCopyAction;
import app.termora.terminal.panel.TerminalWindowsPasteAction;
import app.termora.terminal.panel.TerminalWriter;
import app.termora.terminal.panel.vw.NvidiaSMIVisualWindow;
import app.termora.terminal.panel.vw.Resumeable;
import app.termora.terminal.panel.vw.SystemInformationVisualWindow;
import app.termora.terminal.panel.vw.VisualWindow;
import app.termora.terminal.panel.vw.VisualWindowManager;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.CharCompanionObject;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u0086\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0006\u0086\u0001\u0087\u0001\u0088\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010G\u001a\u00020HH\u0002J\b\u0010I\u001a\u00020HH\u0002J\b\u0010J\u001a\u00020HH\u0002J\u001f\u0010K\u001a\u00020H2\u0006\u0010L\u001a\u00020M2\b\b\u0002\u0010N\u001a\u00020O\u00a2\u0006\u0004\bP\u0010QJ\u0006\u0010R\u001a\u00020HJ\u000e\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020VJ\u0006\u0010W\u001a\u00020HJ\f\u0010X\u001a\b\u0012\u0004\u0012\u0002010YJ\u000e\u0010Z\u001a\u00020H2\u0006\u0010[\u001a\u000201J\u000e\u0010\\\u001a\u00020H2\u0006\u0010[\u001a\u000201J\u000e\u0010]\u001a\u00020H2\u0006\u0010^\u001a\u00020_J\u000e\u0010`\u001a\u00020H2\u0006\u0010^\u001a\u00020_J\b\u0010a\u001a\u00020bH\u0016J\u0010\u0010c\u001a\u00020H2\u0006\u0010d\u001a\u00020eH\u0014J\b\u0010f\u001a\u00020HH\u0016J\u0006\u0010g\u001a\u00020hJ\u0006\u0010i\u001a\u00020hJ\u0006\u0010j\u001a\u00020HJ\u0006\u0010k\u001a\u00020HJ\u000e\u0010l\u001a\u00020H2\u0006\u0010L\u001a\u00020MJ\u0006\u0010m\u001a\u00020MJ\u0006\u0010n\u001a\u00020oJ\u0010\u0010p\u001a\u00020H2\u0006\u0010q\u001a\u00020rH\u0016J'\u0010s\u001a\u0004\u0018\u0001Ht\"\b\b\u0000\u0010t*\u00020u2\f\u0010v\u001a\b\u0012\u0004\u0012\u0002Ht0wH\u0016\u00a2\u0006\u0002\u0010xJ\u0010\u0010y\u001a\u00020H2\u0006\u0010z\u001a\u00020\u001eH\u0016J\u0013\u0010{\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016\u00a2\u0006\u0002\u0010|J\u0010\u0010}\u001a\u00020H2\u0006\u0010z\u001a\u00020\u001eH\u0016J\u0010\u0010~\u001a\u00020H2\u0006\u0010z\u001a\u00020\u001eH\u0016J\u0010\u0010\u007f\u001a\u00020H2\u0006\u0010z\u001a\u00020\u001eH\u0016J\u001b\u0010\u0080\u0001\u001a\u00020H2\u0007\u0010\u0081\u0001\u001a\u00020M2\u0007\u0010\u0082\u0001\u001a\u00020\u0002H\u0016J\u0012\u0010\u0083\u0001\u001a\u00020H2\u0007\u0010\u0081\u0001\u001a\u00020MH\u0016J\n\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00060\u000eR\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00060\u001bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R$\u0010&\u001a\u00020%2\u0006\u0010$\u001a\u00020%@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020100X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00102\u001a\u00020%2\u0006\u0010$\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b3\u0010(\"\u0004\b4\u0010*R\u001a\u00105\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010(\"\u0004\b7\u0010*R\u001a\u00108\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010(\"\u0004\b:\u0010*R$\u0010<\u001a\u00020;2\u0006\u0010$\u001a\u00020;@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001a\u0010A\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010(\"\u0004\bC\u0010*R\u001a\u0010D\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010(\"\u0004\bF\u0010*\u00a8\u0006\u0089\u0001"}, d2={"Lapp/termora/terminal/panel/TerminalPanel;", "Ljavax/swing/JPanel;", "Lapp/termora/actions/DataProvider;", "Lapp/termora/Disposable;", "Lapp/termora/terminal/panel/vw/VisualWindowManager;", "terminal", "Lapp/termora/terminal/Terminal;", "writer", "Lapp/termora/terminal/panel/TerminalWriter;", "<init>", "(Lapp/termora/terminal/Terminal;Lapp/termora/terminal/panel/TerminalWriter;)V", "getTerminal", "()Lapp/termora/terminal/Terminal;", "properties", "Lapp/termora/Database$Properties;", "Lapp/termora/Database;", "getProperties", "()Lapp/termora/Database$Properties;", "terminalBlink", "Lapp/termora/terminal/panel/TerminalBlink;", "terminalFindPanel", "Lapp/termora/terminal/panel/TerminalFindPanel;", "floatingToolbar", "Lapp/termora/terminal/panel/FloatingToolbarPanel;", "terminalDisplay", "Lapp/termora/terminal/panel/TerminalDisplay;", "layeredPane", "Lapp/termora/terminal/panel/TerminalPanel$TerminalLayeredPane;", "visualWindows", "", "Lapp/termora/terminal/panel/vw/VisualWindow;", "[Lapp/termora/terminal/panel/vw/VisualWindow;", "scrollBar", "Lapp/termora/terminal/panel/TerminalScrollBar;", "getScrollBar", "()Lapp/termora/terminal/panel/TerminalScrollBar;", "value", "", "enableFloatingToolbar", "getEnableFloatingToolbar", "()Z", "setEnableFloatingToolbar", "(Z)V", "dataProviderSupport", "Lapp/termora/actions/DataProviderSupport;", "getDataProviderSupport", "()Lapp/termora/actions/DataProviderSupport;", "actions", "", "Lapp/termora/terminal/panel/TerminalPredicateAction;", "debug", "getDebug", "setDebug", "findMap", "getFindMap", "setFindMap", "resizeToast", "getResizeToast", "setResizeToast", "Ljava/awt/Insets;", "padding", "getPadding", "()Ljava/awt/Insets;", "setPadding", "(Ljava/awt/Insets;)V", "showToast", "getShowToast", "setShowToast", "dropFiles", "getDropFiles", "setDropFiles", "initView", "", "initEvents", "enableDropTarget", "toast", "text", "", "duration", "Lkotlin/time/Duration;", "toast-HG0u8IE", "(Ljava/lang/String;J)V", "hideToast", "pointToPosition", "Lapp/termora/terminal/Position;", "point", "Ljava/awt/Point;", "repaintImmediate", "getTerminalActions", "", "addTerminalAction", "action", "removeTerminalAction", "addTerminalPaintListener", "listener", "Lapp/termora/terminal/panel/TerminalPaintListener;", "removeTerminalPaintListener", "getInputMethodRequests", "Ljava/awt/im/InputMethodRequests;", "processInputMethodEvent", "e", "Ljava/awt/event/InputMethodEvent;", "dispose", "getAverageCharWidth", "", "getLineHeight", "showFind", "hideFind", "paste", "copy", "winSize", "Lapp/termora/terminal/TerminalSize;", "paint", "g", "Ljava/awt/Graphics;", "getData", "T", "", "dataKey", "Lapp/termora/terminal/DataKey;", "(Lapp/termora/terminal/DataKey;)Ljava/lang/Object;", "moveToFront", "visualWindow", "getVisualWindows", "()[Lapp/termora/terminal/panel/vw/VisualWindow;", "addVisualWindow", "removeVisualWindow", "rebaseVisualWindow", "resumeVisualWindows", "id", "dataProvider", "storeVisualWindows", "getDimension", "Ljava/awt/Dimension;", "Companion", "MyInputMethodRequests", "TerminalLayeredPane", "termora"})
public final class TerminalPanel
extends JPanel
implements DataProvider,
Disposable,
VisualWindowManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final TerminalWriter writer;
    @NotNull
    private final TerminalBlink terminalBlink;
    @NotNull
    private final TerminalFindPanel terminalFindPanel;
    @NotNull
    private final FloatingToolbarPanel floatingToolbar;
    @NotNull
    private final TerminalDisplay terminalDisplay;
    @NotNull
    private final TerminalLayeredPane layeredPane;
    @NotNull
    private VisualWindow[] visualWindows;
    @NotNull
    private final TerminalScrollBar scrollBar;
    private boolean enableFloatingToolbar;
    @NotNull
    private final DataProviderSupport dataProviderSupport;
    @NotNull
    private final List<TerminalPredicateAction> actions;
    private boolean findMap;
    private boolean resizeToast;
    @NotNull
    private Insets padding;
    private boolean showToast;
    private boolean dropFiles;
    @NotNull
    private static final DataKey<Boolean> Debug = new DataKey(Reflection.getOrCreateKotlinClass(Boolean.TYPE));
    @NotNull
    private static final DataKey<Boolean> Finding = new DataKey(Reflection.getOrCreateKotlinClass(Boolean.TYPE));
    @NotNull
    private static final DataKey<Boolean> Focused = new DataKey(Reflection.getOrCreateKotlinClass(Boolean.TYPE));
    @NotNull
    private static final DataKey<Boolean> SelectCopy = new DataKey(Reflection.getOrCreateKotlinClass(Boolean.TYPE));

    public TerminalPanel(@NotNull Terminal terminal, @NotNull TerminalWriter writer) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        super(new BorderLayout());
        this.terminal = terminal;
        this.writer = writer;
        this.terminalBlink = new TerminalBlink(this.terminal);
        this.terminalFindPanel = new TerminalFindPanel(this, this.terminal);
        this.floatingToolbar = new FloatingToolbarPanel();
        this.terminalDisplay = new TerminalDisplay(this, this.terminal, this.terminalBlink);
        this.layeredPane = new TerminalLayeredPane();
        this.visualWindows = new VisualWindow[0];
        this.scrollBar = new TerminalScrollBar(this, this.terminalFindPanel, this.terminal);
        this.enableFloatingToolbar = true;
        this.dataProviderSupport = new DataProviderSupport();
        Object[] objectArray = new TerminalPredicateAction[]{new TerminalWindowsCopyAction(), new TerminalWindowsPasteAction()};
        this.actions = CollectionsKt.mutableListOf((Object[])objectArray);
        this.findMap = true;
        this.resizeToast = true;
        this.padding = new Insets(4, 4, 4, 4);
        this.showToast = true;
        this.initView();
        this.initEvents();
    }

    @NotNull
    public final Terminal getTerminal() {
        return this.terminal;
    }

    private final Database.Properties getProperties() {
        return Database.Companion.getDatabase().getProperties();
    }

    @NotNull
    public final TerminalScrollBar getScrollBar() {
        return this.scrollBar;
    }

    public final boolean getEnableFloatingToolbar() {
        return this.enableFloatingToolbar;
    }

    public final void setEnableFloatingToolbar(boolean value) {
        this.enableFloatingToolbar = value;
        if (value) {
            Component component = (Component)((Object)this.floatingToolbar);
            Integer n = JLayeredPane.POPUP_LAYER;
            Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type kotlin.Any");
            this.layeredPane.add(component, n);
        } else {
            this.layeredPane.remove((Component)((Object)this.floatingToolbar));
        }
    }

    @NotNull
    public final DataProviderSupport getDataProviderSupport() {
        return this.dataProviderSupport;
    }

    public final boolean getDebug() {
        return this.terminal.getTerminalModel().getData(Debug, false);
    }

    public final void setDebug(boolean value) {
        this.terminal.getTerminalModel().setData(Debug, value);
    }

    public final boolean getFindMap() {
        return this.findMap;
    }

    public final void setFindMap(boolean bl) {
        this.findMap = bl;
    }

    public final boolean getResizeToast() {
        return this.resizeToast;
    }

    public final void setResizeToast(boolean bl) {
        this.resizeToast = bl;
    }

    @NotNull
    public final Insets getPadding() {
        return this.padding;
    }

    public final void setPadding(@NotNull Insets value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.padding = value;
        this.repaintImmediate();
    }

    public final boolean getShowToast() {
        return this.showToast;
    }

    public final void setShowToast(boolean bl) {
        this.showToast = bl;
    }

    public final boolean getDropFiles() {
        return this.dropFiles;
    }

    public final void setDropFiles(boolean bl) {
        this.dropFiles = bl;
    }

    private final void initView() {
        this.writer.onMounted(this);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.setFocusTraversalKeysEnabled(false);
        this.enableEvents(2056L);
        this.enableInputMethods(true);
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum(0);
        this.scrollBar.setValue(0);
        this.scrollBar.setUnitIncrement(1);
        this.scrollBar.setBlockIncrement(1);
        this.setBackground(Color.black);
        Component component = this.terminalDisplay;
        Integer n = JLayeredPane.DEFAULT_LAYER;
        Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type kotlin.Any");
        this.layeredPane.add(component, n);
        Component component2 = this.terminalFindPanel;
        Integer n2 = JLayeredPane.POPUP_LAYER;
        Intrinsics.checkNotNull((Object)n2, (String)"null cannot be cast to non-null type kotlin.Any");
        this.layeredPane.add(component2, n2);
        if (this.enableFloatingToolbar) {
            Component component3 = (Component)((Object)this.floatingToolbar);
            Integer n3 = JLayeredPane.POPUP_LAYER;
            Intrinsics.checkNotNull((Object)n3, (String)"null cannot be cast to non-null type kotlin.Any");
            this.layeredPane.add(component3, n3);
        }
        this.add((Component)this.layeredPane, "Center");
        this.add((Component)this.scrollBar, "East");
        this.hideFind();
        this.dataProviderSupport.addData(DataProviders.INSTANCE.getTerminalPanel(), this);
        this.dataProviderSupport.addData(DataProviders.INSTANCE.getTerminal(), this.terminal);
        this.dataProviderSupport.addData(DataProviders.INSTANCE.getTerminalWriter(), this.writer);
        this.dataProviderSupport.addData(FloatingToolbarPanel.Companion.getFloatingToolbar(), this.floatingToolbar);
    }

    private final void initEvents() {
        this.addKeyListener(new TerminalPanelKeyAdapter(this, this.terminal, this.writer));
        this.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ TerminalPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getTerminal().getTerminalModel().setData(TerminalPanel.Companion.getFocused(), false);
                this.this$0.repaintImmediate();
            }

            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getTerminal().getTerminalModel().setData(TerminalPanel.Companion.getFocused(), true);
                this.this$0.repaintImmediate();
            }
        });
        this.addComponentListener(new TerminalPanelComponentAdapter(this, this.terminalDisplay, this.terminal, this.writer));
        TerminalPanelMouseSelectionAdapter mouseAdapter2 = new TerminalPanelMouseSelectionAdapter(this, this.terminal);
        this.addMouseListener(mouseAdapter2);
        this.addMouseMotionListener(mouseAdapter2);
        TerminalPanelMouseHyperlinkAdapter hyperlinkAdapter = new TerminalPanelMouseHyperlinkAdapter(this, this.terminal);
        this.addMouseListener(hyperlinkAdapter);
        TerminalPanelMouseTrackingAdapter trackingAdapter = new TerminalPanelMouseTrackingAdapter(this, this.terminal, this.writer);
        this.addMouseListener(trackingAdapter);
        this.addMouseWheelListener(trackingAdapter);
        TerminalPanelMouseFloatingToolBarAdapter floatingToolBarAdapter = new TerminalPanelMouseFloatingToolBarAdapter(this, this.terminalDisplay);
        this.addMouseMotionListener(floatingToolBarAdapter);
        this.addMouseListener(floatingToolBarAdapter);
        this.addMouseWheelListener(new MouseWheelListener(this){
            final /* synthetic */ TerminalPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseWheelMoved(MouseWheelEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!this.this$0.getTerminal().getScrollingModel().canVerticalScroll()) {
                    return;
                }
                int unitsToScroll = e.getUnitsToScroll();
                if (e.isShiftDown() || unitsToScroll == 0 || Math.abs(e.getPreciseWheelRotation()) < 0.01) {
                    return;
                }
                int value = this.this$0.getScrollBar().getValue() + unitsToScroll;
                this.this$0.getScrollBar().setValue(value);
                this.this$0.getTerminal().getScrollingModel().scrollTo(value);
            }
        });
        this.terminal.getTerminalModel().addDataListener(new TerminalPanelRepaintListener(this));
        this.terminal.getTerminalModel().addDataListener(new DataListener(this){
            final /* synthetic */ TerminalPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onChanged(DataKey<?> key, Object data) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (Intrinsics.areEqual(key, ScrollingModel.Companion.getScroll())) {
                    int rows = this.this$0.getTerminal().getTerminalModel().getRows();
                    this.this$0.getScrollBar().setMaximum(this.this$0.getTerminal().getScrollingModel().getMaxVerticalScrollOffset() + rows);
                    this.this$0.getScrollBar().setValue(this.this$0.getTerminal().getScrollingModel().getVerticalScrollOffset());
                    this.this$0.getScrollBar().setVisibleAmount(rows);
                }
            }
        });
        this.scrollBar.addAdjustmentListener(arg_0 -> TerminalPanel.initEvents$lambda$0(this, arg_0));
        this.enableDropTarget();
        this.floatingToolbar.addPropertyChangeListener(arg_0 -> TerminalPanel.initEvents$lambda$1(this, arg_0));
    }

    private final void enableDropTarget() {
        this.setDropTarget(new DropTarget(this){
            final /* synthetic */ TerminalPanel this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void drop(DropTargetDropEvent e) {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!this.this$0.getDropFiles()) {
                    return;
                }
                e.acceptDrop(0x40000000);
                if (!e.getTransferable().isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    return;
                }
                Object object = e.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
                Iterable $this$filterIsInstance$iv = (List)object;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof File)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List files = (List)destination$iv$iv;
                if (files.isEmpty()) {
                    return;
                }
                StringBuilder sb = new StringBuilder();
                for (File file : files) {
                    sb.append(file.getAbsolutePath()).append(" ");
                }
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                this.this$0.paste(string);
            }
        });
    }

    public final void toast-HG0u8IE(@NotNull String text, long duration) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.terminalDisplay.toast-HG0u8IE(text, duration);
    }

    public static /* synthetic */ void toast-HG0u8IE$default(TerminalPanel terminalPanel, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS);
        }
        terminalPanel.toast-HG0u8IE(string, l);
    }

    public final void hideToast() {
        this.terminalDisplay.hideToast();
    }

    @NotNull
    public final Position pointToPosition(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.terminalDisplay.pointToPosition(new Point(point.x - this.padding.left, point.y - this.padding.top));
    }

    public final void repaintImmediate() {
        if (this.terminalDisplay.isShowing()) {
            this.terminalDisplay.repaint();
            this.scrollBar.repaint();
        }
    }

    @NotNull
    public final List<TerminalPredicateAction> getTerminalActions() {
        return this.actions;
    }

    public final void addTerminalAction(@NotNull TerminalPredicateAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.actions.add(action);
    }

    public final void removeTerminalAction(@NotNull TerminalPredicateAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.actions.remove(action);
    }

    public final void addTerminalPaintListener(@NotNull TerminalPaintListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listenerList.add(TerminalPaintListener.class, (EventListener)listener2);
    }

    public final void removeTerminalPaintListener(@NotNull TerminalPaintListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listenerList.remove(TerminalPaintListener.class, (EventListener)listener2);
    }

    @Override
    @NotNull
    public InputMethodRequests getInputMethodRequests() {
        return new MyInputMethodRequests();
    }

    @Override
    protected void processInputMethodEvent(@NotNull InputMethodEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.terminalDisplay.setInputMethodData(TerminalInputMethodData.Companion.getDefault());
        int committedCharacterCount = e.getCommittedCharacterCount();
        AttributedCharacterIterator attributedCharacterIterator = e.getText();
        if (attributedCharacterIterator == null) {
            return;
        }
        AttributedCharacterIterator attributedCharacterIterator2 = attributedCharacterIterator;
        char c2 = attributedCharacterIterator2.first();
        StringBuilder sb = new StringBuilder();
        while (c2 != '\uffff') {
            if (c2 >= ' ' && c2 != '\u007f') {
                sb.append(c2);
            }
            c2 = attributedCharacterIterator2.next();
        }
        if (((CharSequence)sb).length() == 0) {
            return;
        }
        if (committedCharacterCount > 0) {
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            byte[] byArray = string2.getBytes(this.writer.getCharset());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.writer.write(TerminalWriter.WriteRequest.Companion.fromBytes(byArray));
        } else {
            BreakIterator breakIterator = BreakIterator.getCharacterInstance();
            List chars = new ArrayList();
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String text = string;
            breakIterator.setText(text);
            int start2 = breakIterator.first();
            int end = breakIterator.next();
            Map followings = new LinkedHashMap();
            while (end != -1) {
                String ch;
                Intrinsics.checkNotNullExpressionValue((Object)text.substring(start2, end), (String)"substring(...)");
                char[] cArray = ch.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                chars.addAll(ArraysKt.toList((char[])cArray));
                if (ch.length() == 1 && KTermKt.mk_wcwidth(StringsKt.first((CharSequence)ch)) == 2) {
                    chars.add(Character.valueOf(KTermKt.getSoftHyphen(CharCompanionObject.INSTANCE)));
                }
                Integer n = start2;
                followings.put(n, chars.size());
                start2 = end;
                end = breakIterator.next();
            }
            TextHitInfo textHitInfo = e.getCaret();
            int charIndex = (textHitInfo != null ? textHitInfo.getCharIndex() : 0) - (SystemInfo.isWindows ? 1 : 0);
            this.terminalDisplay.setInputMethodData(TerminalInputMethodData.Companion.getDefault().copy(new CharBuffer(CollectionsKt.toCharArray((Collection)chars), TextStyle.underline-RZbRhfg(TextStyle.Companion.getDefault-c2YIwqY(), true), null), ((Number)followings.getOrDefault(charIndex, followings.getOrDefault(charIndex - 1, 0))).intValue()));
        }
    }

    @Override
    public void dispose() {
        Disposer.dispose(this.terminalBlink);
        Disposer.dispose(this.floatingToolbar);
    }

    public final int getAverageCharWidth() {
        return this.terminalDisplay.getAverageCharWidth();
    }

    public final int getLineHeight() {
        return this.terminalDisplay.getLineHeight();
    }

    public final void showFind() {
        this.terminalFindPanel.setVisible(true);
        this.terminal.getTerminalModel().setData(Finding, true);
        SwingUtilities.invokeLater(() -> TerminalPanel.showFind$lambda$2(this));
    }

    public final void hideFind() {
        this.terminalFindPanel.setVisible(false);
        this.terminal.getTerminalModel().setData(Finding, false);
        SwingUtilities.invokeLater(() -> TerminalPanel.hideFind$lambda$3(this));
    }

    public final void paste(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String content = text;
        if (!SystemInfo.isWindows) {
            content = StringsKt.replace$default((String)content, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
        }
        content = StringsKt.replace$default((String)content, (char)'\n', (char)'\r', (boolean)false, (int)4, null);
        if (this.terminal.getTerminalModel().getData(DataKey.Companion.getBracketedPasteMode(), false).booleanValue()) {
            byte[] byArray = ("\u001b[200~" + content + "\u001b[201~").getBytes(this.writer.getCharset());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.writer.write(TerminalWriter.WriteRequest.Companion.fromBytes(byArray));
        } else {
            byte[] byArray = content.getBytes(this.writer.getCharset());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.writer.write(TerminalWriter.WriteRequest.Companion.fromBytes(byArray));
        }
        this.terminal.getScrollingModel().scrollToRow(this.terminal.getDocument().getCurrentTerminalLineBuffer().getBufferCount() + this.terminal.getCursorModel().getPosition().getY());
        this.terminal.getSelectionModel().clearSelection();
    }

    @NotNull
    public final String copy() {
        return this.terminal.getSelectionModel().getSelectedText();
    }

    @NotNull
    public final TerminalSize winSize() {
        int cols = this.terminalDisplay.getWidth() / this.getAverageCharWidth();
        int rows = this.terminalDisplay.getHeight() / this.getLineHeight();
        return new TerminalSize(rows, cols);
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.setBackground(new Color(this.terminal.getTerminalModel().getColorPalette().getColor(TerminalColor.Basic.INSTANCE.getBACKGROUND())));
        super.paint(g);
    }

    @Override
    @Nullable
    public <T> T getData(@NotNull DataKey<T> dataKey) {
        Intrinsics.checkNotNullParameter(dataKey, (String)"dataKey");
        return this.dataProviderSupport.getData(dataKey);
    }

    @Override
    public void moveToFront(@NotNull VisualWindow visualWindow) {
        Intrinsics.checkNotNullParameter((Object)visualWindow, (String)"visualWindow");
        if (visualWindow.isWindow()) {
            Window window = visualWindow.getWindow();
            if (window != null) {
                window.requestFocus();
            }
            return;
        }
        this.layeredPane.moveToFront(visualWindow.getJComponent());
    }

    @Override
    @NotNull
    public VisualWindow[] getVisualWindows() {
        return this.visualWindows;
    }

    @Override
    public void addVisualWindow(@NotNull VisualWindow visualWindow) {
        Intrinsics.checkNotNullParameter((Object)visualWindow, (String)"visualWindow");
        Object[] objectArray = ArrayUtils.add((Object[])this.visualWindows, (Object)visualWindow);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"add(...)");
        this.visualWindows = (VisualWindow[])objectArray;
        Component component = visualWindow.getJComponent();
        Integer n = JLayeredPane.DRAG_LAYER;
        Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type kotlin.Any");
        this.layeredPane.add(component, n);
        this.layeredPane.moveToFront(visualWindow.getJComponent());
    }

    @Override
    public void removeVisualWindow(@NotNull VisualWindow visualWindow) {
        Intrinsics.checkNotNullParameter((Object)visualWindow, (String)"visualWindow");
        this.rebaseVisualWindow(visualWindow);
        Object[] objectArray = ArrayUtils.removeElement((Object[])this.visualWindows, (Object)visualWindow);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"removeElement(...)");
        this.visualWindows = (VisualWindow[])objectArray;
    }

    @Override
    public void rebaseVisualWindow(@NotNull VisualWindow visualWindow) {
        Intrinsics.checkNotNullParameter((Object)visualWindow, (String)"visualWindow");
        this.layeredPane.remove(visualWindow.getJComponent());
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
        this.requestFocusInWindow();
    }

    @Override
    public void resumeVisualWindows(@NotNull String id, @NotNull DataProvider dataProvider) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        String string = this.getProperties().getString("VisualWindow." + id + ".store");
        if (string == null) {
            return;
        }
        String windows = string;
        String[] stringArray = new String[]{","};
        for (String name : StringsKt.split$default((CharSequence)windows, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
            if (Intrinsics.areEqual((Object)name, (Object)"NVIDIA-SMI")) {
                TerminalTab terminalTab = dataProvider.getData(DataProviders.INSTANCE.getTerminalTab());
                Intrinsics.checkNotNull((Object)terminalTab, (String)"null cannot be cast to non-null type app.termora.SSHTerminalTab");
                this.addVisualWindow(new NvidiaSMIVisualWindow((SSHTerminalTab)terminalTab, (VisualWindowManager)this));
                continue;
            }
            if (!Intrinsics.areEqual((Object)name, (Object)"SystemInformation")) continue;
            TerminalTab terminalTab = dataProvider.getData(DataProviders.INSTANCE.getTerminalTab());
            Intrinsics.checkNotNull((Object)terminalTab, (String)"null cannot be cast to non-null type app.termora.SSHTerminalTab");
            this.addVisualWindow(new SystemInformationVisualWindow((SSHTerminalTab)terminalTab, (VisualWindowManager)this));
        }
    }

    @Override
    public void storeVisualWindows(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List windows = new ArrayList();
        for (VisualWindow window : this.getVisualWindows()) {
            if (!(window instanceof Resumeable)) continue;
            windows.add(window.getWindowName());
        }
        this.getProperties().putString("VisualWindow." + id + ".store", CollectionsKt.joinToString$default((Iterable)windows, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
    }

    @Override
    @NotNull
    public Dimension getDimension() {
        return new Dimension(this.terminalDisplay.getSize().width + this.padding.left + this.padding.right, this.terminalDisplay.getSize().height + this.padding.bottom + this.padding.top);
    }

    private static final void initEvents$lambda$0(TerminalPanel this$0, AdjustmentEvent e) {
        if (this$0.scrollBar.isVisible() && e.getValueIsAdjusting()) {
            this$0.terminal.getScrollingModel().scrollTo(this$0.scrollBar.getValue());
        }
    }

    private static final void initEvents$lambda$1(TerminalPanel this$0, PropertyChangeEvent it) {
        this$0.repaintImmediate();
    }

    private static final void showFind$lambda$2(TerminalPanel this$0) {
        this$0.terminalFindPanel.getTextField().requestFocusInWindow();
    }

    private static final void hideFind$lambda$3(TerminalPanel this$0) {
        this$0.requestFocusInWindow();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Lapp/termora/terminal/panel/TerminalPanel$Companion;", "", "<init>", "()V", "Debug", "Lapp/termora/terminal/DataKey;", "", "getDebug", "()Lapp/termora/terminal/DataKey;", "Finding", "getFinding", "Focused", "getFocused", "SelectCopy", "getSelectCopy", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<Boolean> getDebug() {
            return Debug;
        }

        @NotNull
        public final DataKey<Boolean> getFinding() {
            return Finding;
        }

        @NotNull
        public final DataKey<Boolean> getFocused() {
            return Focused;
        }

        @NotNull
        public final DataKey<Boolean> getSelectCopy() {
            return SelectCopy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J/\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0010\u0010\u0015\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0017\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u000eH\u0016J!\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0010\u0010\u0015\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0017\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u001bJ!\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0010\u0010\u0015\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0017\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lapp/termora/terminal/panel/TerminalPanel$MyInputMethodRequests;", "Ljava/awt/im/InputMethodRequests;", "<init>", "(Lapp/termora/terminal/panel/TerminalPanel;)V", "cursorModel", "Lapp/termora/terminal/CursorModel;", "getCursorModel", "()Lapp/termora/terminal/CursorModel;", "getTextLocation", "Ljava/awt/Rectangle;", "e", "Ljava/awt/font/TextHitInfo;", "getLocationOffset", "x", "", "y", "getInsertPositionOffset", "getCommittedText", "Ljava/text/AttributedCharacterIterator;", "beginIndex", "endIndex", "attributes", "", "Ljava/text/AttributedCharacterIterator$Attribute;", "(II[Ljava/text/AttributedCharacterIterator$Attribute;)Ljava/text/AttributedCharacterIterator;", "getCommittedTextLength", "cancelLatestCommittedText", "([Ljava/text/AttributedCharacterIterator$Attribute;)Ljava/text/AttributedCharacterIterator;", "getSelectedText", "termora"})
    private final class MyInputMethodRequests
    implements InputMethodRequests {
        private final CursorModel getCursorModel() {
            return TerminalPanel.this.getTerminal().getCursorModel();
        }

        @Override
        @NotNull
        public Rectangle getTextLocation(@Nullable TextHitInfo e) {
            Position position = this.getCursorModel().getPosition();
            Rectangle rectangle = new Rectangle(position.getX() * TerminalPanel.this.getAverageCharWidth(), position.getY() * TerminalPanel.this.getLineHeight() + (SystemUtils.IS_OS_WINDOWS ? Math.abs(TerminalPanel.this.terminalDisplay.getFontMetrics().getDescent()) : 0), 0, 0);
            rectangle.translate(TerminalPanel.this.getLocationOnScreen().x, TerminalPanel.this.getLocationOnScreen().y);
            return rectangle;
        }

        @Override
        @Nullable
        public TextHitInfo getLocationOffset(int x, int y) {
            return null;
        }

        @Override
        public int getInsertPositionOffset() {
            return 0;
        }

        @Override
        @NotNull
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, @Nullable AttributedCharacterIterator.Attribute[] attributes) {
            AttributedCharacterIterator attributedCharacterIterator = new AttributedString(new String()).getIterator();
            Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
            return attributedCharacterIterator;
        }

        @Override
        public int getCommittedTextLength() {
            return 0;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator cancelLatestCommittedText(@Nullable AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator getSelectedText(@Nullable AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lapp/termora/terminal/panel/TerminalPanel$TerminalLayeredPane;", "Ljavax/swing/JLayeredPane;", "<init>", "(Lapp/termora/terminal/panel/TerminalPanel;)V", "doLayout", "", "termora"})
    private final class TerminalLayeredPane
    extends JLayeredPane {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doLayout() {
            int averageCharWidth = TerminalPanel.this.getAverageCharWidth();
            Object object = this.getTreeLock();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
            Object object2 = object;
            TerminalPanel terminalPanel = TerminalPanel.this;
            Object object3 = object2;
            synchronized (object3) {
                boolean bl = false;
                int w = this.getWidth();
                int h = this.getHeight();
                int findPanelHeight = Math.max(((TerminalPanel)terminalPanel).terminalFindPanel.getPreferredSize().height, terminalPanel.terminalFindPanel.getHeight());
                Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this.getComponents());
                while (iterator2.hasNext()) {
                    Component c2 = (Component)iterator2.next();
                    Component component = c2;
                    if (Intrinsics.areEqual((Object)component, (Object)terminalPanel.terminalDisplay)) {
                        c2.setBounds(terminalPanel.getPadding().left, terminalPanel.getPadding().top, w - terminalPanel.getPadding().right - terminalPanel.getPadding().left, h - terminalPanel.getPadding().bottom - terminalPanel.getPadding().top);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)component, (Object)terminalPanel.terminalFindPanel)) {
                        int width = averageCharWidth * 35;
                        c2.setBounds(w - width, 0, width, findPanelHeight);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)component, (Object)terminalPanel.floatingToolbar)) {
                        int width = ((TerminalPanel)terminalPanel).floatingToolbar.getPreferredSize().width;
                        int height = ((TerminalPanel)terminalPanel).floatingToolbar.getPreferredSize().height;
                        int y = 4;
                        c2.setBounds(w - width, terminalPanel.terminalFindPanel.isVisible() ? findPanelHeight + y : y, width, height);
                        continue;
                    }
                    if (!(component instanceof VisualWindow)) continue;
                    Point location = c2.getLocation();
                    Dimension dimension = terminalPanel.getDimension();
                    if (location.x > dimension.width) {
                        location = new Point(dimension.width - c2.getPreferredSize().width, location.y);
                    }
                    if (location.y > dimension.height) {
                        location = new Point(location.x, dimension.height - c2.getPreferredSize().height);
                    }
                    c2.setBounds(location.x, location.y, c2.getWidth(), c2.getHeight());
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }
}

