/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel;

import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.Database;
import app.termora.terminal.Document;
import app.termora.terminal.HighlighterRange;
import app.termora.terminal.HyperlinkHighlighter;
import app.termora.terminal.KTermKt;
import app.termora.terminal.Position;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalLine;
import app.termora.terminal.TextStyle;
import app.termora.terminal.panel.TerminalDisplay;
import app.termora.terminal.panel.TerminalPaintListener;
import app.termora.terminal.panel.TerminalPanel;
import java.awt.Graphics;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.CharCompanionObject;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J8\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\u0018"}, d2={"Lapp/termora/terminal/panel/TerminalHyperlinkPaintListener;", "Lapp/termora/terminal/panel/TerminalPaintListener;", "<init>", "()V", "regex", "Lkotlin/text/Regex;", "isEnableHyperlink", "", "()Z", "before", "", "offset", "", "count", "g", "Ljava/awt/Graphics;", "terminalPanel", "Lapp/termora/terminal/panel/TerminalPanel;", "terminalDisplay", "Lapp/termora/terminal/panel/TerminalDisplay;", "terminal", "Lapp/termora/terminal/Terminal;", "after", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nTerminalHyperlinkPaintListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalHyperlinkPaintListener.kt\napp/termora/terminal/panel/TerminalHyperlinkPaintListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1563#2:114\n1634#2,3:115\n*S KotlinDebug\n*F\n+ 1 TerminalHyperlinkPaintListener.kt\napp/termora/terminal/panel/TerminalHyperlinkPaintListener\n*L\n78#1:114\n78#1:115,3\n*E\n"})
public final class TerminalHyperlinkPaintListener
implements TerminalPaintListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Regex regex = new Regex("https?://\\S*[^.\\s'\",()<>\\[\\]]");

    private TerminalHyperlinkPaintListener() {
    }

    private final boolean isEnableHyperlink() {
        return Database.Companion.getDatabase().getTerminal().getHyperlink();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void before(int offset, int count, @NotNull Graphics g, @NotNull TerminalPanel terminalPanel, @NotNull TerminalDisplay terminalDisplay, @NotNull Terminal terminal) {
        int startOffset;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
        Intrinsics.checkNotNullParameter((Object)terminalDisplay, (String)"terminalDisplay");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        if (!this.isEnableHyperlink()) {
            return;
        }
        Document document = terminal.getDocument();
        int endOffset = startOffset + count;
        for (startOffset = offset; startOffset > 0 && document.getLine(startOffset).getWrapped(); --startOffset) {
        }
        while (endOffset < document.getLineCount() && document.getLine(endOffset).getWrapped()) {
            ++endOffset;
        }
        terminal.getMarkupModel().removeAllHighlighters(1);
        int rows = Math.min(terminal.getDocument().getLineCount(), offset + count);
        List list = new ArrayList();
        int n = endOffset;
        for (int i = startOffset; i < n; ++i) {
            void $this$mapTo$iv$iv;
            TerminalLine line = terminal.getDocument().getLine(i + 1);
            List<Pair<Character, TextStyle>> entry = line.chars();
            int n2 = ((Collection)entry).size();
            for (int j = 0; j < n2; ++j) {
                char c2 = ((Character)entry.get(j).component1()).charValue();
                if (c2 == KTermKt.getSoftHyphen(CharCompanionObject.INSTANCE)) continue;
                if (c2 == KTermKt.getNull(CharCompanionObject.INSTANCE)) break;
                list.add(new Triple((Object)Character.valueOf(c2), (Object)(i + 1), (Object)(j + 1)));
            }
            if (line.getWrapped() && i + 1 < rows) continue;
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable c2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Triple triple = (Triple)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Character.valueOf(((Character)it.getFirst()).charValue()));
            }
            String text = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            for (Triple e : SequencesKt.map((Sequence)Regex.findAll$default((Regex)this.regex, (CharSequence)text, (int)0, (int)2, null), TerminalHyperlinkPaintListener::before$lambda$1)) {
                terminal.getMarkupModel().addHighlighter(new HyperlinkHighlighter(new HighlighterRange(new Position(((Number)((Triple)list.get(((Number)e.getFirst()).intValue())).getSecond()).intValue(), ((Number)((Triple)list.get(((Number)e.getFirst()).intValue())).getThird()).intValue()), new Position(((Number)((Triple)list.get(((Number)e.getThird()).intValue())).getSecond()).intValue(), ((Number)((Triple)list.get(((Number)e.getThird()).intValue())).getThird()).intValue())), terminal, (String)e.getSecond(), (Function2<? super Position, ? super String, Unit>)((Function2)TerminalHyperlinkPaintListener::before$lambda$2)));
            }
            list.clear();
        }
    }

    @Override
    public void after(int offset, int count, @NotNull Graphics g, @NotNull TerminalPanel terminalPanel, @NotNull TerminalDisplay terminalDisplay, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
        Intrinsics.checkNotNullParameter((Object)terminalDisplay, (String)"terminalDisplay");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        if (!this.isEnableHyperlink()) {
            terminal.getMarkupModel().removeAllHighlighters(1);
        }
    }

    private static final Triple before$lambda$1(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Triple((Object)it.getRange().getFirst(), (Object)it.getValue(), (Object)it.getRange().getLast());
    }

    private static final Unit before$lambda$2(Position position, String url) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URI uRI = URI.create(url);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        Application.browse$default(Application.INSTANCE, uRI, false, 2, null);
        return Unit.INSTANCE;
    }

    public /* synthetic */ TerminalHyperlinkPaintListener(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lapp/termora/terminal/panel/TerminalHyperlinkPaintListener$Companion;", "", "<init>", "()V", "getInstance", "Lapp/termora/terminal/panel/TerminalHyperlinkPaintListener;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TerminalHyperlinkPaintListener getInstance() {
            return (TerminalHyperlinkPaintListener)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(TerminalHyperlinkPaintListener.class), Companion::getInstance$lambda$0);
        }

        private static final TerminalHyperlinkPaintListener getInstance$lambda$0() {
            return new TerminalHyperlinkPaintListener(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

