/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel;

import app.termora.Database;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.SSHTerminalTab;
import app.termora.TerminalPanelFactory;
import app.termora.TerminalTab;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.actions.DataProvider;
import app.termora.actions.DataProviders;
import app.termora.snippet.Snippet;
import app.termora.snippet.SnippetAction;
import app.termora.snippet.SnippetTreeDialog;
import app.termora.snippet.SnippetTreeNode;
import app.termora.terminal.DataKey;
import app.termora.terminal.panel.FloatingToolbarPanel;
import app.termora.terminal.panel.TerminalPanel;
import app.termora.terminal.panel.TerminalWriter;
import app.termora.terminal.panel.vw.NvidiaSMIVisualWindow;
import app.termora.terminal.panel.vw.SystemInformationVisualWindow;
import app.termora.terminal.panel.vw.VisualWindow;
import app.termora.terminal.panel.vw.VisualWindowManager;
import com.formdev.flatlaf.extras.components.FlatToolBar;
import com.formdev.flatlaf.ui.FlatRoundBorder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u000fJ\b\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\b\u0010\u001b\u001a\u00020\u0016H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lapp/termora/terminal/panel/FloatingToolbarPanel;", "Lcom/formdev/flatlaf/extras/components/FlatToolBar;", "Lapp/termora/Disposable;", "<init>", "()V", "floatingToolbarEnable", "", "getFloatingToolbarEnable", "()Z", "closed", "anEvent", "Lapp/termora/actions/AnActionEvent;", "getAnEvent", "()Lapp/termora/actions/AnActionEvent;", "updateUI", "", "triggerShow", "triggerHide", "initActions", "initEvents", "resumeVisualWindows", "initServerInfoActionButton", "Ljavax/swing/JButton;", "initSnippetActionButton", "initNvidiaSMIActionButton", "initPinActionButton", "initCloseActionButton", "initReconnectActionButton", "Companion", "termora"})
public final class FloatingToolbarPanel
extends FlatToolBar
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean closed;
    @NotNull
    private static final DataKey<FloatingToolbarPanel> FloatingToolbar = new DataKey(Reflection.getOrCreateKotlinClass(FloatingToolbarPanel.class));
    @NotNull
    private static final Lazy<Companion.pinAction.2.1> pinAction$delegate = LazyKt.lazy(FloatingToolbarPanel::pinAction_delegate$lambda$2);

    public FloatingToolbarPanel() {
        this.setBorder((Border)new FlatRoundBorder());
        this.setFocusable(false);
        this.setFloatable(false);
        this.setVisible(false);
        if (this.getFloatingToolbarEnable() && FloatingToolbarPanel.Companion.getPinAction().isSelected()) {
            this.setVisible(true);
        }
        this.initActions();
        this.initEvents();
    }

    private final boolean getFloatingToolbarEnable() {
        return Database.Companion.getDatabase().getTerminal().getFloatingToolbar();
    }

    private final AnActionEvent getAnEvent() {
        return new AnActionEvent((Object)this, "", new EventObject(this));
    }

    public void updateUI() {
        super.updateUI();
        this.setBorder((Border)new FlatRoundBorder());
    }

    public final void triggerShow() {
        if (!this.getFloatingToolbarEnable() || this.closed) {
            return;
        }
        if (!this.isVisible()) {
            this.setVisible(true);
            this.firePropertyChange("visible", false, true);
        }
    }

    public final void triggerHide() {
        if (this.getFloatingToolbarEnable() && !this.closed && FloatingToolbarPanel.Companion.getPinAction().isSelected()) {
            return;
        }
        if (this.isVisible()) {
            this.setVisible(false);
            this.firePropertyChange("visible", true, false);
        }
    }

    private final void initActions() {
        this.add(this.initPinActionButton());
        this.add(this.initServerInfoActionButton());
        this.add(this.initSnippetActionButton());
        this.add(this.initNvidiaSMIActionButton());
        this.add(this.initReconnectActionButton());
        this.add(this.initCloseActionButton());
    }

    private final void initEvents() {
        this.addPropertyChangeListener("ancestor", new PropertyChangeListener(this){
            final /* synthetic */ FloatingToolbarPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void propertyChange(PropertyChangeEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                this.this$0.removePropertyChangeListener("ancestor", this);
                SwingUtilities.invokeLater(() -> initEvents.1.propertyChange$lambda$0(this.this$0));
            }

            private static final void propertyChange$lambda$0(FloatingToolbarPanel this$0) {
                FloatingToolbarPanel.access$resumeVisualWindows(this$0);
            }
        });
    }

    private final void resumeVisualWindows() {
        TerminalTab terminalTab = this.getAnEvent().getData(DataProviders.INSTANCE.getTerminalTab());
        if (terminalTab == null) {
            return;
        }
        TerminalTab tab = terminalTab;
        if (!(tab instanceof SSHTerminalTab)) {
            return;
        }
        TerminalPanel terminalPanel = ((SSHTerminalTab)tab).getData(DataProviders.INSTANCE.getTerminalPanel());
        if (terminalPanel == null) {
            return;
        }
        TerminalPanel terminalPanel2 = terminalPanel;
        terminalPanel2.resumeVisualWindows(((SSHTerminalTab)tab).getHost().getId(), new DataProvider(tab){
            final /* synthetic */ TerminalTab $tab;
            {
                this.$tab = $tab;
            }

            public <T> T getData(DataKey<T> dataKey) {
                Intrinsics.checkNotNullParameter(dataKey, (String)"dataKey");
                if (Intrinsics.areEqual(dataKey, DataProviders.INSTANCE.getTerminalTab())) {
                    TerminalTab terminalTab = this.$tab;
                    Intrinsics.checkNotNull((Object)terminalTab, (String)"null cannot be cast to non-null type T of app.termora.terminal.panel.FloatingToolbarPanel.resumeVisualWindows.<no name provided>.getData");
                    return (T)terminalTab;
                }
                return DataProvider.DefaultImpls.getData(this, dataKey);
            }
        });
    }

    private final JButton initServerInfoActionButton() {
        JButton btn = new JButton((Icon)((Object)Icons.INSTANCE.getInfoOutline()));
        btn.setToolTipText(I18n.INSTANCE.getString("termora.visual-window.system-information"));
        btn.addActionListener((ActionListener)((Object)new AnAction(this){
            final /* synthetic */ FloatingToolbarPanel this$0;
            {
                this.this$0 = $receiver;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                TerminalTab terminalTab = FloatingToolbarPanel.access$getAnEvent(this.this$0).getData(DataProviders.INSTANCE.getTerminalTab());
                if (terminalTab == null) {
                    return;
                }
                TerminalTab tab = terminalTab;
                TerminalPanel terminalPanel = ((DataProvider)tab).getData(DataProviders.INSTANCE.getTerminalPanel());
                if (terminalPanel == null) {
                    return;
                }
                TerminalPanel terminalPanel2 = terminalPanel;
                if (!(tab instanceof SSHTerminalTab)) {
                    TerminalPanel.toast-HG0u8IE$default(terminalPanel2, I18n.INSTANCE.getString("termora.floating-toolbar.not-supported"), 0L, 2, null);
                    return;
                }
                for (VisualWindow window : terminalPanel2.getVisualWindows()) {
                    if (!(window instanceof SystemInformationVisualWindow)) continue;
                    terminalPanel2.moveToFront(window);
                    return;
                }
                SystemInformationVisualWindow visualWindowPanel = new SystemInformationVisualWindow((SSHTerminalTab)tab, (VisualWindowManager)terminalPanel2);
                terminalPanel2.addVisualWindow(visualWindowPanel);
            }
        }));
        return btn;
    }

    private final JButton initSnippetActionButton() {
        JButton btn = new JButton((Icon)((Object)Icons.INSTANCE.getCodeSpan()));
        btn.setToolTipText(I18n.INSTANCE.getString("termora.snippet.title"));
        btn.addActionListener((ActionListener)((Object)new AnAction(this, btn){
            final /* synthetic */ FloatingToolbarPanel this$0;
            final /* synthetic */ JButton $btn;
            {
                this.this$0 = $receiver;
                this.$btn = $btn;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                TerminalTab terminalTab = FloatingToolbarPanel.access$getAnEvent(this.this$0).getData(DataProviders.INSTANCE.getTerminalTab());
                if (terminalTab == null) {
                    return;
                }
                TerminalTab tab = terminalTab;
                TerminalWriter terminalWriter = tab.getData(DataProviders.INSTANCE.getTerminalWriter());
                if (terminalWriter == null) {
                    return;
                }
                TerminalWriter writer = terminalWriter;
                SnippetTreeDialog dialog = new SnippetTreeDialog(evt.getWindow());
                dialog.setLocationRelativeTo(this.$btn);
                dialog.setLocation(dialog.getX(), this.$btn.getLocationOnScreen().y + this.this$0.getHeight() + 2);
                dialog.setVisible(true);
                SnippetTreeNode snippetTreeNode = dialog.getSelectedNode();
                if (snippetTreeNode == null) {
                    return;
                }
                SnippetTreeNode node = snippetTreeNode;
                SnippetAction.Companion.getInstance().runSnippet((Snippet)node.getData(), writer);
            }
        }));
        return btn;
    }

    private final JButton initNvidiaSMIActionButton() {
        JButton btn = new JButton((Icon)((Object)Icons.INSTANCE.getNvidia()));
        btn.setToolTipText(I18n.INSTANCE.getString("termora.visual-window.nvidia-smi"));
        btn.addActionListener((ActionListener)((Object)new AnAction(this){
            final /* synthetic */ FloatingToolbarPanel this$0;
            {
                this.this$0 = $receiver;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                TerminalTab terminalTab = FloatingToolbarPanel.access$getAnEvent(this.this$0).getData(DataProviders.INSTANCE.getTerminalTab());
                if (terminalTab == null) {
                    return;
                }
                TerminalTab tab = terminalTab;
                TerminalPanel terminalPanel = ((DataProvider)tab).getData(DataProviders.INSTANCE.getTerminalPanel());
                if (terminalPanel == null) {
                    return;
                }
                TerminalPanel terminalPanel2 = terminalPanel;
                if (!(tab instanceof SSHTerminalTab)) {
                    TerminalPanel.toast-HG0u8IE$default(terminalPanel2, I18n.INSTANCE.getString("termora.floating-toolbar.not-supported"), 0L, 2, null);
                    return;
                }
                for (VisualWindow window : terminalPanel2.getVisualWindows()) {
                    if (!(window instanceof NvidiaSMIVisualWindow)) continue;
                    terminalPanel2.moveToFront(window);
                    return;
                }
                NvidiaSMIVisualWindow visualWindowPanel = new NvidiaSMIVisualWindow((SSHTerminalTab)tab, (VisualWindowManager)terminalPanel2);
                terminalPanel2.addVisualWindow(visualWindowPanel);
            }
        }));
        return btn;
    }

    private final JButton initPinActionButton() {
        JButton btn = new JButton((Icon)((Object)Icons.INSTANCE.getPin()));
        btn.setSelected(FloatingToolbarPanel.Companion.getPinAction().isSelected());
        ActionListener actionListener = arg_0 -> FloatingToolbarPanel.initPinActionButton$lambda$0(btn, arg_0);
        FloatingToolbarPanel.Companion.getPinAction().addActionListener(actionListener);
        btn.addActionListener((ActionListener)((Object)FloatingToolbarPanel.Companion.getPinAction()));
        Disposer.register(this, new Disposable(btn, actionListener){
            final /* synthetic */ JButton $btn;
            final /* synthetic */ ActionListener $actionListener;
            {
                this.$btn = $btn;
                this.$actionListener = $actionListener;
            }

            public void dispose() {
                this.$btn.removeActionListener((ActionListener)((Object)app.termora.terminal.panel.FloatingToolbarPanel$Companion.access$getPinAction(FloatingToolbarPanel.Companion)));
                app.termora.terminal.panel.FloatingToolbarPanel$Companion.access$getPinAction(FloatingToolbarPanel.Companion).removeActionListener(this.$actionListener);
            }
        });
        return btn;
    }

    private final JButton initCloseActionButton() {
        JButton btn = new JButton((Icon)((Object)Icons.INSTANCE.getCloseSmall()));
        btn.setToolTipText(I18n.INSTANCE.getString("termora.floating-toolbar.close-in-current-tab"));
        btn.setPressedIcon((Icon)((Object)Icons.INSTANCE.getCloseSmallHovered()));
        btn.setRolloverIcon((Icon)((Object)Icons.INSTANCE.getCloseSmallHovered()));
        btn.addActionListener(arg_0 -> FloatingToolbarPanel.initCloseActionButton$lambda$1(this, arg_0));
        return btn;
    }

    private final JButton initReconnectActionButton() {
        JButton btn = new JButton((Icon)((Object)Icons.INSTANCE.getRefresh()));
        btn.setToolTipText(I18n.INSTANCE.getString("termora.tabbed.contextmenu.reconnect"));
        btn.addActionListener((ActionListener)((Object)new AnAction(this){
            final /* synthetic */ FloatingToolbarPanel this$0;
            {
                this.this$0 = $receiver;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                TerminalTab terminalTab = FloatingToolbarPanel.access$getAnEvent(this.this$0).getData(DataProviders.INSTANCE.getTerminalTab());
                if (terminalTab == null) {
                    return;
                }
                TerminalTab tab = terminalTab;
                if (tab.canReconnect()) {
                    tab.reconnect();
                }
            }
        }));
        return btn;
    }

    private static final void initPinActionButton$lambda$0(JButton $btn, ActionEvent it) {
        $btn.setSelected(FloatingToolbarPanel.Companion.getPinAction().isSelected());
    }

    private static final void initCloseActionButton$lambda$1(FloatingToolbarPanel this$0, ActionEvent it) {
        this$0.closed = true;
        this$0.triggerHide();
    }

    private static final Companion.pinAction.2.1 pinAction_delegate$lambda$2() {
        return new AnAction(){
            private final String key;
            {
                this.key = "FloatingToolbar.pined";
                this.setStateAction();
                this.setSelected(Boolean.parseBoolean(this.getProperties().getString(this.key, "")));
            }

            private final Database.Properties getProperties() {
                return Database.Companion.getDatabase().getProperties();
            }

            protected void actionPerformed(AnActionEvent evt) {
                Object it;
                Object element$iv;
                int n;
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                this.setSelected(!this.isSelected());
                this.getProperties().putString(this.key, String.valueOf(this.isSelected()));
                ActionListener[] actionListenerArray = this.getActionListeners();
                Intrinsics.checkNotNullExpressionValue((Object)actionListenerArray, (String)"getActionListeners(...)");
                Object[] $this$forEach$iv = actionListenerArray;
                boolean $i$f$forEach = false;
                int n2 = $this$forEach$iv.length;
                for (n = 0; n < n2; ++n) {
                    element$iv = $this$forEach$iv[n];
                    it = (ActionListener)element$iv;
                    boolean bl = false;
                    it.actionPerformed(evt);
                }
                if (this.isSelected()) {
                    $this$forEach$iv = TerminalPanelFactory.Companion.getInstance().getTerminalPanels();
                    $i$f$forEach = false;
                    n2 = $this$forEach$iv.length;
                    for (n = 0; n < n2; ++n) {
                        it = element$iv = $this$forEach$iv[n];
                        boolean bl = false;
                        FloatingToolbarPanel floatingToolbarPanel = ((TerminalPanel)it).getData(FloatingToolbarPanel.Companion.getFloatingToolbar());
                        if (floatingToolbarPanel == null) continue;
                        floatingToolbarPanel.triggerShow();
                    }
                } else {
                    FloatingToolbarPanel c2 = evt.getData(FloatingToolbarPanel.Companion.getFloatingToolbar());
                    TerminalPanel[] $this$forEach$iv2 = TerminalPanelFactory.Companion.getInstance().getTerminalPanels();
                    boolean $i$f$forEach2 = false;
                    int n3 = $this$forEach$iv2.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        TerminalPanel element$iv2;
                        TerminalPanel it2 = element$iv2 = $this$forEach$iv2[n2];
                        boolean bl = false;
                        FloatingToolbarPanel e = it2.getData(FloatingToolbarPanel.Companion.getFloatingToolbar());
                        if (Intrinsics.areEqual((Object)c2, (Object)e)) continue;
                        FloatingToolbarPanel floatingToolbarPanel = e;
                        if (floatingToolbarPanel == null) continue;
                        floatingToolbarPanel.triggerHide();
                    }
                }
            }
        };
    }

    public static final /* synthetic */ void access$resumeVisualWindows(FloatingToolbarPanel $this) {
        $this.resumeVisualWindows();
    }

    public static final /* synthetic */ AnActionEvent access$getAnEvent(FloatingToolbarPanel $this) {
        return $this.getAnEvent();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000'\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\b\u0006*\u0001\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lapp/termora/terminal/panel/FloatingToolbarPanel$Companion;", "", "<init>", "()V", "FloatingToolbar", "Lapp/termora/terminal/DataKey;", "Lapp/termora/terminal/panel/FloatingToolbarPanel;", "getFloatingToolbar", "()Lapp/termora/terminal/DataKey;", "isPined", "", "()Z", "pinAction", "app/termora/terminal/panel/FloatingToolbarPanel$Companion$pinAction$2$1", "getPinAction", "()Lapp/termora/terminal/panel/FloatingToolbarPanel$Companion$pinAction$2$1;", "pinAction$delegate", "Lkotlin/Lazy;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<FloatingToolbarPanel> getFloatingToolbar() {
            return FloatingToolbar;
        }

        public final boolean isPined() {
            return this.getPinAction().isSelected();
        }

        private final pinAction.2.1 getPinAction() {
            Lazy lazy = pinAction$delegate;
            return (Object)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

