/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.DataKey;
import app.termora.terminal.Document;
import app.termora.terminal.GraphicCharacterSet;
import app.termora.terminal.KTermKt;
import app.termora.terminal.Processor;
import app.termora.terminal.ProcessorState;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalReader;
import app.termora.terminal.TerminalState;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0016J\b\u0010\u0016\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lapp/termora/terminal/TextProcessor;", "Lapp/termora/terminal/Processor;", "terminal", "Lapp/termora/terminal/Terminal;", "reader", "Lapp/termora/terminal/TerminalReader;", "<init>", "(Lapp/termora/terminal/Terminal;Lapp/termora/terminal/TerminalReader;)V", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "terminals", "", "", "graphicCharacterSet", "Lapp/termora/terminal/GraphicCharacterSet;", "getGraphicCharacterSet", "()Lapp/termora/terminal/GraphicCharacterSet;", "insertMode", "", "getInsertMode", "()Z", "process", "Lapp/termora/terminal/ProcessorState;", "ch", "", "termora"})
public final class TextProcessor
implements Processor {
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final TerminalReader reader;
    @NotNull
    private final StringBuilder sb;
    @NotNull
    private final Set<Character> terminals;

    public TextProcessor(@NotNull Terminal terminal, @NotNull TerminalReader reader) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.terminal = terminal;
        this.reader = reader;
        this.sb = new StringBuilder();
        Object[] objectArray = new Character[]{Character.valueOf('\u001b'), Character.valueOf('\u0007'), Character.valueOf('\r'), Character.valueOf('\n'), Character.valueOf('\f'), Character.valueOf('\u000b'), Character.valueOf('\b'), Character.valueOf('\t')};
        this.terminals = SetsKt.setOf((Object[])objectArray);
    }

    private final GraphicCharacterSet getGraphicCharacterSet() {
        return this.terminal.getTerminalModel().getData(DataKey.Companion.getGraphicCharacterSet());
    }

    private final boolean getInsertMode() {
        return this.terminal.getTerminalModel().getData(DataKey.Companion.getInsertMode(), false);
    }

    @Override
    @NotNull
    public ProcessorState process(char ch) {
        if (KTermKt.isNull(ch)) {
            return TerminalState.READY;
        }
        this.sb.append(this.getGraphicCharacterSet().map(ch));
        if (this.reader.isEmpty() || CollectionsKt.contains((Iterable)this.terminals, (Object)this.reader.peek()) || this.getInsertMode()) {
            this.process();
            return TerminalState.READY;
        }
        return TerminalState.Text;
    }

    private final void process() {
        Document document = this.terminal.getDocument();
        String string = this.sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        document.write(string);
        StringsKt.clear((StringBuilder)this.sb);
    }
}

