/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.ColorPalette;
import app.termora.terminal.ColorPaletteImpl;
import app.termora.terminal.CursorStyle;
import app.termora.terminal.DataKey;
import app.termora.terminal.DataListener;
import app.termora.terminal.GraphicCharacterSet;
import app.termora.terminal.MouseMode;
import app.termora.terminal.ScrollingRegion;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalModel;
import app.termora.terminal.TerminalResize;
import app.termora.terminal.TerminalSize;
import app.termora.terminal.TextStyle;
import java.awt.Toolkit;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClasses;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J%\u0010\u0018\u001a\u0002H\u0019\"\b\b\u0000\u0010\u0019*\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u000bH\u0016\u00a2\u0006\u0002\u0010\u001bJ-\u0010\u0018\u001a\u0002H\u0019\"\b\b\u0000\u0010\u0019*\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u000b2\u0006\u0010\u001c\u001a\u0002H\u0019H\u0016\u00a2\u0006\u0002\u0010\u001dJ-\u0010\u001e\u001a\u00020\u001f\"\b\b\u0000\u0010\u0019*\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u000b2\u0006\u0010\t\u001a\u0002H\u0019H\u0016\u00a2\u0006\u0002\u0010 J\u0014\u0010!\u001a\u00020\"2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u000fH\u0016J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u000fH\u0016J\b\u0010&\u001a\u00020\u001fH\u0016J\u0018\u0010'\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J-\u0010(\u001a\u00020\u001f\"\b\b\u0000\u0010\u0019*\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u000b2\u0006\u0010\t\u001a\u0002H\u0019H\u0004\u00a2\u0006\u0002\u0010 J\b\u0010)\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lapp/termora/terminal/TerminalModelImpl;", "Lapp/termora/terminal/TerminalModel;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/Terminal;)V", "rows", "", "cols", "data", "", "Lapp/termora/terminal/DataKey;", "", "listeners", "", "Lapp/termora/terminal/DataListener;", "[Lapp/termora/terminal/DataListener;", "colorPalette", "Lapp/termora/terminal/ColorPaletteImpl;", "getTerminal", "getCols", "getRows", "getColorPalette", "Lapp/termora/terminal/ColorPalette;", "getData", "T", "key", "(Lapp/termora/terminal/DataKey;)Ljava/lang/Object;", "defaultValue", "(Lapp/termora/terminal/DataKey;Ljava/lang/Object;)Ljava/lang/Object;", "setData", "", "(Lapp/termora/terminal/DataKey;Ljava/lang/Object;)V", "hasData", "", "addDataListener", "listener", "removeDataListener", "bell", "resize", "fireDataChanged", "getMaxRows", "Companion", "termora"})
public class TerminalModelImpl
implements TerminalModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Terminal terminal;
    private int rows;
    private int cols;
    @NotNull
    private final Map<DataKey<?>, Object> data;
    @NotNull
    private DataListener[] listeners;
    @NotNull
    private final ColorPaletteImpl colorPalette;
    private static final Logger log = LoggerFactory.getLogger(TerminalModelImpl.class);

    public TerminalModelImpl(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminal = terminal;
        this.rows = 27;
        this.cols = 80;
        this.data = new LinkedHashMap();
        this.listeners = new DataListener[0];
        this.colorPalette = new ColorPaletteImpl(this.terminal);
        this.setData(DataKey.Companion.getTextStyle(), TextStyle.box-impl(TextStyle.Companion.getDefault-c2YIwqY()));
        this.setData(DataKey.Companion.getCursorStyle(), CursorStyle.Block);
        this.setData(DataKey.Companion.getShowCursor(), true);
        this.setData(DataKey.Companion.getGraphicCharacterSet(), new GraphicCharacterSet(null, null, 3, null));
        if (!this.hasData(DataKey.Companion.getScrollingRegion())) {
            this.setData(DataKey.Companion.getScrollingRegion(), new ScrollingRegion(1, this.getRows()));
        }
        this.setData(DataKey.Companion.getMouseMode(), MouseMode.MOUSE_REPORTING_NONE);
        this.addDataListener(new DataListener(){

            @Override
            public void onChanged(DataKey<?> key, Object data) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (Intrinsics.areEqual(key, TerminalModel.Companion.getResize())) {
                    TerminalResize resize = (TerminalResize)KClasses.cast(TerminalModel.Companion.getResize().getClazz(), (Object)data);
                    ScrollingRegion region = null;
                    if (this.hasData(DataKey.Companion.getScrollingRegion())) {
                        region = this.getData(DataKey.Companion.getScrollingRegion());
                        region = ScrollingRegion.copy$default(region, 0, resize.getNewSize().getRows(), 1, null);
                    } else {
                        region = new ScrollingRegion(1, resize.getNewSize().getRows());
                    }
                    this.setData(DataKey.Companion.getScrollingRegion(), region);
                    if (log.isDebugEnabled()) {
                        log.debug("Resize ScrollingRegion. {}", (Object)region);
                    }
                }
            }
        });
    }

    @Override
    @NotNull
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public int getCols() {
        return this.cols;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    @NotNull
    public ColorPalette getColorPalette() {
        return this.colorPalette;
    }

    @Override
    @NotNull
    public <T> T getData(@NotNull DataKey<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (T)KClasses.cast(key.getClazz(), (Object)this.data.get(key));
    }

    @Override
    @NotNull
    public <T> T getData(@NotNull DataKey<T> key, @NotNull T defaultValue) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        if (this.data.containsKey(key)) {
            return this.getData(key);
        }
        return defaultValue;
    }

    @Override
    public <T> void setData(@NotNull DataKey<T> key, @NotNull T data) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.data.put(key, data);
        this.fireDataChanged(key, data);
    }

    @Override
    public boolean hasData(@NotNull DataKey<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.data.containsKey(key);
    }

    @Override
    public void addDataListener(@NotNull DataListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Object[] objectArray = ArrayUtils.add((Object[])this.listeners, (Object)listener2);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"add(...)");
        this.listeners = (DataListener[])objectArray;
    }

    @Override
    public void removeDataListener(@NotNull DataListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Object[] objectArray = ArrayUtils.removeElement((Object[])this.listeners, (Object)listener2);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"removeElement(...)");
        this.listeners = (DataListener[])objectArray;
    }

    @Override
    public void bell() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void resize(int rows, int cols) {
        if (rows < 5 || cols < 10) {
            return;
        }
        int oldRows = this.getRows();
        int oldCols = this.getCols();
        this.rows = rows;
        this.cols = cols;
        this.fireDataChanged(TerminalModel.Companion.getResize(), new TerminalResize(new TerminalSize(oldRows, oldCols), new TerminalSize(rows, cols)));
    }

    protected final <T> void fireDataChanged(@NotNull DataKey<T> key, @NotNull T data) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        for (DataListener listener2 : this.listeners) {
            listener2.onChanged(key, data);
        }
    }

    @Override
    public int getMaxRows() {
        return 5000;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/terminal/TerminalModelImpl$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

