/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.CharBuffer;
import app.termora.terminal.CursorModel;
import app.termora.terminal.CursorMove;
import app.termora.terminal.DataKey;
import app.termora.terminal.DocumentImpl;
import app.termora.terminal.KTermKt;
import app.termora.terminal.MarkupModel;
import app.termora.terminal.Position;
import app.termora.terminal.ScrollingModel;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalLine;
import app.termora.terminal.TerminalLineBuffer;
import app.termora.terminal.TerminalModel;
import app.termora.terminal.TerminalSize;
import app.termora.terminal.TextStyle;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.CharCompanionObject;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0015\n\u0002\u0010(\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 R2\u00020\u0001:\u0003RSTB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J'\u0010(\u001a\u00020%2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010*\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b+\u0010,J\u0019\u0010-\u001a\u00020\u000b2\b\b\u0002\u0010*\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b.\u0010/J\b\u00100\u001a\u00020%H\u0002J\u000e\u00101\u001a\u00020%2\u0006\u00102\u001a\u00020#J\u0010\u00103\u001a\u00020%2\u0006\u0010\f\u001a\u000204H\u0002J\u000e\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020'J\u001f\u00107\u001a\u00020\u000b2\u0006\u00106\u001a\u00020'2\b\b\u0002\u0010*\u001a\u00020\u0017\u00a2\u0006\u0004\b8\u00109J\u000e\u0010:\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u0006\u0010;\u001a\u00020'J\b\u0010<\u001a\u00020'H\u0002J\u001e\u0010=\u001a\u00020%2\u0006\u0010>\u001a\u00020'2\u0006\u0010?\u001a\u00020'2\u0006\u0010@\u001a\u00020'J\u001e\u0010A\u001a\u00020%2\u0006\u0010>\u001a\u00020'2\u0006\u0010?\u001a\u00020'2\u0006\u0010@\u001a\u00020'J$\u0010B\u001a\u00020C2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0D2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020G0FH\u0002J)\u0010H\u001a\b\u0012\u0004\u0012\u00020G0I2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0D2\u0006\u0010J\u001a\u00020CH\u0002\u00a2\u0006\u0002\u0010KJ\u000e\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000b0DH\u0002J\u0016\u0010M\u001a\u00020%2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020OJ\u0006\u0010Q\u001a\u00020'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006U"}, d2={"Lapp/termora/terminal/TerminalLineBuffer;", "", "terminal", "Lapp/termora/terminal/Terminal;", "isAlternateScreenBuffer", "", "<init>", "(Lapp/termora/terminal/Terminal;Z)V", "()Z", "screen", "", "Lapp/termora/terminal/TerminalLine;", "buffer", "Lapp/termora/terminal/TerminalLineBuffer$StrangeArrayList;", "cursorModel", "Lapp/termora/terminal/CursorModel;", "getCursorModel", "()Lapp/termora/terminal/CursorModel;", "terminalModel", "Lapp/termora/terminal/TerminalModel;", "getTerminalModel", "()Lapp/termora/terminal/TerminalModel;", "currentTextStyle", "Lapp/termora/terminal/TextStyle;", "getCurrentTextStyle-c2YIwqY", "()J", "scrollingModel", "Lapp/termora/terminal/ScrollingModel;", "getScrollingModel", "()Lapp/termora/terminal/ScrollingModel;", "resizing", "currentTerminalLine", "getCurrentTerminalLine", "()Lapp/termora/terminal/TerminalLine;", "getText", "", "eraseInDisplay", "", "n", "", "grow", "lines", "attr", "grow-QwXzuJw", "(Ljava/util/List;J)V", "newline", "newline-oMHEAL4", "(J)Lapp/termora/terminal/TerminalLine;", "wrap", "write", "text", "writeTerminalLineChar", "Lapp/termora/terminal/CharBuffer;", "getLineAt", "index", "getScreenLineAt", "getScreenLineAt-QwXzuJw", "(IJ)Lapp/termora/terminal/TerminalLine;", "eraseInLine", "getLineCount", "getScreenSizeIgnoreNullLine", "insertLines", "top", "bottom", "count", "deleteLines", "positionToCharIndex", "", "", "positions", "", "Lapp/termora/terminal/Position;", "charIndexToPosition", "", "charIndexes", "(Ljava/util/Iterator;[I)[Lapp/termora/terminal/Position;", "lineIterator", "resize", "oldSize", "Lapp/termora/terminal/TerminalSize;", "newSize", "getBufferCount", "Companion", "StrangeArrayList", "Resizer", "termora"})
@SourceDebugExtension(value={"SMAP\nTerminalLineBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalLineBuffer.kt\napp/termora/terminal/TerminalLineBuffer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,774:1\n1878#2,3:775\n12532#3,2:778\n*S KotlinDebug\n*F\n+ 1 TerminalLineBuffer.kt\napp/termora/terminal/TerminalLineBuffer\n*L\n391#1:775,3\n394#1:778,2\n*E\n"})
public final class TerminalLineBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Terminal terminal;
    private final boolean isAlternateScreenBuffer;
    @NotNull
    private final List<TerminalLine> screen;
    @NotNull
    private final StrangeArrayList buffer;
    private boolean resizing;
    private static final Logger log = LoggerFactory.getLogger(TerminalLineBuffer.class);

    public TerminalLineBuffer(@NotNull Terminal terminal, boolean isAlternateScreenBuffer) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminal = terminal;
        this.isAlternateScreenBuffer = isAlternateScreenBuffer;
        this.screen = new ArrayList();
        this.buffer = new StrangeArrayList();
    }

    public final boolean isAlternateScreenBuffer() {
        return this.isAlternateScreenBuffer;
    }

    private final CursorModel getCursorModel() {
        return this.terminal.getCursorModel();
    }

    private final TerminalModel getTerminalModel() {
        return this.terminal.getTerminalModel();
    }

    private final long getCurrentTextStyle-c2YIwqY() {
        return this.getTerminalModel().getData(DataKey.Companion.getTextStyle()).unbox-impl();
    }

    private final ScrollingModel getScrollingModel() {
        return this.terminal.getScrollingModel();
    }

    private final TerminalLine getCurrentTerminalLine() {
        int y = this.getCursorModel().getPosition().getY() - 1;
        while (y >= this.screen.size()) {
            TerminalLineBuffer.grow-QwXzuJw$default(this, this.screen, 0L, 2, null);
        }
        return this.screen.get(y);
    }

    @NotNull
    public final String getText() {
        StringBuilder sb = new StringBuilder();
        int count = this.getLineCount();
        for (int i = 0; i < count; ++i) {
            sb.append(this.getLineAt(i).getText());
            if (i == count - 1) continue;
            sb.append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void eraseInDisplay(int n) {
        Position position = this.getCursorModel().getPosition();
        int cols = this.getTerminalModel().getCols();
        long attr = TextStyle.copyOnlyColors-c2YIwqY(this.getTerminalModel().getData(DataKey.Companion.getTextStyle()).unbox-impl());
        block0 : switch (n) {
            case 0: {
                int i = position.getY();
                int n2 = Math.max(this.screen.size(), position.getY());
                if (i > n2) break;
                while (true) {
                    TerminalLine line = this.getScreenLineAt-QwXzuJw(i - 1, attr);
                    if (i == position.getY()) {
                        line.eraseChars-PM23JaI(position.getX() - 1, cols - (position.getX() - 1), attr);
                    } else {
                        line.eraseChars-PM23JaI(0, cols, attr);
                    }
                    if (i == n2) break block0;
                    ++i;
                }
            }
            case 1: {
                int i = 1;
                int n3 = position.getY();
                if (i > n3) break;
                while (true) {
                    TerminalLine line = TerminalLineBuffer.getScreenLineAt-QwXzuJw$default(this, i - 1, 0L, 2, null);
                    Pair c2 = new Pair((Object)Character.valueOf(KTermKt.getSpace(CharCompanionObject.INSTANCE)), (Object)TextStyle.box-impl(attr));
                    if (i == position.getY()) {
                        line.eraseChars(0, position.getX(), (Pair<Character, TextStyle>)c2);
                    } else {
                        line.eraseChars(0, cols, (Pair<Character, TextStyle>)c2);
                    }
                    if (i == n3) break block0;
                    ++i;
                }
            }
            case 2: {
                while (!((Collection)this.screen).isEmpty() && ((TerminalLine)CollectionsKt.last(this.screen)).actualCount() < 1) {
                    this.screen.removeLast();
                }
                this.buffer.addAll((Collection<? extends TerminalLine>)this.screen);
                this.screen.clear();
                int n4 = this.getTerminalModel().getRows();
                for (int i = 0; i < n4; ++i) {
                    this.grow-QwXzuJw(this.screen, attr);
                }
                if (!this.terminal.getScrollingModel().isStick()) break;
                this.terminal.getScrollingModel().scrollTo(Integer.MAX_VALUE);
                break;
            }
            case 3: {
                this.buffer.clear();
                this.screen.clear();
                this.terminal.getScrollingModel().scrollTo(0);
                this.getCursorModel().move(1, 1);
                MarkupModel.DefaultImpls.removeAllHighlighters$default(this.terminal.getMarkupModel(), 0, 1, null);
            }
        }
    }

    private final void grow-QwXzuJw(List<TerminalLine> lines, long attr) {
        lines.add(this.newline-oMHEAL4(attr));
    }

    static /* synthetic */ void grow-QwXzuJw$default(TerminalLineBuffer terminalLineBuffer, List list, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = TextStyle.Companion.getDefault-c2YIwqY();
        }
        terminalLineBuffer.grow-QwXzuJw(list, l);
    }

    private final TerminalLine newline-oMHEAL4(long attr) {
        TerminalLine line = new TerminalLine();
        int n = this.getTerminalModel().getCols();
        for (int i = 0; i < n; ++i) {
            line.addChar((Pair<Character, TextStyle>)new Pair((Object)Character.valueOf(KTermKt.getNull(CharCompanionObject.INSTANCE)), (Object)TextStyle.box-impl(attr)));
        }
        return line;
    }

    static /* synthetic */ TerminalLine newline-oMHEAL4$default(TerminalLineBuffer terminalLineBuffer, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = TextStyle.Companion.getDefault-c2YIwqY();
        }
        return terminalLineBuffer.newline-oMHEAL4(l);
    }

    private final void wrap() {
        if (this.getCursorModel().getPosition().getX() > this.getTerminalModel().getCols()) {
            if (this.getTerminalModel().getData(DataKey.Companion.getAutoWrapMode(), true).booleanValue()) {
                this.getCurrentTerminalLine().setWrapped(true);
                this.terminal.getDocument().newline();
                this.getCursorModel().move(CursorMove.RowHome);
            } else {
                this.getCursorModel().move(CursorMove.RowHome);
            }
        }
    }

    public final void write(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.screen.isEmpty()) {
            TerminalLineBuffer.grow-QwXzuJw$default(this, this.screen, 0L, 2, null);
        }
        this.wrap();
        String string = Normalizer.normalize(text, Normalizer.Form.NFC);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalize(...)");
        CharBuffer buffer = new CharBuffer(string, this.getCurrentTextStyle-c2YIwqY(), null);
        while (buffer.getSize() - 1 + this.getCursorModel().getPosition().getX() > this.getTerminalModel().getCols()) {
            int count = this.getTerminalModel().getCols() - this.getCursorModel().getPosition().getX() + 1;
            this.writeTerminalLineChar(buffer.chunked(0, count));
            this.wrap();
            buffer = buffer.chunked(count, buffer.getSize() - count);
        }
        this.writeTerminalLineChar(buffer);
    }

    private final void writeTerminalLineChar(CharBuffer buffer) {
        if (buffer.isEmpty()) {
            return;
        }
        int x = this.getCursorModel().getPosition().getX();
        if (this.getTerminalModel().getData(DataKey.Companion.getInsertMode(), false).booleanValue()) {
            this.getCurrentTerminalLine().insertChars(x - 1, this.getTerminalModel().getCols(), buffer);
        } else {
            this.getCurrentTerminalLine().write(x - 1, buffer);
        }
        this.getCursorModel().move(CursorMove.Right, buffer.getSize());
    }

    @NotNull
    public final TerminalLine getLineAt(int index) {
        if (index < this.buffer.size()) {
            Object e = this.buffer.get(index);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            return (TerminalLine)e;
        }
        return TerminalLineBuffer.getScreenLineAt-QwXzuJw$default(this, index - this.buffer.size(), 0L, 2, null);
    }

    @NotNull
    public final TerminalLine getScreenLineAt-QwXzuJw(int index, long attr) {
        while (index >= this.screen.size()) {
            this.grow-QwXzuJw(this.screen, attr);
        }
        return this.screen.get(index);
    }

    public static /* synthetic */ TerminalLine getScreenLineAt-QwXzuJw$default(TerminalLineBuffer terminalLineBuffer, int n, long l, int n2, Object object) {
        if ((n2 & 2) != 0) {
            l = TextStyle.Companion.getDefault-c2YIwqY();
        }
        return terminalLineBuffer.getScreenLineAt-QwXzuJw(n, l);
    }

    public final void eraseInLine(int n) {
        int x = this.getCursorModel().getPosition().getX() - 1;
        int y = this.getCursorModel().getPosition().getY();
        int cols = this.terminal.getTerminalModel().getCols();
        long attr = TextStyle.copyOnlyColors-c2YIwqY(this.getTerminalModel().getData(DataKey.Companion.getTextStyle()).unbox-impl());
        TerminalLine line = TerminalLineBuffer.getScreenLineAt-QwXzuJw$default(this, y - 1, 0L, 2, null);
        switch (n) {
            case 0: {
                line.eraseChars(x, cols - x, (Pair<Character, TextStyle>)new Pair((Object)Character.valueOf(KTermKt.getNull(CharCompanionObject.INSTANCE)), (Object)TextStyle.box-impl(attr)));
                line.setWrapped(false);
                if (!log.isDebugEnabled()) break;
                log.debug("Erase In Line 0. x:" + x + " , y:" + y + " cols:" + cols);
                break;
            }
            case 1: {
                line.eraseChars-PM23JaI(0, this.getCursorModel().getPosition().getX(), attr);
                if (!log.isDebugEnabled()) break;
                log.debug("Erase In Line 1. x:" + x + " , y:" + y + " , cols:" + cols);
                break;
            }
            case 2: {
                line.eraseChars-PM23JaI(0, cols, attr);
                if (!log.isDebugEnabled()) break;
                log.debug("Erase In Line 2. x:" + x + " , y:" + y + " , cols:" + cols);
            }
        }
    }

    public final int getLineCount() {
        return this.screen.size() + this.buffer.size();
    }

    private final int getScreenSizeIgnoreNullLine() {
        if (this.screen.isEmpty()) {
            return 0;
        }
        for (int i = this.screen.size() - 1; -1 < i; --i) {
            if (this.screen.get(i).actualCount() == 0) continue;
            return i + 1;
        }
        return 0;
    }

    public final void insertLines(int top, int bottom, int count) {
        int i;
        List tail = new ArrayList();
        int n = this.screen.size() - bottom;
        for (int i2 = 0; i2 < n; ++i2) {
            tail.addFirst(this.screen.removeLast());
        }
        List head = new ArrayList();
        for (i = 1; i < top; ++i) {
            head.addLast(this.screen.removeFirst());
        }
        for (i = 0; i < count; ++i) {
            this.screen.addFirst(this.newline-oMHEAL4(this.getTerminalModel().getData(DataKey.Companion.getTextStyle()).unbox-impl()));
        }
        for (i = 0; i < count; ++i) {
            this.screen.removeLast();
        }
        this.screen.addAll(0, head);
        this.screen.addAll(tail);
    }

    public final void deleteLines(int top, int bottom, int count) {
        int i;
        List tail = new ArrayList();
        int n = this.screen.size() - bottom;
        for (int i2 = 0; i2 < n && !this.screen.isEmpty(); ++i2) {
            tail.addFirst(this.screen.removeLast());
        }
        List head = new ArrayList();
        for (int i3 = 1; i3 < top && !this.screen.isEmpty(); ++i3) {
            head.addLast(this.screen.removeFirst());
        }
        List removed = new ArrayList();
        for (i = 0; i < count && !this.screen.isEmpty(); ++i) {
            TerminalLine terminalLine = this.screen.removeFirst();
            Intrinsics.checkNotNullExpressionValue((Object)terminalLine, (String)"removeFirst(...)");
            removed.add(terminalLine);
        }
        this.screen.addAll(0, head);
        for (i = 0; i < count; ++i) {
            this.screen.add(this.newline-oMHEAL4(this.getTerminalModel().getData(DataKey.Companion.getTextStyle()).unbox-impl()));
        }
        this.screen.addAll(tail);
        if (top != 1 || this.isAlternateScreenBuffer) {
            return;
        }
        this.buffer.addAll(removed);
    }

    /*
     * WARNING - void declaration
     */
    private final int[] positionToCharIndex(Iterator<TerminalLine> lines, List<Position> positions) {
        boolean bl;
        boolean[] status;
        int[] charIndexes;
        block9: {
            int n = 0;
            int n2 = positions.size();
            int[] nArray = new int[n2];
            while (n < n2) {
                int n3 = n++;
                nArray[n3] = -1;
            }
            charIndexes = nArray;
            n2 = 0;
            int n4 = positions.size();
            boolean[] blArray = new boolean[n4];
            while (n2 < n4) {
                int n5 = n2++;
                blArray[n5] = false;
            }
            status = blArray;
            Iterable $this$forEachIndexed$iv = positions;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void position;
                int n6;
                if ((n6 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Position position2 = (Position)item$iv;
                int index = n6;
                boolean bl2 = false;
                status[index] = !position.isValid();
            }
            boolean[] $this$all$iv = status;
            boolean $i$f$all = false;
            int n7 = $this$all$iv.length;
            for (int i = 0; i < n7; ++i) {
                boolean element$iv;
                boolean it = element$iv = $this$all$iv[i];
                boolean bl3 = false;
                if (it) continue;
                bl = false;
                break block9;
            }
            bl = true;
        }
        if (bl) {
            return charIndexes;
        }
        ArraysKt.fill((int[])charIndexes, (int)0, (int)0, (int)charIndexes.length);
        Iterator<TerminalLine> iterator2 = new Iterator<TerminalLine>(this, lines){
            private final TerminalLine line;
            final /* synthetic */ Iterator<TerminalLine> $lines;
            {
                void $this$line_u24lambda_u240;
                TerminalLine terminalLine;
                this.$lines = $lines;
                TerminalLine terminalLine2 = terminalLine = TerminalLineBuffer.newline-oMHEAL4$default($receiver, 0L, 1, null);
                positionToCharIndex.iterator.1 var12_5 = this;
                boolean bl = false;
                int n = 0;
                int n2 = TerminalLineBuffer.access$getTerminalModel($receiver).getCols();
                char[] cArray = new char[n2];
                int n3 = 0;
                void var10_11 = $this$line_u24lambda_u240;
                while (n < n2) {
                    int n4 = n++;
                    cArray[n4] = KTermKt.getSpace(CharCompanionObject.INSTANCE);
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                long l = TextStyle.Companion.getDefault-c2YIwqY();
                char[] cArray2 = cArray;
                var10_11.write(n3, new CharBuffer(cArray2, l, defaultConstructorMarker));
                var12_5.line = terminalLine;
            }

            public boolean hasNext() {
                return true;
            }

            public TerminalLine next() {
                return this.$lines.hasNext() ? this.$lines.next() : this.line;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
        Iterator iterator3 = CollectionsKt.withIndex((Iterator)iterator2);
        while (iterator3.hasNext()) {
            IndexedValue indexedValue = (IndexedValue)iterator3.next();
            int i = indexedValue.component1();
            TerminalLine line = (TerminalLine)indexedValue.component2();
            boolean breakFlag = true;
            Iterator iterator4 = ((Iterable)positions).iterator();
            int n = 0;
            while (iterator4.hasNext()) {
                int j = n++;
                Position position = (Position)iterator4.next();
                if (status[j]) continue;
                if (i + 1 == position.getY()) {
                    charIndexes[j] = charIndexes[j] + position.getX() - 1;
                    status[j] = true;
                    continue;
                }
                charIndexes[j] = charIndexes[j] + line.actualCount();
                if (!breakFlag) continue;
                breakFlag = false;
            }
            if (!breakFlag) continue;
            break;
        }
        return charIndexes;
    }

    private final Position[] charIndexToPosition(Iterator<TerminalLine> lines, int[] charIndexes) {
        int n = 0;
        int n2 = charIndexes.length;
        Position[] positionArray = new Position[n2];
        while (n < n2) {
            int n3 = n++;
            positionArray[n3] = Position.Companion.getUnknown();
        }
        Position[] positions = positionArray;
        n2 = 0;
        int n4 = charIndexes.length;
        Object object = new int[n4];
        while (n2 < n4) {
            int n5 = n2++;
            object[n5] = 0;
        }
        int[] indexes = object;
        Iterator<TerminalLine> infinity2 = new Iterator<TerminalLine>(this, lines){
            private final TerminalLine line;
            private int index;
            final /* synthetic */ TerminalLineBuffer this$0;
            final /* synthetic */ Iterator<TerminalLine> $lines;
            {
                this.this$0 = $receiver;
                this.$lines = $lines;
                this.line = new TerminalLine(CollectionsKt.emptyList());
            }

            public boolean hasNext() {
                return this.index < TerminalLineBuffer.access$getTerminalModel(this.this$0).getMaxRows();
            }

            public TerminalLine next() {
                int n = this.index;
                this.index = n + 1;
                return this.$lines.hasNext() ? this.$lines.next() : this.line;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
        Iterator iterator2 = CollectionsKt.withIndex((Iterator)infinity2);
        while (iterator2.hasNext()) {
            object = (IndexedValue)iterator2.next();
            int i = object.component1();
            TerminalLine line = (TerminalLine)object.component2();
            boolean breakFlag = true;
            int n6 = charIndexes.length;
            for (int j = 0; j < n6; ++j) {
                int j2 = j;
                int charIndex = charIndexes[j];
                if (charIndex < 0 || !Intrinsics.areEqual((Object)positions[j2], (Object)Position.Companion.getUnknown())) continue;
                if (line.actualCount() + indexes[j2] >= charIndex) {
                    int n7 = line.actualCount();
                    for (int k = 0; k < n7; ++k) {
                        if (indexes[j2] == charIndex) {
                            if (k + 1 > this.getTerminalModel().getCols()) break;
                            positions[j2] = new Position(i + 1, k + 1);
                            break;
                        }
                        int n8 = indexes[j2];
                        indexes[j2] = n8 + 1;
                    }
                    breakFlag = !Intrinsics.areEqual((Object)positions[j2], (Object)Position.Companion.getUnknown());
                    continue;
                }
                indexes[j2] = indexes[j2] + line.actualCount();
                breakFlag = false;
            }
            if (!breakFlag) continue;
            break;
        }
        return positions;
    }

    private final Iterator<TerminalLine> lineIterator() {
        return new Iterator<TerminalLine>(this){
            private int index;
            final /* synthetic */ TerminalLineBuffer this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean hasNext() {
                return this.index < this.this$0.getLineCount();
            }

            public TerminalLine next() {
                int n = this.index;
                this.index = n + 1;
                return this.this$0.getLineAt(n);
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public final void resize(@NotNull TerminalSize oldSize, @NotNull TerminalSize newSize) {
        Object object;
        int charCount;
        Intrinsics.checkNotNullParameter((Object)oldSize, (String)"oldSize");
        Intrinsics.checkNotNullParameter((Object)newSize, (String)"newSize");
        int lineCount = this.getLineCount();
        if (lineCount < 1 || this.isAlternateScreenBuffer) {
            return;
        }
        ScrollingModel scrollingModel = this.getScrollingModel().getNonAlternateScreenBufferScrollingModel();
        int verticalScrollOffset = scrollingModel.getVerticalScrollOffset();
        int maxVerticalScrollOffset = scrollingModel.getMaxVerticalScrollOffset();
        Position selectionStartPosition = this.terminal.getSelectionModel().getSelectionStartPosition();
        Position selectionEndPosition = this.terminal.getSelectionModel().getSelectionEndPosition();
        if (selectionEndPosition.isValid() && selectionEndPosition.getY() <= lineCount) {
            charCount = this.getLineAt(selectionEndPosition.getY() - 1).actualCount();
            if (selectionEndPosition.getX() > charCount) {
                selectionEndPosition = Position.copy$default(selectionEndPosition, 0, charCount, 1, null);
            }
        }
        if (selectionStartPosition.isValid() && selectionStartPosition.getY() <= lineCount) {
            charCount = this.getLineAt(selectionStartPosition.getY() - 1).actualCount();
            if (selectionStartPosition.getX() > charCount) {
                Position position;
                if (selectionStartPosition.getY() + 1 <= lineCount) {
                    object = selectionStartPosition;
                    int n = selectionStartPosition.getY() + 1;
                    position = ((Position)object).copy(n, 1);
                } else {
                    position = Position.copy$default(selectionStartPosition, 0, 1, 1, null);
                }
                selectionStartPosition = position;
            }
        }
        object = new Position[]{selectionStartPosition, selectionEndPosition};
        int[] charIndexes = this.positionToCharIndex(this.lineIterator(), CollectionsKt.listOf((Object[])object));
        new Resizer(oldSize, newSize).resize();
        scrollingModel.scrollTo(scrollingModel.getMaxVerticalScrollOffset() - (maxVerticalScrollOffset - verticalScrollOffset));
        Position[] positions = this.charIndexToPosition(this.lineIterator(), charIndexes);
        if (positions[0].isValid() && positions[1].isValid()) {
            if (selectionStartPosition.getY() > lineCount) {
                positions[0] = selectionStartPosition;
            }
            if (selectionEndPosition.getY() > lineCount) {
                positions[1] = selectionEndPosition;
            }
            this.terminal.getSelectionModel().setSelection(positions[0], positions[1]);
        }
    }

    public final int getBufferCount() {
        return this.buffer.size();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/terminal/TerminalLineBuffer$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016H\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lapp/termora/terminal/TerminalLineBuffer$Resizer;", "", "oldSize", "Lapp/termora/terminal/TerminalSize;", "newSize", "<init>", "(Lapp/termora/terminal/TerminalLineBuffer;Lapp/termora/terminal/TerminalSize;Lapp/termora/terminal/TerminalSize;)V", "getOldSize", "()Lapp/termora/terminal/TerminalSize;", "getNewSize", "myLines", "Ljava/util/ArrayList;", "Lapp/termora/terminal/TerminalLine;", "Lkotlin/collections/ArrayList;", "count", "", "getCount", "()I", "oldScreenSize", "addLines", "", "iterator", "", "sublist", "", "offset", "resize", "", "resizeCols", "resizeRows", "termora"})
    @SourceDebugExtension(value={"SMAP\nTerminalLineBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalLineBuffer.kt\napp/termora/terminal/TerminalLineBuffer$Resizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,774:1\n1#2:775\n1869#3,2:776\n*S KotlinDebug\n*F\n+ 1 TerminalLineBuffer.kt\napp/termora/terminal/TerminalLineBuffer$Resizer\n*L\n603#1:776,2\n*E\n"})
    private final class Resizer {
        @NotNull
        private final TerminalSize oldSize;
        @NotNull
        private final TerminalSize newSize;
        @NotNull
        private ArrayList<TerminalLine> myLines;
        private final int oldScreenSize;

        public Resizer(@NotNull TerminalSize oldSize, TerminalSize newSize) {
            Intrinsics.checkNotNullParameter((Object)oldSize, (String)"oldSize");
            Intrinsics.checkNotNullParameter((Object)newSize, (String)"newSize");
            this.oldSize = oldSize;
            this.newSize = newSize;
            this.myLines = new ArrayList();
            this.oldScreenSize = TerminalLineBuffer.this.getScreenSizeIgnoreNullLine();
        }

        @NotNull
        public final TerminalSize getOldSize() {
            return this.oldSize;
        }

        @NotNull
        public final TerminalSize getNewSize() {
            return this.newSize;
        }

        public final int getCount() {
            return this.myLines.size();
        }

        private final List<TerminalLine> addLines(Iterator<TerminalLine> iterator2) {
            ArrayList<TerminalLine> list = this.myLines;
            List segments = new ArrayList();
            int count = 0;
            int cols = this.newSize.getCols();
            while (iterator2.hasNext()) {
                TerminalLine current;
                do {
                    current = iterator2.next();
                    segments.add(current);
                    count += current.actualCount();
                } while (current.getWrapped() && iterator2.hasNext());
                if (count <= cols) {
                    Object e = segments.removeFirst();
                    TerminalLine $this$addLines_u24lambda_u240 = (TerminalLine)e;
                    boolean bl = false;
                    $this$addLines_u24lambda_u240.setWrapped(false);
                    Object e2 = e;
                    Intrinsics.checkNotNullExpressionValue(e2, (String)"apply(...)");
                    TerminalLine line = (TerminalLine)e2;
                    if (!((Collection)segments).isEmpty()) {
                        Iterable $this$forEach$iv = segments;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            TerminalLine it = (TerminalLine)element$iv;
                            boolean bl2 = false;
                            line.addChars(it.chars());
                        }
                    }
                    list.add(line);
                } else {
                    int pages = count % cols == 0 ? count / cols : count / cols + 1;
                    List chars = new ArrayList();
                    for (TerminalLine segment : segments) {
                        chars.addAll((Collection)segment.chars().subList(0, segment.actualCount()));
                    }
                    for (int i = 0; i < pages; ++i) {
                        TerminalLine terminalLine;
                        TerminalLine $this$addLines_u24lambda_u242 = terminalLine = new TerminalLine(chars.subList(i * cols, Math.min(i * cols + cols, chars.size())));
                        boolean bl = false;
                        $this$addLines_u24lambda_u242.setWrapped(true);
                        TerminalLine line = terminalLine;
                        list.add(line);
                    }
                    ((TerminalLine)CollectionsKt.last((List)list)).setWrapped(false);
                }
                count = 0;
                segments.clear();
            }
            return list;
        }

        @NotNull
        public final List<TerminalLine> sublist(int offset, int count) {
            List<TerminalLine> list = this.myLines.subList(offset, offset + count);
            Intrinsics.checkNotNullExpressionValue(list, (String)"subList(...)");
            return list;
        }

        public final void resize() {
            TerminalLineBuffer.this.resizing = true;
            this.resizeCols();
            this.resizeRows();
            TerminalLineBuffer.this.resizing = false;
        }

        private final void resizeCols() {
            Ref.IntRef lineStartIndex = new Ref.IntRef();
            lineStartIndex.element = -1;
            int screenSize = this.oldScreenSize;
            int totalCount = TerminalLineBuffer.this.buffer.size() + screenSize;
            if (totalCount < 1) {
                return;
            }
            this.addLines(new Iterator<TerminalLine>(totalCount, TerminalLineBuffer.this, lineStartIndex, this){
                private int index;
                final /* synthetic */ int $totalCount;
                final /* synthetic */ TerminalLineBuffer this$0;
                final /* synthetic */ Ref.IntRef $lineStartIndex;
                final /* synthetic */ Resizer this$1;
                {
                    this.$totalCount = $totalCount;
                    this.this$0 = $receiver;
                    this.$lineStartIndex = $lineStartIndex;
                    this.this$1 = $receiver2;
                }

                public boolean hasNext() {
                    return this.index < this.$totalCount;
                }

                public TerminalLine next() {
                    TerminalLine terminalLine = this.index < TerminalLineBuffer.access$getBuffer$p(this.this$0).size() ? (TerminalLine)TerminalLineBuffer.access$getBuffer$p(this.this$0).get(this.index) : (TerminalLine)TerminalLineBuffer.access$getScreen$p(this.this$0).get(this.index - TerminalLineBuffer.access$getBuffer$p(this.this$0).size());
                    Intrinsics.checkNotNull((Object)terminalLine);
                    TerminalLine line = terminalLine;
                    if (this.$lineStartIndex.element == -1 && this.index >= TerminalLineBuffer.access$getBuffer$p(this.this$0).size()) {
                        this.$lineStartIndex.element = this.this$1.getCount();
                    }
                    int n = this.index;
                    this.index = n + 1;
                    return line;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            });
            TerminalLineBuffer.this.buffer.clear();
            List<TerminalLine> resizeLines = this.sublist(lineStartIndex.element, this.getCount() - lineStartIndex.element);
            if (resizeLines.size() > screenSize) {
                if (resizeLines.size() > this.newSize.getRows()) {
                    int count = resizeLines.size() - screenSize;
                    TerminalLineBuffer.this.buffer.addAll((Collection<? extends TerminalLine>)this.sublist(0, lineStartIndex.element));
                    TerminalLineBuffer.this.buffer.addAll((Collection<? extends TerminalLine>)resizeLines.subList(0, count));
                    TerminalLineBuffer.this.screen.clear();
                    v0 = TerminalLineBuffer.this.screen.addAll((Collection)resizeLines.subList(count, resizeLines.size()));
                } else {
                    TerminalLineBuffer.this.screen.clear();
                    v0 = TerminalLineBuffer.this.screen.addAll((Collection)resizeLines);
                }
            } else if (resizeLines.size() == screenSize) {
                TerminalLineBuffer.this.buffer.addAll((Collection<? extends TerminalLine>)this.sublist(0, lineStartIndex.element));
                TerminalLineBuffer.this.screen.clear();
                v0 = TerminalLineBuffer.this.screen.addAll((Collection)resizeLines);
            } else {
                int count = Math.abs(screenSize - resizeLines.size());
                if (lineStartIndex.element - count > 0) {
                    TerminalLineBuffer.this.buffer.addAll((Collection<? extends TerminalLine>)this.sublist(0, lineStartIndex.element - count));
                }
                TerminalLineBuffer.this.screen.clear();
                if (lineStartIndex.element > 0) {
                    TerminalLineBuffer.this.screen.addAll((Collection)this.sublist(Math.max(lineStartIndex.element - count, 0), count));
                }
                v0 = TerminalLineBuffer.this.screen.addAll((Collection)resizeLines);
            }
        }

        private final void resizeRows() {
            if (this.myLines.isEmpty()) {
                return;
            }
            int screenSize = TerminalLineBuffer.this.getScreenSizeIgnoreNullLine();
            if (screenSize > this.oldScreenSize) {
                TerminalLineBuffer.this.getCursorModel().move(CursorMove.Down, screenSize - this.oldScreenSize);
            } else if (screenSize < this.oldScreenSize) {
                TerminalLineBuffer.this.getCursorModel().move(CursorMove.Up, this.oldScreenSize - screenSize);
            }
            if (this.newSize.getRows() == this.oldSize.getRows()) {
                return;
            }
            if (this.newSize.getRows() < this.oldSize.getRows()) {
                if (screenSize < this.newSize.getRows()) {
                    return;
                }
                int count = screenSize - this.newSize.getRows();
                for (int i = 0; i < count; ++i) {
                    StrangeArrayList strangeArrayList = TerminalLineBuffer.this.buffer;
                    Object e = TerminalLineBuffer.this.screen.removeFirst();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"removeFirst(...)");
                    strangeArrayList.add((TerminalLine)e);
                }
                TerminalLineBuffer.this.getCursorModel().move(CursorMove.Up, count);
            } else {
                int count = Math.min(this.newSize.getRows() - screenSize, TerminalLineBuffer.this.buffer.size());
                if (count > 0) {
                    for (int i = 0; i < count; ++i) {
                        TerminalLineBuffer.this.screen.addFirst(TerminalLineBuffer.this.buffer.removeLast());
                    }
                    TerminalLineBuffer.this.getCursorModel().move(CursorMove.Down, count);
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J$\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014H\u0082\b\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lapp/termora/terminal/TerminalLineBuffer$StrangeArrayList;", "Ljava/util/ArrayList;", "Lapp/termora/terminal/TerminalLine;", "Lkotlin/collections/ArrayList;", "<init>", "(Lapp/termora/terminal/TerminalLineBuffer;)V", "addAll", "", "elements", "", "add", "element", "addFirst", "", "addLast", "index", "", "canIUse", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "termora"})
    @SourceDebugExtension(value={"SMAP\nTerminalLineBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalLineBuffer.kt\napp/termora/terminal/TerminalLineBuffer$StrangeArrayList\n*L\n1#1,774:1\n59#1,10:775\n59#1,10:785\n59#1,10:795\n59#1,10:805\n59#1,10:815\n59#1,10:825\n*S KotlinDebug\n*F\n+ 1 TerminalLineBuffer.kt\napp/termora/terminal/TerminalLineBuffer$StrangeArrayList\n*L\n35#1:775,10\n39#1:785,10\n43#1:795,10\n47#1:805,10\n51#1:815,10\n55#1:825,10\n*E\n"})
    private final class StrangeArrayList
    extends ArrayList<TerminalLine> {
        @Override
        public boolean addAll(@NotNull Collection<? extends TerminalLine> elements) {
            Boolean bl;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            StrangeArrayList this_$iv = this;
            boolean $i$f$canIUse = false;
            if (this_$iv.TerminalLineBuffer.this.isAlternateScreenBuffer()) {
                bl = null;
            } else {
                boolean bl2 = false;
                Boolean bl3 = super.addAll(elements);
                TerminalLineBuffer terminalLineBuffer = this_$iv.TerminalLineBuffer.this;
                Boolean $this$canIUse_u24lambda_u246$iv = bl3;
                boolean bl4 = false;
                if (!terminalLineBuffer.resizing) {
                    while (this_$iv.size() > terminalLineBuffer.getTerminalModel().getMaxRows()) {
                        this_$iv.removeFirst();
                        terminalLineBuffer.terminal.getTerminalModel().setData(DocumentImpl.Companion.getOverflowLines(), 1);
                    }
                }
                bl = bl3;
            }
            return bl != null ? bl : false;
        }

        @Override
        public boolean add(@NotNull TerminalLine element) {
            Boolean bl;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            StrangeArrayList this_$iv = this;
            boolean $i$f$canIUse = false;
            if (this_$iv.TerminalLineBuffer.this.isAlternateScreenBuffer()) {
                bl = null;
            } else {
                boolean bl2 = false;
                Boolean bl3 = super.add(element);
                TerminalLineBuffer terminalLineBuffer = this_$iv.TerminalLineBuffer.this;
                Boolean $this$canIUse_u24lambda_u246$iv = bl3;
                boolean bl4 = false;
                if (!terminalLineBuffer.resizing) {
                    while (this_$iv.size() > terminalLineBuffer.getTerminalModel().getMaxRows()) {
                        this_$iv.removeFirst();
                        terminalLineBuffer.terminal.getTerminalModel().setData(DocumentImpl.Companion.getOverflowLines(), 1);
                    }
                }
                bl = bl3;
            }
            return bl != null ? bl : false;
        }

        @Override
        public void addFirst(@NotNull TerminalLine element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            StrangeArrayList this_$iv = this;
            boolean $i$f$canIUse = false;
            if (!this_$iv.TerminalLineBuffer.this.isAlternateScreenBuffer()) {
                boolean bl = false;
                super.addFirst(element);
                Unit unit = Unit.INSTANCE;
                TerminalLineBuffer terminalLineBuffer = this_$iv.TerminalLineBuffer.this;
                Unit $this$canIUse_u24lambda_u246$iv = unit;
                boolean bl2 = false;
                if (!terminalLineBuffer.resizing) {
                    while (this_$iv.size() > terminalLineBuffer.getTerminalModel().getMaxRows()) {
                        this_$iv.removeFirst();
                        terminalLineBuffer.terminal.getTerminalModel().setData(DocumentImpl.Companion.getOverflowLines(), 1);
                    }
                }
            }
        }

        @Override
        public void addLast(@NotNull TerminalLine element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            StrangeArrayList this_$iv = this;
            boolean $i$f$canIUse = false;
            if (!this_$iv.TerminalLineBuffer.this.isAlternateScreenBuffer()) {
                boolean bl = false;
                super.addLast(element);
                Unit unit = Unit.INSTANCE;
                TerminalLineBuffer terminalLineBuffer = this_$iv.TerminalLineBuffer.this;
                Unit $this$canIUse_u24lambda_u246$iv = unit;
                boolean bl2 = false;
                if (!terminalLineBuffer.resizing) {
                    while (this_$iv.size() > terminalLineBuffer.getTerminalModel().getMaxRows()) {
                        this_$iv.removeFirst();
                        terminalLineBuffer.terminal.getTerminalModel().setData(DocumentImpl.Companion.getOverflowLines(), 1);
                    }
                }
            }
        }

        @Override
        public void add(int index, @NotNull TerminalLine element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            StrangeArrayList this_$iv = this;
            boolean $i$f$canIUse = false;
            if (!this_$iv.TerminalLineBuffer.this.isAlternateScreenBuffer()) {
                boolean bl = false;
                super.add(index, element);
                Unit unit = Unit.INSTANCE;
                TerminalLineBuffer terminalLineBuffer = this_$iv.TerminalLineBuffer.this;
                Unit $this$canIUse_u24lambda_u246$iv = unit;
                boolean bl2 = false;
                if (!terminalLineBuffer.resizing) {
                    while (this_$iv.size() > terminalLineBuffer.getTerminalModel().getMaxRows()) {
                        this_$iv.removeFirst();
                        terminalLineBuffer.terminal.getTerminalModel().setData(DocumentImpl.Companion.getOverflowLines(), 1);
                    }
                }
            }
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends TerminalLine> elements) {
            Boolean bl;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            StrangeArrayList this_$iv = this;
            boolean $i$f$canIUse = false;
            if (this_$iv.TerminalLineBuffer.this.isAlternateScreenBuffer()) {
                bl = null;
            } else {
                boolean bl2 = false;
                Boolean bl3 = super.addAll(index, elements);
                TerminalLineBuffer terminalLineBuffer = this_$iv.TerminalLineBuffer.this;
                Boolean $this$canIUse_u24lambda_u246$iv = bl3;
                boolean bl4 = false;
                if (!terminalLineBuffer.resizing) {
                    while (this_$iv.size() > terminalLineBuffer.getTerminalModel().getMaxRows()) {
                        this_$iv.removeFirst();
                        terminalLineBuffer.terminal.getTerminalModel().setData(DocumentImpl.Companion.getOverflowLines(), 1);
                    }
                }
                bl = bl3;
            }
            return bl != null ? bl : false;
        }

        private final <R> R canIUse(Function0<? extends R> block) {
            boolean $i$f$canIUse = false;
            if (TerminalLineBuffer.this.isAlternateScreenBuffer()) {
                return null;
            }
            Object object = block.invoke();
            TerminalLineBuffer terminalLineBuffer = TerminalLineBuffer.this;
            Object $this$canIUse_u24lambda_u246 = object;
            boolean bl = false;
            if (!terminalLineBuffer.resizing) {
                while (this.size() > terminalLineBuffer.getTerminalModel().getMaxRows()) {
                    this.removeFirst();
                    terminalLineBuffer.terminal.getTerminalModel().setData(DocumentImpl.Companion.getOverflowLines(), 1);
                }
            }
            return (R)object;
        }
    }
}

