/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.CharBuffer;
import app.termora.terminal.KTermKt;
import app.termora.terminal.TCharArrayList;
import app.termora.terminal.TTextStyleArrayList;
import app.termora.terminal.TextStyle;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PrimitiveIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CharCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B#\b\u0016\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005\u00a2\u0006\u0004\b\u0002\u0010\tJ\u001a\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006J \u0010\u0016\u001a\u00020\u00142\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005J\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005J\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\b0\u00060\u0005H\u0002J\u001e\u0010!\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001b0#0\"J*\u0010$\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006J%\u0010&\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\b\u00a2\u0006\u0004\b(\u0010)J*\u0010&\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006J\u001e\u0010*\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010,\u001a\u00020\u001bJ\b\u0010-\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006."}, d2={"Lapp/termora/terminal/TerminalLine;", "", "<init>", "()V", "chars", "", "Lkotlin/Pair;", "", "Lapp/termora/terminal/TextStyle;", "(Ljava/util/List;)V", "Lapp/termora/terminal/TCharArrayList;", "styles", "Lapp/termora/terminal/TTextStyleArrayList;", "wrapped", "", "getWrapped", "()Z", "setWrapped", "(Z)V", "addChar", "", "char", "addChars", "getText", "", "write", "offset", "", "buffer", "Lapp/termora/terminal/CharBuffer;", "modifyChars", "count", "segments", "characters", "", "Lkotlin/Triple;", "deleteChars", "c", "eraseChars", "attr", "eraseChars-PM23JaI", "(IIJ)V", "insertChars", "cols", "actualCount", "toString", "termora"})
@SourceDebugExtension(value={"SMAP\nTerminalLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalLine.kt\napp/termora/terminal/TerminalLine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,263:1\n1563#2:264\n1634#2,3:265\n413#3,4:268\n*S KotlinDebug\n*F\n+ 1 TerminalLine.kt\napp/termora/terminal/TerminalLine\n*L\n120#1:264\n120#1:265,3\n131#1:268,4\n*E\n"})
public final class TerminalLine {
    @NotNull
    private final TCharArrayList chars;
    @NotNull
    private final TTextStyleArrayList styles;
    private boolean wrapped;

    public final boolean getWrapped() {
        return this.wrapped;
    }

    public final void setWrapped(boolean bl) {
        this.wrapped = bl;
    }

    public TerminalLine() {
        this.chars = new TCharArrayList();
        this.styles = new TTextStyleArrayList();
    }

    public TerminalLine(@NotNull List<Pair<Character, TextStyle>> chars) {
        Intrinsics.checkNotNullParameter(chars, (String)"chars");
        this.chars = new TCharArrayList();
        this.styles = new TTextStyleArrayList();
        this.addChars(chars);
    }

    public final void addChar(@NotNull Pair<Character, TextStyle> pair) {
        Intrinsics.checkNotNullParameter(pair, (String)"char");
        this.chars.add(((Character)pair.getFirst()).charValue());
        this.styles.add-oMHEAL4(((TextStyle)pair.getSecond()).unbox-impl());
    }

    public final void addChars(@NotNull List<Pair<Character, TextStyle>> chars) {
        Intrinsics.checkNotNullParameter(chars, (String)"chars");
        for (Pair<Character, TextStyle> e : chars) {
            this.chars.add(((Character)e.getFirst()).charValue());
            this.styles.add-oMHEAL4(((TextStyle)e.getSecond()).unbox-impl());
        }
    }

    @NotNull
    public final List<Pair<Character, TextStyle>> chars() {
        List list = new ArrayList();
        int n = this.chars.size();
        for (int i = 0; i < n; ++i) {
            list.add(new Pair((Object)Character.valueOf(this.chars.get(i)), (Object)TextStyle.box-impl(this.styles.getTextStyle-RZbRhfg(i))));
        }
        return list;
    }

    @NotNull
    public final String getText() {
        StringBuilder sb = new StringBuilder();
        if (this.chars.isEmpty() || KTermKt.isNull(this.chars.get(0))) {
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        block0: for (int i = this.chars.size() - 1; -1 < i; --i) {
            if (KTermKt.isNull(this.chars.get(i))) continue;
            int j = 0;
            if (j > i) break;
            while (true) {
                char ch;
                if (KTermKt.isNull(ch = this.chars.get(j))) {
                    v1 = sb.append(KTermKt.getSpace(CharCompanionObject.INSTANCE));
                } else if (!KTermKt.isSoftHyphen(ch)) {
                    v1 = sb.append(ch);
                }
                if (j == i) break block0;
                ++j;
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void write(int offset, @NotNull CharBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.modifyChars(offset, buffer.getSize(), buffer);
    }

    private final void modifyChars(int offset, int count, CharBuffer buffer) {
        int i;
        for (i = 0; i < offset && this.chars.size() > i; ++i) {
            if (!KTermKt.isNull(this.chars.get(i))) continue;
            this.chars.set(i, KTermKt.getSpace(CharCompanionObject.INSTANCE));
        }
        for (i = 0; i < count; ++i) {
            int index = offset + i;
            if (index >= this.chars.size()) {
                this.chars.add(buffer.getChars()[i]);
                this.styles.add-oMHEAL4(buffer.getStyle-c2YIwqY());
                continue;
            }
            this.chars.set(index, buffer.getChars()[i]);
            this.styles.set-QwXzuJw(index, buffer.getStyle-c2YIwqY());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, TextStyle>> segments() {
        void $this$mapTo$iv$iv;
        Iterable e;
        List list = new ArrayList();
        int n = this.chars.size();
        for (int i = 0; i < n; ++i) {
            e = new Pair((Object)Character.valueOf(this.chars.get(i)), (Object)TextStyle.box-impl(this.styles.getTextStyle-RZbRhfg(i)));
            if (list.isEmpty()) {
                list.add(new Pair((Object)new StringBuilder(), e.getSecond()));
            }
            if (!TextStyle.equals-impl0(((TextStyle)e.getSecond()).unbox-impl(), ((TextStyle)((Pair)CollectionsKt.last((List)list)).getSecond()).unbox-impl())) {
                list.add(new Pair((Object)new StringBuilder(), e.getSecond()));
            }
            ((StringBuilder)((Pair)CollectionsKt.last((List)list)).getFirst()).append(KTermKt.isNull(((Character)e.getFirst()).charValue()) ? KTermKt.getSpace(CharCompanionObject.INSTANCE) : ((Character)e.getFirst()).charValue());
        }
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        e = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)((StringBuilder)it.getFirst()).toString(), it.getSecond()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Triple<String, TextStyle, Integer>> characters() {
        List characters = new ArrayList();
        BreakIterator breakIterator = BreakIterator.getCharacterInstance();
        for (Pair<String, TextStyle> e : this.segments()) {
            breakIterator.setText((String)e.getFirst());
            int start2 = breakIterator.first();
            int end = breakIterator.next();
            while (end != -1) {
                String grapheme;
                block5: {
                    String string;
                    void $this$dropWhile$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)((String)e.getFirst()).substring(start2, end), (String)"substring(...)");
                    boolean $i$f$dropWhile = false;
                    int n = ((CharSequence)$this$dropWhile$iv).length();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        char it = $this$dropWhile$iv.charAt(index$iv);
                        boolean bl = false;
                        if (it == KTermKt.getSoftHyphen(CharCompanionObject.INSTANCE)) continue;
                        String string2 = $this$dropWhile$iv.substring(index$iv);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        break block5;
                    }
                    string = grapheme = "";
                }
                if (((CharSequence)grapheme).length() > 0) {
                    int width = 0;
                    PrimitiveIterator.OfInt ofInt = grapheme.chars().iterator();
                    while (ofInt.hasNext()) {
                        Integer n = ofInt.next();
                        Intrinsics.checkNotNull((Object)n);
                        width += Math.max(1, KTermKt.mk_wcwidth(n));
                    }
                    characters.add(new Triple((Object)grapheme, e.getSecond(), (Object)width));
                }
                start2 = end;
                end = breakIterator.next();
            }
        }
        return characters;
    }

    public final void deleteChars(int offset, int count, @NotNull Pair<Character, TextStyle> c2) {
        Intrinsics.checkNotNullParameter(c2, (String)"c");
        for (int i = 0; i < count; ++i) {
            this.chars.remove(offset);
            this.styles.remove(offset);
            this.chars.add(((Character)c2.getFirst()).charValue());
            this.styles.add-oMHEAL4(((TextStyle)c2.getSecond()).unbox-impl());
        }
    }

    public final void eraseChars-PM23JaI(int offset, int count, long attr) {
        this.eraseChars(offset, count, (Pair<Character, TextStyle>)new Pair((Object)Character.valueOf(count >= this.actualCount() ? KTermKt.getNull(CharCompanionObject.INSTANCE) : KTermKt.getSpace(CharCompanionObject.INSTANCE)), (Object)TextStyle.box-impl(attr)));
    }

    public final void eraseChars(int offset, int count, @NotNull Pair<Character, TextStyle> c2) {
        Intrinsics.checkNotNullParameter(c2, (String)"c");
        for (int i = 0; i < count && offset + i < this.chars.size(); ++i) {
            this.chars.set(offset + i, ((Character)c2.getFirst()).charValue());
            this.styles.set-QwXzuJw(offset + i, ((TextStyle)c2.getSecond()).unbox-impl());
        }
    }

    public final void insertChars(int offset, int cols, @NotNull CharBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int n = buffer.getSize();
        for (int i = 0; i < n; ++i) {
            this.chars.insert(i + offset, buffer.getChars()[i]);
            this.styles.insert-QwXzuJw(i + offset, buffer.getStyle-c2YIwqY());
            if (this.chars.size() <= cols) continue;
            this.chars.remove(this.chars.size() - 1);
            this.styles.remove(this.styles.size() - 1);
        }
    }

    public final int actualCount() {
        for (int i = this.chars.size() - 1; -1 < i; --i) {
            if (KTermKt.isNull(this.chars.get(i))) continue;
            return i + 1;
        }
        return 0;
    }

    @NotNull
    public String toString() {
        return this.getText();
    }
}

