/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.DataKey;
import app.termora.terminal.DataListener;
import app.termora.terminal.Tabulator;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalModel;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lapp/termora/terminal/TabulatorImpl;", "Lapp/termora/terminal/Tabulator;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/Terminal;)V", "tabStops", "Ljava/util/TreeSet;", "", "getTabStops$termora", "()Ljava/util/TreeSet;", "cols", "getCols", "()I", "clearTabStop", "", "x", "clearAllTabStops", "nextTab", "previousTab", "setTabStop", "getTerminal", "termora"})
public class TabulatorImpl
implements Tabulator {
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final TreeSet<Integer> tabStops;

    public TabulatorImpl(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminal = terminal;
        this.tabStops = SetsKt.sortedSetOf((Object[])new Integer[0]);
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)8, (int)this.getCols())), (int)8);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                this.tabStops.add(i);
                if (i == n) break;
                i += n2;
            }
        }
        this.terminal.getTerminalModel().addDataListener(new DataListener(){

            @Override
            public void onChanged(DataKey<?> key, Object data) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (Intrinsics.areEqual(key, TerminalModel.Companion.getResize())) {
                    this.clearAllTabStops();
                    IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)8, (int)this.getCols())), (int)8);
                    int i = intProgression.getFirst();
                    int n = intProgression.getLast();
                    int n2 = intProgression.getStep();
                    if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
                        while (true) {
                            this.getTabStops$termora().add(i);
                            if (i == n) break;
                            i += n2;
                        }
                    }
                }
            }
        });
    }

    @NotNull
    public final TreeSet<Integer> getTabStops$termora() {
        return this.tabStops;
    }

    private final int getCols() {
        return this.terminal.getTerminalModel().getCols();
    }

    @Override
    public void clearTabStop(int x) {
        this.tabStops.remove(x);
    }

    @Override
    public void clearAllTabStops() {
        this.tabStops.clear();
    }

    @Override
    public int nextTab(int x) {
        int tabStop = Integer.MAX_VALUE;
        SortedSet<Integer> tailSet = this.tabStops.tailSet(x + 1);
        Intrinsics.checkNotNull(tailSet);
        if (!((Collection)tailSet).isEmpty()) {
            Integer n = tailSet.first();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"first(...)");
            tabStop = ((Number)n).intValue();
        }
        return Math.min(tabStop, this.getCols());
    }

    @Override
    public int previousTab(int x) {
        SortedSet<Integer> headSet = this.tabStops.headSet(x);
        int tabStop = 1;
        if (!headSet.isEmpty()) {
            Integer n = headSet.last();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"last(...)");
            tabStop = ((Number)n).intValue();
        }
        return Math.max(1, tabStop);
    }

    @Override
    public void setTabStop(int x) {
        this.tabStops.add(x);
    }

    @Override
    @NotNull
    public Terminal getTerminal() {
        return this.terminal;
    }
}

