/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.AbstractProcessor;
import app.termora.terminal.ColorPalette;
import app.termora.terminal.DataKey;
import app.termora.terminal.ProcessorState;
import app.termora.terminal.SystemCommandSequence;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalColor;
import app.termora.terminal.TerminalModel;
import app.termora.terminal.TerminalReader;
import app.termora.terminal.TerminalState;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.StringReader;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lapp/termora/terminal/OperatingSystemCommandProcessor;", "Lapp/termora/terminal/AbstractProcessor;", "terminal", "Lapp/termora/terminal/Terminal;", "reader", "Lapp/termora/terminal/TerminalReader;", "<init>", "(Lapp/termora/terminal/Terminal;Lapp/termora/terminal/TerminalReader;)V", "systemCommandSequence", "Lapp/termora/terminal/SystemCommandSequence;", "colorPalette", "Lapp/termora/terminal/ColorPalette;", "getColorPalette", "()Lapp/termora/terminal/ColorPalette;", "process", "Lapp/termora/terminal/ProcessorState;", "ch", "", "processOperatingSystemCommandProcessor", "", "replyColor", "mode", "", "terminalColor", "Lapp/termora/terminal/TerminalColor;", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nOperatingSystemCommandProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperatingSystemCommandProcessor.kt\napp/termora/terminal/OperatingSystemCommandProcessor\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,152:1\n158#2,6:153\n*S KotlinDebug\n*F\n+ 1 OperatingSystemCommandProcessor.kt\napp/termora/terminal/OperatingSystemCommandProcessor\n*L\n51#1:153,6\n*E\n"})
public final class OperatingSystemCommandProcessor
extends AbstractProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SystemCommandSequence systemCommandSequence;
    private static final Logger log = LoggerFactory.getLogger(OperatingSystemCommandProcessor.class);

    public OperatingSystemCommandProcessor(@NotNull Terminal terminal, @NotNull TerminalReader reader) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        super(terminal, reader);
        this.systemCommandSequence = new SystemCommandSequence();
    }

    private final ColorPalette getColorPalette() {
        return this.getTerminal().getTerminalModel().getColorPalette();
    }

    @Override
    @NotNull
    public ProcessorState process(char ch) {
        this.getReader().addFirst(ch);
        while (!this.systemCommandSequence.process(this.getReader().read())) {
            if (this.getReader().isEmpty()) {
                return TerminalState.OSC;
            }
            if (this.getReader().isNotEmpty()) continue;
        }
        this.processOperatingSystemCommandProcessor();
        this.systemCommandSequence.reset();
        return TerminalState.READY;
    }

    private final void processOperatingSystemCommandProcessor() {
        int idx;
        String args;
        block12: {
            int n;
            args = this.systemCommandSequence.getCommand();
            CharSequence $this$indexOfFirst$iv = args;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it == ';')) continue;
                n = index$iv;
                break block12;
            }
            n = idx = -1;
        }
        if (idx == -1) {
            return;
        }
        String string = args.substring(0, idx);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String prefix = string;
        String string2 = args.substring(prefix.length() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String suffix = string2;
        Integer n = StringsKt.toIntOrNull((String)prefix);
        int mode = n != null ? n : -1;
        switch (mode) {
            case 0: 
            case 2: {
                this.getTerminal().getTerminalModel().setData(DataKey.Companion.getWindowTitle(), suffix);
                if (!log.isDebugEnabled()) break;
                log.debug("Window Title: " + suffix);
                break;
            }
            case 1: {
                this.getTerminal().getTerminalModel().setData(DataKey.Companion.getIconTitle(), suffix);
                if (!log.isDebugEnabled()) break;
                log.debug("Icon Title: " + suffix);
                break;
            }
            case 7: {
                this.getTerminal().getTerminalModel().setData(DataKey.Companion.getWorkdir(), suffix);
                if (!log.isDebugEnabled()) break;
                log.debug("Workdir: " + suffix);
                break;
            }
            case 8: {
                if (!log.isDebugEnabled()) break;
                log.debug("Ignore hyperlink OSC: 8");
                break;
            }
            case 1337: {
                Properties properties = new Properties();
                properties.load(new StringReader(suffix));
                if (!properties.containsKey("CurrentDir")) break;
                String currentDir = properties.getProperty("CurrentDir");
                TerminalModel terminalModel = this.getTerminal().getTerminalModel();
                DataKey<String> dataKey = DataKey.Companion.getCurrentDir();
                Intrinsics.checkNotNull((Object)currentDir);
                terminalModel.setData(dataKey, currentDir);
                if (!log.isDebugEnabled()) break;
                log.debug("CurrentDir: " + currentDir);
                break;
            }
            case 10: 
            case 11: {
                TerminalColor terminalColor = mode == 10 ? TerminalColor.Normal.INSTANCE.getWHITE() : TerminalColor.Normal.INSTANCE.getBLACK();
                this.replyColor(mode, terminalColor);
                break;
            }
            case 52: {
                String[] currentDir = new String[]{";"};
                List it = StringsKt.split$default((CharSequence)suffix, (String[])currentDir, (boolean)false, (int)2, (int)2, null);
                boolean bl = false;
                Pair pair = new Pair(CollectionsKt.first((List)it), CollectionsKt.last((List)it));
                if (Intrinsics.areEqual((Object)pair.getFirst(), (Object)"c")) {
                    byte[] byArray = Base64.decodeBase64((String)((String)pair.getSecond()));
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decodeBase64(...)");
                    byte[] byArray2 = byArray;
                    String text = new String(byArray2, Charsets.UTF_8);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
                    if (!log.isDebugEnabled()) break;
                    log.debug("Copy {} to clipboard", (Object)text);
                    break;
                }
                if (!log.isWarnEnabled()) break;
                log.warn("Manipulate Selection Data. Unknown: {}", (Object)pair);
                break;
            }
            default: {
                if (!log.isWarnEnabled()) break;
                log.warn("Unknown OSC: " + prefix);
            }
        }
    }

    private final void replyColor(int mode, TerminalColor terminalColor) {
        int color = this.getColorPalette().getColor(terminalColor);
        String string = HexExtensionsKt.toHexString$default((int)((color >> 16 & 0xFF) * 257), null, (int)1, null).substring(4);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String red = string;
        String string2 = HexExtensionsKt.toHexString$default((int)((color >> 8 & 0xFF) * 257), null, (int)1, null).substring(4);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String green = string2;
        String string3 = HexExtensionsKt.toHexString$default((int)((color & 0xFF) * 257), null, (int)1, null).substring(4);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String blue = string3;
        String buffer = "\u001b]" + mode + ";rgb:" + red + "/" + green + "/" + blue + "\u0007";
        if (log.isDebugEnabled()) {
            log.debug("OSC reply color: " + buffer);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/terminal/OperatingSystemCommandProcessor$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

