/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.DataKey;
import app.termora.terminal.DataListener;
import app.termora.terminal.DocumentImpl;
import app.termora.terminal.Highlighter;
import app.termora.terminal.HighlighterRange;
import app.termora.terminal.MarkupModel;
import app.termora.terminal.Position;
import app.termora.terminal.SelectionModelImpl;
import app.termora.terminal.Terminal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lapp/termora/terminal/MarkupModelImpl;", "Lapp/termora/terminal/MarkupModel;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/Terminal;)V", "highlighters", "", "", "", "Lapp/termora/terminal/Highlighter;", "addHighlighter", "", "highlighter", "removeHighlighter", "removeAllHighlighters", "tag", "removeAllHighlightersInLine", "row", "getHighlighters", "", "position", "Lapp/termora/terminal/Position;", "getTerminal", "termora"})
@SourceDebugExtension(value={"SMAP\nMarkupModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkupModelImpl.kt\napp/termora/terminal/MarkupModelImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n384#2,7:87\n384#2,7:94\n774#3:101\n865#3,2:102\n*S KotlinDebug\n*F\n+ 1 MarkupModelImpl.kt\napp/termora/terminal/MarkupModelImpl\n*L\n23#1:87,7\n26#1:94,7\n67#1:101\n67#1:102,2\n*E\n"})
public class MarkupModelImpl
implements MarkupModel {
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final Map<Integer, List<Highlighter>> highlighters;

    public MarkupModelImpl(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminal = terminal;
        this.highlighters = new LinkedHashMap();
        this.terminal.getTerminalModel().addDataListener(new DataListener(){

            @Override
            public void onChanged(DataKey<?> key, Object data) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (!Intrinsics.areEqual(key, DocumentImpl.Companion.getOverflowLines())) {
                    return;
                }
                if (highlighters.isEmpty()) {
                    return;
                }
                int row = (Integer)data;
                for (int i = 0; i < row; ++i) {
                    terminal.getMarkupModel().removeAllHighlightersInLine(0);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addHighlighter(@NotNull Highlighter highlighter) {
        int n;
        int i;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        HighlighterRange range = highlighter.getHighlighterRange();
        Map<Integer, List<Highlighter>> map = this.highlighters;
        Integer key$iv = range.getStart().getY();
        boolean $i$f$getOrPut2 = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).addLast(highlighter);
        if (range.getStart().getY() != range.getEnd().getY() && (i = range.getStart().getY() + 1) <= (n = range.getEnd().getY())) {
            while (true) {
                Object object2;
                void $this$getOrPut$iv2;
                Map<Integer, List<Highlighter>> $i$f$getOrPut2 = this.highlighters;
                Integer key$iv2 = i;
                boolean $i$f$getOrPut3 = false;
                Object value$iv2 = $this$getOrPut$iv2.get(key$iv2);
                if (value$iv2 == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv2.put(key$iv2, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv2;
                }
                ((List)object2).addLast(highlighter);
                if (i == n) break;
                ++i;
            }
        }
    }

    @Override
    public void removeHighlighter(@NotNull Highlighter highlighter) {
        int n;
        int i;
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        HighlighterRange range = highlighter.getHighlighterRange();
        if (this.highlighters.containsKey(range.getStart().getY())) {
            ((List)MapsKt.getValue(this.highlighters, (Object)range.getStart().getY())).remove(highlighter);
        }
        if (range.getStart().getY() != range.getEnd().getY() && (i = range.getStart().getY() + 1) <= (n = range.getEnd().getY())) {
            while (true) {
                ((List)MapsKt.getValue(this.highlighters, (Object)i)).remove(highlighter);
                if (i == n) break;
                ++i;
            }
        }
    }

    @Override
    public void removeAllHighlighters(int tag) {
        if (tag == 0) {
            if (this.highlighters.isEmpty()) {
                return;
            }
            this.highlighters.clear();
        } else {
            Iterator<Map.Entry<Integer, List<Highlighter>>> iterator2 = this.highlighters.entrySet().iterator();
            while (iterator2.hasNext()) {
                List<Highlighter> e = iterator2.next().getValue();
                CollectionsKt.removeAll(e, arg_0 -> MarkupModelImpl.removeAllHighlighters$lambda$2(tag, arg_0));
                if (!e.isEmpty()) continue;
                iterator2.remove();
            }
        }
    }

    @Override
    public void removeAllHighlightersInLine(int row) {
        this.highlighters.remove(row);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Highlighter> getHighlighters(@NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (this.highlighters.containsKey(position.getY())) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)MapsKt.getValue(this.highlighters, (Object)position.getY());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Highlighter it = (Highlighter)element$iv$iv;
                boolean bl = false;
                if (!SelectionModelImpl.Companion.isPointInsideArea(it.getHighlighterRange().getStart(), it.getHighlighterRange().getEnd(), position.getX(), position.getY(), this.terminal.getTerminalModel().getCols())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Terminal getTerminal() {
        return this.terminal;
    }

    private static final boolean removeAllHighlighters$lambda$2(int $tag, Highlighter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTag() == $tag;
    }
}

