/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.DataKey;
import app.termora.terminal.DataListener;
import app.termora.terminal.KeyEncoder;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalKeyEvent;
import app.termora.terminal.TerminalModel;
import com.formdev.flatlaf.util.SystemInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00020\u0011\"\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J \u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0006\u0010\"\u001a\u00020\u0018J\u0006\u0010#\u001a\u00020\u0018J\u0006\u0010$\u001a\u00020\u0018J\u0006\u0010%\u001a\u00020\u0018J\u0006\u0010&\u001a\u00020\u0018J\u001c\u0010'\u001a\u00020\u00182\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030(2\u0006\u0010)\u001a\u00020*H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lapp/termora/terminal/KeyEncoderImpl;", "Lapp/termora/terminal/KeyEncoder;", "Lapp/termora/terminal/DataListener;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/Terminal;)V", "mapping", "", "Lapp/termora/terminal/TerminalKeyEvent;", "", "nothing", "encode", "event", "makeCode", "", "bytesAsInt", "", "", "alwaysSendEsc", "", "key", "getTerminal", "putCode", "", "getCodeWithModifiers", "bytes", "modifiers", "insertCodeAt", "code", "at", "modifiersToCode", "isCursorKey", "isFunctionKey", "arrowKeysApplicationSequences", "arrowKeysAnsiCursorSequences", "configureLeftRight", "keypadApplicationSequences", "keypadAnsiSequences", "onChanged", "Lapp/termora/terminal/DataKey;", "data", "", "termora"})
public class KeyEncoderImpl
implements KeyEncoder,
DataListener {
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final Map<TerminalKeyEvent, String> mapping;
    @NotNull
    private final String nothing;

    public KeyEncoderImpl(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminal = terminal;
        this.mapping = new LinkedHashMap();
        this.nothing = "";
        TerminalModel terminalModel = this.terminal.getTerminalModel();
        if (terminalModel.getData(DataKey.Companion.getApplicationCursorKeys(), false).booleanValue()) {
            this.arrowKeysApplicationSequences();
        } else {
            this.arrowKeysAnsiCursorSequences();
        }
        if (terminalModel.getData(DataKey.Companion.getAlternateKeypad(), false).booleanValue()) {
            this.keypadApplicationSequences();
        } else {
            this.keypadAnsiSequences();
        }
        this.configureLeftRight();
        byte[] byArray = new byte[]{127};
        this.putCode(new TerminalKeyEvent(8, 0, 2, null), new String(byArray, Charsets.UTF_8));
        if (terminalModel.getData(DataKey.Companion.getAutoNewline(), false).booleanValue()) {
            this.putCode(new TerminalKeyEvent(10, 0, 2, null), "\r\n");
        } else {
            this.putCode(new TerminalKeyEvent(10, 0, 2, null), "\r");
        }
        this.putCode(new TerminalKeyEvent(33, 0, 2, null), "\u001b[5~");
        this.putCode(new TerminalKeyEvent(34, 0, 2, null), "\u001b[6~");
        this.putCode(new TerminalKeyEvent(155, 0, 2, null), "\u001b[2~");
        this.putCode(new TerminalKeyEvent(127, 0, 2, null), "\u001b[3~");
        this.putCode(new TerminalKeyEvent(112, 0, 2, null), "\u001bOP");
        this.putCode(new TerminalKeyEvent(113, 0, 2, null), "\u001bOQ");
        this.putCode(new TerminalKeyEvent(114, 0, 2, null), "\u001bOR");
        this.putCode(new TerminalKeyEvent(115, 0, 2, null), "\u001bOS");
        this.putCode(new TerminalKeyEvent(116, 0, 2, null), "\u001b[15~");
        this.putCode(new TerminalKeyEvent(117, 0, 2, null), "\u001b[17~");
        this.putCode(new TerminalKeyEvent(118, 0, 2, null), "\u001b[18~");
        this.putCode(new TerminalKeyEvent(119, 0, 2, null), "\u001b[19~");
        this.putCode(new TerminalKeyEvent(120, 0, 2, null), "\u001b[20~");
        this.putCode(new TerminalKeyEvent(121, 0, 2, null), "\u001b[21~");
        this.putCode(new TerminalKeyEvent(122, 0, 2, null), "\u001b[23~");
        this.putCode(new TerminalKeyEvent(123, 0, 2, null), "\u001b[24~");
        this.terminal.getTerminalModel().addDataListener(new DataListener(){

            @Override
            public void onChanged(DataKey<?> key, Object data) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.onChanged(key, data);
            }
        });
    }

    @Override
    @NotNull
    public String encode(@NotNull TerminalKeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.mapping.containsKey(event)) {
            return (String)MapsKt.getValue(this.mapping, (Object)event);
        }
        String string = this.mapping.get(new TerminalKeyEvent(event.getKeyCode(), 0));
        if (string == null) {
            return this.nothing;
        }
        Object object = string;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        if (this.alwaysSendEsc(event.getKeyCode()) && (event.getModifiers() & 0x20) != 0) {
            object = new int[1];
            object[0] = 27;
            bytes = this.insertCodeAt(bytes, this.makeCode((int[])object), 0);
            return new String(bytes, Charsets.UTF_8);
        }
        if (this.alwaysSendEsc(event.getKeyCode()) && (event.getModifiers() & 8) != 0) {
            object = new int[1];
            object[0] = 27;
            bytes = this.insertCodeAt(bytes, this.makeCode((int[])object), 0);
            return new String(bytes, Charsets.UTF_8);
        }
        if (this.isCursorKey(event.getKeyCode()) || this.isFunctionKey(event.getKeyCode())) {
            bytes = this.getCodeWithModifiers(bytes, event.getModifiers());
            return new String(bytes, Charsets.UTF_8);
        }
        return new String(bytes, Charsets.UTF_8);
    }

    private final byte[] makeCode(int ... bytesAsInt) {
        byte[] bytes = new byte[bytesAsInt.length];
        int n = bytesAsInt.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            int byteAsInt = bytesAsInt[i];
            bytes[i2] = (byte)byteAsInt;
        }
        return bytes;
    }

    private final boolean alwaysSendEsc(int key) {
        return this.isCursorKey(key) || key == 8;
    }

    @Override
    @NotNull
    public Terminal getTerminal() {
        return this.terminal;
    }

    private final void putCode(TerminalKeyEvent event, String encode) {
        this.mapping.put(event, encode);
    }

    private final byte[] getCodeWithModifiers(byte[] bytes, int modifiers) {
        int code = this.modifiersToCode(modifiers);
        if (code > 0 && bytes.length > 2) {
            if (bytes[0] == 27 && bytes[1] == 79) {
                bytes[1] = 91;
            }
            String prefix = bytes.length == 3 ? "1;" : ";";
            String string = prefix + code;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return this.insertCodeAt(bytes, byArray, bytes.length - 1);
        }
        return bytes;
    }

    private final byte[] insertCodeAt(byte[] bytes, byte[] code, int at) {
        byte[] res = new byte[bytes.length + code.length];
        System.arraycopy(bytes, 0, res, 0, bytes.length);
        System.arraycopy(bytes, at, res, at + code.length, bytes.length - at);
        System.arraycopy(code, 0, res, at, code.length);
        return res;
    }

    private final int modifiersToCode(int modifiers) {
        int code = 0;
        if ((modifiers & 4) != 0) {
            code |= 1;
        }
        if ((modifiers & 0x20) != 0) {
            code |= 2;
        }
        if ((modifiers & 0x10) != 0) {
            code |= 4;
        }
        if ((modifiers & 8) != 0) {
            code |= 8;
        }
        return code != 0 ? code + 1 : 0;
    }

    private final boolean isCursorKey(int key) {
        return key == 40 || key == 38 || key == 37 || key == 39 || key == 36 || key == 35;
    }

    private final boolean isFunctionKey(int key) {
        return key >= 112 && key <= 123 || key == 155 || key == 127 || key == 33 || key == 34;
    }

    public final void arrowKeysApplicationSequences() {
        this.putCode(new TerminalKeyEvent(38, 0, 2, null), "\u001bOA");
        this.putCode(new TerminalKeyEvent(40, 0, 2, null), "\u001bOB");
        this.putCode(new TerminalKeyEvent(37, 0, 2, null), "\u001bOD");
        this.putCode(new TerminalKeyEvent(39, 0, 2, null), "\u001bOC");
    }

    public final void arrowKeysAnsiCursorSequences() {
        this.putCode(new TerminalKeyEvent(38, 0, 2, null), "\u001b[A");
        this.putCode(new TerminalKeyEvent(40, 0, 2, null), "\u001b[B");
        this.putCode(new TerminalKeyEvent(37, 0, 2, null), "\u001b[D");
        this.putCode(new TerminalKeyEvent(39, 0, 2, null), "\u001b[C");
    }

    public final void configureLeftRight() {
        if (SystemInfo.isMacOS) {
            this.putCode(new TerminalKeyEvent(37, 32), "\u001bb");
            this.putCode(new TerminalKeyEvent(39, 32), "\u001bf");
        } else {
            this.putCode(new TerminalKeyEvent(37, 16), "\u001b[1;5D");
            this.putCode(new TerminalKeyEvent(39, 16), "\u001b[1;5C");
            this.putCode(new TerminalKeyEvent(37, 32), "\u001b[1;3D");
            this.putCode(new TerminalKeyEvent(39, 32), "\u001b[1;3C");
        }
    }

    public final void keypadApplicationSequences() {
        this.putCode(new TerminalKeyEvent(224, 0, 2, null), "\u001bOA");
        this.putCode(new TerminalKeyEvent(225, 0, 2, null), "\u001bOB");
        this.putCode(new TerminalKeyEvent(226, 0, 2, null), "\u001bOD");
        this.putCode(new TerminalKeyEvent(227, 0, 2, null), "\u001bOC");
        this.putCode(new TerminalKeyEvent(36, 0, 2, null), "\u001bOH");
        this.putCode(new TerminalKeyEvent(35, 0, 2, null), "\u001bOF");
    }

    public final void keypadAnsiSequences() {
        this.putCode(new TerminalKeyEvent(224, 0, 2, null), "\u001b[A");
        this.putCode(new TerminalKeyEvent(225, 0, 2, null), "\u001b[B");
        this.putCode(new TerminalKeyEvent(226, 0, 2, null), "\u001b[D");
        this.putCode(new TerminalKeyEvent(227, 0, 2, null), "\u001b[C");
        this.putCode(new TerminalKeyEvent(36, 0, 2, null), "\u001b[H");
        this.putCode(new TerminalKeyEvent(35, 0, 2, null), "\u001b[F");
    }

    @Override
    public void onChanged(@NotNull DataKey<?> key, @NotNull Object data) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (Intrinsics.areEqual(key, DataKey.Companion.getApplicationCursorKeys())) {
            if (((Boolean)data).booleanValue()) {
                this.arrowKeysApplicationSequences();
            } else {
                this.arrowKeysAnsiCursorSequences();
            }
        } else if (Intrinsics.areEqual(key, DataKey.Companion.getAlternateKeypad())) {
            if (((Boolean)data).booleanValue()) {
                this.keypadApplicationSequences();
            } else {
                this.keypadAnsiSequences();
            }
        } else if (Intrinsics.areEqual(key, DataKey.Companion.getAutoNewline())) {
            if (((Boolean)data).booleanValue()) {
                this.putCode(new TerminalKeyEvent(10, 0, 2, null), "\r\n");
            } else {
                this.putCode(new TerminalKeyEvent(10, 0, 2, null), "\r");
            }
        }
    }
}

