/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.Position;
import app.termora.terminal.SelectionModelImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0017"}, d2={"Lapp/termora/terminal/HighlighterRange;", "", "start", "Lapp/termora/terminal/Position;", "end", "<init>", "(Lapp/termora/terminal/Position;Lapp/termora/terminal/Position;)V", "getStart", "()Lapp/termora/terminal/Position;", "getEnd", "has", "", "pos", "cols", "", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "termora"})
public final class HighlighterRange {
    @NotNull
    private final Position start;
    @NotNull
    private final Position end;

    public HighlighterRange(@NotNull Position start2, @NotNull Position end) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.start = start2;
        this.end = end;
    }

    @NotNull
    public final Position getStart() {
        return this.start;
    }

    @NotNull
    public final Position getEnd() {
        return this.end;
    }

    public final boolean has(@NotNull Position pos, int cols) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return SelectionModelImpl.Companion.isPointInsideArea(this.start, pos, pos.getX(), pos.getY(), cols);
    }

    @NotNull
    public final Position component1() {
        return this.start;
    }

    @NotNull
    public final Position component2() {
        return this.end;
    }

    @NotNull
    public final HighlighterRange copy(@NotNull Position start2, @NotNull Position end) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return new HighlighterRange(start2, end);
    }

    public static /* synthetic */ HighlighterRange copy$default(HighlighterRange highlighterRange, Position position, Position position2, int n, Object object) {
        if ((n & 1) != 0) {
            position = highlighterRange.start;
        }
        if ((n & 2) != 0) {
            position2 = highlighterRange.end;
        }
        return highlighterRange.copy(position, position2);
    }

    @NotNull
    public String toString() {
        return "HighlighterRange(start=" + this.start + ", end=" + this.end + ")";
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = result * 31 + this.end.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HighlighterRange)) {
            return false;
        }
        HighlighterRange highlighterRange = (HighlighterRange)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)highlighterRange.start)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.end, (Object)highlighterRange.end);
    }
}

