/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.AbstractProcessor;
import app.termora.terminal.CharacterSet;
import app.termora.terminal.DataKey;
import app.termora.terminal.Graphic;
import app.termora.terminal.GraphicCharacterSet;
import app.termora.terminal.ProcessorState;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalReader;
import app.termora.terminal.TerminalState;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lapp/termora/terminal/EscapeDesignateCharacterSetProcessor;", "Lapp/termora/terminal/AbstractProcessor;", "terminal", "Lapp/termora/terminal/Terminal;", "reader", "Lapp/termora/terminal/TerminalReader;", "<init>", "(Lapp/termora/terminal/Terminal;Lapp/termora/terminal/TerminalReader;)V", "graphicCharacterSet", "Lapp/termora/terminal/GraphicCharacterSet;", "getGraphicCharacterSet", "()Lapp/termora/terminal/GraphicCharacterSet;", "graphic", "Lapp/termora/terminal/Graphic;", "getGraphic", "()Lapp/termora/terminal/Graphic;", "process", "Lapp/termora/terminal/ProcessorState;", "ch", "", "Companion", "termora"})
public final class EscapeDesignateCharacterSetProcessor
extends AbstractProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DataKey<Graphic> Graphic = new DataKey(Reflection.getOrCreateKotlinClass(Graphic.class));
    private static final Logger log = LoggerFactory.getLogger(EscapeDesignateCharacterSetProcessor.class);

    public EscapeDesignateCharacterSetProcessor(@NotNull Terminal terminal, @NotNull TerminalReader reader) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        super(terminal, reader);
    }

    private final GraphicCharacterSet getGraphicCharacterSet() {
        return this.getTerminal().getTerminalModel().getData(DataKey.Companion.getGraphicCharacterSet());
    }

    private final Graphic getGraphic() {
        return this.getTerminal().getTerminalModel().getData(Graphic);
    }

    @Override
    @NotNull
    public ProcessorState process(char ch) {
        return switch (ch) {
            case 'A' -> {
                this.getGraphicCharacterSet().designate(this.getGraphic(), CharacterSet.UK);
                if (log.isDebugEnabled()) {
                    log.debug(this.getGraphic() + " Character Set: United Kingdom (UK)");
                }
                yield TerminalState.READY;
            }
            case 'B' -> {
                this.getGraphicCharacterSet().designate(this.getGraphic(), CharacterSet.USASCII);
                if (log.isDebugEnabled()) {
                    log.debug(this.getGraphic() + " Character Set: United States (USASCII)");
                }
                yield TerminalState.READY;
            }
            case '4' -> {
                this.getGraphicCharacterSet().designate(this.getGraphic(), CharacterSet.Dutch);
                if (log.isDebugEnabled()) {
                    log.debug(this.getGraphic() + " Character Set: Dutch");
                }
                yield TerminalState.READY;
            }
            case 'R', 'f' -> {
                this.getGraphicCharacterSet().designate(this.getGraphic(), CharacterSet.French);
                if (log.isDebugEnabled()) {
                    log.debug(this.getGraphic() + " Character Set: French");
                }
                yield TerminalState.READY;
            }
            case 'K' -> {
                this.getGraphicCharacterSet().designate(this.getGraphic(), CharacterSet.German);
                if (log.isDebugEnabled()) {
                    log.debug(this.getGraphic() + " Character Set: German");
                }
                yield TerminalState.READY;
            }
            case '6', 'E' -> {
                this.getGraphicCharacterSet().designate(this.getGraphic(), CharacterSet.Norwegian_Danish);
                if (log.isDebugEnabled()) {
                    log.debug(this.getGraphic() + " Character Set: Norwegian/Danish");
                }
                yield TerminalState.READY;
            }
            case '7', 'H' -> {
                this.getGraphicCharacterSet().designate(this.getGraphic(), CharacterSet.Swedish);
                if (log.isDebugEnabled()) {
                    log.debug(this.getGraphic() + " Character Set: Swedish");
                }
                yield TerminalState.READY;
            }
            case '=' -> {
                this.getGraphicCharacterSet().designate(this.getGraphic(), CharacterSet.Swiss);
                if (log.isDebugEnabled()) {
                    log.debug(this.getGraphic() + " Character Set: Swiss");
                }
                yield TerminalState.READY;
            }
            case '<', 'U' -> {
                this.getGraphicCharacterSet().designate(this.getGraphic(), CharacterSet.DECSupplemental);
                if (log.isDebugEnabled()) {
                    log.debug(this.getGraphic() + " Character Set: DEC Supplemental");
                }
                yield TerminalState.READY;
            }
            case 'Z' -> {
                this.getGraphicCharacterSet().designate(this.getGraphic(), CharacterSet.Spanish);
                if (log.isDebugEnabled()) {
                    log.debug(this.getGraphic() + " Character Set: Spanish");
                }
                yield TerminalState.READY;
            }
            case 'Y' -> {
                this.getGraphicCharacterSet().designate(this.getGraphic(), CharacterSet.Italian);
                if (log.isDebugEnabled()) {
                    log.debug(this.getGraphic() + " Character Set: Italian");
                }
                yield TerminalState.READY;
            }
            case '9', 'Q' -> {
                this.getGraphicCharacterSet().designate(this.getGraphic(), CharacterSet.FrenchCanadian);
                if (log.isDebugEnabled()) {
                    log.debug(this.getGraphic() + " Character Set: Finnish Canadian");
                }
                yield TerminalState.READY;
            }
            case '5', 'C' -> {
                this.getGraphicCharacterSet().designate(this.getGraphic(), CharacterSet.Finnish);
                if (log.isDebugEnabled()) {
                    log.debug(this.getGraphic() + " Character Set: Finnish");
                }
                yield TerminalState.READY;
            }
            case '0', '2' -> {
                this.getGraphicCharacterSet().designate(this.getGraphic(), CharacterSet.DECSpecialCharacter);
                if (log.isDebugEnabled()) {
                    log.debug(this.getGraphic() + " Character Set: DEC Special Character and Line Drawing Set, VT100.");
                }
                yield TerminalState.READY;
            }
            default -> {
                if (log.isWarnEnabled()) {
                    log.warn("Unknown character set: " + ch);
                }
                yield TerminalState.READY;
            }
        };
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/termora/terminal/EscapeDesignateCharacterSetProcessor$Companion;", "", "<init>", "()V", "Graphic", "Lapp/termora/terminal/DataKey;", "Lapp/termora/terminal/Graphic;", "getGraphic$termora", "()Lapp/termora/terminal/DataKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<Graphic> getGraphic$termora() {
            return Graphic;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

