/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.AbstractProcessor;
import app.termora.terminal.ProcessorState;
import app.termora.terminal.SystemCommandSequence;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalReader;
import app.termora.terminal.TerminalState;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lapp/termora/terminal/DeviceControlStringProcessor;", "Lapp/termora/terminal/AbstractProcessor;", "terminal", "Lapp/termora/terminal/Terminal;", "reader", "Lapp/termora/terminal/TerminalReader;", "<init>", "(Lapp/termora/terminal/Terminal;Lapp/termora/terminal/TerminalReader;)V", "systemCommandSequence", "Lapp/termora/terminal/SystemCommandSequence;", "process", "Lapp/termora/terminal/ProcessorState;", "ch", "", "processCommand", "", "command", "", "Companion", "termora"})
public final class DeviceControlStringProcessor
extends AbstractProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SystemCommandSequence systemCommandSequence;
    private static final Logger log = LoggerFactory.getLogger(DeviceControlStringProcessor.class);

    public DeviceControlStringProcessor(@NotNull Terminal terminal, @NotNull TerminalReader reader) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        super(terminal, reader);
        this.systemCommandSequence = new SystemCommandSequence();
    }

    @Override
    @NotNull
    public ProcessorState process(char ch) {
        this.getReader().addFirst(ch);
        while (!this.systemCommandSequence.process(this.getReader().read())) {
            if (this.getReader().isEmpty()) {
                return TerminalState.DCS;
            }
            if (this.getReader().isNotEmpty()) continue;
        }
        this.processCommand(this.systemCommandSequence.getCommand());
        this.systemCommandSequence.reset();
        return TerminalState.READY;
    }

    private final void processCommand(String command) {
        if (((CharSequence)command).length() == 0) {
            return;
        }
        if (log.isWarnEnabled()) {
            log.warn("Cannot process command: {}", (Object)command);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/terminal/DeviceControlStringProcessor$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

