/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.CursorModel;
import app.termora.terminal.CursorMove;
import app.termora.terminal.CursorStyle;
import app.termora.terminal.DataKey;
import app.termora.terminal.Position;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalModelKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0001H\u0016J\b\u0010\f\u001a\u00020\u0001H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lapp/termora/terminal/CursorModelImpl;", "Lapp/termora/terminal/CursorModel;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/Terminal;)V", "screenPosition", "Lapp/termora/terminal/Position;", "position", "getTerminal", "getPosition", "getAlternateScreenBufferCursorModel", "getNonAlternateScreenBufferCursorModel", "move", "", "Lapp/termora/terminal/CursorMove;", "count", "", "row", "col", "getStyle", "Lapp/termora/terminal/CursorStyle;", "Companion", "termora"})
public class CursorModelImpl
implements CursorModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Terminal terminal;
    @NotNull
    private Position screenPosition;
    @NotNull
    private Position position;
    private static final Logger log = LoggerFactory.getLogger(CursorModelImpl.class);

    public CursorModelImpl(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminal = terminal;
        this.screenPosition = new Position(1, 1);
        this.position = new Position(1, 1);
    }

    @Override
    @NotNull
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    @NotNull
    public Position getPosition() {
        return TerminalModelKt.isAlternateScreenBuffer(this.terminal.getTerminalModel()) ? this.getAlternateScreenBufferCursorModel().getPosition() : this.getNonAlternateScreenBufferCursorModel().getPosition();
    }

    @Override
    @NotNull
    public CursorModel getAlternateScreenBufferCursorModel() {
        Terminal terminal = this.terminal;
        return new CursorModelImpl(this, terminal){
            final /* synthetic */ CursorModelImpl this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public Position getPosition() {
                return CursorModelImpl.access$getScreenPosition$p(this.this$0);
            }

            public void move(int row, int col) {
                CursorModelImpl.access$setScreenPosition$p(this.this$0, new Position(row, col));
            }

            public CursorModel getAlternateScreenBufferCursorModel() {
                return this;
            }

            public CursorModel getNonAlternateScreenBufferCursorModel() {
                return this.this$0.getNonAlternateScreenBufferCursorModel();
            }
        };
    }

    @Override
    @NotNull
    public CursorModel getNonAlternateScreenBufferCursorModel() {
        Terminal terminal = this.terminal;
        return new CursorModelImpl(this, terminal){
            final /* synthetic */ CursorModelImpl this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public Position getPosition() {
                return CursorModelImpl.access$getPosition$p(this.this$0);
            }

            public void move(int row, int col) {
                CursorModelImpl.access$setPosition$p(this.this$0, new Position(row, col));
            }

            public CursorModel getAlternateScreenBufferCursorModel() {
                return this.this$0.getAlternateScreenBufferCursorModel();
            }

            public CursorModel getNonAlternateScreenBufferCursorModel() {
                return this;
            }
        };
    }

    @Override
    public void move(@NotNull CursorMove move) {
        Intrinsics.checkNotNullParameter((Object)((Object)move), (String)"move");
        this.move(move, 1);
    }

    @Override
    public void move(@NotNull CursorMove move, int count) {
        Intrinsics.checkNotNullParameter((Object)((Object)move), (String)"move");
        if (count <= 0 && log.isErrorEnabled()) {
            log.error("Caret move count " + count);
        }
        Position position = this.getPosition();
        position = switch (WhenMappings.$EnumSwitchMapping$0[move.ordinal()]) {
            case 1 -> Position.copy$default(position, 0, 1, 1, null);
            case 2 -> Position.copy$default(position, 0, this.getTerminal().getTerminalModel().getCols() - 1, 1, null);
            case 3 -> Position.copy$default(position, 0, position.getX() - count, 1, null);
            case 4 -> Position.copy$default(position, 0, position.getX() + count, 1, null);
            case 5 -> Position.copy$default(position, position.getY() + count, 0, 2, null);
            case 6 -> Position.copy$default(position, position.getY() - count, 0, 2, null);
            default -> throw new NoWhenBranchMatchedException();
        };
        this.move(position.getY(), position.getX());
    }

    @Override
    public void move(int row, int col) {
        int newRow = Math.max(row, 1);
        int newCol = Math.max(col, 1);
        if (TerminalModelKt.isAlternateScreenBuffer(this.terminal.getTerminalModel())) {
            this.getAlternateScreenBufferCursorModel().move(newRow, newCol);
            if (log.isTraceEnabled()) {
                log.trace("[Alternate Screen Buffer] Move Caret row:" + newRow + " col:" + newCol + ". Max col: " + this.terminal.getTerminalModel().getCols());
            }
        } else {
            Position old = this.getNonAlternateScreenBufferCursorModel().getPosition();
            this.getNonAlternateScreenBufferCursorModel().move(newRow, newCol);
            if (log.isTraceEnabled()) {
                log.trace("Move Caret old row:" + old.getY() + " col:" + old.getX() + " , row:" + newRow + " col:" + newCol + ". Max col: " + this.terminal.getTerminalModel().getCols());
            }
        }
    }

    @Override
    @NotNull
    public CursorStyle getStyle() {
        return this.terminal.getTerminalModel().getData(DataKey.Companion.getCursorStyle());
    }

    public static final /* synthetic */ Position access$getScreenPosition$p(CursorModelImpl $this) {
        return $this.screenPosition;
    }

    public static final /* synthetic */ void access$setScreenPosition$p(CursorModelImpl $this, Position position) {
        $this.screenPosition = position;
    }

    public static final /* synthetic */ Position access$getPosition$p(CursorModelImpl $this) {
        return $this.position;
    }

    public static final /* synthetic */ void access$setPosition$p(CursorModelImpl $this, Position position) {
        $this.position = position;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/terminal/CursorModelImpl$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CursorMove.values().length];
            try {
                nArray[CursorMove.RowHome.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorMove.RowEnd.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorMove.Left.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorMove.Right.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorMove.Down.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CursorMove.Up.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

