/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.TermoraFrameKt;
import app.termora.terminal.AbstractProcessor;
import app.termora.terminal.CharBuffer;
import app.termora.terminal.CursorModel;
import app.termora.terminal.CursorStoreStores;
import app.termora.terminal.CursorStyle;
import app.termora.terminal.DataKey;
import app.termora.terminal.Document;
import app.termora.terminal.KTermKt;
import app.termora.terminal.MouseMode;
import app.termora.terminal.Position;
import app.termora.terminal.ProcessorState;
import app.termora.terminal.ScrollingRegion;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalLine;
import app.termora.terminal.TerminalLineBuffer;
import app.termora.terminal.TerminalModel;
import app.termora.terminal.TerminalModelKt;
import app.termora.terminal.TerminalMouseButton;
import app.termora.terminal.TerminalReader;
import app.termora.terminal.TerminalState;
import app.termora.terminal.TextStyle;
import app.termora.terminal.panel.TerminalWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.ArrayIteratorsKt;
import kotlin.jvm.internal.CharCompanionObject;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u0012\u0010\u001e\u001a\u00020\u001c2\b\b\u0002\u0010\u001f\u001a\u00020\u001aH\u0002J\u0012\u0010 \u001a\u00020\u001c2\b\b\u0002\u0010\u001f\u001a\u00020\u001aH\u0002J\b\u0010!\u001a\u00020\u001cH\u0002J\u0010\u0010\"\u001a\u00020\u001a*\u00060\u0011j\u0002`\u0012H\u0002J\u0010\u0010#\u001a\u00020\u001a*\u00060\u0011j\u0002`\u0012H\u0002J\u0018\u0010$\u001a\u00020%*\u00060\u0011j\u0002`\u00122\u0006\u0010&\u001a\u00020%H\u0002J\u0010\u0010'\u001a\u00020(*\u00060\u0011j\u0002`\u0012H\u0002R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lapp/termora/terminal/ControlSequenceIntroducerProcessor;", "Lapp/termora/terminal/AbstractProcessor;", "terminal", "Lapp/termora/terminal/Terminal;", "reader", "Lapp/termora/terminal/TerminalReader;", "<init>", "(Lapp/termora/terminal/Terminal;Lapp/termora/terminal/TerminalReader;)V", "terminalModel", "Lapp/termora/terminal/TerminalModel;", "getTerminalModel", "()Lapp/termora/terminal/TerminalModel;", "document", "Lapp/termora/terminal/Document;", "getDocument", "()Lapp/termora/terminal/Document;", "args", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "illegalChars", "", "", "process", "Lapp/termora/terminal/ProcessorState;", "ch", "needReread", "", "processDeviceStatusReport", "", "sendDeviceAttributes", "enableMode", "enable", "enablePrivateMode", "processCharacterAttributes", "startsWithQuestionMark", "startsWithMoreMark", "toInt", "", "defaultValue", "controlSequences", "", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nControlSequenceIntroducerProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlSequenceIntroducerProcessor.kt\napp/termora/terminal/ControlSequenceIntroducerProcessor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1050:1\n13493#2,2:1051\n13493#2,2:1058\n1#3:1053\n1#3:1073\n975#4:1054\n1046#4,3:1055\n774#5:1060\n865#5,2:1061\n1617#5,9:1063\n1869#5:1072\n1870#5:1074\n1626#5:1075\n*S KotlinDebug\n*F\n+ 1 ControlSequenceIntroducerProcessor.kt\napp/termora/terminal/ControlSequenceIntroducerProcessor\n*L\n190#1:1051,2\n562#1:1058,2\n1039#1:1073\n463#1:1054\n463#1:1055,3\n1039#1:1060\n1039#1:1061,2\n1039#1:1063,9\n1039#1:1072\n1039#1:1074\n1039#1:1075\n*E\n"})
public final class ControlSequenceIntroducerProcessor
extends AbstractProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringBuilder args;
    @NotNull
    private final List<Character> illegalChars;
    private static final Logger log = LoggerFactory.getLogger(ControlSequenceIntroducerProcessor.class);

    public ControlSequenceIntroducerProcessor(@NotNull Terminal terminal, @NotNull TerminalReader reader) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        super(terminal, reader);
        this.args = new StringBuilder();
        this.illegalChars = new ArrayList();
    }

    private final TerminalModel getTerminalModel() {
        return this.getTerminal().getTerminalModel();
    }

    private final Document getDocument() {
        return this.getTerminal().getDocument();
    }

    @Override
    @NotNull
    public ProcessorState process(char ch) {
        TerminalState state = TerminalState.READY;
        if (this.needReread(ch)) {
            return state;
        }
        switch (ch) {
            case 'm': {
                this.processCharacterAttributes();
                break;
            }
            case 'A': {
                int count = Math.max(this.toInt(this.args, 1), 1);
                Position position = this.getTerminal().getCursorModel().getPosition();
                int top = TerminalModelKt.getScrollingRegion(this.getTerminalModel()).getTop();
                Position position2 = position = position.getY() - count < top ? Position.copy$default(position, top, 0, 2, null) : Position.copy$default(position, position.getY() - count, 0, 2, null);
                if (log.isDebugEnabled()) {
                    log.debug("Cursor Up " + count + " Times (CUU)");
                }
                this.getTerminal().getCursorModel().move(position.getY(), position.getX());
                break;
            }
            case 'D': {
                int count = Math.max(1, this.toInt(this.args, 1));
                Position position = this.getTerminal().getCursorModel().getPosition();
                this.getTerminal().getCursorModel().move(position.getY(), Math.max(position.getX() - count, 1));
                if (!log.isDebugEnabled()) break;
                log.debug("Cursor Backward " + count + " Times (CUB).");
                break;
            }
            case 'q': {
                switch (StringsKt.first((CharSequence)this.args)) {
                    case '0': 
                    case '1': 
                    case '2': {
                        this.getTerminalModel().setData(DataKey.Companion.getCursorStyle(), CursorStyle.Block);
                        break;
                    }
                    case '3': 
                    case '4': {
                        this.getTerminalModel().setData(DataKey.Companion.getCursorStyle(), CursorStyle.Underline);
                        break;
                    }
                    case '5': 
                    case '6': {
                        this.getTerminalModel().setData(DataKey.Companion.getCursorStyle(), CursorStyle.Bar);
                    }
                }
                if (!log.isDebugEnabled()) break;
                log.debug("Set cursor style (DECSCUSR), VT520.");
                break;
            }
            case 'B': {
                int count = Math.max(this.toInt(this.args, 1), 1);
                Position position = this.getTerminal().getCursorModel().getPosition();
                int bottom = TerminalModelKt.getScrollingRegion(this.getTerminalModel()).getBottom();
                Position position3 = position = position.getY() + count > bottom ? Position.copy$default(position, bottom, 0, 2, null) : Position.copy$default(position, position.getY() + count, 0, 2, null);
                if (log.isDebugEnabled()) {
                    log.debug("Cursor Down " + count + " Times (CUD)");
                }
                this.getTerminal().getCursorModel().move(position.getY(), position.getX());
                break;
            }
            case '@': {
                int count = this.toInt(this.args, 1);
                Position position = this.getTerminal().getCursorModel().getPosition();
                TerminalLine line = TerminalLineBuffer.getScreenLineAt-QwXzuJw$default(this.getTerminal().getDocument().getCurrentTerminalLineBuffer(), position.getY() - 1, 0L, 2, null);
                int n = 0;
                char[] cArray = new char[count];
                int n2 = this.getTerminalModel().getCols();
                int n3 = position.getX() - 1;
                TerminalLine terminalLine = line;
                while (n < count) {
                    int n4 = n++;
                    cArray[n4] = KTermKt.getSpace(CharCompanionObject.INSTANCE);
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                long l = this.getTerminalModel().getData(DataKey.Companion.getTextStyle()).unbox-impl();
                char[] cArray2 = cArray;
                terminalLine.insertChars(n3, n2, new CharBuffer(cArray2, l, defaultConstructorMarker));
                if (!log.isDebugEnabled()) break;
                log.debug("Insert Ps (Blank) Character(s) (ICH). count:" + count);
                break;
            }
            case 'F': {
                int count = Math.max(1, this.toInt(this.args, 1));
                Position position = this.getTerminal().getCursorModel().getPosition();
                int top = TerminalModelKt.getScrollingRegion(this.getTerminalModel()).getTop();
                position = position.getY() - count < top ? Position.copy$default(position, top, 0, 2, null) : Position.copy$default(position, position.getY() - count, 0, 2, null);
                this.getTerminal().getCursorModel().move(position.getY(), 1);
                if (!log.isDebugEnabled()) break;
                log.debug("Cursor Preceding Line " + count + " Times (default = 1) (CPL).");
                break;
            }
            case 'E': {
                int count = Math.max(1, this.toInt(this.args, 1));
                Position position = this.getTerminal().getCursorModel().getPosition();
                int bottom = TerminalModelKt.getScrollingRegion(this.getTerminalModel()).getBottom();
                position = position.getY() + count > bottom ? Position.copy$default(position, bottom, 0, 2, null) : Position.copy$default(position, position.getY() + count, 0, 2, null);
                this.getTerminal().getCursorModel().move(position.getY(), 1);
                if (!log.isDebugEnabled()) break;
                log.debug("Cursor Next Line Ps Times " + count + " Times (default = 1) (CNL).");
                break;
            }
            case 'C': {
                int count = Math.max(this.toInt(this.args, 1), 1);
                Position position = this.getTerminal().getCursorModel().getPosition();
                this.getTerminal().getCursorModel().move(position.getY(), Math.min(position.getX() + count, this.getTerminalModel().getCols()));
                if (!log.isDebugEnabled()) break;
                log.debug("Cursor Forward " + count + " Times (default = 1) (CUF).");
                break;
            }
            case 'n': {
                this.processDeviceStatusReport();
                break;
            }
            case 'J': {
                if (StringsKt.isBlank((CharSequence)this.args)) {
                    this.args.append('0');
                }
                int[] $this$forEach$iv = this.controlSequences(this.args);
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int bottom = 0; bottom < n; ++bottom) {
                    int element$iv;
                    int it = element$iv = $this$forEach$iv[bottom];
                    boolean bl = false;
                    this.getTerminal().getDocument().eraseInDisplay(it);
                }
                break;
            }
            case 'K': {
                this.getTerminal().getDocument().eraseInLine(this.toInt(this.args, 0));
                break;
            }
            case 'H': 
            case 'f': {
                int rows = 1;
                int cols = 1;
                if (!StringsKt.isBlank((CharSequence)this.args)) {
                    int n;
                    int it;
                    int n5;
                    int element$iv = 0;
                    int[] position = this.controlSequences(this.args);
                    int[] nArray = position;
                    if (element$iv < nArray.length) {
                        n5 = nArray[element$iv];
                    } else {
                        it = element$iv;
                        boolean bl = false;
                        n5 = 1;
                    }
                    rows = n5;
                    nArray = position;
                    element$iv = 1;
                    if (element$iv < nArray.length) {
                        n = nArray[element$iv];
                    } else {
                        it = element$iv;
                        boolean bl = false;
                        n = 1;
                    }
                    cols = n;
                }
                if (TerminalModelKt.isOriginMode(this.getTerminalModel())) {
                    rows += TerminalModelKt.getScrollingRegion(this.getTerminalModel()).getTop() - 1;
                }
                if (rows > TerminalModelKt.getScrollingRegion(this.getTerminalModel()).getBottom()) {
                    rows = TerminalModelKt.getScrollingRegion(this.getTerminalModel()).getBottom();
                }
                this.getTerminal().getCursorModel().move(rows, Math.min(cols, this.getTerminalModel().getCols()));
                if (!log.isDebugEnabled()) break;
                log.debug("Cursor Position [" + rows + ";" + cols + "] (CUP)");
                break;
            }
            case 'G': {
                int column = Math.min(this.toInt(this.args, 1), this.getTerminalModel().getCols());
                int row = this.getTerminal().getCursorModel().getPosition().getY();
                this.getTerminal().getCursorModel().move(row, column);
                if (!log.isDebugEnabled()) break;
                log.debug("Cursor Character Absolute  [" + column + "] (CHA)");
                break;
            }
            case 'T': {
                int count = this.toInt(this.args, 1);
                this.getTerminal().getDocument().scroll(TerminalMouseButton.ScrollUp, count);
                if (!log.isDebugEnabled()) break;
                log.debug("Scroll down Ps lines (default = 1) (SD): " + count);
                break;
            }
            case 'S': {
                int count = this.toInt(this.args, 1);
                for (int i = 0; i < count; ++i) {
                    Document.DefaultImpls.scroll$default(this.getTerminal().getDocument(), TerminalMouseButton.ScrollDown, 0, 2, null);
                }
                if (!log.isDebugEnabled()) break;
                log.debug("Scroll up Ps lines (default = 1) (SD): " + count);
                break;
            }
            case 'P': {
                Position position = this.getTerminal().getCursorModel().getPosition();
                int count = this.toInt(this.args, 1);
                int offset = position.getX() - 1;
                TerminalLine line = TerminalLineBuffer.getScreenLineAt-QwXzuJw$default(this.getTerminal().getDocument().getCurrentTerminalLineBuffer(), position.getY() - 1, 0L, 2, null);
                if (count > 0) {
                    line.deleteChars(offset, count, (Pair<Character, TextStyle>)new Pair((Object)Character.valueOf(KTermKt.getNull(CharCompanionObject.INSTANCE)), (Object)this.getTerminalModel().getData(DataKey.Companion.getTextStyle())));
                }
                if (!log.isDebugEnabled()) break;
                log.debug("Line:" + position.getY() + " Delete Ps Character(s): " + count);
                break;
            }
            case 'd': {
                Position position = this.getTerminal().getCursorModel().getPosition();
                int row = this.toInt(this.args, 1);
                this.getTerminal().getCursorModel().move(row, position.getX());
                if (!log.isDebugEnabled()) break;
                log.debug("Line Position Absolute  [" + row + "]");
                break;
            }
            case 'h': {
                ControlSequenceIntroducerProcessor.enableMode$default(this, false, 1, null);
                break;
            }
            case 'l': {
                this.enableMode(false);
                break;
            }
            case 'X': {
                int count = this.toInt(this.args, 1);
                Position position = this.getTerminal().getCursorModel().getPosition();
                int offset = position.getX() - 1;
                TerminalLine line22 = TerminalLineBuffer.getScreenLineAt-QwXzuJw$default(this.getTerminal().getDocument().getCurrentTerminalLineBuffer(), position.getY() - 1, 0L, 2, null);
                line22.eraseChars-PM23JaI(offset, count, this.getTerminalModel().getData(DataKey.Companion.getTextStyle()).unbox-impl());
                break;
            }
            case 'L': {
                int count = this.toInt(this.args, 1);
                Position position = this.getTerminal().getCursorModel().getPosition();
                this.getTerminal().getDocument().getCurrentTerminalLineBuffer().insertLines(position.getY(), TerminalModelKt.getScrollingRegion(this.getTerminalModel()).getBottom(), count);
                if (!log.isDebugEnabled()) break;
                log.debug("Insert Ps Line(s) " + count + " (IL).");
                break;
            }
            case 'r': {
                int n;
                int n6;
                if (this.startsWithQuestionMark(this.args)) {
                    return TerminalState.READY;
                }
                int line22 = 0;
                int[] sr = this.controlSequences(this.args);
                int[] offset = sr;
                if (line22 < offset.length) {
                    n6 = offset[line22];
                } else {
                    int it = line22;
                    boolean bl = false;
                    n6 = 1;
                }
                int top = n6;
                int[] line22 = sr;
                int n7 = 1;
                if (n7 < line22.length) {
                    n = line22[n7];
                } else {
                    int it = n7;
                    boolean bl = false;
                    n = this.getTerminalModel().getRows();
                }
                int bottom = n;
                if (bottom <= top || top < 1) {
                    if (log.isWarnEnabled()) {
                        log.warn("Set Scrolling Region Error. top: " + top + " , bottom: " + bottom);
                    }
                    top = 1;
                    bottom = this.getTerminalModel().getRows();
                }
                this.getTerminal().getTerminalModel().setData(DataKey.Companion.getScrollingRegion(), new ScrollingRegion(top, bottom));
                if (log.isDebugEnabled()) {
                    log.debug("Set Scrolling Region [" + top + "; " + bottom + "]");
                }
                this.getTerminal().getCursorModel().move(TerminalModelKt.isOriginMode(this.getTerminalModel()) ? top : 1, 1);
                break;
            }
            case 't': {
                if (!log.isDebugEnabled()) break;
                log.debug("Window manipulation (XTWINOPS) Ignore");
                break;
            }
            case 'c': {
                this.sendDeviceAttributes();
                break;
            }
            case 'M': {
                int count = this.toInt(this.args, 1);
                this.getTerminal().getDocument().getCurrentTerminalLineBuffer().deleteLines(this.getTerminal().getCursorModel().getPosition().getY(), TerminalModelKt.getScrollingRegion(this.getTerminalModel()).getBottom(), count);
                if (!log.isDebugEnabled()) break;
                log.debug("Delete " + count + " Line(s) (DL).");
                break;
            }
            case 'g': {
                int mode = this.toInt(this.args, 0);
                if (mode == 0) {
                    int x = this.getTerminal().getCursorModel().getPosition().getX();
                    this.getTerminal().getTabulator().clearTabStop(x - 1);
                    if (!log.isDebugEnabled()) break;
                    log.debug("Tab Clear (TBC). clearTabStop(" + x + ")");
                    break;
                }
                if (mode == 3) {
                    this.getTerminal().getTabulator().clearAllTabStops();
                    if (!log.isDebugEnabled()) break;
                    log.debug("Tab Clear (TBC). clearAllTabStops");
                    break;
                }
                if (!log.isWarnEnabled()) break;
                log.warn("Tab Clear (TBC). TBC: " + mode);
                break;
            }
            case 'Z': {
                int count = this.toInt(this.args, 1);
                CursorModel cursorModel = this.getTerminal().getCursorModel();
                for (int i = 0; i < count; ++i) {
                    int x = this.getTerminal().getTabulator().previousTab(cursorModel.getPosition().getX() - 1) + 1;
                    this.getTerminal().getCursorModel().move(cursorModel.getPosition().getY(), x);
                }
                break;
            }
            case ';': {
                this.args.append(ch);
                state = TerminalState.CSI;
                break;
            }
            case '\b': 
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case '\u009c': {
                this.illegalChars.add(Character.valueOf(ch));
                state = TerminalState.CSI;
                break;
            }
            default: {
                this.args.append(ch);
                boolean bl = '@' <= ch ? ch < '\u007f' : false;
                if (bl) {
                    if (!log.isWarnEnabled()) break;
                    log.warn("Unknown CSI: " + this.args);
                    break;
                }
                state = TerminalState.CSI;
            }
        }
        if (state == TerminalState.READY) {
            StringsKt.clear((StringBuilder)this.args);
            this.illegalChars.clear();
        }
        return state;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean needReread(char ch) {
        if (!((Collection)this.illegalChars).isEmpty()) {
            char c2 = ch;
            boolean bl = '@' <= c2 ? c2 < '\u007f' : false;
            if (bl) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List chars = new ArrayList();
                chars.addAll((Collection)this.illegalChars);
                chars.add(Character.valueOf('\u001b'));
                chars.add(Character.valueOf('['));
                CharSequence charSequence = this.args;
                List list = chars;
                boolean $i$f$map = false;
                void var5_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length());
                boolean $i$f$mapTo = false;
                for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
                    void it;
                    char item$iv$iv;
                    char c3 = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(Character.valueOf((char)it));
                }
                list.addAll((List)destination$iv$iv);
                chars.add(Character.valueOf(ch));
                if (log.isDebugEnabled()) {
                    log.debug("Re-read: " + chars);
                }
                this.getReader().addFirst(chars);
                StringsKt.clear((StringBuilder)this.args);
                this.illegalChars.clear();
                return true;
            }
        }
        return false;
    }

    private final void processDeviceStatusReport() {
        TermoraFrameKt.assertEventDispatchThread();
        if (this.startsWithQuestionMark(this.args)) {
            if (log.isWarnEnabled()) {
                log.warn("Don't support DEC-specific Device Report Status");
            }
            return;
        }
        if (!this.getTerminalModel().hasData(DataKey.Companion.getTerminalWriter())) {
            return;
        }
        TerminalWriter writer = this.getTerminalModel().getData(DataKey.Companion.getTerminalWriter());
        char m = StringsKt.first((CharSequence)this.args);
        switch (m) {
            case '6': {
                Position position = this.getTerminal().getCursorModel().getPosition();
                byte[] byArray = ("\u001b[" + position.getY() + ";" + position.getX() + "R").getBytes(writer.getCharset());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] bytes = byArray;
                writer.write(TerminalWriter.WriteRequest.Companion.fromBytes(bytes));
                break;
            }
            case '5': {
                byte[] byArray = "\u001b[0n".getBytes(writer.getCharset());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] bytes = byArray;
                writer.write(TerminalWriter.WriteRequest.Companion.fromBytes(bytes));
            }
        }
    }

    private final void sendDeviceAttributes() {
        TermoraFrameKt.assertEventDispatchThread();
        if (!this.getTerminalModel().hasData(DataKey.Companion.getTerminalWriter())) {
            return;
        }
        TerminalWriter writer = this.getTerminalModel().getData(DataKey.Companion.getTerminalWriter());
        byte[] byArray = "\u001b[?6c".getBytes(writer.getCharset());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        writer.write(TerminalWriter.WriteRequest.Companion.fromBytes(bytes));
    }

    private final void enableMode(boolean enable) {
        if (this.startsWithQuestionMark(this.args)) {
            this.enablePrivateMode(enable);
            return;
        }
        String string = this.args.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        switch (Integer.parseInt(string)) {
            case 4: {
                this.getTerminalModel().setData(DataKey.Companion.getInsertMode(), enable);
                if (!log.isDebugEnabled()) break;
                log.debug("Insert Mode (IRM). " + enable);
                break;
            }
            case 20: {
                this.getTerminalModel().setData(DataKey.Companion.getAutoNewline(), enable);
                if (!log.isDebugEnabled()) break;
                log.debug("Automatic Newline (LNM). " + enable);
                break;
            }
            default: {
                if (!log.isWarnEnabled()) break;
                log.warn("Unknown Mode: " + this.args);
            }
        }
    }

    static /* synthetic */ void enableMode$default(ControlSequenceIntroducerProcessor controlSequenceIntroducerProcessor, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        controlSequenceIntroducerProcessor.enableMode(bl);
    }

    private final void enablePrivateMode(boolean enable) {
        int[] $this$forEach$iv = this.controlSequences(this.args);
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        block26: for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            switch (it) {
                case 1: {
                    this.getTerminalModel().setData(DataKey.Companion.getApplicationCursorKeys(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Application Cursor Keys (DECCKM) " + enable);
                    break;
                }
                case 2: {
                    this.getTerminalModel().setData(DataKey.Companion.getVT52Mode(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("VT52 mode (DECANM), VT100. " + enable);
                    break;
                }
                case 3: {
                    this.getTerminalModel().setData(DataKey.Companion.getColumnMode(), enable);
                    this.getDocument().eraseInDisplay(2);
                    this.getTerminalModel().setData(DataKey.Companion.getScrollingRegion(), new ScrollingRegion(1, this.getTerminalModel().getRows()));
                    this.getTerminal().getCursorModel().move(1, 1);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Column Mode (DECCOLM) " + enable);
                    break;
                }
                case 4: {
                    this.getTerminalModel().setData(DataKey.Companion.getSmoothScroll(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Smooth (Slow) Scroll (DECSCLM) " + enable);
                    break;
                }
                case 5: {
                    this.getTerminalModel().setData(DataKey.Companion.getReverseVideo(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Reverse Video (DECSCNM) (DECOM) " + enable);
                    break;
                }
                case 6: {
                    this.getTerminalModel().setData(DataKey.Companion.getOriginMode(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Origin Mode (DECOM) " + enable);
                    break;
                }
                case 7: {
                    this.getTerminalModel().setData(DataKey.Companion.getAutoWrapMode(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Auto-Wrap Mode (DECAWM) " + enable);
                    break;
                }
                case 8: {
                    this.getTerminalModel().setData(DataKey.Companion.getAutoRepeatKeys(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Auto-Repeat Keys (DECARM) " + enable);
                    break;
                }
                case 25: {
                    this.getTerminalModel().setData(DataKey.Companion.getShowCursor(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Hide cursor (DECTCEM) " + enable);
                    break;
                }
                case 40: {
                    this.getTerminalModel().setData(DataKey.Companion.getAllow80_132(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Allow 80 \u21d2  132 mode " + enable);
                    break;
                }
                case 45: {
                    this.getTerminalModel().setData(DataKey.Companion.getReverseWraparoundMode(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Reverse-wraparound mode " + enable);
                    break;
                }
                case 1000: {
                    if (enable) {
                        this.getTerminalModel().setData(DataKey.Companion.getMouseMode(), MouseMode.MOUSE_REPORTING_NORMAL);
                    } else {
                        this.getTerminalModel().setData(DataKey.Companion.getMouseMode(), MouseMode.MOUSE_REPORTING_NONE);
                    }
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Send Mouse X & Y on button press and release. " + enable);
                    break;
                }
                case 1001: {
                    if (enable) {
                        this.getTerminalModel().setData(DataKey.Companion.getMouseMode(), MouseMode.MOUSE_REPORTING_HILITE);
                    } else {
                        this.getTerminalModel().setData(DataKey.Companion.getMouseMode(), MouseMode.MOUSE_REPORTING_NONE);
                    }
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Use Hilite Mouse Tracking, xterm. " + enable);
                    break;
                }
                case 1006: {
                    this.getTerminalModel().setData(DataKey.Companion.getSGRMouseMode(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("SGR Mouse Mode " + enable);
                    break;
                }
                case 1015: {
                    this.getTerminalModel().setData(DataKey.Companion.getUrxvtMouseMode(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Enable urxvt Mouse Mode. " + enable);
                    break;
                }
                case 1004: {
                    this.getTerminalModel().setData(DataKey.Companion.getSendFocusInFocusOutEvents(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Send FocusIn/FocusOut events, xterm. " + enable);
                    break;
                }
                case 1034: {
                    this.getTerminalModel().setData(DataKey.Companion.getEightBitInput(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Eight Bit Input " + enable);
                    break;
                }
                case 1049: {
                    if (enable) {
                        CursorStoreStores.INSTANCE.store(this.getTerminal());
                    } else {
                        CursorStoreStores.INSTANCE.restore(this.getTerminal());
                    }
                    if (!enable) {
                        this.getTerminal().getDocument().eraseInDisplay(2);
                    }
                    this.getTerminal().getSelectionModel().clearSelection();
                    this.getTerminalModel().setData(DataKey.Companion.getAlternateScreenBuffer(), enable);
                    if (enable) {
                        this.getTerminal().getScrollingModel().scrollTo(0);
                    }
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Alternate Screen Buffer " + enable);
                    break;
                }
                case 2004: {
                    this.getTerminalModel().setData(DataKey.Companion.getBracketedPasteMode(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Set bracketed paste mode " + enable);
                    break;
                }
                case 12: {
                    this.getTerminalModel().setData(DataKey.Companion.getStartBlinkingCursor(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Start blinking cursor (AT&T 610). " + enable);
                    break;
                }
                case 1002: {
                    if (enable) {
                        this.getTerminalModel().setData(DataKey.Companion.getMouseMode(), MouseMode.MOUSE_REPORTING_BUTTON_MOTION);
                    } else {
                        this.getTerminalModel().setData(DataKey.Companion.getMouseMode(), MouseMode.MOUSE_REPORTING_NONE);
                    }
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Use Cell Motion Mouse Tracking, xterm. " + enable);
                    break;
                }
                case 1003: {
                    if (enable) {
                        this.getTerminalModel().setData(DataKey.Companion.getMouseMode(), MouseMode.MOUSE_REPORTING_ALL_MOTION);
                    } else {
                        this.getTerminalModel().setData(DataKey.Companion.getMouseMode(), MouseMode.MOUSE_REPORTING_NONE);
                    }
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Use All Motion Mouse Tracking, xterm. " + enable);
                    break;
                }
                case 1005: {
                    this.getTerminalModel().setData(DataKey.Companion.getUTF8MouseMode(), enable);
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("Enable UTF-8 Mouse Mode, xterm. " + enable);
                    break;
                }
                case 9001: {
                    if (!log.isDebugEnabled()) continue block26;
                    log.debug("win32-input-mode " + enable);
                    break;
                }
                default: {
                    if (!log.isWarnEnabled()) continue block26;
                    log.warn("Unknown Private Mode: " + this.args + " , enable: " + enable);
                }
            }
        }
    }

    static /* synthetic */ void enablePrivateMode$default(ControlSequenceIntroducerProcessor controlSequenceIntroducerProcessor, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        controlSequenceIntroducerProcessor.enablePrivateMode(bl);
    }

    private final void processCharacterAttributes() {
        long textStyle = this.getTerminal().getTerminalModel().getData(DataKey.Companion.getTextStyle()).unbox-impl();
        int foreground = TextStyle.getForeground-impl(textStyle);
        int background = TextStyle.getBackground-impl(textStyle);
        boolean bold = TextStyle.getBold-impl(textStyle);
        boolean dim = TextStyle.getDim-impl(textStyle);
        boolean italic = TextStyle.getItalic-impl(textStyle);
        boolean underline = TextStyle.getUnderline-impl(textStyle);
        boolean inverse = TextStyle.getInverse-impl(textStyle);
        boolean lineThrough = TextStyle.getLineThrough-impl(textStyle);
        boolean blink = TextStyle.getBlink-impl(textStyle);
        boolean doublyUnderline = TextStyle.getDoublyUnderline-impl(textStyle);
        if (StringsKt.isBlank((CharSequence)this.args)) {
            StringsKt.clear((StringBuilder)this.args);
            this.args.append("0");
        } else {
            if (this.startsWithMoreMark(this.args)) {
                return;
            }
            if (this.startsWithQuestionMark(this.args)) {
                if (log.isWarnEnabled()) {
                    log.warn("ignore SGR: {}", (Object)this.args);
                }
                return;
            }
        }
        IntIterator iterator2 = ArrayIteratorsKt.iterator((int[])this.controlSequences(this.args));
        block33: while (iterator2.hasNext()) {
            int mode = iterator2.nextInt();
            switch (mode) {
                case 0: {
                    foreground = 0;
                    background = 0;
                    underline = false;
                    bold = false;
                    inverse = false;
                    italic = false;
                    doublyUnderline = false;
                    blink = false;
                    lineThrough = false;
                    dim = false;
                    continue block33;
                }
                case 1: {
                    bold = true;
                    continue block33;
                }
                case 2: {
                    dim = true;
                    continue block33;
                }
                case 3: {
                    italic = true;
                    continue block33;
                }
                case 4: {
                    underline = true;
                    continue block33;
                }
                case 5: {
                    blink = true;
                    continue block33;
                }
                case 7: {
                    inverse = true;
                    continue block33;
                }
                case 9: {
                    lineThrough = true;
                    continue block33;
                }
                case 29: {
                    lineThrough = false;
                    continue block33;
                }
                case 21: {
                    doublyUnderline = true;
                    continue block33;
                }
                case 22: {
                    bold = false;
                    dim = false;
                    continue block33;
                }
                case 25: {
                    blink = false;
                    continue block33;
                }
                case 27: {
                    inverse = false;
                    continue block33;
                }
                case 24: {
                    underline = false;
                    continue block33;
                }
                case 23: {
                    italic = false;
                    continue block33;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    foreground = mode - 30 + 1;
                    continue block33;
                }
                case 38: {
                    int b;
                    int g;
                    int r;
                    if (!iterator2.hasNext()) continue block33;
                    int code = iterator2.nextInt();
                    switch (code) {
                        case 2: {
                            r = iterator2.nextInt();
                            g = iterator2.nextInt();
                            b = iterator2.nextInt();
                            foreground = 65536 * r + 256 * g + b;
                            continue block33;
                        }
                        case 5: {
                            foreground = this.getTerminalModel().getColorPalette().getXTerm256Color(iterator2.nextInt() + 1);
                            continue block33;
                        }
                    }
                    if (!log.isWarnEnabled()) continue block33;
                    log.warn("xterm-256 foreground color, code: " + code);
                    continue block33;
                }
                case 39: {
                    foreground = 0;
                    continue block33;
                }
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    background = mode - 40 + 1;
                    continue block33;
                }
                case 48: {
                    int b;
                    int g;
                    int r;
                    if (!iterator2.hasNext()) continue block33;
                    int code = iterator2.nextInt();
                    switch (code) {
                        case 2: {
                            r = iterator2.nextInt();
                            g = iterator2.nextInt();
                            b = iterator2.nextInt();
                            background = 65536 * r + 256 * g + b;
                            continue block33;
                        }
                        case 5: {
                            background = this.getTerminalModel().getColorPalette().getXTerm256Color(iterator2.nextInt() + 1);
                            continue block33;
                        }
                    }
                    if (!log.isWarnEnabled()) continue block33;
                    log.warn("xterm-256 background color, code: " + code);
                    continue block33;
                }
                case 49: {
                    background = 0;
                    continue block33;
                }
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: {
                    foreground = mode - 82 + 1;
                    continue block33;
                }
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    background = mode - 92 + 1;
                    continue block33;
                }
            }
            if (!log.isWarnEnabled()) continue;
            log.warn("Unknown SGR: " + mode);
        }
        long style = TextStyle.copy-dS5fxWA(TextStyle.Companion.getDefault-c2YIwqY(), foreground, background, bold, italic, underline, lineThrough, inverse, blink, dim, doublyUnderline);
        this.getTerminalModel().setData(DataKey.Companion.getTextStyle(), TextStyle.box-impl(style));
        if (log.isDebugEnabled()) {
            log.debug("SGR: " + this.args);
        }
    }

    private final boolean startsWithQuestionMark(StringBuilder $this$startsWithQuestionMark) {
        return StringsKt.startsWith$default((CharSequence)$this$startsWithQuestionMark, (char)'?', (boolean)false, (int)2, null);
    }

    private final boolean startsWithMoreMark(StringBuilder $this$startsWithMoreMark) {
        return StringsKt.startsWith$default((CharSequence)$this$startsWithMoreMark, (char)'>', (boolean)false, (int)2, null);
    }

    private final int toInt(StringBuilder $this$toInt, int defaultValue) {
        if (StringsKt.isBlank((CharSequence)$this$toInt)) {
            return defaultValue;
        }
        String string = $this$toInt.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Integer n = StringsKt.toIntOrNull((String)string);
        if (n == null) {
            return defaultValue;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final int[] controlSequences(StringBuilder $this$controlSequences) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        CharSequence str = this.startsWithQuestionMark($this$controlSequences) || this.startsWithMoreMark($this$controlSequences) ? $this$controlSequences.substring(1) : $this$controlSequences;
        String[] stringArray = new String[]{";"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)str, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            Integer t = StringsKt.toIntOrNull((String)it);
            if (t == null && log.isErrorEnabled()) {
                log.error(it + " is not a valid integer. args: " + $this$controlSequences);
            }
            if (t == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/terminal/ControlSequenceIntroducerProcessor$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

