/*
 * Decompiled with CFR 0.152.
 */
package app.termora.sync;

import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.DeletedData;
import app.termora.PBKDF2;
import app.termora.ResponseException;
import app.termora.sync.GistResponse;
import app.termora.sync.SafetySyncer;
import app.termora.sync.SyncConfig;
import app.termora.sync.SyncRange;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lapp/termora/sync/WebDAVSyncer;", "Lapp/termora/sync/SafetySyncer;", "<init>", "()V", "pull", "Lapp/termora/sync/GistResponse;", "config", "Lapp/termora/sync/SyncConfig;", "push", "getWebDavFileUrl", "", "getKey", "", "newRequestBuilder", "Lokhttp3/Request$Builder;", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nWebDAVSyncer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebDAVSyncer.kt\napp/termora/sync/WebDAVSyncer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,190:1\n1#2:191\n222#3:192\n205#3:214\n774#4:193\n865#4,2:194\n774#4:196\n865#4,2:197\n774#4:199\n865#4,2:200\n774#4:202\n865#4,2:203\n774#4:205\n865#4,2:206\n774#4:208\n865#4,2:209\n29#5,3:211\n*S KotlinDebug\n*F\n+ 1 WebDAVSyncer.kt\napp/termora/sync/WebDAVSyncer\n*L\n40#1:192\n157#1:214\n47#1:193\n47#1:194,2\n54#1:196\n54#1:197,2\n61#1:199\n61#1:200,2\n68#1:202\n68#1:203,2\n75#1:205\n75#1:206,2\n82#1:208\n82#1:209,2\n92#1:211,3\n*E\n"})
public final class WebDAVSyncer
extends SafetySyncer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(WebDAVSyncer.class);

    private WebDAVSyncer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public GistResponse pull(@NotNull SyncConfig config) {
        block34: {
            List list;
            DeletedData e;
            Iterable $this$filterTo$iv$iv;
            boolean $i$f$filterTo;
            Collection destination$iv$iv;
            boolean $i$f$filter;
            WebDAVSyncer webDAVSyncer;
            Object object;
            Object it;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Response response = this.getHttpClient().newCall(this.newRequestBuilder(config).get().build()).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 404) {
                    return new GistResponse(config, CollectionsKt.emptyList());
                }
                throw new ResponseException(response.code(), response);
            }
            Closeable closeable = (Closeable)response;
            Throwable throwable = null;
            try {
                Object object3;
                Response resp = (Response)closeable;
                boolean bl = false;
                ResponseBody responseBody = resp.body();
                if (responseBody != null) {
                    Closeable closeable2 = (Closeable)responseBody;
                    Throwable throwable2 = null;
                    try {
                        Object it2 = (ResponseBody)closeable2;
                        boolean bl2 = false;
                        it2 = it2.string();
                        object3 = it2;
                    }
                    catch (Throwable bl2) {
                        throwable2 = bl2;
                        throw bl2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                } else {
                    object3 = null;
                }
                Object object4 = object3;
                object2 = object4;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (object2 == null) {
                throw new ResponseException(response.code(), response);
            }
            Object text = object2;
            Json this_$iv = Application.INSTANCE.getOhMyJson();
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            JsonObject json = (JsonObject)this_$iv.decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), (String)text);
            List deletedData = new ArrayList();
            Object object5 = (JsonElement)json.get((Object)"DeletedData");
            if (object5 != null && (object5 = JsonElementKt.getJsonPrimitive((JsonElement)object5)) != null && (object5 = object5.getContent()) != null) {
                it = object5;
                boolean bl = false;
                deletedData.addAll((Collection)this.decodeDeletedData((String)it, config));
            }
            if (config.getRanges().contains((Object)SyncRange.Hosts)) {
                Object object6 = (JsonElement)json.get((Object)"Hosts");
                if (object6 != null && (object6 = JsonElementKt.getJsonPrimitive((JsonElement)object6)) != null && (object6 = object6.getContent()) != null) {
                    void $this$filter$iv;
                    it = object6;
                    boolean bl = false;
                    Iterable bl2 = deletedData;
                    object = it;
                    webDAVSyncer = this;
                    $i$f$filter = false;
                    void var16_34 = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        e = (DeletedData)element$iv$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)e.getType(), (Object)"Host")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    webDAVSyncer.decodeHosts((String)object, list, config);
                }
            }
            if (config.getRanges().contains((Object)SyncRange.KeyPairs)) {
                Object object7 = (JsonElement)json.get((Object)"KeyPairs");
                if (object7 != null && (object7 = JsonElementKt.getJsonPrimitive((JsonElement)object7)) != null && (object7 = object7.getContent()) != null) {
                    it = object7;
                    boolean bl = false;
                    Iterable $this$filter$iv = deletedData;
                    object = it;
                    webDAVSyncer = this;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        e = (DeletedData)element$iv$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)e.getType(), (Object)"KeyPair")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    webDAVSyncer.decodeKeys((String)object, list, config);
                }
            }
            if (config.getRanges().contains((Object)SyncRange.KeywordHighlights)) {
                Object object8 = (JsonElement)json.get((Object)"KeywordHighlights");
                if (object8 != null && (object8 = JsonElementKt.getJsonPrimitive((JsonElement)object8)) != null && (object8 = object8.getContent()) != null) {
                    it = object8;
                    boolean bl = false;
                    Iterable $this$filter$iv = deletedData;
                    object = it;
                    webDAVSyncer = this;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        e = (DeletedData)element$iv$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)e.getType(), (Object)"KeywordHighlight")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    webDAVSyncer.decodeKeywordHighlights((String)object, list, config);
                }
            }
            if (config.getRanges().contains((Object)SyncRange.Macros)) {
                Object object9 = (JsonElement)json.get((Object)"Macros");
                if (object9 != null && (object9 = JsonElementKt.getJsonPrimitive((JsonElement)object9)) != null && (object9 = object9.getContent()) != null) {
                    it = object9;
                    boolean bl = false;
                    Iterable $this$filter$iv = deletedData;
                    object = it;
                    webDAVSyncer = this;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        e = (DeletedData)element$iv$iv;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual((Object)e.getType(), (Object)"Macro")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    webDAVSyncer.decodeMacros((String)object, list, config);
                }
            }
            if (config.getRanges().contains((Object)SyncRange.Keymap)) {
                Object object10 = (JsonElement)json.get((Object)"Keymaps");
                if (object10 != null && (object10 = JsonElementKt.getJsonPrimitive((JsonElement)object10)) != null && (object10 = object10.getContent()) != null) {
                    it = object10;
                    boolean bl = false;
                    Iterable $this$filter$iv = deletedData;
                    object = it;
                    webDAVSyncer = this;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        e = (DeletedData)element$iv$iv;
                        boolean bl7 = false;
                        if (!Intrinsics.areEqual((Object)e.getType(), (Object)"Keymap")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    webDAVSyncer.decodeKeymaps((String)object, list, config);
                }
            }
            if (!config.getRanges().contains((Object)SyncRange.Snippets)) break block34;
            Object object11 = (JsonElement)json.get((Object)"Snippets");
            if (object11 != null && (object11 = JsonElementKt.getJsonPrimitive((JsonElement)object11)) != null && (object11 = object11.getContent()) != null) {
                it = object11;
                boolean bl = false;
                Iterable $this$filter$iv = deletedData;
                object = it;
                webDAVSyncer = this;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    e = (DeletedData)element$iv$iv;
                    boolean bl8 = false;
                    if (!Intrinsics.areEqual((Object)e.getType(), (Object)"Snippet")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                webDAVSyncer.decodeSnippets((String)object, list, config);
            }
        }
        return new GistResponse(config, CollectionsKt.emptyList());
    }

    @Override
    @NotNull
    public GistResponse push(@NotNull SyncConfig config) {
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        byte[] key = this.getKey(config);
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$push_u24lambda_u2415 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        if (config.getRanges().contains((Object)SyncRange.Hosts)) {
            String hostsContent = this.encodeHosts(key);
            if (log.isDebugEnabled()) {
                log.debug("Push encryptedHosts: {}", (Object)hostsContent);
            }
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$push_u24lambda_u2415, (String)"Hosts", (String)hostsContent);
        }
        if (config.getRanges().contains((Object)SyncRange.Snippets)) {
            String snippetsContent = this.encodeSnippets(key);
            if (log.isDebugEnabled()) {
                log.debug("Push encryptedSnippets: {}", (Object)snippetsContent);
            }
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$push_u24lambda_u2415, (String)"Snippets", (String)snippetsContent);
        }
        if (config.getRanges().contains((Object)SyncRange.KeyPairs)) {
            String keysContent = this.encodeKeys(key);
            if (log.isDebugEnabled()) {
                log.debug("Push encryptedKeys: {}", (Object)keysContent);
            }
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$push_u24lambda_u2415, (String)"KeyPairs", (String)keysContent);
        }
        if (config.getRanges().contains((Object)SyncRange.KeywordHighlights)) {
            String keywordHighlightsContent = this.encodeKeywordHighlights(key);
            if (log.isDebugEnabled()) {
                log.debug("Push keywordHighlights: {}", (Object)keywordHighlightsContent);
            }
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$push_u24lambda_u2415, (String)"KeywordHighlights", (String)keywordHighlightsContent);
        }
        if (config.getRanges().contains((Object)SyncRange.Macros)) {
            String macrosContent = this.encodeMacros(key);
            if (log.isDebugEnabled()) {
                log.debug("Push macros: {}", (Object)macrosContent);
            }
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$push_u24lambda_u2415, (String)"Macros", (String)macrosContent);
        }
        if (config.getRanges().contains((Object)SyncRange.Keymap)) {
            String keymapsContent = this.encodeKeymaps();
            if (log.isDebugEnabled()) {
                log.debug("Push keymaps: {}", (Object)keymapsContent);
            }
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$push_u24lambda_u2415, (String)"Keymaps", (String)keymapsContent);
        }
        String deletedData = this.encodeDeletedData(config);
        if (log.isDebugEnabled()) {
            log.debug("Push DeletedData: {}", (Object)deletedData);
        }
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$push_u24lambda_u2415, (String)"DeletedData", (String)deletedData);
        JsonObject json = builder$iv.build();
        OkHttpClient okHttpClient = this.getHttpClient();
        Request.Builder builder2 = this.newRequestBuilder(config);
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        Response response = okHttpClient.newCall(builder2.put(RequestBody.Companion.create(this_$iv.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)json), MediaType.Companion.get("application/json"))).build()).execute();
        if (!response.isSuccessful()) {
            throw new ResponseException(response.code(), response);
        }
        return new GistResponse(config, CollectionsKt.emptyList());
    }

    private final String getWebDavFileUrl(SyncConfig config) {
        String string = config.getOptions().get("domain");
        if (string == null) {
            throw new IllegalStateException("domain is not defined");
        }
        return string;
    }

    @Override
    @NotNull
    protected byte[] getKey(@NotNull SyncConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        char[] cArray = config.getGistId().toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        String string = config.getToken();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return PBKDF2.INSTANCE.generateSecret(cArray, byArray, 10000, 128);
    }

    private final Request.Builder newRequestBuilder(SyncConfig config) {
        return new Request.Builder().header("Authorization", Credentials.basic((String)config.getGistId(), (String)config.getToken(), (Charset)Charsets.UTF_8)).url(this.getWebDavFileUrl(config));
    }

    public /* synthetic */ WebDAVSyncer(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/sync/WebDAVSyncer$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/sync/WebDAVSyncer;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WebDAVSyncer getInstance() {
            return (WebDAVSyncer)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(WebDAVSyncer.class), Companion::getInstance$lambda$0);
        }

        private static final WebDAVSyncer getInstance$lambda$0() {
            return new WebDAVSyncer(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

