/*
 * Decompiled with CFR 0.152.
 */
package app.termora.sync;

import app.termora.ApplicationScope;
import app.termora.Database;
import app.termora.Disposable;
import app.termora.sync.GistResponse;
import app.termora.sync.GitHubSyncer;
import app.termora.sync.GitLabSyncer;
import app.termora.sync.GiteeSyncer;
import app.termora.sync.SyncConfig;
import app.termora.sync.SyncRange;
import app.termora.sync.SyncType;
import app.termora.sync.Syncer;
import app.termora.sync.WebDAVSyncer;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.random.Random;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001b2\u00020\u0001:\u0003\u001b\u001c\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0010J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0004\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u001a\u001a\u00020\u0010H\u0016R\u0018\u0010\u0004\u001a\u00060\u0005R\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lapp/termora/sync/SyncManager;", "Lapp/termora/Disposable;", "<init>", "()V", "sync", "Lapp/termora/Database$Sync;", "Lapp/termora/Database;", "getSync", "()Lapp/termora/Database$Sync;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "job", "Lkotlinx/coroutines/Job;", "disableTrigger", "", "trigger", "", "triggerOnChanged", "config", "Lapp/termora/sync/SyncConfig;", "Lapp/termora/sync/SyncManager$SyncResponse;", "getSyncConfig", "syncImmediately", "pull", "Lapp/termora/sync/GistResponse;", "push", "dispose", "Companion", "SyncerProvider", "SyncResponse", "termora"})
public final class SyncManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getIO()));
    @Nullable
    private Job job;
    private boolean disableTrigger;
    private static final Logger log = LoggerFactory.getLogger(SyncManager.class);

    private SyncManager() {
    }

    private final Database.Sync getSync() {
        return Database.Companion.getDatabase().getSync();
    }

    private final void trigger() {
        this.trigger(this.getSyncConfig());
    }

    public final void triggerOnChanged() {
        if (Intrinsics.areEqual((Object)this.getSync().getPolicy(), (Object)"OnChange")) {
            this.trigger();
        }
    }

    private final void trigger(SyncConfig config) {
        if (this.disableTrigger) {
            return;
        }
        Job job = this.job;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        if (log.isInfoEnabled()) {
            log.info("Automatic synchronisation is interrupted");
        }
        this.job = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, config, null){
            int label;
            final /* synthetic */ SyncManager this$0;
            final /* synthetic */ SyncConfig $config;
            {
                this.this$0 = $receiver;
                this.$config = $config;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        seconds = Random.Default.nextInt(10, 30);
                        if (SyncManager.access$getLog$cp().isInfoEnabled()) {
                            SyncManager.access$getLog$cp().info("Trigger synchronisation, which will take place after {} seconds", (Object)Boxing.boxInt((int)seconds));
                        }
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)var2_3, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if (SyncManager.access$getDisableTrigger$p(this.this$0)) ** GOTO lbl32
                        try {
                            if (SyncManager.access$getLog$cp().isInfoEnabled()) {
                                SyncManager.access$getLog$cp().info("Automatic synchronisation begin");
                            }
                            SyncManager.access$setJob$p(this.this$0, null);
                            this.this$0.sync(this.$config);
                            SyncManager.access$getSync(this.this$0).setLastSyncTime(System.currentTimeMillis());
                            if (SyncManager.access$getLog$cp().isInfoEnabled()) {
                                SyncManager.access$getLog$cp().info("Automatic synchronisation end");
                            }
                        }
                        catch (Exception e) {
                            if (!SyncManager.access$getLog$cp().isErrorEnabled()) ** GOTO lbl32
                            SyncManager.access$getLog$cp().error(e.getMessage(), (Throwable)e);
                        }
lbl32:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final SyncResponse sync(@NotNull SyncConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return this.syncImmediately(config);
    }

    private final SyncConfig getSyncConfig() {
        Set range = new LinkedHashSet();
        if (this.getSync().getRangeHosts()) {
            range.add(SyncRange.Hosts);
        }
        if (this.getSync().getRangeKeyPairs()) {
            range.add(SyncRange.KeyPairs);
        }
        if (this.getSync().getRangeKeywordHighlights()) {
            range.add(SyncRange.KeywordHighlights);
        }
        if (this.getSync().getRangeMacros()) {
            range.add(SyncRange.Macros);
        }
        if (this.getSync().getRangeKeymap()) {
            range.add(SyncRange.Keymap);
        }
        if (this.getSync().getRangeSnippets()) {
            range.add(SyncRange.Snippets);
        }
        return new SyncConfig(this.getSync().getType(), this.getSync().getToken(), this.getSync().getGist(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"domain", (Object)this.getSync().getDomain())), range);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SyncResponse syncImmediately(SyncConfig config) {
        SyncManager syncManager = this;
        synchronized (syncManager) {
            boolean bl = false;
            SyncResponse syncResponse = new SyncResponse(this.pull(config), this.push(config));
            return syncResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final GistResponse pull(@NotNull SyncConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        SyncManager syncManager = this;
        synchronized (syncManager) {
            GistResponse gistResponse;
            boolean bl = false;
            this.disableTrigger = true;
            try {
                GistResponse gistResponse2 = SyncerProvider.Companion.getInstance().getSyncer(config.getType()).pull(config);
                this.disableTrigger = false;
                gistResponse = gistResponse2;
            }
            catch (Throwable throwable) {
                this.disableTrigger = false;
                throw throwable;
            }
            return gistResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final GistResponse push(@NotNull SyncConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        SyncManager syncManager = this;
        synchronized (syncManager) {
            GistResponse gistResponse;
            boolean bl = false;
            try {
                this.disableTrigger = true;
                GistResponse gistResponse2 = SyncerProvider.Companion.getInstance().getSyncer(config.getType()).push(config);
                this.disableTrigger = false;
                gistResponse = gistResponse2;
            }
            catch (Throwable throwable) {
                this.disableTrigger = false;
                throw throwable;
            }
            return gistResponse;
        }
    }

    @Override
    public void dispose() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
    }

    public /* synthetic */ SyncManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ boolean access$getDisableTrigger$p(SyncManager $this) {
        return $this.disableTrigger;
    }

    public static final /* synthetic */ void access$setJob$p(SyncManager $this, Job job) {
        $this.job = job;
    }

    public static final /* synthetic */ Database.Sync access$getSync(SyncManager $this) {
        return $this.getSync();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/sync/SyncManager$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/sync/SyncManager;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SyncManager getInstance() {
            return (SyncManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(SyncManager.class), Companion::getInstance$lambda$0);
        }

        private static final SyncManager getInstance$lambda$0() {
            return new SyncManager(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lapp/termora/sync/SyncManager$SyncResponse;", "", "pull", "Lapp/termora/sync/GistResponse;", "push", "<init>", "(Lapp/termora/sync/GistResponse;Lapp/termora/sync/GistResponse;)V", "getPull", "()Lapp/termora/sync/GistResponse;", "getPush", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "termora"})
    public static final class SyncResponse {
        @NotNull
        private final GistResponse pull;
        @NotNull
        private final GistResponse push;

        public SyncResponse(@NotNull GistResponse pull, @NotNull GistResponse push) {
            Intrinsics.checkNotNullParameter((Object)pull, (String)"pull");
            Intrinsics.checkNotNullParameter((Object)push, (String)"push");
            this.pull = pull;
            this.push = push;
        }

        @NotNull
        public final GistResponse getPull() {
            return this.pull;
        }

        @NotNull
        public final GistResponse getPush() {
            return this.push;
        }

        @NotNull
        public final GistResponse component1() {
            return this.pull;
        }

        @NotNull
        public final GistResponse component2() {
            return this.push;
        }

        @NotNull
        public final SyncResponse copy(@NotNull GistResponse pull, @NotNull GistResponse push) {
            Intrinsics.checkNotNullParameter((Object)pull, (String)"pull");
            Intrinsics.checkNotNullParameter((Object)push, (String)"push");
            return new SyncResponse(pull, push);
        }

        public static /* synthetic */ SyncResponse copy$default(SyncResponse syncResponse, GistResponse gistResponse, GistResponse gistResponse2, int n, Object object) {
            if ((n & 1) != 0) {
                gistResponse = syncResponse.pull;
            }
            if ((n & 2) != 0) {
                gistResponse2 = syncResponse.push;
            }
            return syncResponse.copy(gistResponse, gistResponse2);
        }

        @NotNull
        public String toString() {
            return "SyncResponse(pull=" + this.pull + ", push=" + this.push + ")";
        }

        public int hashCode() {
            int result = this.pull.hashCode();
            result = result * 31 + this.push.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SyncResponse)) {
                return false;
            }
            SyncResponse syncResponse = (SyncResponse)other;
            if (!Intrinsics.areEqual((Object)this.pull, (Object)syncResponse.pull)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.push, (Object)syncResponse.push);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lapp/termora/sync/SyncManager$SyncerProvider;", "", "<init>", "()V", "getSyncer", "Lapp/termora/sync/Syncer;", "type", "Lapp/termora/sync/SyncType;", "Companion", "termora"})
    private static final class SyncerProvider {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private SyncerProvider() {
        }

        @NotNull
        public final Syncer getSyncer(@NotNull SyncType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1 -> GitHubSyncer.Companion.getInstance();
                case 2 -> GiteeSyncer.Companion.getInstance();
                case 3 -> GitLabSyncer.Companion.getInstance();
                case 4 -> WebDAVSyncer.Companion.getInstance();
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ SyncerProvider(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lapp/termora/sync/SyncManager$SyncerProvider$Companion;", "", "<init>", "()V", "getInstance", "Lapp/termora/sync/SyncManager$SyncerProvider;", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final SyncerProvider getInstance() {
                return (SyncerProvider)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(SyncerProvider.class), Companion::getInstance$lambda$0);
            }

            private static final SyncerProvider getInstance$lambda$0() {
                return new SyncerProvider(null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SyncType.values().length];
                try {
                    nArray[SyncType.GitHub.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SyncType.Gitee.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SyncType.GitLab.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SyncType.WebDAV.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

