/*
 * Decompiled with CFR 0.152.
 */
package app.termora.sync;

import app.termora.AES;
import app.termora.Application;
import app.termora.Authentication;
import app.termora.DeleteDataManager;
import app.termora.DeletedData;
import app.termora.EncryptedHost;
import app.termora.Host;
import app.termora.HostManager;
import app.termora.Options;
import app.termora.Protocol;
import app.termora.Proxy;
import app.termora.Tunneling;
import app.termora.highlight.KeywordHighlight;
import app.termora.highlight.KeywordHighlightManager;
import app.termora.keymap.Keymap;
import app.termora.keymap.KeymapManager;
import app.termora.keymgr.KeyManager;
import app.termora.keymgr.OhKeyPair;
import app.termora.macro.Macro;
import app.termora.macro.MacroManager;
import app.termora.snippet.Snippet;
import app.termora.snippet.SnippetManager;
import app.termora.sync.SyncConfig;
import app.termora.sync.Syncer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonObject;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0011\b&\u0018\u0000 B2\u00020\u0001:\u0001BB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/H\u0004J\u0010\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u000202H\u0004J\u0010\u00103\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/H\u0004J\u001e\u00104\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/H\u0004J&\u00105\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/H\u0004J\u0010\u00106\u001a\u00020\u00052\u0006\u00101\u001a\u000202H\u0004J&\u00107\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/H\u0004J\u0010\u00108\u001a\u00020\u00052\u0006\u00101\u001a\u000202H\u0004J&\u00109\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/H\u0004J\u0010\u0010:\u001a\u00020\u00052\u0006\u00101\u001a\u000202H\u0004J&\u0010;\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/H\u0004J\u0010\u0010<\u001a\u00020\u00052\u0006\u00101\u001a\u000202H\u0004J&\u0010=\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/H\u0004J\b\u0010>\u001a\u00020\u0005H\u0004J\u0010\u0010?\u001a\u0002022\u0006\u0010.\u001a\u00020/H\u0014J\u0010\u0010@\u001a\u0002022\u0006\u0010A\u001a\u00020\u0005H\u0004R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006C"}, d2={"Lapp/termora/sync/SafetySyncer;", "Lapp/termora/sync/Syncer;", "<init>", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "httpClient", "Lokhttp3/OkHttpClient;", "getHttpClient", "()Lokhttp3/OkHttpClient;", "hostManager", "Lapp/termora/HostManager;", "getHostManager", "()Lapp/termora/HostManager;", "keyManager", "Lapp/termora/keymgr/KeyManager;", "getKeyManager", "()Lapp/termora/keymgr/KeyManager;", "keywordHighlightManager", "Lapp/termora/highlight/KeywordHighlightManager;", "getKeywordHighlightManager", "()Lapp/termora/highlight/KeywordHighlightManager;", "macroManager", "Lapp/termora/macro/MacroManager;", "getMacroManager", "()Lapp/termora/macro/MacroManager;", "keymapManager", "Lapp/termora/keymap/KeymapManager;", "getKeymapManager", "()Lapp/termora/keymap/KeymapManager;", "snippetManager", "Lapp/termora/snippet/SnippetManager;", "getSnippetManager", "()Lapp/termora/snippet/SnippetManager;", "deleteDataManager", "Lapp/termora/DeleteDataManager;", "getDeleteDataManager", "()Lapp/termora/DeleteDataManager;", "decodeHosts", "", "text", "deletedData", "", "Lapp/termora/DeletedData;", "config", "Lapp/termora/sync/SyncConfig;", "encodeHosts", "key", "", "encodeDeletedData", "decodeDeletedData", "decodeSnippets", "encodeSnippets", "decodeKeys", "encodeKeys", "decodeKeywordHighlights", "encodeKeywordHighlights", "decodeMacros", "encodeMacros", "decodeKeymaps", "encodeKeymaps", "getKey", "getIv", "id", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nSafetySyncer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SafetySyncer.kt\napp/termora/sync/SafetySyncer\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,437:1\n222#2:438\n222#2:445\n222#2:446\n222#2:447\n222#2:448\n205#2:449\n205#2:450\n205#2:451\n205#2:452\n205#2:453\n205#2:454\n222#2:455\n222#2:456\n205#2:463\n222#2:464\n205#2:471\n222#2:472\n205#2:479\n222#2:480\n205#2:487\n222#2:494\n205#2:508\n1208#3,2:439\n1236#3,4:441\n1208#3,2:457\n1236#3,4:459\n1208#3,2:465\n1236#3,4:467\n1208#3,2:473\n1236#3,4:475\n1208#3,2:481\n1236#3,4:483\n1208#3,2:488\n1236#3,4:490\n1617#3,9:495\n1869#3:504\n1870#3:506\n1626#3:507\n1869#3,2:509\n1869#3,2:511\n1869#3,2:513\n1869#3,2:515\n1869#3,2:517\n1869#3,2:519\n1#4:505\n*S KotlinDebug\n*F\n+ 1 SafetySyncer.kt\napp/termora/sync/SafetySyncer\n*L\n42#1:438\n69#1:445\n72#1:446\n75#1:447\n78#1:448\n121#1:449\n123#1:450\n125#1:451\n127#1:452\n137#1:453\n142#1:454\n146#1:455\n155#1:456\n209#1:463\n216#1:464\n277#1:471\n283#1:472\n333#1:479\n339#1:480\n388#1:487\n394#1:494\n427#1:508\n43#1:439,2\n43#1:441,4\n156#1:457,2\n156#1:459,4\n217#1:465,2\n217#1:467,4\n284#1:473,2\n284#1:475,4\n340#1:481,2\n340#1:483,4\n393#1:488,2\n393#1:490,4\n394#1:495,9\n394#1:504\n394#1:506\n394#1:507\n97#1:509,2\n185#1:511,2\n249#1:513,2\n311#1:515,2\n366#1:517,2\n406#1:519,2\n394#1:505\n*E\n"})
public abstract class SafetySyncer
implements Syncer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String description = Application.INSTANCE.getName() + " config";
    private static final Logger log = LoggerFactory.getLogger(SafetySyncer.class);

    @NotNull
    protected final String getDescription() {
        return this.description;
    }

    @NotNull
    protected final OkHttpClient getHttpClient() {
        return Application.INSTANCE.getHttpClient();
    }

    @NotNull
    protected final HostManager getHostManager() {
        return HostManager.Companion.getInstance();
    }

    @NotNull
    protected final KeyManager getKeyManager() {
        return KeyManager.Companion.getInstance();
    }

    @NotNull
    protected final KeywordHighlightManager getKeywordHighlightManager() {
        return KeywordHighlightManager.Companion.getInstance();
    }

    @NotNull
    protected final MacroManager getMacroManager() {
        return MacroManager.Companion.getInstance();
    }

    @NotNull
    protected final KeymapManager getKeymapManager() {
        return KeymapManager.Companion.getInstance();
    }

    @NotNull
    protected final SnippetManager getSnippetManager() {
        return SnippetManager.Companion.getInstance();
    }

    @NotNull
    protected final DeleteDataManager getDeleteDataManager() {
        return DeleteDataManager.Companion.getInstance();
    }

    /*
     * WARNING - void declaration
     */
    protected final void decodeHosts(@NotNull String text, @NotNull List<DeletedData> deletedData, @NotNull SyncConfig config) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(deletedData, (String)"deletedData");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        byte[] key = this.getKey(config);
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        List encryptedHosts = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(EncryptedHost.Companion.serializer()), text);
        Iterable $this$associateBy$iv = this.getHostManager().hosts();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Host host = (Host)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv);
        }
        Map hosts = destination$iv$iv;
        for (EncryptedHost encryptedHost : encryptedHosts) {
            Host oldHost = (Host)hosts.get(encryptedHost.getId());
            if (oldHost != null && oldHost.getUpdateDate() >= encryptedHost.getUpdateDate()) continue;
            try {
                String string$iv;
                Json this_$iv2;
                byte[] iv = this.getIv(encryptedHost.getId());
                String string = encryptedHost.getId();
                String string2 = StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedHost.getName()), key, iv));
                Protocol protocol = Protocol.valueOf(StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedHost.getProtocol()), key, iv)));
                String string3 = StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedHost.getHost()), key, iv));
                Integer n = StringsKt.toIntOrNull((String)StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedHost.getPort()), key, iv)));
                int n2 = n != null ? n : 0;
                String string4 = StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedHost.getUsername()), key, iv));
                String string5 = StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedHost.getRemark()), key, iv));
                Json $i$f$associateByTo2 = Application.INSTANCE.getOhMyJson();
                String string6 = StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedHost.getAuthentication()), key, iv));
                boolean $i$f$decodeFromString2 = false;
                this_$iv2.getSerializersModule();
                Authentication authentication = (Authentication)this_$iv2.decodeFromString((DeserializationStrategy)Authentication.Companion.serializer(), string$iv);
                this_$iv2 = Application.INSTANCE.getOhMyJson();
                string$iv = StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedHost.getProxy()), key, iv));
                $i$f$decodeFromString2 = false;
                this_$iv2.getSerializersModule();
                Proxy proxy = (Proxy)this_$iv2.decodeFromString((DeserializationStrategy)Proxy.Companion.serializer(), string$iv);
                this_$iv2 = Application.INSTANCE.getOhMyJson();
                string$iv = StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedHost.getOptions()), key, iv));
                $i$f$decodeFromString2 = false;
                this_$iv2.getSerializersModule();
                Options options = (Options)this_$iv2.decodeFromString((DeserializationStrategy)Options.Companion.serializer(), string$iv);
                this_$iv2 = Application.INSTANCE.getOhMyJson();
                string$iv = StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedHost.getTunnelings()), key, iv));
                $i$f$decodeFromString2 = false;
                this_$iv2.getSerializersModule();
                Host host = new Host(string, string2, protocol, string3, n2, string4, string5, authentication, proxy, options, (List)this_$iv2.decodeFromString((DeserializationStrategy)new ArrayListSerializer(Tunneling.Companion.serializer()), string$iv), encryptedHost.getSort(), StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedHost.getParentId()), key, iv)), StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedHost.getOwnerId()), key, iv)), StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedHost.getCreatorId()), key, iv)), encryptedHost.getCreateDate(), encryptedHost.getUpdateDate(), false, 131072, null);
                SwingUtilities.invokeLater(() -> SafetySyncer.decodeHosts$lambda$1(this, host));
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                log.warn("Decode host: " + encryptedHost.getId() + " failed. error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        SwingUtilities.invokeLater(() -> SafetySyncer.decodeHosts$lambda$3(deletedData, this));
        if (log.isDebugEnabled()) {
            log.debug("Decode hosts: {}", (Object)text);
        }
    }

    @NotNull
    protected final String encodeHosts(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        List encryptedHosts = new ArrayList();
        for (Host host : this.getHostManager().hosts()) {
            Json this_$iv;
            String string = StringsKt.padEnd((String)host.getId(), (int)16, (char)'0');
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] iv = ArrayUtils.subarray((byte[])byArray, (int)0, (int)16);
            EncryptedHost encryptedHost = new EncryptedHost(null, null, null, null, null, null, null, null, null, null, null, 0L, false, null, null, null, 0L, 0L, 262143, null);
            encryptedHost.setId(host.getId());
            String string2 = host.getName();
            Intrinsics.checkNotNull((Object)iv);
            encryptedHost.setName(AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(string2, key, iv)));
            encryptedHost.setProtocol(AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(host.getProtocol().name(), key, iv)));
            encryptedHost.setHost(AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(host.getHost(), key, iv)));
            encryptedHost.setPort(AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(String.valueOf(host.getPort()), key, iv)));
            encryptedHost.setUsername(AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(host.getUsername(), key, iv)));
            encryptedHost.setRemark(AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(host.getRemark(), key, iv)));
            Json json = Application.INSTANCE.getOhMyJson();
            List<Tunneling> value$iv = host.getAuthentication();
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            encryptedHost.setAuthentication(AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(this_$iv.encodeToString((SerializationStrategy)Authentication.Companion.serializer(), (Object)value$iv), key, iv)));
            this_$iv = Application.INSTANCE.getOhMyJson();
            value$iv = host.getProxy();
            $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            encryptedHost.setProxy(AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(this_$iv.encodeToString((SerializationStrategy)Proxy.Companion.serializer(), (Object)value$iv), key, iv)));
            this_$iv = Application.INSTANCE.getOhMyJson();
            value$iv = host.getOptions();
            $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            encryptedHost.setOptions(AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(this_$iv.encodeToString((SerializationStrategy)Options.Companion.serializer(), (Object)value$iv), key, iv)));
            this_$iv = Application.INSTANCE.getOhMyJson();
            value$iv = host.getTunnelings();
            $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            encryptedHost.setTunnelings(AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(Tunneling.Companion.serializer()), value$iv), key, iv)));
            encryptedHost.setSort(host.getSort());
            encryptedHost.setParentId(AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(host.getParentId(), key, iv)));
            encryptedHost.setOwnerId(AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(host.getOwnerId(), key, iv)));
            encryptedHost.setCreatorId(AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(host.getCreatorId(), key, iv)));
            encryptedHost.setCreateDate(host.getCreateDate());
            encryptedHost.setUpdateDate(host.getUpdateDate());
            encryptedHosts.add(encryptedHost);
        }
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        return this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(EncryptedHost.Companion.serializer()), (Object)encryptedHosts);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final String encodeDeletedData(@NotNull SyncConfig config) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Json json = Application.INSTANCE.getOhMyJson();
        List<DeletedData> value$iv = this.getDeleteDataManager().getDeletedData();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        return this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(DeletedData.Companion.serializer()), value$iv);
    }

    @NotNull
    protected final List<DeletedData> decodeDeletedData(@NotNull String text, @NotNull SyncConfig config) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        List deletedData = CollectionsKt.toMutableList((Collection)((Collection)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(DeletedData.Companion.serializer()), text)));
        deletedData.addAll((Collection)this.getDeleteDataManager().getDeletedData());
        return deletedData;
    }

    /*
     * WARNING - void declaration
     */
    protected final void decodeSnippets(@NotNull String text, @NotNull List<DeletedData> deletedData, @NotNull SyncConfig config) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(deletedData, (String)"deletedData");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        byte[] key = this.getKey(config);
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        List encryptedSnippets = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(Snippet.Companion.serializer()), text);
        Iterable $this$associateBy$iv = this.getSnippetManager().snippets();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Snippet snippet = (Snippet)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv);
        }
        Map snippets = destination$iv$iv;
        for (Snippet encryptedSnippet : encryptedSnippets) {
            Snippet oldHost = (Snippet)snippets.get(encryptedSnippet.getId());
            if (oldHost != null && oldHost.getUpdateDate() >= encryptedSnippet.getUpdateDate()) continue;
            try {
                byte[] iv = this.getIv(encryptedSnippet.getId());
                String string = StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedSnippet.getName()), key, iv));
                String string2 = StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedSnippet.getParentId()), key, iv));
                String string3 = StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedSnippet.getSnippet()), key, iv));
                Snippet snippet = Snippet.copy$default(encryptedSnippet, null, string, string3, string2, null, false, 0L, 0L, 0L, 497, null);
                SwingUtilities.invokeLater(() -> SafetySyncer.decodeSnippets$lambda$5(this, snippet));
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                log.warn("Decode snippet: " + encryptedSnippet.getId() + " failed. error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        SwingUtilities.invokeLater(() -> SafetySyncer.decodeSnippets$lambda$7(deletedData, this));
        if (log.isDebugEnabled()) {
            log.debug("Decode Snippets: {}", (Object)text);
        }
    }

    @NotNull
    protected final String encodeSnippets(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        List snippets = new ArrayList();
        for (Snippet snippet : this.getSnippetManager().snippets()) {
            String string = StringsKt.padEnd((String)snippet.getId(), (int)16, (char)'0');
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] iv = ArrayUtils.subarray((byte[])byArray, (int)0, (int)16);
            String string2 = snippet.getName();
            Intrinsics.checkNotNull((Object)iv);
            snippets.add(Snippet.copy$default(snippet, null, AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(string2, key, iv)), AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(snippet.getSnippet(), key, iv)), AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(snippet.getParentId(), key, iv)), null, false, 0L, 0L, 0L, 497, null));
        }
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        return this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(Snippet.Companion.serializer()), (Object)snippets);
    }

    /*
     * WARNING - void declaration
     */
    protected final void decodeKeys(@NotNull String text, @NotNull List<DeletedData> deletedData, @NotNull SyncConfig config) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(deletedData, (String)"deletedData");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        byte[] key = this.getKey(config);
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        List encryptedKeys = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(OhKeyPair.Companion.serializer()), text);
        Iterable $this$associateBy$iv = this.getKeyManager().getOhKeyPairs();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            OhKeyPair ohKeyPair = (OhKeyPair)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv);
        }
        Map keys = destination$iv$iv;
        for (OhKeyPair encryptedKey : encryptedKeys) {
            OhKeyPair k = (OhKeyPair)keys.get(encryptedKey.getId());
            if (k != null && k.getUpdateDate() > encryptedKey.getUpdateDate()) continue;
            try {
                byte[] iv = this.getIv(encryptedKey.getId());
                OhKeyPair keyPair = new OhKeyPair(encryptedKey.getId(), AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedKey.getPublicKey()), key, iv)), AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedKey.getPrivateKey()), key, iv)), StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedKey.getType()), key, iv)), StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedKey.getName()), key, iv)), StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(encryptedKey.getRemark()), key, iv)), encryptedKey.getLength(), encryptedKey.getSort(), 0L, 256, null);
                SwingUtilities.invokeLater(() -> SafetySyncer.decodeKeys$lambda$9(this, keyPair));
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                log.warn("Decode key: " + encryptedKey.getId() + " failed. error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        SwingUtilities.invokeLater(() -> SafetySyncer.decodeKeys$lambda$11(deletedData, this));
        if (log.isDebugEnabled()) {
            log.debug("Decode keys: {}", (Object)text);
        }
    }

    @NotNull
    protected final String encodeKeys(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        List encryptedKeys = new ArrayList();
        for (OhKeyPair keyPair : this.getKeyManager().getOhKeyPairs()) {
            String string = StringsKt.padEnd((String)keyPair.getId(), (int)16, (char)'0');
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] iv = ArrayUtils.subarray((byte[])byArray, (int)0, (int)16);
            String string2 = keyPair.getId();
            byte[] byArray2 = AES.INSTANCE.decodeBase64(keyPair.getPublicKey());
            Intrinsics.checkNotNull((Object)iv);
            OhKeyPair encryptedKeyPair = new OhKeyPair(string2, AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(byArray2, key, iv)), AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(AES.INSTANCE.decodeBase64(keyPair.getPrivateKey()), key, iv)), AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(keyPair.getType(), key, iv)), AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(keyPair.getName(), key, iv)), AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(keyPair.getRemark(), key, iv)), keyPair.getLength(), keyPair.getSort(), 0L, 256, null);
            encryptedKeys.add(encryptedKeyPair);
        }
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        return this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(OhKeyPair.Companion.serializer()), (Object)encryptedKeys);
    }

    /*
     * WARNING - void declaration
     */
    protected final void decodeKeywordHighlights(@NotNull String text, @NotNull List<DeletedData> deletedData, @NotNull SyncConfig config) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(deletedData, (String)"deletedData");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        byte[] key = this.getKey(config);
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        List encryptedKeywordHighlights = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(KeywordHighlight.Companion.serializer()), text);
        Iterable $this$associateBy$iv = this.getKeywordHighlightManager().getKeywordHighlights();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            KeywordHighlight keywordHighlight = (KeywordHighlight)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv);
        }
        Map keywordHighlights = destination$iv$iv;
        for (KeywordHighlight e : encryptedKeywordHighlights) {
            KeywordHighlight keywordHighlight = (KeywordHighlight)keywordHighlights.get(e.getId());
            if (keywordHighlight != null && keywordHighlight.getUpdateDate() >= e.getUpdateDate()) continue;
            try {
                byte[] iv = this.getIv(e.getId());
                this.getKeywordHighlightManager().addKeywordHighlight(KeywordHighlight.copy$default(e, null, StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(e.getKeyword()), key, iv)), StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(e.getDescription()), key, iv)), false, false, 0, 0, false, false, false, false, false, 0L, 0L, 16377, null));
            }
            catch (Exception ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn("Decode KeywordHighlight: " + e.getId() + " failed. error: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
        SwingUtilities.invokeLater(() -> SafetySyncer.decodeKeywordHighlights$lambda$14(deletedData, this));
        if (log.isDebugEnabled()) {
            log.debug("Decode KeywordHighlight: {}", (Object)text);
        }
    }

    @NotNull
    protected final String encodeKeywordHighlights(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        List keywordHighlights = new ArrayList();
        for (KeywordHighlight keywordHighlight : this.getKeywordHighlightManager().getKeywordHighlights()) {
            byte[] iv = this.getIv(keywordHighlight.getId());
            KeywordHighlight encryptedKeyPair = KeywordHighlight.copy$default(keywordHighlight, null, AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(keywordHighlight.getKeyword(), key, iv)), AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(keywordHighlight.getDescription(), key, iv)), false, false, 0, 0, false, false, false, false, false, 0L, 0L, 16377, null);
            keywordHighlights.add(encryptedKeyPair);
        }
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        return this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(KeywordHighlight.Companion.serializer()), (Object)keywordHighlights);
    }

    /*
     * WARNING - void declaration
     */
    protected final void decodeMacros(@NotNull String text, @NotNull List<DeletedData> deletedData, @NotNull SyncConfig config) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(deletedData, (String)"deletedData");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        byte[] key = this.getKey(config);
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        List encryptedMacros = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(Macro.Companion.serializer()), text);
        Iterable $this$associateBy$iv = this.getMacroManager().getMacros();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Macro macro = (Macro)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv);
        }
        Map macros = destination$iv$iv;
        for (Macro e : encryptedMacros) {
            Macro macro = (Macro)macros.get(e.getId());
            if (macro != null && macro.getUpdateDate() >= e.getUpdateDate()) continue;
            try {
                byte[] iv = this.getIv(e.getId());
                String string = StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(e.getName()), key, iv));
                String string2 = StringsKt.decodeToString((byte[])AES.CBC.INSTANCE.aesCBCDecrypt(AES.INSTANCE.decodeBase64(e.getMacro()), key, iv));
                this.getMacroManager().addMacro(Macro.copy$default(e, null, string2, string, 0L, 0L, 0L, 57, null));
            }
            catch (Exception ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn("Decode Macro: " + e.getId() + " failed. error: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
        SwingUtilities.invokeLater(() -> SafetySyncer.decodeMacros$lambda$17(deletedData, this));
        if (log.isDebugEnabled()) {
            log.debug("Decode Macros: {}", (Object)text);
        }
    }

    @NotNull
    protected final String encodeMacros(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        List macros = new ArrayList();
        for (Macro macro : this.getMacroManager().getMacros()) {
            byte[] iv = this.getIv(macro.getId());
            String string = AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(macro.getName(), key, iv));
            String string2 = AES.INSTANCE.encodeBase64String(AES.CBC.INSTANCE.aesCBCEncrypt(macro.getMacro(), key, iv));
            macros.add(Macro.copy$default(macro, null, string2, string, 0L, 0L, 0L, 57, null));
        }
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        return this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(Macro.Companion.serializer()), (Object)macros);
    }

    /*
     * WARNING - void declaration
     */
    protected final void decodeKeymaps(@NotNull String text, @NotNull List<DeletedData> deletedData, @NotNull SyncConfig config) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object object;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(deletedData, (String)"deletedData");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Iterable $this$associateBy$iv = this.getKeymapManager().getKeymaps();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            object = (Keymap)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        Map localKeymaps = destination$iv$iv;
        Object this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        this_$iv = (Iterable)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(JsonObject.Companion.serializer()), text);
        boolean $i$f$mapNotNull = false;
        $this$associateByTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Keymap it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            JsonObject it = (JsonObject)element$iv$iv;
            boolean bl2 = false;
            if (Keymap.Companion.fromJSON(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List remoteKeymaps = (List)destination$iv$iv;
        for (Keymap keymap : remoteKeymaps) {
            Keymap localKeymap = (Keymap)localKeymaps.get(keymap.getName());
            if (localKeymap != null && localKeymap.getUpdateDate() > keymap.getUpdateDate()) continue;
            this.getKeymapManager().addKeymap(keymap);
        }
        SwingUtilities.invokeLater(() -> SafetySyncer.decodeKeymaps$lambda$21(deletedData, this));
        if (log.isDebugEnabled()) {
            log.debug("Decode Keymaps: {}", (Object)text);
        }
    }

    @NotNull
    protected final String encodeKeymaps() {
        List keymaps = new ArrayList();
        for (Keymap keymap : this.getKeymapManager().getKeymaps()) {
            if (keymap.isReadonly()) continue;
            keymaps.add(keymap.toJSONObject());
        }
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        return this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(JsonObject.Companion.serializer()), (Object)keymaps);
    }

    @NotNull
    protected byte[] getKey(@NotNull SyncConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String string = StringsKt.padEnd((String)config.getToken(), (int)16, (char)'0');
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = ArrayUtils.subarray((byte[])byArray, (int)0, (int)16);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"subarray(...)");
        return byArray2;
    }

    @NotNull
    protected final byte[] getIv(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String string = StringsKt.padEnd((String)id, (int)16, (char)'0');
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = ArrayUtils.subarray((byte[])byArray, (int)0, (int)16);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"subarray(...)");
        return byArray2;
    }

    private static final void decodeHosts$lambda$1(SafetySyncer this$0, Host $host) {
        this$0.getHostManager().addHost($host);
    }

    private static final void decodeHosts$lambda$3(List $deletedData, SafetySyncer this$0) {
        Iterable $this$forEach$iv = $deletedData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeletedData it = (DeletedData)element$iv;
            boolean bl = false;
            this$0.getHostManager().removeHost(it.getId());
            this$0.getDeleteDataManager().removeHost(it.getId(), it.getDeleteDate());
        }
    }

    private static final void decodeSnippets$lambda$5(SafetySyncer this$0, Snippet $snippet) {
        this$0.getSnippetManager().addSnippet($snippet);
    }

    private static final void decodeSnippets$lambda$7(List $deletedData, SafetySyncer this$0) {
        Iterable $this$forEach$iv = $deletedData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeletedData it = (DeletedData)element$iv;
            boolean bl = false;
            this$0.getSnippetManager().removeSnippet(it.getId());
            this$0.getDeleteDataManager().removeSnippet(it.getId(), it.getDeleteDate());
        }
    }

    private static final void decodeKeys$lambda$9(SafetySyncer this$0, OhKeyPair $keyPair) {
        this$0.getKeyManager().addOhKeyPair($keyPair);
    }

    private static final void decodeKeys$lambda$11(List $deletedData, SafetySyncer this$0) {
        Iterable $this$forEach$iv = $deletedData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeletedData it = (DeletedData)element$iv;
            boolean bl = false;
            this$0.getKeyManager().removeOhKeyPair(it.getId());
            this$0.getDeleteDataManager().removeKeyPair(it.getId(), it.getDeleteDate());
        }
    }

    private static final void decodeKeywordHighlights$lambda$14(List $deletedData, SafetySyncer this$0) {
        Iterable $this$forEach$iv = $deletedData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeletedData it = (DeletedData)element$iv;
            boolean bl = false;
            this$0.getKeywordHighlightManager().removeKeywordHighlight(it.getId());
            this$0.getDeleteDataManager().removeKeywordHighlight(it.getId(), it.getDeleteDate());
        }
    }

    private static final void decodeMacros$lambda$17(List $deletedData, SafetySyncer this$0) {
        Iterable $this$forEach$iv = $deletedData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeletedData it = (DeletedData)element$iv;
            boolean bl = false;
            this$0.getMacroManager().removeMacro(it.getId());
            this$0.getDeleteDataManager().removeMacro(it.getId(), it.getDeleteDate());
        }
    }

    private static final void decodeKeymaps$lambda$21(List $deletedData, SafetySyncer this$0) {
        Iterable $this$forEach$iv = $deletedData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeletedData it = (DeletedData)element$iv;
            boolean bl = false;
            this$0.getKeymapManager().removeKeymap(it.getId());
            this$0.getDeleteDataManager().removeKeymap(it.getId(), it.getDeleteDate());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/sync/SafetySyncer$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

