/*
 * Decompiled with CFR 0.152.
 */
package app.termora.snippet;

import app.termora.Database;
import app.termora.DialogWrapper;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.I18n;
import app.termora.TreeUtils;
import app.termora.snippet.SnippetTree;
import app.termora.snippet.SnippetTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\b\u0010\u0018\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00060\tR\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lapp/termora/snippet/SnippetTreeDialog;", "Lapp/termora/DialogWrapper;", "owner", "Ljava/awt/Window;", "<init>", "(Ljava/awt/Window;)V", "snippetTree", "Lapp/termora/snippet/SnippetTree;", "properties", "Lapp/termora/Database$Properties;", "Lapp/termora/Database;", "getProperties", "()Lapp/termora/Database$Properties;", "lastNode", "Lapp/termora/snippet/SnippetTreeNode;", "getLastNode", "()Lapp/termora/snippet/SnippetTreeNode;", "setLastNode", "(Lapp/termora/snippet/SnippetTreeNode;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "doCancelAction", "", "doOKAction", "getSelectedNode", "termora"})
@SourceDebugExtension(value={"SMAP\nSnippetTreeDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnippetTreeDialog.kt\napp/termora/snippet/SnippetTreeDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class SnippetTreeDialog
extends DialogWrapper {
    @NotNull
    private final SnippetTree snippetTree;
    @Nullable
    private SnippetTreeNode lastNode;

    public SnippetTreeDialog(@NotNull Window owner) {
        String selectionRows;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(owner);
        this.snippetTree = new SnippetTree();
        this.setSize(new Dimension(360, 380));
        this.setTitle(I18n.INSTANCE.getString("termora.snippet.title"));
        this.setModal(true);
        this.setResizable(true);
        this.setControlsVisible(false);
        this.setLocationRelativeTo(null);
        this.init();
        this.snippetTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() % 2 == 0) {
                    SnippetTreeNode snippetTreeNode = snippetTree.getLastSelectedPathNode();
                    if (snippetTreeNode == null) {
                        return;
                    }
                    SnippetTreeNode node = snippetTreeNode;
                    if (node.isFolder()) {
                        return;
                    }
                    this.doOKAction();
                }
            }
        });
        Disposer.register(this.getDisposable(), new Disposable(){

            @Override
            public void dispose() {
                this.getProperties().putString("SnippetTreeDialog.Tree.expansionState", TreeUtils.INSTANCE.saveExpansionState((JTree)((Object)snippetTree)));
                this.getProperties().putString("SnippetTreeDialog.Tree.selectionRows", TreeUtils.INSTANCE.saveSelectionRows((JTree)((Object)snippetTree)));
            }
        });
        String expansionState = this.getProperties().getString("SnippetTreeDialog.Tree.expansionState", "");
        if (!StringsKt.isBlank((CharSequence)expansionState)) {
            TreeUtils.INSTANCE.loadExpansionState((JTree)((Object)this.snippetTree), expansionState);
        }
        if (!StringsKt.isBlank((CharSequence)(selectionRows = this.getProperties().getString("SnippetTreeDialog.Tree.selectionRows", "")))) {
            TreeUtils.INSTANCE.loadSelectionRows((JTree)((Object)this.snippetTree), selectionRows);
        }
    }

    private final Database.Properties getProperties() {
        return Database.Companion.getDatabase().getProperties();
    }

    @Nullable
    public final SnippetTreeNode getLastNode() {
        return this.lastNode;
    }

    public final void setLastNode(@Nullable SnippetTreeNode snippetTreeNode) {
        this.lastNode = snippetTreeNode;
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        JScrollPane jScrollPane;
        JScrollPane $this$createCenterPanel_u24lambda_u240 = jScrollPane = new JScrollPane((Component)((Object)this.snippetTree));
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u240.setBorder(BorderFactory.createEmptyBorder(0, 6, 6, 6));
        return jScrollPane;
    }

    @Override
    protected void doCancelAction() {
        this.lastNode = null;
        super.doCancelAction();
    }

    @Override
    protected void doOKAction() {
        SnippetTreeNode snippetTreeNode = this.snippetTree.getLastSelectedPathNode();
        if (snippetTreeNode == null) {
            return;
        }
        SnippetTreeNode node = snippetTreeNode;
        if (node.isFolder()) {
            return;
        }
        this.lastNode = node;
        super.doOKAction();
    }

    @Nullable
    public final SnippetTreeNode getSelectedNode() {
        return this.lastNode;
    }
}

