/*
 * Decompiled with CFR 0.152.
 */
package app.termora.snippet;

import app.termora.I18n;
import app.termora.OptionPane;
import app.termora.SimpleTree;
import app.termora.SimpleTreeNode;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.snippet.Snippet;
import app.termora.snippet.SnippetManager;
import app.termora.snippet.SnippetTreeModel;
import app.termora.snippet.SnippetTreeNode;
import app.termora.snippet.SnippetType;
import com.formdev.flatlaf.extras.components.FlatPopupMenu;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u001c\u0010\u0014\u001a\u00020\r2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J \u0010\u0019\u001a\u00020\r2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0014J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lapp/termora/snippet/SnippetTree;", "Lapp/termora/SimpleTree;", "<init>", "()V", "model", "Lapp/termora/snippet/SnippetTreeModel;", "getModel", "()Lapp/termora/snippet/SnippetTreeModel;", "snippetManager", "Lapp/termora/snippet/SnippetManager;", "getSnippetManager", "()Lapp/termora/snippet/SnippetManager;", "initViews", "", "initEvents", "showContextmenu", "evt", "Ljava/awt/event/MouseEvent;", "getLastSelectedPathNode", "Lapp/termora/snippet/SnippetTreeNode;", "onRenamed", "node", "Lapp/termora/SimpleTreeNode;", "text", "", "rebase", "parent", "getSelectionSimpleTreeNodes", "", "include", "", "termora"})
@SourceDebugExtension(value={"SMAP\nSnippetTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnippetTree.kt\napp/termora/snippet/SnippetTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n808#2,11:147\n*S KotlinDebug\n*F\n+ 1 SnippetTree.kt\napp/termora/snippet/SnippetTree\n*L\n144#1:147,11\n*E\n"})
public final class SnippetTree
extends SimpleTree {
    @NotNull
    private final SnippetTreeModel model = new SnippetTreeModel();

    public SnippetTree() {
        this.initViews();
        this.initEvents();
    }

    @NotNull
    protected SnippetTreeModel getModel() {
        return this.model;
    }

    private final SnippetManager getSnippetManager() {
        return SnippetManager.Companion.getInstance();
    }

    private final void initViews() {
        super.setModel((TreeModel)this.getModel());
        this.setEditable(true);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON_OR_INSERT);
    }

    private final void initEvents() {
    }

    @Override
    protected void showContextmenu(@NotNull MouseEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        SnippetTreeNode snippetTreeNode = this.getLastSelectedPathNode();
        if (snippetTreeNode == null) {
            return;
        }
        SnippetTreeNode lastNode = snippetTreeNode;
        FlatPopupMenu popupMenu = new FlatPopupMenu();
        JMenu newMenu = new JMenu(I18n.INSTANCE.getString("termora.welcome.contextmenu.new"));
        JMenuItem newFolder = newMenu.add(I18n.INSTANCE.getString("termora.welcome.contextmenu.new.folder"));
        JMenuItem newSnippet = newMenu.add(I18n.INSTANCE.getString("termora.snippet"));
        JMenuItem rename = popupMenu.add(I18n.INSTANCE.getString("termora.tabbed.contextmenu.rename"));
        JMenuItem remove = popupMenu.add(I18n.INSTANCE.getString("termora.welcome.contextmenu.remove"));
        popupMenu.addSeparator();
        JMenuItem refresh2 = popupMenu.add(I18n.INSTANCE.getString("termora.welcome.contextmenu.refresh"));
        JMenuItem expandAll = popupMenu.add(I18n.INSTANCE.getString("termora.welcome.contextmenu.expand-all"));
        JMenuItem colspanAll = popupMenu.add(I18n.INSTANCE.getString("termora.welcome.contextmenu.collapse-all"));
        popupMenu.addSeparator();
        newFolder.addActionListener(arg_0 -> SnippetTree.showContextmenu$lambda$0(lastNode, this, arg_0));
        newSnippet.addActionListener(arg_0 -> SnippetTree.showContextmenu$lambda$1(lastNode, this, arg_0));
        rename.addActionListener(arg_0 -> SnippetTree.showContextmenu$lambda$2(this, lastNode, arg_0));
        refresh2.addActionListener(arg_0 -> SnippetTree.showContextmenu$lambda$3(this, lastNode, arg_0));
        expandAll.addActionListener(arg_0 -> SnippetTree.showContextmenu$lambda$4(this, arg_0));
        colspanAll.addActionListener(arg_0 -> SnippetTree.showContextmenu$lambda$5(this, arg_0));
        remove.addActionListener((ActionListener)((Object)new AnAction(this){
            final /* synthetic */ SnippetTree this$0;
            {
                this.this$0 = $receiver;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                List nodes = SimpleTree.getSelectionSimpleTreeNodes$default(this.this$0, false, 1, null);
                if (nodes.isEmpty()) {
                    return;
                }
                if (OptionPane.showConfirmDialog$default(OptionPane.INSTANCE, SwingUtilities.getWindowAncestor((Component)((Object)SnippetTree.access$getTree(this.this$0))), I18n.INSTANCE.getString("termora.keymgr.delete-warning"), I18n.INSTANCE.getString("termora.remove"), 0, 3, null, null, null, null, 480, null) == 0) {
                    for (SnippetTreeNode c2 : nodes) {
                        SnippetTree.access$getSnippetManager(this.this$0).addSnippet(Snippet.copy$default((Snippet)c2.getData(), null, null, null, null, null, true, 0L, 0L, System.currentTimeMillis(), 223, null));
                        this.this$0.getModel().removeNodeFromParent(c2);
                        for (SimpleTreeNode<T> child : c2.getAllChildren()) {
                            SnippetTree.access$getSnippetManager(this.this$0).addSnippet(Snippet.copy$default((Snippet)child.getData(), null, null, null, null, null, true, 0L, 0L, System.currentTimeMillis(), 223, null));
                        }
                    }
                }
            }
        }));
        rename.setEnabled(!Intrinsics.areEqual((Object)lastNode, (Object)this.getModel().getRoot()));
        remove.setEnabled(rename.isEnabled());
        newFolder.setEnabled(((Snippet)lastNode.getData()).getType() == SnippetType.Folder);
        newSnippet.setEnabled(newFolder.isEnabled());
        newMenu.setEnabled(newFolder.isEnabled());
        refresh2.setEnabled(newFolder.isEnabled());
        popupMenu.add((JMenuItem)newMenu);
        popupMenu.show((Component)((Object)this), evt.getX(), evt.getY());
    }

    @Nullable
    public SnippetTreeNode getLastSelectedPathNode() {
        SimpleTreeNode<?> simpleTreeNode = super.getLastSelectedPathNode();
        return simpleTreeNode instanceof SnippetTreeNode ? (SnippetTreeNode)simpleTreeNode : null;
    }

    @Override
    protected void onRenamed(@NotNull SimpleTreeNode<?> node, @NotNull String text) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SnippetTreeNode snippetTreeNode = node instanceof SnippetTreeNode ? (SnippetTreeNode)node : null;
        if (snippetTreeNode == null) {
            return;
        }
        SnippetTreeNode n = snippetTreeNode;
        n.setData(Snippet.copy$default((Snippet)n.getData(), null, text, null, null, null, false, 0L, 0L, System.currentTimeMillis(), 253, null));
        this.getSnippetManager().addSnippet((Snippet)n.getData());
        this.getModel().nodeStructureChanged(n);
    }

    @Override
    protected void rebase(@NotNull SimpleTreeNode<?> node, @NotNull SimpleTreeNode<?> parent) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        SnippetTreeNode snippetTreeNode = node instanceof SnippetTreeNode ? (SnippetTreeNode)node : null;
        if (snippetTreeNode == null) {
            return;
        }
        SnippetTreeNode nNode = snippetTreeNode;
        SnippetTreeNode snippetTreeNode2 = parent instanceof SnippetTreeNode ? (SnippetTreeNode)parent : null;
        if (snippetTreeNode2 == null) {
            return;
        }
        SnippetTreeNode nParent = snippetTreeNode2;
        nNode.setData(Snippet.copy$default((Snippet)nNode.getData(), null, null, null, ((Snippet)nParent.getData()).getId(), null, false, 0L, 0L, System.currentTimeMillis(), 247, null));
        this.getSnippetManager().addSnippet((Snippet)nNode.getData());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<SnippetTreeNode> getSelectionSimpleTreeNodes(boolean include) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = super.getSelectionSimpleTreeNodes(include);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SnippetTreeNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void showContextmenu$lambda$0(SnippetTreeNode $lastNode, SnippetTree this$0, ActionEvent it) {
        String string = I18n.INSTANCE.getString("termora.welcome.contextmenu.new.folder.name");
        SnippetType snippetType = SnippetType.Folder;
        String string2 = ((Snippet)$lastNode.getData()).getId();
        Snippet snippet = new Snippet(null, string, null, string2, snippetType, false, 0L, 0L, 0L, 485, null);
        this$0.getSnippetManager().addSnippet(snippet);
        this$0.newFolder(new SnippetTreeNode(snippet));
    }

    private static final void showContextmenu$lambda$1(SnippetTreeNode $lastNode, SnippetTree this$0, ActionEvent it) {
        String string = I18n.INSTANCE.getString("termora.snippet");
        SnippetType snippetType = SnippetType.Snippet;
        String string2 = ((Snippet)$lastNode.getData()).getId();
        Snippet snippet = new Snippet(null, string, null, string2, snippetType, false, 0L, 0L, 0L, 485, null);
        this$0.getSnippetManager().addSnippet(snippet);
        this$0.newFile(new SnippetTreeNode(snippet));
    }

    private static final void showContextmenu$lambda$2(SnippetTree this$0, SnippetTreeNode $lastNode, ActionEvent it) {
        this$0.startEditingAtPath(new TreePath(this$0.getModel().getPathToRoot($lastNode)));
    }

    private static final void showContextmenu$lambda$3(SnippetTree this$0, SnippetTreeNode $lastNode, ActionEvent it) {
        this$0.refreshNode($lastNode);
    }

    private static final void showContextmenu$lambda$4(SnippetTree this$0, ActionEvent it) {
        for (SnippetTreeNode node : this$0.getSelectionSimpleTreeNodes(true)) {
            this$0.expandPath(new TreePath(this$0.getModel().getPathToRoot(node)));
        }
    }

    private static final void showContextmenu$lambda$5(SnippetTree this$0, ActionEvent it) {
        for (SnippetTreeNode node : CollectionsKt.reversed((Iterable)this$0.getSelectionSimpleTreeNodes(true))) {
            this$0.collapsePath(new TreePath(this$0.getModel().getPathToRoot(node)));
        }
    }

    public static final /* synthetic */ SimpleTree access$getTree(SnippetTree $this) {
        return $this.getTree();
    }

    public static final /* synthetic */ SnippetManager access$getSnippetManager(SnippetTree $this) {
        return $this.getSnippetManager();
    }
}

