/*
 * Decompiled with CFR 0.152.
 */
package app.termora.snippet;

import app.termora.Database;
import app.termora.Disposable;
import app.termora.DocumentAdaptor;
import app.termora.DynamicColor;
import app.termora.TreeUtils;
import app.termora.snippet.Snippet;
import app.termora.snippet.SnippetBannerPanel;
import app.termora.snippet.SnippetManager;
import app.termora.snippet.SnippetTree;
import app.termora.snippet.SnippetTreeNode;
import com.formdev.flatlaf.extras.components.FlatTextArea;
import com.formdev.flatlaf.ui.FlatRoundBorder;
import com.formdev.flatlaf.util.SystemInfo;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.undo.UndoManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0002\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lapp/termora/snippet/SnippetPanel;", "Ljavax/swing/JPanel;", "Lapp/termora/Disposable;", "<init>", "()V", "leftPanel", "cardLayout", "Ljava/awt/CardLayout;", "rightPanel", "snippetTree", "Lapp/termora/snippet/SnippetTree;", "editor", "Lapp/termora/snippet/SnippetPanel$SnippetEditor;", "lastNode", "Lapp/termora/snippet/SnippetTreeNode;", "getLastNode", "()Lapp/termora/snippet/SnippetTreeNode;", "initViews", "", "initEvents", "dispose", "Companion", "SnippetEditor", "termora"})
public final class SnippetPanel
extends JPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JPanel leftPanel = new JPanel(new BorderLayout());
    @NotNull
    private final CardLayout cardLayout = new CardLayout();
    @NotNull
    private final JPanel rightPanel = new JPanel(this.cardLayout);
    @NotNull
    private final SnippetTree snippetTree = new SnippetTree();
    @NotNull
    private final SnippetEditor editor = new SnippetEditor();
    private static final Logger log = LoggerFactory.getLogger(SnippetPanel.class);

    public SnippetPanel() {
        super(new BorderLayout());
        this.initViews();
        this.initEvents();
    }

    private final SnippetTreeNode getLastNode() {
        return this.snippetTree.getLastSelectedPathNode();
    }

    private final void initViews() {
        JSplitPane splitPane = new JSplitPane();
        splitPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, DynamicColor.Companion.getBorderColor()));
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.snippetTree));
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.leftPanel.add((Component)scrollPane, "Center");
        this.leftPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, DynamicColor.Companion.getBorderColor()), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        Integer n = StringsKt.toIntOrNull((String)SnippetPanel.Companion.getProperties().getString("SnippetPanel.LeftPanel.width", "180"));
        this.leftPanel.setPreferredSize(new Dimension(n != null ? n : 180, -1));
        this.leftPanel.setMinimumSize(new Dimension(this.leftPanel.getPreferredSize().width, this.leftPanel.getPreferredSize().height));
        this.rightPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, DynamicColor.Companion.getBorderColor()), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        JPanel bannerPanel = new JPanel(new BorderLayout());
        bannerPanel.add((Component)new SnippetBannerPanel(0, 1, null), "Center");
        bannerPanel.setBorder(BorderFactory.createEmptyBorder(32, 0, 0, 0));
        this.rightPanel.add((Component)bannerPanel, "Banner");
        this.rightPanel.add((Component)this.editor, "Editor");
        splitPane.setLeftComponent(this.leftPanel);
        splitPane.setRightComponent(this.rightPanel);
        this.add((Component)splitPane, "Center");
        this.cardLayout.show(this.rightPanel, "Banner");
    }

    private final void initEvents() {
        String selectionRows;
        this.snippetTree.addTreeSelectionListener(arg_0 -> SnippetPanel.initEvents$lambda$0(this, arg_0));
        SwingUtilities.invokeLater(() -> SnippetPanel.initEvents$lambda$1(this));
        String expansionState = SnippetPanel.Companion.getProperties().getString("SnippetPanel.LeftTreePanel.expansionState", "");
        if (!StringsKt.isBlank((CharSequence)expansionState)) {
            TreeUtils.INSTANCE.loadExpansionState((JTree)((Object)this.snippetTree), expansionState);
        }
        if (!StringsKt.isBlank((CharSequence)(selectionRows = SnippetPanel.Companion.getProperties().getString("SnippetPanel.LeftTreePanel.selectionRows", "")))) {
            TreeUtils.INSTANCE.loadSelectionRows((JTree)((Object)this.snippetTree), selectionRows);
        }
    }

    @Override
    public void dispose() {
        SnippetPanel.Companion.getProperties().putString("SnippetPanel.LeftPanel.width", String.valueOf(this.leftPanel.getWidth()));
        SnippetPanel.Companion.getProperties().putString("SnippetPanel.LeftPanel.height", String.valueOf(this.leftPanel.getHeight()));
        SnippetPanel.Companion.getProperties().putString("SnippetPanel.LeftTreePanel.expansionState", TreeUtils.INSTANCE.saveExpansionState((JTree)((Object)this.snippetTree)));
        SnippetPanel.Companion.getProperties().putString("SnippetPanel.LeftTreePanel.selectionRows", TreeUtils.INSTANCE.saveSelectionRows((JTree)((Object)this.snippetTree)));
    }

    private static final void initEvents$lambda$0(SnippetPanel this$0, TreeSelectionEvent it) {
        SnippetTreeNode lastNode = this$0.getLastNode();
        if (lastNode == null || lastNode.isFolder()) {
            this$0.cardLayout.show(this$0.rightPanel, "Banner");
        } else {
            this$0.cardLayout.show(this$0.rightPanel, "Editor");
            this$0.editor.getTextArea().setText(((Snippet)lastNode.getData()).getSnippet());
            this$0.editor.resetUndo();
        }
    }

    private static final void initEvents$lambda$1(SnippetPanel this$0) {
        int[] nArray = this$0.snippetTree.getSelectionRows();
        boolean bl = nArray != null ? nArray.length == 0 : false;
        if (bl) {
            this$0.snippetTree.addSelectionRow(0);
        }
        this$0.snippetTree.requestFocusInWindow();
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ SnippetTreeNode access$getLastNode(SnippetPanel $this) {
        return $this.getLastNode();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00060\bR\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lapp/termora/snippet/SnippetPanel$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "properties", "Lapp/termora/Database$Properties;", "Lapp/termora/Database;", "getProperties", "()Lapp/termora/Database$Properties;", "snippetManager", "Lapp/termora/snippet/SnippetManager;", "getSnippetManager", "()Lapp/termora/snippet/SnippetManager;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        private final Database.Properties getProperties() {
            return Database.Companion.getDatabase().getProperties();
        }

        private final SnippetManager getSnippetManager() {
            return SnippetManager.Companion.getInstance();
        }

        public static final /* synthetic */ SnippetManager access$getSnippetManager(Companion $this) {
            return $this.getSnippetManager();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\u0006\u0010\r\u001a\u00020\u000bJ\b\u0010\u000e\u001a\u00020\u0001H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lapp/termora/snippet/SnippetPanel$SnippetEditor;", "Ljavax/swing/JPanel;", "<init>", "(Lapp/termora/snippet/SnippetPanel;)V", "textArea", "Lcom/formdev/flatlaf/extras/components/FlatTextArea;", "getTextArea", "()Lcom/formdev/flatlaf/extras/components/FlatTextArea;", "undoManager", "Ljavax/swing/undo/UndoManager;", "initViews", "", "initEvents", "resetUndo", "createTip", "createTipLabel", "Ljavax/swing/JLabel;", "text", "", "termora"})
    @SourceDebugExtension(value={"SMAP\nSnippetPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnippetPanel.kt\napp/termora/snippet/SnippetPanel$SnippetEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n1#2:229\n*E\n"})
    private final class SnippetEditor
    extends JPanel {
        @NotNull
        private final FlatTextArea textArea;
        @NotNull
        private UndoManager undoManager;

        public SnippetEditor() {
            super(new BorderLayout());
            this.textArea = new FlatTextArea();
            this.undoManager = new UndoManager();
            this.initViews();
            this.initEvents();
        }

        @NotNull
        public final FlatTextArea getTextArea() {
            return this.textArea;
        }

        /*
         * WARNING - void declaration
         */
        private final void initViews() {
            void $this$initViews_u24lambda_u240;
            JScrollPane jScrollPane;
            JPanel panel2 = new JPanel(new BorderLayout());
            JScrollPane jScrollPane2 = jScrollPane = new JScrollPane((Component)this.textArea);
            JPanel jPanel = panel2;
            boolean bl = false;
            $this$initViews_u24lambda_u240.setBorder(BorderFactory.createEmptyBorder());
            jPanel.add((Component)jScrollPane, "Center");
            panel2.setBorder((Border)new FlatRoundBorder());
            this.add((Component)panel2, "Center");
            this.add((Component)this.createTip(), "South");
            this.textArea.setFocusTraversalKeys(0, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(0));
            this.textArea.setFocusTraversalKeys(1, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(1));
        }

        private final void initEvents() {
            this.textArea.getDocument().addUndoableEditListener(this.undoManager);
            this.textArea.addKeyListener((KeyListener)new KeyAdapter(this){
                final /* synthetic */ SnippetEditor this$0;
                {
                    this.this$0 = $receiver;
                }

                public void keyPressed(KeyEvent e) {
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if ((e.getKeyCode() == 90 || e.getKeyCode() == 89) && (SystemInfo.isMacOS ? e.isMetaDown() : e.isControlDown())) {
                            try {
                                if (e.getKeyCode() == 90) {
                                    if (SnippetEditor.access$getUndoManager$p(this.this$0).canUndo()) {
                                        SnippetEditor.access$getUndoManager$p(this.this$0).undo();
                                    }
                                } else if (SnippetEditor.access$getUndoManager$p(this.this$0).canRedo()) {
                                    SnippetEditor.access$getUndoManager$p(this.this$0).redo();
                                }
                            }
                            catch (Exception cue) {
                                if (!SnippetPanel.access$getLog$cp().isErrorEnabled()) break block7;
                                SnippetPanel.access$getLog$cp().error(cue.getMessage(), (Object)cue.getMessage());
                            }
                        }
                    }
                }
            });
            this.textArea.getDocument().addDocumentListener(new DocumentAdaptor(SnippetPanel.this, this){
                final /* synthetic */ SnippetPanel this$0;
                final /* synthetic */ SnippetEditor this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void changedUpdate(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SnippetTreeNode snippetTreeNode = SnippetPanel.access$getLastNode(this.this$0);
                    if (snippetTreeNode == null) {
                        return;
                    }
                    SnippetTreeNode lastNode = snippetTreeNode;
                    Snippet snippet = (Snippet)lastNode.getData();
                    String string = this.this$1.getTextArea().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    lastNode.setData(Snippet.copy$default(snippet, null, null, string, null, null, false, 0L, 0L, System.currentTimeMillis(), 251, null));
                    app.termora.snippet.SnippetPanel$Companion.access$getSnippetManager(SnippetPanel.Companion).addSnippet((Snippet)lastNode.getData());
                }
            });
        }

        public final void resetUndo() {
            this.textArea.getDocument().removeUndoableEditListener(this.undoManager);
            this.undoManager = new UndoManager();
            this.textArea.getDocument().addUndoableEditListener(this.undoManager);
        }

        private final JPanel createTip() {
            JPanel jPanel;
            String formMargin = "10dlu";
            JPanel panel2 = FormBuilder.create().debug(false).border((Border)BorderFactory.createCompoundBorder((Border)new FlatRoundBorder(), BorderFactory.createEmptyBorder(2, 4, 4, 4))).layout(new FormLayout("left:pref, left:pref, " + formMargin + ", left:pref, left:pref, " + formMargin + ", left:pref, left:pref", "pref, " + formMargin + ", pref")).add((Component)this.createTipLabel("\\r - ")).xy(1, 1).add((Component)this.createTipLabel("CR")).xy(2, 1).add((Component)this.createTipLabel("\\n - ")).xy(4, 1).add((Component)this.createTipLabel("LF")).xy(5, 1).add((Component)this.createTipLabel("\\t - ")).xy(7, 1).add((Component)this.createTipLabel("Tab")).xy(8, 1).add((Component)this.createTipLabel("\\a - ")).xy(1, 2).add((Component)this.createTipLabel("Bell")).xy(2, 2).add((Component)this.createTipLabel("\\e - ")).xy(4, 2).add((Component)this.createTipLabel("Escape")).xy(5, 2).add((Component)this.createTipLabel("\\b - ")).xy(7, 2).add((Component)this.createTipLabel("Backspace")).xy(8, 2).build();
            JPanel $this$createTip_u24lambda_u241 = jPanel = new JPanel(new BorderLayout());
            boolean bl = false;
            $this$createTip_u24lambda_u241.add((Component)panel2, "Center");
            $this$createTip_u24lambda_u241.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
            return jPanel;
        }

        private final JLabel createTipLabel(String text) {
            JLabel label = new JLabel(text);
            label.setForeground(UIManager.getColor("textInactiveText"));
            return label;
        }

        public static final /* synthetic */ UndoManager access$getUndoManager$p(SnippetEditor $this) {
            return $this.undoManager;
        }
    }
}

