/*
 * Decompiled with CFR 0.152.
 */
package app.termora.snippet;

import app.termora.ApplicationScope;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.snippet.Snippet;
import app.termora.snippet.SnippetDialog;
import app.termora.snippet.SnippetType;
import app.termora.terminal.panel.TerminalWriter;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lapp/termora/snippet/SnippetAction;", "Lapp/termora/actions/AnAction;", "<init>", "()V", "actionPerformed", "", "evt", "Lapp/termora/actions/AnActionEvent;", "runSnippet", "snippet", "Lapp/termora/snippet/Snippet;", "writer", "Lapp/termora/terminal/panel/TerminalWriter;", "unescape", "", "text", "Companion", "termora"})
public final class SnippetAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SNIPPET = "SnippetAction";
    @NotNull
    private static final Map<Character, Character> SpecialChars;

    private SnippetAction() {
        super(I18n.INSTANCE.getString("termora.snippet.title"), (Icon)((Object)Icons.INSTANCE.getCodeSpan()));
    }

    @Override
    protected void actionPerformed(@NotNull AnActionEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        new SnippetDialog(evt.getWindow()).setVisible(true);
    }

    public final void runSnippet(@NotNull Snippet snippet, @NotNull TerminalWriter writer) {
        Intrinsics.checkNotNullParameter((Object)snippet, (String)"snippet");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (snippet.getType() != SnippetType.Snippet) {
            return;
        }
        byte[] byArray = this.unescape(snippet.getSnippet()).getBytes(writer.getCharset());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        writer.write(TerminalWriter.WriteRequest.Companion.fromBytes(byArray));
    }

    private final String unescape(String text) {
        char[] cArray = text.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] chars = cArray;
        StringBuilder sb = new StringBuilder();
        int n = chars.length;
        for (int i = 0; i < n; ++i) {
            char c2 = chars[i];
            if (!SpecialChars.containsKey(Character.valueOf(c2))) {
                sb.append(c2);
                continue;
            }
            Character c3 = ArraysKt.getOrNull((char[])chars, (int)(i - 1));
            char c4 = '\\';
            if (c3 == null || c3.charValue() != c4) {
                sb.append(c2);
                continue;
            }
            Character c5 = ArraysKt.getOrNull((char[])chars, (int)(i - 2));
            c4 = '\\';
            if (c5 != null && c5.charValue() == c4) {
                sb.deleteCharAt(sb.length() - 1);
                sb.append(c2);
                continue;
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(((Character)MapsKt.getValue(SpecialChars, (Object)Character.valueOf(c2))).charValue());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public /* synthetic */ SnippetAction(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('r'), (Object)Character.valueOf('\r')), TuplesKt.to((Object)Character.valueOf('n'), (Object)Character.valueOf('\n')), TuplesKt.to((Object)Character.valueOf('t'), (Object)Character.valueOf('\t')), TuplesKt.to((Object)Character.valueOf('a'), (Object)Character.valueOf('\u0007')), TuplesKt.to((Object)Character.valueOf('e'), (Object)Character.valueOf('\u001b')), TuplesKt.to((Object)Character.valueOf('b'), (Object)Character.valueOf('\b'))};
        SpecialChars = MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lapp/termora/snippet/SnippetAction$Companion;", "", "<init>", "()V", "getInstance", "Lapp/termora/snippet/SnippetAction;", "SNIPPET", "", "SpecialChars", "", "", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SnippetAction getInstance() {
            return (SnippetAction)((Object)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(SnippetAction.class), Companion::getInstance$lambda$0));
        }

        private static final SnippetAction getInstance$lambda$0() {
            return new SnippetAction(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

