/*
 * Decompiled with CFR 0.152.
 */
package app.termora.sftp;

import app.termora.ApplicationKt;
import app.termora.I18n;
import app.termora.sftp.Transport;
import app.termora.sftp.TransportStatus;
import app.termora.vfs2.sftp.MySftpFileSystem;
import app.termora.vfs2.sftp.MySftpFileSystemConfigBuilder;
import java.util.Enumeration;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.sshd.client.session.ClientSession;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0011\u001a\u00020\rH\u0002J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00140\u0016R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lapp/termora/sftp/TransportTreeTableNode;", "Lorg/jdesktop/swingx/treetable/DefaultMutableTreeTableNode;", "transport", "Lapp/termora/sftp/Transport;", "<init>", "(Lapp/termora/sftp/Transport;)V", "getTransport", "()Lapp/termora/sftp/Transport;", "getValueAt", "", "column", "", "formatPath", "", "file", "Lorg/apache/commons/vfs2/FileObject;", "formatStatus", "size", "getColumnCount", "visit", "", "consumer", "Lkotlin/Function1;", "termora"})
public final class TransportTreeTableNode
extends DefaultMutableTreeTableNode {
    public TransportTreeTableNode(@NotNull Transport transport2) {
        Intrinsics.checkNotNullParameter((Object)transport2, (String)"transport");
        super((Object)transport2);
    }

    @NotNull
    public final Transport getTransport() {
        Object object = this.userObject;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type app.termora.sftp.Transport");
        return (Transport)object;
    }

    @NotNull
    public Object getValueAt(int column) {
        boolean isProcessing = this.getTransport().getStatus() == TransportStatus.Processing;
        long speed = isProcessing ? this.getTransport().getSpeed() : 0L;
        long estimatedTime = isProcessing && speed > 0L ? (this.getTransport().getFilesize().get() - this.getTransport().getTransferredFilesize().get()) / speed : 0L;
        Object object = switch (column) {
            case 0 -> this.getTransport().getSource().getName().getBaseName();
            case 1 -> this.formatStatus(this.getTransport());
            case 3 -> this.size();
            case 6 -> {
                if (isProcessing) {
                    yield ApplicationKt.formatBytes(speed) + "/s";
                }
                yield "-";
            }
            case 7 -> {
                if (isProcessing) {
                    yield ApplicationKt.formatSeconds(estimatedTime);
                }
                yield "-";
            }
            case 4 -> this.formatPath(this.getTransport().getSource());
            case 5 -> this.formatPath(this.getTransport().getTarget());
            default -> super.getValueAt(column);
        };
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    private final String formatPath(FileObject file) {
        if (file.getFileSystem() instanceof MySftpFileSystem) {
            MySftpFileSystemConfigBuilder mySftpFileSystemConfigBuilder = MySftpFileSystemConfigBuilder.Companion.getInstance();
            FileSystemOptions fileSystemOptions = file.getFileSystem().getFileSystemOptions();
            Intrinsics.checkNotNullExpressionValue((Object)fileSystemOptions, (String)"getFileSystemOptions(...)");
            ClientSession clientSession = mySftpFileSystemConfigBuilder.getClientSession(fileSystemOptions);
            Intrinsics.checkNotNull((Object)clientSession, (String)"null cannot be cast to non-null type org.eclipse.jgit.internal.transport.sshd.JGitClientSession");
            JGitClientSession session = (JGitClientSession)clientSession;
            String hostname = session.getHostConfigEntry().getHostName();
            return hostname + ":" + file.getName().getPath();
        }
        return file.getName().toString();
    }

    private final String formatStatus(Transport transport2) {
        return switch (WhenMappings.$EnumSwitchMapping$0[transport2.getStatus().ordinal()]) {
            case 1 -> I18n.INSTANCE.getString("termora.transport.sftp.status.transporting");
            case 2 -> I18n.INSTANCE.getString("termora.transport.sftp.status.waiting");
            case 3 -> I18n.INSTANCE.getString("termora.transport.sftp.status.done");
            case 4 -> I18n.INSTANCE.getString("termora.transport.sftp.status.failed") + ": " + transport2.getException().getMessage();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String size() {
        long transferredFilesize = this.getTransport().getTransferredFilesize().get();
        long filesize = this.getTransport().getFilesize().get();
        if (transferredFilesize <= 0L) {
            return ApplicationKt.formatBytes(filesize);
        }
        return ApplicationKt.formatBytes(transferredFilesize) + "/" + ApplicationKt.formatBytes(filesize);
    }

    public int getColumnCount() {
        return 8;
    }

    public final void visit(@NotNull Function1<? super TransportTreeTableNode, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (this.getChildCount() == 0) {
            return;
        }
        Enumeration enumeration = this.children();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"children(...)");
        Iterator iterator2 = CollectionsKt.iterator((Enumeration)enumeration);
        while (iterator2.hasNext()) {
            MutableTreeTableNode child = (MutableTreeTableNode)iterator2.next();
            if (!(child instanceof TransportTreeTableNode)) continue;
            ((TransportTreeTableNode)child).visit(consumer);
            consumer.invoke((Object)child);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TransportStatus.values().length];
            try {
                nArray[TransportStatus.Processing.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransportStatus.Ready.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransportStatus.Done.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransportStatus.Failed.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

