/*
 * Decompiled with CFR 0.152.
 */
package app.termora.sftp;

import app.termora.Database;
import app.termora.sftp.SlidingWindowByteCounter;
import app.termora.sftp.SpeedReporter;
import app.termora.sftp.TransportStatus;
import app.termora.sftp.TransportStatusException;
import java.io.Closeable;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 N2\u00020\u0001:\u0001NB?\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u001b\u001a\u00020BJ\u000e\u0010C\u001a\u00020\u00052\u0006\u00108\u001a\u000207J\u0016\u0010E\u001a\u00020B2\u0006\u0010F\u001a\u00020GH\u0086@\u00a2\u0006\u0002\u0010HJ\b\u0010I\u001a\u00020BH\u0002J\u000e\u0010J\u001a\u00020B2\u0006\u0010K\u001a\u00020\u0003J\u0016\u0010L\u001a\u00020B2\u0006\u0010K\u001a\u00020\u00032\u0006\u0010M\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0013\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010!\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010 \u001a\u0004\b#\u0010$R(\u0010'\u001a\u0004\u0018\u00010\u00002\b\u0010&\u001a\u0004\u0018\u00010\u0000@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010/R\u0011\u00102\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0010R\u0011\u00103\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0010R\u0011\u00104\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0010R\u0011\u00105\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u000fR\u001e\u00108\u001a\u0002072\u0006\u0010&\u001a\u000207@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u001c\u0010;\u001a\u00020<X\u0086\u000e\u00a2\u0006\u0010\n\u0002\bA\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u000e\u0010D\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lapp/termora/sftp/Transport;", "", "id", "", "isDirectory", "", "parentId", "source", "Lorg/apache/commons/vfs2/FileObject;", "target", "mode", "Ljava/nio/file/StandardOpenOption;", "<init>", "(JZJLorg/apache/commons/vfs2/FileObject;Lorg/apache/commons/vfs2/FileObject;Ljava/nio/file/StandardOpenOption;)V", "getId", "()J", "()Z", "getParentId", "getSource", "()Lorg/apache/commons/vfs2/FileObject;", "getTarget", "setTarget", "(Lorg/apache/commons/vfs2/FileObject;)V", "getMode", "()Ljava/nio/file/StandardOpenOption;", "setMode", "(Ljava/nio/file/StandardOpenOption;)V", "scanned", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getScanned", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "scanned$delegate", "Lkotlin/Lazy;", "counter", "Lapp/termora/sftp/SlidingWindowByteCounter;", "getCounter", "()Lapp/termora/sftp/SlidingWindowByteCounter;", "counter$delegate", "value", "parent", "getParent", "()Lapp/termora/sftp/Transport;", "setParent", "(Lapp/termora/sftp/Transport;)V", "filesize", "Ljava/util/concurrent/atomic/AtomicLong;", "getFilesize", "()Ljava/util/concurrent/atomic/AtomicLong;", "transferredFilesize", "getTransferredFilesize", "isScanned", "isFile", "isRoot", "speed", "getSpeed", "Lapp/termora/sftp/TransportStatus;", "status", "getStatus", "()Lapp/termora/sftp/TransportStatus;", "exception", "", "getException", "()Ljava/lang/Throwable;", "setException", "(Ljava/lang/Throwable;)V", "exception$1", "", "changeStatus", "c", "transport", "reporter", "Lapp/termora/sftp/SpeedReporter;", "(Lapp/termora/sftp/SpeedReporter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "preserveModificationTime", "reportFilesize", "bytes", "reportTransferredFilesize", "time", "Companion", "termora"})
public final class Transport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long id;
    private final boolean isDirectory;
    private final long parentId;
    @NotNull
    private final FileObject source;
    @NotNull
    private FileObject target;
    @NotNull
    private StandardOpenOption mode;
    @NotNull
    private final Lazy scanned$delegate;
    @NotNull
    private final Lazy counter$delegate;
    @Nullable
    private Transport parent;
    @NotNull
    private final AtomicLong filesize;
    @NotNull
    private final AtomicLong transferredFilesize;
    private final boolean isFile;
    private final boolean isRoot;
    @NotNull
    private volatile TransportStatus status;
    @NotNull
    private Throwable exception$1;
    @NotNull
    private final AtomicLong c;
    @NotNull
    private static final AtomicLong idGenerator = new AtomicLong(0L);
    @NotNull
    private static final RuntimeException exception = new RuntimeException("Nothing");
    private static final Logger log = LoggerFactory.getLogger(Transport.class);

    public Transport(long id, boolean isDirectory, long parentId, @NotNull FileObject source, @NotNull FileObject target, @NotNull StandardOpenOption mode) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        this.id = id;
        this.isDirectory = isDirectory;
        this.parentId = parentId;
        this.source = source;
        this.target = target;
        this.mode = mode;
        this.scanned$delegate = LazyKt.lazy(Transport::scanned_delegate$lambda$0);
        this.counter$delegate = LazyKt.lazy(Transport::counter_delegate$lambda$1);
        this.filesize = new AtomicLong(0L);
        this.transferredFilesize = new AtomicLong(0L);
        this.isFile = !this.isDirectory;
        this.isRoot = this.parentId == 0L;
        this.status = TransportStatus.Ready;
        this.exception$1 = exception;
        this.c = new AtomicLong(0L);
    }

    public /* synthetic */ Transport(long l, boolean bl, long l2, FileObject fileObject, FileObject fileObject2, StandardOpenOption standardOpenOption, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = idGenerator.incrementAndGet();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            l2 = 0L;
        }
        if ((n & 0x20) != 0) {
            standardOpenOption = StandardOpenOption.TRUNCATE_EXISTING;
        }
        this(l, bl, l2, fileObject, fileObject2, standardOpenOption);
    }

    public final long getId() {
        return this.id;
    }

    public final boolean isDirectory() {
        return this.isDirectory;
    }

    public final long getParentId() {
        return this.parentId;
    }

    @NotNull
    public final FileObject getSource() {
        return this.source;
    }

    @NotNull
    public final FileObject getTarget() {
        return this.target;
    }

    public final void setTarget(@NotNull FileObject fileObject) {
        Intrinsics.checkNotNullParameter((Object)fileObject, (String)"<set-?>");
        this.target = fileObject;
    }

    @NotNull
    public final StandardOpenOption getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull StandardOpenOption standardOpenOption) {
        Intrinsics.checkNotNullParameter((Object)standardOpenOption, (String)"<set-?>");
        this.mode = standardOpenOption;
    }

    private final AtomicBoolean getScanned() {
        Lazy lazy = this.scanned$delegate;
        return (AtomicBoolean)lazy.getValue();
    }

    private final SlidingWindowByteCounter getCounter() {
        Lazy lazy = this.counter$delegate;
        return (SlidingWindowByteCounter)lazy.getValue();
    }

    @Nullable
    public final Transport getParent() {
        return this.parent;
    }

    public final void setParent(@Nullable Transport value) {
        if (this.parent != null) {
            throw new IllegalStateException("parent already exists");
        }
        this.parent = value;
        this.reportFilesize(this.filesize.get());
    }

    @NotNull
    public final AtomicLong getFilesize() {
        return this.filesize;
    }

    @NotNull
    public final AtomicLong getTransferredFilesize() {
        return this.transferredFilesize;
    }

    public final boolean isScanned() {
        return this.getScanned().get();
    }

    public final boolean isFile() {
        return this.isFile;
    }

    public final boolean isRoot() {
        return this.isRoot;
    }

    public final long getSpeed() {
        return this.getCounter().getLastSecondBytes();
    }

    @NotNull
    public final TransportStatus getStatus() {
        return this.status;
    }

    @NotNull
    public final Throwable getException() {
        return this.exception$1;
    }

    public final void setException(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"<set-?>");
        this.exception$1 = throwable;
    }

    public final void scanned() {
        this.getScanned().compareAndSet(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean changeStatus(@NotNull TransportStatus status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Transport transport2 = this;
        synchronized (transport2) {
            block9: {
                block10: {
                    block8: {
                        boolean bl = false;
                        if (status != TransportStatus.Processing) break block8;
                        if (this.status != TransportStatus.Ready) {
                            boolean bl2 = false;
                            return bl2;
                        }
                        break block9;
                    }
                    if (status != TransportStatus.Failed && status != TransportStatus.Done) break block10;
                    if (this.status != TransportStatus.Ready && this.status != TransportStatus.Processing) {
                        boolean bl = false;
                        return bl;
                    }
                    break block9;
                }
                if (status != TransportStatus.Ready || this.status == TransportStatus.Ready) break block9;
                boolean bl = false;
                return bl;
            }
            this.status = status;
            boolean bl = true;
            return bl;
        }
    }

    @Nullable
    public final Object transport(@NotNull SpeedReporter reporter, @NotNull Continuation<? super Unit> $completion) {
        if (this.isDirectory) {
            Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ Transport this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            try {
                                if (!this.this$0.getTarget().exists()) {
                                    this.this$0.getTarget().createFolder();
                                }
                            }
                            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                                if (Transport.access$getLog$cp().isWarnEnabled()) {
                                    Transport.access$getLog$cp().warn("Directory " + this.this$0.getTarget().getName() + " already exists");
                                }
                            }
                            catch (Exception e) {
                                this.this$0.setException(e);
                                throw e;
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, reporter, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Transport this$0;
            final /* synthetic */ SpeedReporter $reporter;
            {
                this.this$0 = $receiver;
                this.$reporter = $reporter;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object var1_1) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$withContext = (CoroutineScope)this.L$0;
                        input = this.this$0.getSource().getContent().getInputStream();
                        output = this.this$0.getTarget().getContent().getOutputStream(this.this$0.getMode() == StandardOpenOption.APPEND);
                        try {
                            buff = new byte[1024];
                            len = new Ref.IntRef();
                            do {
                                it = var7_10 = input.read(buff);
                                $i$a$-also-Transport$transport$3$1 = false;
                                len.element = it;
                                if (var7_10 == -1 || !CoroutineScopeKt.isActive((CoroutineScope)$this$withContext)) ** GOTO lbl28
                                output.write(buff, 0, len.element);
                                size = len.element;
                                now = System.currentTimeMillis();
                                this.$reporter.report(this.this$0, size, now);
                            } while (this.this$0.getStatus() == TransportStatus.Processing);
                            throw new TransportStatusException("status is " + this.this$0.getStatus());
                        }
                        catch (Throwable var5_6) {
                            var6_8 = new Closeable[]{input, output};
                            IOUtils.closeQuietly((Closeable[])var6_8);
                            throw var5_6;
                        }
lbl28:
                        // 1 sources

                        var5_5 = new Closeable[]{input, output};
                        IOUtils.closeQuietly((Closeable[])var5_5);
                        Transport.access$preserveModificationTime(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void preserveModificationTime() {
        if (Transport.Companion.isPreserveModificationTime()) {
            this.target.getContent().setLastModifiedTime(this.source.getContent().getLastModifiedTime());
        }
    }

    public final void reportFilesize(long bytes) {
        Transport transport2 = this.parent;
        if (transport2 == null) {
            return;
        }
        Transport p = transport2;
        if (this.isRoot) {
            return;
        }
        if (p.status == TransportStatus.Failed) {
            return;
        }
        p.filesize.addAndGet(bytes);
        p.reportFilesize(bytes);
    }

    public final void reportTransferredFilesize(long bytes, long time) {
        Transport p = this;
        while (p != null) {
            if (bytes > 0L) {
                p.getCounter().addBytes(bytes, time);
            }
            if (p.status == TransportStatus.Failed) {
                return;
            }
            p.transferredFilesize.addAndGet(bytes);
            p = p.parent;
            this.c.incrementAndGet();
        }
    }

    private static final AtomicBoolean scanned_delegate$lambda$0() {
        return new AtomicBoolean(false);
    }

    private static final SlidingWindowByteCounter counter_delegate$lambda$1() {
        return new SlidingWindowByteCounter();
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ void access$preserveModificationTime(Transport $this) {
        $this.preserveModificationTime();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lapp/termora/sftp/Transport$Companion;", "", "<init>", "()V", "idGenerator", "Ljava/util/concurrent/atomic/AtomicLong;", "getIdGenerator", "()Ljava/util/concurrent/atomic/AtomicLong;", "exception", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "isPreserveModificationTime", "", "()Z", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicLong getIdGenerator() {
            return idGenerator;
        }

        private final boolean isPreserveModificationTime() {
            return Database.Companion.getDatabase().getSftp().getPreserveModificationTime();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

