/*
 * Decompiled with CFR 0.152.
 */
package app.termora.sftp;

import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.Host;
import app.termora.HostDialog;
import app.termora.HostManager;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.Options;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.sftp.FileSystemViewPanel;
import app.termora.sftp.SFTPDataProviders;
import app.termora.sftp.SFTPFileSystemViewPanel;
import app.termora.sftp.SFTPKitKt;
import app.termora.sftp.TransportManager;
import com.formdev.flatlaf.extras.components.FlatPopupMenu;
import com.formdev.flatlaf.extras.components.FlatTabbedPane;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\u0018J\b\u0010\"\u001a\u00020\u0014H\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0018H\u0016J\b\u0010$\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\u00a8\u0006%"}, d2={"Lapp/termora/sftp/SFTPTabbed;", "Lcom/formdev/flatlaf/extras/components/FlatTabbedPane;", "Lapp/termora/Disposable;", "transportManager", "Lapp/termora/sftp/TransportManager;", "<init>", "(Lapp/termora/sftp/TransportManager;)V", "addBtn", "Ljavax/swing/JButton;", "tabbed", "disposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "hostManager", "Lapp/termora/HostManager;", "getHostManager", "()Lapp/termora/HostManager;", "isDisposed", "", "()Z", "initViews", "", "initEvents", "showContextMenu", "tabIndex", "", "e", "Ljava/awt/event/MouseEvent;", "addSFTPFileSystemViewPanelTab", "host", "Lapp/termora/Host;", "getSelectedFileSystemViewPanel", "Lapp/termora/sftp/FileSystemViewPanel;", "getFileSystemViewPanel", "index", "updateUI", "removeTabAt", "dispose", "termora"})
public final class SFTPTabbed
extends FlatTabbedPane
implements Disposable {
    @NotNull
    private final TransportManager transportManager;
    @NotNull
    private final JButton addBtn;
    @NotNull
    private final SFTPTabbed tabbed;
    @NotNull
    private final AtomicBoolean disposed;

    public SFTPTabbed(@NotNull TransportManager transportManager) {
        Intrinsics.checkNotNullParameter((Object)transportManager, (String)"transportManager");
        this.transportManager = transportManager;
        this.addBtn = new JButton((Icon)((Object)Icons.INSTANCE.getAdd()));
        this.tabbed = this;
        this.disposed = new AtomicBoolean(false);
        this.initViews();
        this.initEvents();
    }

    private final HostManager getHostManager() {
        return HostManager.Companion.getInstance();
    }

    public final boolean isDisposed() {
        return this.disposed.get();
    }

    private final void initViews() {
        super.setTabLayoutPolicy(1);
        super.setTabsClosable(true);
        super.setTabType(FlatTabbedPane.TabType.underlined);
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.addBtn);
        super.setTrailingComponent((Component)toolbar);
    }

    private final void initEvents() {
        this.addBtn.addActionListener((ActionListener)((Object)new AnAction(this){
            final /* synthetic */ SFTPTabbed this$0;
            {
                this.this$0 = $receiver;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                int n = this.this$0.getTabCount();
                for (int i = 0; i < n; ++i) {
                    Component c2 = this.this$0.getComponentAt(i);
                    if (!(c2 instanceof SFTPFileSystemViewPanel) || ((SFTPFileSystemViewPanel)c2).getState() != SFTPFileSystemViewPanel.State.Initialized) continue;
                    this.this$0.setSelectedIndex(i);
                    return;
                }
                this.this$0.addTab(I18n.INSTANCE.getString("termora.transport.sftp.select-host"), new SFTPFileSystemViewPanel(null, SFTPTabbed.access$getTransportManager$p(this.this$0), 1, null));
                this.this$0.setSelectedIndex(this.this$0.getTabCount() - 1);
            }
        }));
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ SFTPTabbed this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                int index = this.this$0.indexAtLocation(e.getX(), e.getY());
                if (index < 0) {
                    return;
                }
                SFTPTabbed.access$showContextMenu(this.this$0, index, e);
            }
        });
    }

    private final void showContextMenu(int tabIndex, MouseEvent e) {
        FileSystemViewPanel fileSystemViewPanel = this.getFileSystemViewPanel(tabIndex);
        if (fileSystemViewPanel == null) {
            return;
        }
        FileSystemViewPanel panel2 = fileSystemViewPanel;
        FlatPopupMenu popupMenu = new FlatPopupMenu();
        JMenuItem clone = popupMenu.add(I18n.INSTANCE.getString("termora.tabbed.contextmenu.clone"));
        clone.addActionListener((ActionListener)((Object)new AnAction(this, panel2){
            final /* synthetic */ SFTPTabbed this$0;
            final /* synthetic */ FileSystemViewPanel $panel;
            {
                this.this$0 = $receiver;
                this.$panel = $panel;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                Host host = SFTPTabbed.access$getHostManager(this.this$0).getHost(this.$panel.getHost().getId());
                if (host == null) {
                    return;
                }
                Host host2 = host;
                this.this$0.addSFTPFileSystemViewPanelTab(Host.copy$default(host2, null, null, null, null, 0, null, null, null, null, Options.copy$default(host2.getOptions(), null, null, null, null, 0, null, SFTPKitKt.absolutePathString(this.$panel.getWorkdir()), false, null, 447, null), null, 0L, null, null, null, 0L, 0L, false, 261631, null));
            }
        }));
        JMenuItem edit = popupMenu.add(I18n.INSTANCE.getString("termora.keymgr.edit"));
        edit.addActionListener((ActionListener)((Object)new AnAction(panel2, this){
            final /* synthetic */ FileSystemViewPanel $panel;
            final /* synthetic */ SFTPTabbed this$0;
            {
                this.$panel = $panel;
                this.this$0 = $receiver;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                if (Intrinsics.areEqual((Object)this.$panel.getHost().getId(), (Object)"local")) {
                    return;
                }
                Host host = SFTPTabbed.access$getHostManager(this.this$0).getHost(this.$panel.getHost().getId());
                if (host == null) {
                    return;
                }
                Host host2 = host;
                HostDialog dialog = new HostDialog(evt.getWindow(), host2);
                dialog.setLocationRelativeTo(evt.getWindow());
                dialog.setVisible(true);
                Host host3 = dialog.getHost();
                if (host3 == null) {
                    return;
                }
                SFTPTabbed.access$getHostManager(this.this$0).addHost(host3);
            }
        }));
        clone.setEnabled(!Intrinsics.areEqual((Object)panel2.getHost().getId(), (Object)"local"));
        edit.setEnabled(clone.isEnabled());
        popupMenu.show((Component)((Object)this), e.getX(), e.getY());
    }

    public final void addSFTPFileSystemViewPanelTab(@NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        SFTPFileSystemViewPanel panel2 = new SFTPFileSystemViewPanel(host, this.transportManager);
        this.addTab(host.getName(), panel2);
        panel2.connect();
        this.setSelectedIndex(this.getTabCount() - 1);
    }

    @Nullable
    public final FileSystemViewPanel getSelectedFileSystemViewPanel() {
        return this.getFileSystemViewPanel(this.getSelectedIndex());
    }

    @Nullable
    public final FileSystemViewPanel getFileSystemViewPanel(int index) {
        if (this.getTabCount() < 1 || index < 0) {
            return null;
        }
        Component c2 = this.getComponentAt(index);
        if (c2 instanceof FileSystemViewPanel) {
            return (FileSystemViewPanel)c2;
        }
        if (c2 instanceof SFTPFileSystemViewPanel) {
            return ((SFTPFileSystemViewPanel)c2).getData(SFTPDataProviders.INSTANCE.getFileSystemViewPanel());
        }
        return null;
    }

    public void updateUI() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"focusColor", (Object)UIManager.getColor("TabbedPane.selectedBackground")), TuplesKt.to((Object)"hoverColor", (Object)UIManager.getColor("TabbedPane.background")), TuplesKt.to((Object)"tabHeight", (Object)30)};
        this.setStyleMap(MapsKt.mapOf((Pair[])pairArray));
        super.updateUI();
    }

    public void removeTabAt(int index) {
        Component c2 = this.getComponentAt(index);
        if (c2 instanceof Disposable) {
            Disposer.dispose((Disposable)((Object)c2));
        }
        super.removeTabAt(index);
    }

    @Override
    public void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            while (this.getTabCount() > 0) {
                this.removeTabAt(0);
            }
        }
    }

    public static final /* synthetic */ TransportManager access$getTransportManager$p(SFTPTabbed $this) {
        return $this.transportManager;
    }

    public static final /* synthetic */ void access$showContextMenu(SFTPTabbed $this, int tabIndex, MouseEvent e) {
        $this.showContextMenu(tabIndex, e);
    }

    public static final /* synthetic */ HostManager access$getHostManager(SFTPTabbed $this) {
        return $this.getHostManager();
    }
}

