/*
 * Decompiled with CFR 0.152.
 */
package app.termora.sftp;

import app.termora.Database;
import app.termora.Disposer;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.OptionPane;
import app.termora.RememberFocusTerminalTab;
import app.termora.sftp.FileSystemViewPanel;
import app.termora.sftp.SFTPDataProviders;
import app.termora.sftp.SFTPPanel;
import app.termora.sftp.SFTPTabbed;
import app.termora.sftp.TransportManager;
import app.termora.terminal.DataKey;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J'\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 H\u0016\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00060\u0007R\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lapp/termora/sftp/SFTPTab;", "Lapp/termora/RememberFocusTerminalTab;", "<init>", "()V", "sftpPanel", "Lapp/termora/sftp/SFTPPanel;", "sftp", "Lapp/termora/Database$SFTP;", "Lapp/termora/Database;", "getSftp", "()Lapp/termora/Database$SFTP;", "getTitle", "", "getIcon", "Ljavax/swing/Icon;", "addPropertyChangeListener", "", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "canClose", "", "willBeClose", "hasActiveTab", "tabbed", "Lapp/termora/sftp/SFTPTabbed;", "getJComponent", "Ljavax/swing/JComponent;", "getData", "T", "", "dataKey", "Lapp/termora/terminal/DataKey;", "(Lapp/termora/terminal/DataKey;)Ljava/lang/Object;", "termora"})
public final class SFTPTab
extends RememberFocusTerminalTab {
    @NotNull
    private final SFTPPanel sftpPanel = new SFTPPanel();

    public SFTPTab() {
        Disposer.register(this, this.sftpPanel);
    }

    private final Database.SFTP getSftp() {
        return Database.Companion.getDatabase().getSftp();
    }

    @Override
    @NotNull
    public String getTitle() {
        return "SFTP";
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return (Icon)((Object)Icons.INSTANCE.getFolder());
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    @Override
    public boolean canClose() {
        return !this.getSftp().getPinTab();
    }

    @Override
    public boolean willBeClose() {
        if (!this.canClose()) {
            return false;
        }
        TransportManager transportManager = this.sftpPanel.getData(SFTPDataProviders.INSTANCE.getTransportManager());
        if (transportManager == null) {
            return true;
        }
        TransportManager transportManager2 = transportManager;
        if (transportManager2.getTransportCount() > 0) {
            String string;
            OptionPane optionPane = OptionPane.INSTANCE;
            Window window = SwingUtilities.getWindowAncestor(this.getJComponent());
            return OptionPane.showConfirmDialog$default(optionPane, window, string = I18n.INSTANCE.getString("termora.transport.sftp.close-tab"), null, 2, 3, null, null, null, null, 484, null) == 0;
        }
        SFTPTabbed sFTPTabbed = this.sftpPanel.getData(SFTPDataProviders.INSTANCE.getLeftSFTPTabbed());
        if (sFTPTabbed == null) {
            return true;
        }
        SFTPTabbed leftTabbed = sFTPTabbed;
        SFTPTabbed sFTPTabbed2 = this.sftpPanel.getData(SFTPDataProviders.INSTANCE.getRightSFTPTabbed());
        if (sFTPTabbed2 == null) {
            return true;
        }
        SFTPTabbed rightTabbed = sFTPTabbed2;
        if (this.hasActiveTab(leftTabbed) || this.hasActiveTab(rightTabbed)) {
            String string;
            OptionPane optionPane = OptionPane.INSTANCE;
            Window window = SwingUtilities.getWindowAncestor(this.getJComponent());
            return OptionPane.showConfirmDialog$default(optionPane, window, string = I18n.INSTANCE.getString("termora.transport.sftp.close-tab-has-active-session"), null, 2, 3, null, null, null, null, 484, null) == 0;
        }
        return true;
    }

    private final boolean hasActiveTab(SFTPTabbed tabbed) {
        int n = tabbed.getTabCount();
        for (int i = 0; i < n; ++i) {
            FileSystemViewPanel c2;
            if (tabbed.getFileSystemViewPanel(i) == null || Intrinsics.areEqual((Object)c2.getHost().getId(), (Object)"local")) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public JComponent getJComponent() {
        return this.sftpPanel;
    }

    @Override
    @Nullable
    public <T> T getData(@NotNull DataKey<T> dataKey) {
        Intrinsics.checkNotNullParameter(dataKey, (String)"dataKey");
        return this.sftpPanel.getData(dataKey);
    }
}

