/*
 * Decompiled with CFR 0.152.
 */
package app.termora.sftp;

import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicColor;
import app.termora.Host;
import app.termora.I18n;
import app.termora.OptionPane;
import app.termora.Protocol;
import app.termora.TermoraFrameKt;
import app.termora.actions.DataProvider;
import app.termora.actions.DataProviderSupport;
import app.termora.sftp.FileSystemViewPanel;
import app.termora.sftp.SFTPDataProviders;
import app.termora.sftp.SFTPFileSystemViewPanel;
import app.termora.sftp.SFTPTabbed;
import app.termora.sftp.Transport;
import app.termora.sftp.TransportTable;
import app.termora.sftp.TransportTableModel;
import app.termora.sftp.TransportTreeTableNode;
import app.termora.terminal.DataKey;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.VFS;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J2\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010(\u001a\u0004\u0018\u00010#2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010)\u001a\u00020#J'\u0010*\u001a\u0004\u0018\u0001H+\"\b\b\u0000\u0010+*\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H+0.H\u0016\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020\u0016H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lapp/termora/sftp/SFTPPanel;", "Ljavax/swing/JPanel;", "Lapp/termora/actions/DataProvider;", "Lapp/termora/Disposable;", "<init>", "()V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "transportTable", "Lapp/termora/sftp/TransportTable;", "transportManager", "Lapp/termora/sftp/TransportTableModel;", "getTransportManager", "()Lapp/termora/sftp/TransportTableModel;", "dataProviderSupport", "Lapp/termora/actions/DataProviderSupport;", "leftComponent", "Lapp/termora/sftp/SFTPTabbed;", "rightComponent", "localHost", "Lapp/termora/Host;", "initViews", "", "initEvents", "tabCloseCallback", "tabbed", "index", "", "addTransport", "", "source", "Ljavax/swing/JComponent;", "sourceWorkdir", "Lorg/apache/commons/vfs2/FileObject;", "target", "Lapp/termora/sftp/FileSystemViewPanel;", "targetWorkdir", "transport", "Lapp/termora/sftp/Transport;", "canTransfer", "getTarget", "getLocalTarget", "getData", "T", "", "dataKey", "Lapp/termora/terminal/DataKey;", "(Lapp/termora/terminal/DataKey;)Ljava/lang/Object;", "dispose", "termora"})
@SourceDebugExtension(value={"SMAP\nSFTPPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SFTPPanel.kt\napp/termora/sftp/SFTPPanel\n+ 2 -JvmPlatform.kt\nokio/_JvmPlatformKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n33#2:219\n1869#3,2:220\n*S KotlinDebug\n*F\n+ 1 SFTPPanel.kt\napp/termora/sftp/SFTPPanel\n*L\n133#1:219\n156#1:220,2\n*E\n"})
public final class SFTPPanel
extends JPanel
implements DataProvider,
Disposable {
    @NotNull
    private final CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getIO()));
    @NotNull
    private final TransportTable transportTable = new TransportTable();
    @NotNull
    private final DataProviderSupport dataProviderSupport = new DataProviderSupport();
    @NotNull
    private final SFTPTabbed leftComponent = new SFTPTabbed(this.getTransportManager());
    @NotNull
    private final SFTPTabbed rightComponent = new SFTPTabbed(this.getTransportManager());
    @NotNull
    private final Host localHost = new Host("local", I18n.INSTANCE.getString("termora.transport.local"), Protocol.Local, null, 0, null, null, null, null, null, null, 0L, null, null, null, 0L, 0L, false, 262136, null);

    public SFTPPanel() {
        super(new BorderLayout());
        this.initViews();
        this.initEvents();
        FileSystems.getDefault();
    }

    private final TransportTableModel getTransportManager() {
        return this.transportTable.getModel();
    }

    private final void initViews() {
        this.putClientProperty("SKIP_FIND_EVERYWHERE", true);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.5);
        splitPane.setLeftComponent((Component)((Object)this.leftComponent));
        splitPane.setRightComponent((Component)((Object)this.rightComponent));
        splitPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, DynamicColor.Companion.getBorderColor()));
        splitPane.addComponentListener(new ComponentAdapter(this, splitPane){
            final /* synthetic */ SFTPPanel this$0;
            final /* synthetic */ JSplitPane $splitPane;
            {
                this.this$0 = $receiver;
                this.$splitPane = $splitPane;
            }

            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.removeComponentListener(this);
                this.$splitPane.setDividerLocation(this.$splitPane.getResizeWeight());
            }
        });
        this.leftComponent.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, DynamicColor.Companion.getBorderColor()));
        this.rightComponent.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, DynamicColor.Companion.getBorderColor()));
        JSplitPane rootSplitPane = new JSplitPane(0);
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.transportTable));
        scrollPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, DynamicColor.Companion.getBorderColor()));
        rootSplitPane.setResizeWeight(0.7);
        rootSplitPane.setTopComponent(splitPane);
        rootSplitPane.setBottomComponent(scrollPane);
        rootSplitPane.addComponentListener(new ComponentAdapter(this, rootSplitPane){
            final /* synthetic */ SFTPPanel this$0;
            final /* synthetic */ JSplitPane $rootSplitPane;
            {
                this.this$0 = $receiver;
                this.$rootSplitPane = $rootSplitPane;
            }

            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.removeComponentListener(this);
                this.$rootSplitPane.setDividerLocation(this.$rootSplitPane.getResizeWeight());
            }
        });
        this.add((Component)rootSplitPane, "Center");
    }

    private final void initEvents() {
        Disposer.register(this, this.leftComponent);
        Disposer.register(this, this.rightComponent);
        Disposer.register(this, this.transportTable);
        this.dataProviderSupport.addData(SFTPDataProviders.INSTANCE.getTransportManager(), this.getTransportManager());
        this.dataProviderSupport.addData(SFTPDataProviders.INSTANCE.getLeftSFTPTabbed(), this.leftComponent);
        this.dataProviderSupport.addData(SFTPDataProviders.INSTANCE.getRightSFTPTabbed(), this.rightComponent);
        String string = I18n.INSTANCE.getString("termora.transport.local");
        FileSystem fileSystem = VFS.getManager().resolveFile("file:///" + SystemUtils.USER_HOME).getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getFileSystem(...)");
        this.leftComponent.addTab(string, new FileSystemViewPanel(this.localHost, fileSystem, this.getTransportManager(), this.coroutineScope));
        this.leftComponent.setTabClosable(0, false);
        this.rightComponent.addTab(I18n.INSTANCE.getString("termora.transport.sftp.select-host"), new SFTPFileSystemViewPanel(null, this.getTransportManager(), 1, null));
        this.rightComponent.addChangeListener(arg_0 -> SFTPPanel.initEvents$lambda$0(this, arg_0));
        this.leftComponent.setTabCloseCallback((arg_0, arg_1) -> SFTPPanel.initEvents$lambda$1(this, arg_0, arg_1));
        this.rightComponent.setTabCloseCallback((arg_0, arg_1) -> SFTPPanel.initEvents$lambda$2(this, arg_0, arg_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tabCloseCallback(SFTPTabbed tabbed, int index) {
        TermoraFrameKt.assertEventDispatchThread();
        FileSystemViewPanel c2 = tabbed.getFileSystemViewPanel(index);
        if (c2 == null) {
            tabbed.removeTabAt(index);
            return;
        }
        FileSystem fs = c2.getFileSystem();
        DefaultMutableTreeTableNode root = this.getTransportManager().getRoot();
        ReentrantLock $this$withLock$iv = this.getTransportManager().getLock();
        boolean $i$f$withLock = false;
        Lock lock = $this$withLock$iv;
        lock.lock();
        try {
            Object object;
            Window window;
            OptionPane i2;
            boolean bl = false;
            List deletedIds = new ArrayList();
            int n = root.getChildCount();
            for (int i2 = 0; i2 < n; ++i2) {
                TransportTreeTableNode child;
                TreeTableNode treeTableNode = root.getChildAt(i2);
                TransportTreeTableNode transportTreeTableNode = treeTableNode instanceof TransportTreeTableNode ? (TransportTreeTableNode)treeTableNode : null;
                if (transportTreeTableNode == null || !Intrinsics.areEqual((Object)(child = transportTreeTableNode).getTransport().getSource().getFileSystem(), (Object)fs) && !Intrinsics.areEqual((Object)child.getTransport().getTarget().getFileSystem(), (Object)fs)) continue;
                deletedIds.add(child.getTransport().getId());
            }
            if (!((Collection)deletedIds).isEmpty() && OptionPane.showConfirmDialog$default(i2 = OptionPane.INSTANCE, window = SwingUtilities.getWindowAncestor(this), object = I18n.INSTANCE.getString("termora.transport.sftp.close-tab"), null, 2, 3, null, null, null, null, 484, null) != 0) {
                return;
            }
            Iterable $this$forEach$iv = deletedIds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                long it = ((Number)element$iv).longValue();
                boolean bl2 = false;
                this.getTransportManager().removeTransport(it);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        tabbed.removeTabAt(index);
    }

    public final boolean addTransport(@NotNull JComponent source, @Nullable FileObject sourceWorkdir, @NotNull FileSystemViewPanel target, @Nullable FileObject targetWorkdir, @NotNull Transport transport2) {
        FileObject fileObject;
        FileObject myTargetWorkdir;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)transport2, (String)"transport");
        Container container = SwingUtilities.getAncestorOfClass(FileSystemViewPanel.class, source);
        FileSystemViewPanel fileSystemViewPanel = container instanceof FileSystemViewPanel ? (FileSystemViewPanel)container : null;
        if (fileSystemViewPanel == null) {
            return false;
        }
        FileSystemViewPanel sourcePanel = fileSystemViewPanel;
        FileSystemViewPanel fileSystemViewPanel2 = target;
        if (fileSystemViewPanel2 == null) {
            return false;
        }
        FileSystemViewPanel targetPanel = fileSystemViewPanel2;
        if (sourcePanel.isDisposed() || targetPanel.isDisposed()) {
            return false;
        }
        FileObject fileObject2 = targetWorkdir;
        if (fileObject2 == null) {
            fileObject2 = myTargetWorkdir = targetPanel.getWorkdir();
        }
        if ((fileObject = sourceWorkdir) == null) {
            fileObject = sourcePanel.getWorkdir();
        }
        FileObject mySourceWorkdir = fileObject;
        FileObject sourcePath = transport2.getSource();
        String relativeName = mySourceWorkdir.getName().getRelativeName(sourcePath.getName());
        FileObject fileObject3 = myTargetWorkdir.resolveFile(relativeName);
        Intrinsics.checkNotNullExpressionValue((Object)fileObject3, (String)"resolveFile(...)");
        transport2.setTarget(fileObject3);
        return this.getTransportManager().addTransport(transport2);
    }

    public final boolean canTransfer(@NotNull JComponent source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.getTarget(source) != null;
    }

    @Nullable
    public final FileSystemViewPanel getTarget(@NotNull JComponent source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Container container = SwingUtilities.getAncestorOfClass(SFTPTabbed.class, source);
        SFTPTabbed sFTPTabbed = container instanceof SFTPTabbed ? (SFTPTabbed)((Object)container) : null;
        if (sFTPTabbed == null) {
            return null;
        }
        SFTPTabbed sourceTabbed = sFTPTabbed;
        boolean isLeft = Intrinsics.areEqual((Object)sourceTabbed, (Object)this.leftComponent);
        SFTPTabbed targetTabbed = isLeft ? this.rightComponent : this.leftComponent;
        return targetTabbed.getSelectedFileSystemViewPanel();
    }

    @NotNull
    public final FileSystemViewPanel getLocalTarget() {
        FileSystemViewPanel fileSystemViewPanel = this.leftComponent.getFileSystemViewPanel(0);
        Intrinsics.checkNotNull((Object)fileSystemViewPanel, (String)"null cannot be cast to non-null type app.termora.sftp.FileSystemViewPanel");
        return fileSystemViewPanel;
    }

    @Override
    @Nullable
    public <T> T getData(@NotNull DataKey<T> dataKey) {
        Intrinsics.checkNotNullParameter(dataKey, (String)"dataKey");
        return this.dataProviderSupport.getData(dataKey);
    }

    @Override
    public void dispose() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
    }

    private static final void initEvents$lambda$0(SFTPPanel this$0, ChangeEvent it) {
        if (this$0.rightComponent.getTabCount() == 0 && !this$0.rightComponent.isDisposed()) {
            this$0.rightComponent.addTab(I18n.INSTANCE.getString("termora.transport.sftp.select-host"), new SFTPFileSystemViewPanel(null, this$0.getTransportManager(), 1, null));
        }
    }

    private static final void initEvents$lambda$1(SFTPPanel this$0, JTabbedPane jTabbedPane, Integer index) {
        SFTPTabbed sFTPTabbed = this$0.leftComponent;
        Intrinsics.checkNotNull((Object)index);
        this$0.tabCloseCallback(sFTPTabbed, index);
    }

    private static final void initEvents$lambda$2(SFTPPanel this$0, JTabbedPane jTabbedPane, Integer index) {
        SFTPTabbed sFTPTabbed = this$0.rightComponent;
        Intrinsics.checkNotNull((Object)index);
        this$0.tabCloseCallback(sFTPTabbed, index);
    }
}

