/*
 * Decompiled with CFR 0.152.
 */
package app.termora.sftp;

import app.termora.Database;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.Host;
import app.termora.I18n;
import app.termora.NewHostTree;
import app.termora.SimpleTreeNode;
import app.termora.SshClients;
import app.termora.TreeUtils;
import app.termora.actions.DataProvider;
import app.termora.sftp.FileSystemViewPanel;
import app.termora.sftp.SFTPDataProviders;
import app.termora.sftp.TransportManager;
import app.termora.terminal.DataKey;
import app.termora.vfs2.sftp.MySftpFileSystemConfigBuilder;
import com.formdev.flatlaf.icons.FlatOptionPaneErrorIcon;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.swing.SwingDispatcherKt;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CloseFuture;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXHyperlink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 ?2\u00020\u00012\u00020\u00022\u00020\u0003:\u0005?@ABCB\u001b\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0002J\u0006\u0010/\u001a\u00020-J\u000e\u00100\u001a\u00020-H\u0082@\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020-H\u0002J\b\u00103\u001a\u00020-H\u0002J\b\u00104\u001a\u00020-H\u0016J'\u00105\u001a\u0004\u0018\u0001H6\"\b\b\u0000\u00106*\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u0002H609H\u0016\u00a2\u0006\u0002\u0010:J\u000e\u0010;\u001a\u00020-2\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020>H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00060\u001bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00060\u001dR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010!\u001a\u00060\"R\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lapp/termora/sftp/SFTPFileSystemViewPanel;", "Ljavax/swing/JPanel;", "Lapp/termora/Disposable;", "Lapp/termora/actions/DataProvider;", "host", "Lapp/termora/Host;", "transportManager", "Lapp/termora/sftp/TransportManager;", "<init>", "(Lapp/termora/Host;Lapp/termora/sftp/TransportManager;)V", "getHost", "()Lapp/termora/Host;", "setHost", "(Lapp/termora/Host;)V", "value", "Lapp/termora/sftp/SFTPFileSystemViewPanel$State;", "state", "getState", "()Lapp/termora/sftp/SFTPFileSystemViewPanel$State;", "cardLayout", "Ljava/awt/CardLayout;", "cardPanel", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "connectingPanel", "Lapp/termora/sftp/SFTPFileSystemViewPanel$ConnectingPanel;", "selectHostPanel", "Lapp/termora/sftp/SFTPFileSystemViewPanel$SelectHostPanel;", "connectFailedPanel", "Lapp/termora/sftp/SFTPFileSystemViewPanel$ConnectFailedPanel;", "isDisposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "that", "properties", "Lapp/termora/Database$Properties;", "Lapp/termora/Database;", "getProperties", "()Lapp/termora/Database$Properties;", "client", "Lorg/apache/sshd/client/SshClient;", "session", "Lorg/apache/sshd/client/session/ClientSession;", "fileSystemPanel", "Lapp/termora/sftp/FileSystemViewPanel;", "initView", "", "initEvents", "connect", "doConnect", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onClose", "closeIO", "dispose", "getData", "T", "", "dataKey", "Lapp/termora/terminal/DataKey;", "(Lapp/termora/terminal/DataKey;)Ljava/lang/Object;", "selectHost", "setTabTitle", "title", "", "Companion", "State", "ConnectingPanel", "ConnectFailedPanel", "SelectHostPanel", "termora"})
@SourceDebugExtension(value={"SMAP\nSFTPFileSystemViewPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SFTPFileSystemViewPanel.kt\napp/termora/sftp/SFTPFileSystemViewPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,337:1\n1#2:338\n*E\n"})
public final class SFTPFileSystemViewPanel
extends JPanel
implements Disposable,
DataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Host host;
    @NotNull
    private final TransportManager transportManager;
    @NotNull
    private volatile State state;
    @NotNull
    private final CardLayout cardLayout;
    @NotNull
    private final JPanel cardPanel;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConnectingPanel connectingPanel;
    @NotNull
    private final SelectHostPanel selectHostPanel;
    @NotNull
    private final ConnectFailedPanel connectFailedPanel;
    @NotNull
    private final AtomicBoolean isDisposed;
    @NotNull
    private final SFTPFileSystemViewPanel that;
    @Nullable
    private SshClient client;
    @Nullable
    private ClientSession session;
    @Nullable
    private FileSystemViewPanel fileSystemPanel;
    private static final Logger log = LoggerFactory.getLogger(SFTPFileSystemViewPanel.class);

    public SFTPFileSystemViewPanel(@Nullable Host host, @NotNull TransportManager transportManager) {
        Intrinsics.checkNotNullParameter((Object)transportManager, (String)"transportManager");
        super(new BorderLayout());
        this.host = host;
        this.transportManager = transportManager;
        this.state = State.Initialized;
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getIO()));
        this.connectingPanel = new ConnectingPanel();
        this.selectHostPanel = new SelectHostPanel();
        this.connectFailedPanel = new ConnectFailedPanel();
        this.isDisposed = new AtomicBoolean(false);
        this.that = this;
        this.initView();
        this.initEvents();
    }

    public /* synthetic */ SFTPFileSystemViewPanel(Host host, TransportManager transportManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            host = null;
        }
        this(host, transportManager);
    }

    @Nullable
    public final Host getHost() {
        return this.host;
    }

    public final void setHost(@Nullable Host host) {
        this.host = host;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    private final Database.Properties getProperties() {
        return Database.Companion.getDatabase().getProperties();
    }

    private final void initView() {
        this.cardPanel.add((Component)this.selectHostPanel, "Initialized");
        this.cardPanel.add((Component)this.connectingPanel, "Connecting");
        this.cardPanel.add((Component)this.connectFailedPanel, "ConnectFailed");
        this.cardLayout.show(this.cardPanel, "Initialized");
        this.add((Component)this.cardPanel, "Center");
    }

    private final void initEvents() {
        Disposer.register(this, this.selectHostPanel);
    }

    public final void connect() {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SFTPFileSystemViewPanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        if (this.this$0.getState() == State.Connecting) ** GOTO lbl70
                        SFTPFileSystemViewPanel.access$setState$p(this.this$0, State.Connecting);
                        this.L$0 = $this$launch;
                        this.label = 1;
                        v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ SFTPFileSystemViewPanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        SFTPFileSystemViewPanel.access$getConnectingPanel$p(this.this$0).start();
                                        SFTPFileSystemViewPanel.access$getCardLayout$p(this.this$0).show(SFTPFileSystemViewPanel.access$getCardPanel$p(this.this$0), "Connecting");
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        var3_4 /* !! */  = $this$launch;
                        var4_6 = this.this$0;
                        $i$a$-runCatching-SFTPFileSystemViewPanel$connect$1$2 = false;
                        this.L$0 = null;
                        this.label = 2;
                        v1 = SFTPFileSystemViewPanel.access$doConnect(var4_6, (Continuation)this);
                        ** if (v1 != var8_2) goto lbl29
lbl28:
                        // 1 sources

                        return var8_2;
lbl29:
                        // 1 sources

                        ** GOTO lbl36
                    }
                    case 2: {
                        $i$a$-runCatching-SFTPFileSystemViewPanel$connect$1$2 = false;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl36:
                            // 2 sources

                            var5_10 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable $i$a$-runCatching-SFTPFileSystemViewPanel$connect$1$2) {
                            var5_10 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-SFTPFileSystemViewPanel$connect$1$2));
                        }
                        var3_4 /* !! */  = var5_10;
                        var4_6 = this.this$0;
                        v2 = Result.exceptionOrNull-impl((Object)var3_4 /* !! */ );
                        if (v2 == null) break;
                        it = var5_10 = v2;
                        $i$a$-onFailure-SFTPFileSystemViewPanel$connect$1$3 = false;
                        if (SFTPFileSystemViewPanel.access$getLog$cp().isErrorEnabled()) {
                            SFTPFileSystemViewPanel.access$getLog$cp().error(it.getMessage(), (Throwable)it);
                        }
                        this.L$0 = var3_4 /* !! */ ;
                        this.label = 3;
                        v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(var4_6, (Throwable)it, null){
                            int label;
                            final /* synthetic */ SFTPFileSystemViewPanel this$0;
                            final /* synthetic */ Throwable $it;
                            {
                                this.this$0 = $receiver;
                                this.$it = $it;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        SFTPFileSystemViewPanel.access$setState$p(this.this$0, State.ConnectFailed);
                                        SFTPFileSystemViewPanel.access$getConnectFailedPanel$p(this.this$0).getErrorLabel().setText(ExceptionUtils.getRootCauseMessage((Throwable)this.$it));
                                        SFTPFileSystemViewPanel.access$getCardLayout$p(this.this$0).show(SFTPFileSystemViewPanel.access$getCardPanel$p(this.this$0), "ConnectFailed");
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        if (v3 == var8_2) {
                            return var8_2;
                        }
                        break;
                    }
                    case 3: {
                        $i$a$-onFailure-SFTPFileSystemViewPanel$connect$1$3 = false;
                        var3_5 = this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        break;
                    }
                }
                this.L$0 = null;
                this.label = 4;
                v4 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                    int label;
                    final /* synthetic */ SFTPFileSystemViewPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                SFTPFileSystemViewPanel.access$getConnectingPanel$p(this.this$0).stop();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)((Continuation)this));
                if (v4 == var8_2) {
                    return var8_2;
                }
                ** GOTO lbl70
                {
                    case 4: {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl70:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object doConnect(Continuation<? super Unit> $completion) {
        Host host = this.host;
        if (host == null) {
            return Unit.INSTANCE;
        }
        Host thisHost = host;
        this.closeIO();
        FileSystem mySftpFileSystem = null;
        try {
            SshClient sshClient;
            Window owner = SwingUtilities.getWindowAncestor(this.that);
            Intrinsics.checkNotNull((Object)owner);
            SshClient $this$doConnect_u24lambda_u240 = sshClient = SshClients.INSTANCE.openClient(thisHost, owner);
            boolean bl = false;
            this.client = $this$doConnect_u24lambda_u240;
            SshClient client = sshClient;
            SshClient $this$doConnect_u24lambda_u241 = $this$doConnect_u24lambda_u240 = SshClients.INSTANCE.openSession(thisHost, client);
            boolean bl2 = false;
            this.session = $this$doConnect_u24lambda_u241;
            SshClient session = $this$doConnect_u24lambda_u240;
            FileSystemOptions options = new FileSystemOptions();
            MySftpFileSystemConfigBuilder.Companion.getInstance().setClientSession(options, (ClientSession)session);
            FileSystem fileSystem = VFS.getManager().resolveFile("sftp:///", options).getFileSystem();
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getFileSystem(...)");
            mySftpFileSystem = fileSystem;
            session.addCloseFutureListener(arg_0 -> SFTPFileSystemViewPanel.doConnect$lambda$2(this, arg_0));
        }
        catch (Exception e) {
            this.closeIO();
            throw e;
        }
        if (this.isDisposed.get()) {
            throw new IllegalStateException("Closed");
        }
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, thisHost, mySftpFileSystem, null){
            int label;
            final /* synthetic */ SFTPFileSystemViewPanel this$0;
            final /* synthetic */ Host $thisHost;
            final /* synthetic */ FileSystem $mySftpFileSystem;
            {
                this.this$0 = $receiver;
                this.$thisHost = $thisHost;
                this.$mySftpFileSystem = $mySftpFileSystem;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        SFTPFileSystemViewPanel.access$setState$p(this.this$0, State.Connected);
                        FileSystemViewPanel fileSystemPanel = new FileSystemViewPanel(this.$thisHost, this.$mySftpFileSystem, SFTPFileSystemViewPanel.access$getTransportManager$p(this.this$0), SFTPFileSystemViewPanel.access$getCoroutineScope$p(this.this$0));
                        SFTPFileSystemViewPanel.access$getCardPanel$p(this.this$0).add((Component)fileSystemPanel, "Connected");
                        SFTPFileSystemViewPanel.access$getCardLayout$p(this.this$0).show(SFTPFileSystemViewPanel.access$getCardPanel$p(this.this$0), "Connected");
                        SFTPFileSystemViewPanel.access$setFileSystemPanel$p(SFTPFileSystemViewPanel.access$getThat$p(this.this$0), fileSystemPanel);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void onClose() {
        if (this.isDisposed.get()) {
            return;
        }
        SwingUtilities.invokeLater(() -> SFTPFileSystemViewPanel.onClose$lambda$3(this));
    }

    private final void closeIO() {
        Object object;
        Object $this$closeIO_u24lambda_u245;
        Host host = this.host;
        FileSystemViewPanel fileSystemViewPanel = this.fileSystemPanel;
        if (fileSystemViewPanel != null) {
            FileSystemViewPanel it = fileSystemViewPanel;
            boolean bl = false;
            Disposer.dispose(it);
        }
        this.fileSystemPanel = null;
        SFTPFileSystemViewPanel sFTPFileSystemViewPanel = this;
        try {
            $this$closeIO_u24lambda_u245 = sFTPFileSystemViewPanel;
            boolean bl = false;
            IOUtils.closeQuietly((Closeable)((Closeable)((SFTPFileSystemViewPanel)$this$closeIO_u24lambda_u245).session));
            $this$closeIO_u24lambda_u245 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$closeIO_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        sFTPFileSystemViewPanel = this;
        try {
            SFTPFileSystemViewPanel $this$closeIO_u24lambda_u246 = sFTPFileSystemViewPanel;
            boolean bl = false;
            IOUtils.closeQuietly((Closeable)((Closeable)$this$closeIO_u24lambda_u246.client));
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        if (host != null && log.isInfoEnabled()) {
            log.info("Sftp " + host.getName() + " is closed");
        }
    }

    @Override
    public void dispose() {
        if (this.isDisposed.compareAndSet(false, true)) {
            this.closeIO();
            CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
        }
    }

    @Override
    @Nullable
    public <T> T getData(@NotNull DataKey<T> dataKey) {
        Intrinsics.checkNotNullParameter(dataKey, (String)"dataKey");
        DataKey<T> dataKey2 = dataKey;
        return (T)(Intrinsics.areEqual(dataKey2, SFTPDataProviders.INSTANCE.getFileSystemViewPanel()) ? (Object)this.fileSystemPanel : (Intrinsics.areEqual(dataKey2, SFTPDataProviders.INSTANCE.getCoroutineScope()) ? (Object)this.coroutineScope : null));
    }

    public final void selectHost(@NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.that.setTabTitle(host.getName());
        this.that.host = host;
        this.that.connect();
    }

    private final void setTabTitle(String title) {
        Container tabbed = SwingUtilities.getAncestorOfClass(JTabbedPane.class, this.that);
        if (tabbed instanceof JTabbedPane) {
            int n = ((JTabbedPane)tabbed).getTabCount();
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual((Object)((JTabbedPane)tabbed).getComponentAt(i), (Object)this.that)) continue;
                ((JTabbedPane)tabbed).setTitleAt(i, title);
                break;
            }
        }
    }

    private static final void doConnect$lambda$2(SFTPFileSystemViewPanel this$0, CloseFuture it) {
        this$0.onClose();
    }

    private static final void onClose$lambda$3(SFTPFileSystemViewPanel this$0) {
        this$0.closeIO();
        this$0.state = State.ConnectFailed;
        this$0.connectFailedPanel.getErrorLabel().setText(I18n.INSTANCE.getString("termora.transport.sftp.closed"));
        this$0.cardLayout.show(this$0.cardPanel, "ConnectFailed");
    }

    public static final /* synthetic */ void access$setState$p(SFTPFileSystemViewPanel $this, State state) {
        $this.state = state;
    }

    public static final /* synthetic */ ConnectingPanel access$getConnectingPanel$p(SFTPFileSystemViewPanel $this) {
        return $this.connectingPanel;
    }

    public static final /* synthetic */ CardLayout access$getCardLayout$p(SFTPFileSystemViewPanel $this) {
        return $this.cardLayout;
    }

    public static final /* synthetic */ JPanel access$getCardPanel$p(SFTPFileSystemViewPanel $this) {
        return $this.cardPanel;
    }

    public static final /* synthetic */ Object access$doConnect(SFTPFileSystemViewPanel $this, Continuation $completion) {
        return $this.doConnect((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ ConnectFailedPanel access$getConnectFailedPanel$p(SFTPFileSystemViewPanel $this) {
        return $this.connectFailedPanel;
    }

    public static final /* synthetic */ TransportManager access$getTransportManager$p(SFTPFileSystemViewPanel $this) {
        return $this.transportManager;
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(SFTPFileSystemViewPanel $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ void access$setFileSystemPanel$p(SFTPFileSystemViewPanel $this, FileSystemViewPanel fileSystemViewPanel) {
        $this.fileSystemPanel = fileSystemViewPanel;
    }

    public static final /* synthetic */ SFTPFileSystemViewPanel access$getThat$p(SFTPFileSystemViewPanel $this) {
        return $this.that;
    }

    public static final /* synthetic */ void access$setTabTitle(SFTPFileSystemViewPanel $this, String title) {
        $this.setTabTitle(title);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/sftp/SFTPFileSystemViewPanel$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lapp/termora/sftp/SFTPFileSystemViewPanel$ConnectFailedPanel;", "Ljavax/swing/JPanel;", "<init>", "(Lapp/termora/sftp/SFTPFileSystemViewPanel;)V", "errorLabel", "Ljavax/swing/JLabel;", "getErrorLabel", "()Ljavax/swing/JLabel;", "initView", "", "termora"})
    private final class ConnectFailedPanel
    extends JPanel {
        @NotNull
        private final JLabel errorLabel;

        public ConnectFailedPanel() {
            super(new BorderLayout());
            this.errorLabel = new JLabel();
            this.initView();
        }

        @NotNull
        public final JLabel getErrorLabel() {
            return this.errorLabel;
        }

        /*
         * WARNING - void declaration
         */
        private final void initView() {
            void $this$initView_u24lambda_u241;
            String $this$initView_u24lambda_u240;
            String formMargin = "4dlu";
            FormLayout layout = new FormLayout("default:grow, pref, default:grow", "40dlu, pref, " + formMargin + ", pref, " + formMargin + ", pref, " + formMargin + ", pref");
            this.errorLabel.setHorizontalAlignment(0);
            FormBuilder builder2 = FormBuilder.create().layout(layout).debug(false);
            builder2.add((Icon)new FlatOptionPaneErrorIcon()).xy(2, 2);
            builder2.add((Component)this.errorLabel).xyw(1, 4, 3, "fill, center");
            String string = I18n.INSTANCE.getString("termora.transport.sftp.retry");
            String string2 = string = new JXHyperlink((Action)new AbstractAction(SFTPFileSystemViewPanel.this, string){
                final /* synthetic */ SFTPFileSystemViewPanel this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.this$0.connect();
                }
            });
            FormBuilder formBuilder = builder2;
            boolean bl = false;
            $this$initView_u24lambda_u240.setHorizontalAlignment(0);
            $this$initView_u24lambda_u240.setVerticalAlignment(0);
            $this$initView_u24lambda_u240.setFocusable(false);
            formBuilder.add((Component)((Object)string)).xy(2, 6);
            string = I18n.INSTANCE.getString("termora.transport.sftp.select-another-host");
            $this$initView_u24lambda_u240 = string = new JXHyperlink((Action)new AbstractAction(SFTPFileSystemViewPanel.this, string){
                final /* synthetic */ SFTPFileSystemViewPanel this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SFTPFileSystemViewPanel.access$setState$p(this.this$0, State.Initialized);
                    SFTPFileSystemViewPanel.access$setTabTitle(SFTPFileSystemViewPanel.access$getThat$p(this.this$0), I18n.INSTANCE.getString("termora.transport.sftp.select-host"));
                    SFTPFileSystemViewPanel.access$getCardLayout$p(this.this$0).show(SFTPFileSystemViewPanel.access$getCardPanel$p(this.this$0), "Initialized");
                }
            });
            formBuilder = builder2;
            boolean bl2 = false;
            $this$initView_u24lambda_u241.setHorizontalAlignment(0);
            $this$initView_u24lambda_u241.setVerticalAlignment(0);
            $this$initView_u24lambda_u241.setFocusable(false);
            formBuilder.add((Component)((Object)string)).xy(2, 8);
            this.add((Component)builder2.build(), "Center");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lapp/termora/sftp/SFTPFileSystemViewPanel$ConnectingPanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "busyLabel", "Lorg/jdesktop/swingx/JXBusyLabel;", "initView", "", "start", "stop", "termora"})
    private static final class ConnectingPanel
    extends JPanel {
        @NotNull
        private final JXBusyLabel busyLabel = new JXBusyLabel();

        public ConnectingPanel() {
            super(new BorderLayout());
            this.initView();
        }

        private final void initView() {
            String formMargin = "7dlu";
            FormLayout layout = new FormLayout("default:grow, pref, default:grow", "40dlu, pref, " + formMargin + ", pref");
            JLabel label = new JLabel(I18n.INSTANCE.getString("termora.transport.sftp.connecting"));
            label.setHorizontalAlignment(0);
            this.busyLabel.setHorizontalAlignment(0);
            this.busyLabel.setVerticalAlignment(0);
            FormBuilder builder2 = FormBuilder.create().layout(layout).debug(false);
            builder2.add((Component)this.busyLabel).xy(2, 2, "fill, center");
            builder2.add((Component)label).xy(2, 4);
            this.add((Component)builder2.build(), "Center");
        }

        public final void start() {
            this.busyLabel.setBusy(true);
        }

        public final void stop() {
            this.busyLabel.setBusy(false);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lapp/termora/sftp/SFTPFileSystemViewPanel$SelectHostPanel;", "Ljavax/swing/JPanel;", "Lapp/termora/Disposable;", "<init>", "(Lapp/termora/sftp/SFTPFileSystemViewPanel;)V", "tree", "Lapp/termora/NewHostTree;", "initView", "", "initEvents", "dispose", "termora"})
    private final class SelectHostPanel
    extends JPanel
    implements Disposable {
        @NotNull
        private final NewHostTree tree;

        public SelectHostPanel() {
            super(new BorderLayout());
            this.tree = new NewHostTree();
            this.initView();
            this.initEvents();
        }

        private final void initView() {
            this.tree.setContextmenu(false);
            this.tree.setDragEnabled(false);
            this.tree.setDoubleClickConnection(false);
            JScrollPane scrollPane = new JScrollPane((Component)((Object)this.tree));
            scrollPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.add((Component)scrollPane, "Center");
            TreeUtils.INSTANCE.loadExpansionState((JTree)((Object)this.tree), SFTPFileSystemViewPanel.this.getProperties().getString("SFTPTabbed.Tree.state", ""));
        }

        private final void initEvents() {
            this.tree.addMouseListener(new MouseAdapter(this, SFTPFileSystemViewPanel.this){
                final /* synthetic */ SelectHostPanel this$0;
                final /* synthetic */ SFTPFileSystemViewPanel this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() % 2 == 0) {
                        SimpleTreeNode<?> simpleTreeNode = SelectHostPanel.access$getTree$p(this.this$0).getLastSelectedPathNode();
                        if (simpleTreeNode == null) {
                            return;
                        }
                        SimpleTreeNode<?> node = simpleTreeNode;
                        if (node.isFolder()) {
                            return;
                        }
                        ? obj = node.getData();
                        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type app.termora.Host");
                        Host host = (Host)obj;
                        this.this$1.selectHost(host);
                    }
                }
            });
            this.tree.addTreeExpansionListener(new TreeExpansionListener(SFTPFileSystemViewPanel.this, this){
                final /* synthetic */ SFTPFileSystemViewPanel this$0;
                final /* synthetic */ SelectHostPanel this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void treeExpanded(TreeExpansionEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    SFTPFileSystemViewPanel.access$getProperties(this.this$0).putString("SFTPTabbed.Tree.state", TreeUtils.INSTANCE.saveExpansionState((JTree)((Object)SelectHostPanel.access$getTree$p(this.this$1))));
                }

                public void treeCollapsed(TreeExpansionEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    SFTPFileSystemViewPanel.access$getProperties(this.this$0).putString("SFTPTabbed.Tree.state", TreeUtils.INSTANCE.saveExpansionState((JTree)((Object)SelectHostPanel.access$getTree$p(this.this$1))));
                }
            });
        }

        @Override
        public void dispose() {
            SFTPFileSystemViewPanel.this.getProperties().putString("SFTPTabbed.Tree.state", TreeUtils.INSTANCE.saveExpansionState((JTree)((Object)this.tree)));
        }

        public static final /* synthetic */ NewHostTree access$getTree$p(SelectHostPanel $this) {
            return $this.tree;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lapp/termora/sftp/SFTPFileSystemViewPanel$State;", "", "<init>", "(Ljava/lang/String;I)V", "Initialized", "Connecting", "Connected", "ConnectFailed", "termora"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State Initialized = new State();
        public static final /* enum */ State Connecting = new State();
        public static final /* enum */ State Connected = new State();
        public static final /* enum */ State ConnectFailed = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.Initialized, State.Connecting, State.Connected, State.ConnectFailed};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

