/*
 * Decompiled with CFR 0.152.
 */
package app.termora.sftp;

import app.termora.Host;
import app.termora.HostManager;
import app.termora.HostTerminalTab;
import app.termora.Icons;
import app.termora.Protocol;
import app.termora.TerminalTab;
import app.termora.TerminalTabbedManager;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.actions.DataProviders;
import app.termora.sftp.FileSystemViewPanel;
import app.termora.sftp.SFTPActionEvent;
import app.termora.sftp.SFTPDataProviders;
import app.termora.sftp.SFTPFileSystemViewPanel;
import app.termora.sftp.SFTPTab;
import app.termora.sftp.SFTPTabbed;
import java.awt.Component;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lapp/termora/sftp/SFTPAction;", "Lapp/termora/actions/AnAction;", "<init>", "()V", "hostManager", "Lapp/termora/HostManager;", "getHostManager", "()Lapp/termora/HostManager;", "actionPerformed", "", "evt", "Lapp/termora/actions/AnActionEvent;", "termora"})
public final class SFTPAction
extends AnAction {
    public SFTPAction() {
        super("SFTP", (Icon)((Object)Icons.INSTANCE.getFolder()));
    }

    private final HostManager getHostManager() {
        return HostManager.Companion.getInstance();
    }

    @Override
    protected void actionPerformed(@NotNull AnActionEvent evt) {
        String hostId;
        TerminalTab tab2;
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        TerminalTabbedManager terminalTabbedManager = evt.getData(DataProviders.INSTANCE.getTerminalTabbedManager());
        if (terminalTabbedManager == null) {
            return;
        }
        TerminalTabbedManager terminalTabbedManager2 = terminalTabbedManager;
        SFTPTab sftpTab = null;
        for (TerminalTab tab2 : terminalTabbedManager2.getTerminalTabs()) {
            if (!(tab2 instanceof SFTPTab)) continue;
            sftpTab = (SFTPTab)tab2;
            break;
        }
        if (sftpTab == null) {
            sftpTab = new SFTPTab();
            terminalTabbedManager2.addTerminalTab(sftpTab, false);
        }
        String string = hostId = evt instanceof SFTPActionEvent ? ((SFTPActionEvent)evt).getHostId() : "";
        if (StringsKt.isBlank((CharSequence)hostId) && (tab2 = terminalTabbedManager2.getSelectedTerminalTab()) instanceof HostTerminalTab && (((HostTerminalTab)tab2).getHost().getProtocol() == Protocol.SSH || ((HostTerminalTab)tab2).getHost().getProtocol() == Protocol.SFTPPty)) {
            hostId = ((HostTerminalTab)tab2).getHost().getId();
        }
        terminalTabbedManager2.setSelectedTerminalTab(sftpTab);
        if (StringsKt.isBlank((CharSequence)hostId)) {
            return;
        }
        SFTPTabbed sFTPTabbed = sftpTab.getData(SFTPDataProviders.INSTANCE.getRightSFTPTabbed());
        if (sFTPTabbed == null) {
            return;
        }
        SFTPTabbed tabbed = sFTPTabbed;
        int n = tabbed.getTabCount();
        for (int i = 0; i < n; ++i) {
            FileSystemViewPanel fileSystemViewPanel;
            if (tabbed.getFileSystemViewPanel(i) == null || !Intrinsics.areEqual((Object)fileSystemViewPanel.getHost().getId(), (Object)hostId)) continue;
            tabbed.setSelectedIndex(i);
            return;
        }
        Host host = this.getHostManager().getHost(hostId);
        if (host == null) {
            return;
        }
        Host host2 = host;
        int n2 = tabbed.getTabCount();
        for (int i = 0; i < n2; ++i) {
            Component c2 = tabbed.getComponentAt(i);
            if (!(c2 instanceof SFTPFileSystemViewPanel) || ((SFTPFileSystemViewPanel)c2).getState() != SFTPFileSystemViewPanel.State.Initialized) continue;
            ((SFTPFileSystemViewPanel)c2).selectHost(host2);
            return;
        }
        tabbed.addSFTPFileSystemViewPanelTab(host2);
    }
}

