/*
 * Decompiled with CFR 0.152.
 */
package app.termora.sftp;

import app.termora.Application;
import app.termora.I18n;
import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.icons.FlatTreeClosedIcon;
import com.formdev.flatlaf.icons.FlatTreeLeafIcon;
import com.formdev.flatlaf.util.SystemInfo;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jgit.util.LRUMap;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0006J8\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u0010\u000f\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lapp/termora/sftp/NativeFileIcons;", "", "<init>", "()V", "cache", "Lorg/eclipse/jgit/util/LRUMap;", "", "Lkotlin/Pair;", "Ljavax/swing/Icon;", "folderIcon", "Lcom/formdev/flatlaf/icons/FlatTreeClosedIcon;", "fileIcon", "Lcom/formdev/flatlaf/icons/FlatTreeLeafIcon;", "getFolderIcon", "getFileIcon", "filename", "getIcon", "isFile", "", "width", "", "height", "termora"})
public final class NativeFileIcons {
    @NotNull
    public static final NativeFileIcons INSTANCE = new NativeFileIcons();
    @NotNull
    private static final LRUMap<String, Pair<Icon, String>> cache = new LRUMap(16, 512);
    @NotNull
    private static final FlatTreeClosedIcon folderIcon = new FlatTreeClosedIcon();
    @NotNull
    private static final FlatTreeLeafIcon fileIcon = new FlatTreeLeafIcon();

    private NativeFileIcons() {
    }

    @NotNull
    public final Icon getFolderIcon() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return (Icon)NativeFileIcons.getIcon$default(this, string, false, 0, 0, 12, null).getFirst();
    }

    @NotNull
    public final Icon getFileIcon(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return (Icon)NativeFileIcons.getIcon$default(this, filename, true, 0, 0, 12, null).getFirst();
    }

    @NotNull
    public final Pair<Icon, String> getIcon(@NotNull String filename, boolean isFile, int width, int height) {
        boolean isDirectory;
        String key;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        String string = key = isFile ? FilenameUtils.getExtension((String)filename) + "." + width + "@" + height : SystemUtils.USER_HOME + "." + width + "@" + height;
        if (cache.containsKey((Object)key)) {
            Object object = MapsKt.getValue((Map)((Map)cache), (Object)key);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (Pair)object;
        }
        boolean bl = isDirectory = !isFile;
        if (SystemInfo.isWindows) {
            String string2;
            Icon icon;
            Icon icon2;
            File file;
            if (isDirectory) {
                var8_7 = new String[]{SystemUtils.USER_HOME};
                v3 = FileUtils.getFile((String[])var8_7);
            } else {
                var8_7 = new String[]{UUID.randomUUID() + "." + filename};
                v3 = file = FileUtils.getFile((File)Application.INSTANCE.getTemporaryDir(), (String[])var8_7);
            }
            if (isFile && !file.exists()) {
                file.createNewFile();
            }
            if ((icon2 = FileSystemView.getFileSystemView().getSystemIcon(file, width, height)) == null) {
                icon2 = icon = (Icon)(isFile ? (FlatAbstractIcon)fileIcon : (FlatAbstractIcon)folderIcon);
            }
            if ((string2 = FileSystemView.getFileSystemView().getSystemTypeDescription(file)) == null) {
                Intrinsics.checkNotNull((Object)file);
                string2 = StringUtils.defaultString((String)FilesKt.getExtension((File)file));
            }
            String description = string2;
            Pair pair = TuplesKt.to((Object)icon, (Object)description);
            ((Map)cache).put(key, pair);
            if (isFile) {
                FileUtils.deleteQuietly((File)file);
            }
            return pair;
        }
        return new Pair((Object)(isDirectory ? (FlatAbstractIcon)folderIcon : (FlatAbstractIcon)fileIcon), (Object)(isDirectory ? I18n.INSTANCE.getString("termora.folder") : FilenameUtils.getExtension((String)filename)));
    }

    public static /* synthetic */ Pair getIcon$default(NativeFileIcons nativeFileIcons, String string, boolean bl, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            bl = true;
        }
        if ((n3 & 4) != 0) {
            n = 16;
        }
        if ((n3 & 8) != 0) {
            n2 = 16;
        }
        return nativeFileIcons.getIcon(string, bl, n, n2);
    }

    static {
        if (SystemUtils.IS_OS_UNIX) {
            ((Map)cache).put(SystemUtils.USER_HOME, new Pair((Object)folderIcon, (Object)I18n.INSTANCE.getString("termora.folder")));
        }
    }
}

